<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Promotion extends CI_Controller {

	/**
	 * 
	 * Start 
	 * Create Date: 8 September, 2016
	 * This controller to manage user side promotional banners.
	 * Created karthiga.
	 * @see http://zhyip.com/
	 * Last Updated: 8 September, 2016
	 * End
	 * 
	 */

	public function __construct() {
		parent::__construct();
		// admin login only
		if($this->session->userdata('admin_login')) {
			// form validation library
			$this->load->library('form_validation');

			// custom encryption
			$this->load->library('MyEncrypt');
			$myencrypt = new MyEncrypt;
			$this->isSubadmin();

		} else {
			redirect('admin/login');
		}

	}
    
    private function isSubadmin() {

		if($this->session->userdata('user_type') == 'subadmin') {
			$controller = $this->router->fetch_class();
			$pages = json_decode($this->session->userdata('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				redirect('admin');
			}
		}
	}
	
	public function index()
	{
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_extra')
		
		);
		$this->data['module_name'] = 'settings';
		$this->data['banner_data'] = $this->common_model->GetResults('promotionalbanner_control');
        

		$this->load->view('admin/promotion/promotion',$this->data);

	}
	public function add($id='') {

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('slider_text'),
			'href' => base_url().'admin/promotion'
		);
		
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  base_url().'admin/promotion/add';
        $this->data['user_list'] = $this->common_model->GetResults('uusers');

		if($id) {
			$myencrypt = new MyEncrypt;
			$banner_id = $myencrypt->decode($id);
			$condition = "banner_id = '".$banner_id."'";
			$this->data['banner_data'] = $this->common_model->GetRow('promotionalbanner_control', $condition);
		}

		if($this->input->post()) {
			
			$this->form_validation->set_rules('banner_title', $this->lang->line("lbl_slider_title"), 'trim|required');
			  if($this->input->post('banner_id')=='') {
			  		$this->form_validation->set_rules('banner_image', $this->lang->line("lbl_slider_image"), 'trim|required');
		      }
			$this->form_validation->set_rules('banner_description', $this->lang->line("lbl_slider_description"), 'trim|required');
			$tmp_name=$_FILES['banner_image']['tmp_name'];

			if($tmp_name!='') {
				$this->form_validation->set_rules('banner_image', $this->lang->line("lbl_slider_image"), 'trim|callback_validate_image');
			}
            
            
			// check form validate
			if ($this->form_validation->run() == TRUE) {
				

				if($this->input->post('banner_id')) {

					$banner_id = $this->input->post('banner_id');

	                $banner_data = array(
						"banner_title"			=>	$this->input->post('banner_title'),
						"banner_description"	=>	$this->input->post('banner_description'),
						"banner_status"		=>	($this->input->post('banner_status')) ? 'on' : 'off' 
					);
	                $tmp_name=$_FILES['banner_image']['tmp_name'];
					if($tmp_name!='') {
						$slider_image_file = $this->upload->data();
						$banner_data['banner_image'] = $slider_image_file['file_name'];
					}
						
					$this->db->where('banner_id',$banner_id);
					$query_status = $this->db->update('promotionalbanner_control',$banner_data);

				} else {

					$banner_data = array(
						"banner_title"			=>	$this->input->post('banner_title'),
						"banner_description"	=>	$this->input->post('banner_description'),
						"banner_status"		    =>	($this->input->post('banner_status')) ? 'on' : 'off' 
					);
					$tmp_name=$_FILES['banner_image']['tmp_name'];
					if($tmp_name!='') {
						$slider_image_file = $this->upload->data();
						$banner_data['banner_image'] = $slider_image_file['file_name'];
					}
					
					$query_status = $this->db->insert('promotionalbanner_control',$banner_data);

				}
				
			 	

				if($query_status) {
					$this->session->set_flashdata('success_slider', $this->lang->line('Promotional_banner_success_message'));
					redirect('admin/promotion');
				} else {
					$this->session->set_flashdata('error_slider', $this->lang->line('Promotional_banner_error_message'));
					redirect('admin/promotion');
				}
				
			} 
			
		}
		$this->load->view('admin/promotion/addpromotion',$this->data);
	}

	public function delete($id) {
			$myencrypt = new MyEncrypt;
			$banner_id = $myencrypt->decode($id);
			if(isset($banner_id)){
				
				$this->db->where('banner_id',$banner_id);
				$delete_status = $this->db->delete('promotionalbanner_control');

				if($delete_status) {
					$this->session->set_flashdata('success_slider', $this->lang->line('promotion_delete_success_message'));
					redirect('admin/promotion');
				} else {
					$this->session->set_flashdata('error_slider', $this->lang->line('promotion_delete_error_message'));
					redirect('admin/promotion');
				}	
				
			} else {
				redirect('admin/promotion');
			}
	}

	public function changeStatus($id) {
		
			$myencrypt = new MyEncrypt;
			$banner_id = $myencrypt->decode($id);
		
			$cur_up_data = array(
				"banner_status" => 'off'
			);
			$this->db->where('banner_id',$banner_id);
			$update_status = $this->db->update('promotionalbanner_control',$cur_up_data);

			if($update_status){
				$this->session->set_flashdata('success_slider', $this->lang->line('promotion_default_success'));
                redirect('admin/promotion');
			} else {
				$this->session->set_flashdata('error_slider', $this->lang->line('promotion_default_error'));
				redirect('admin/promotion');
			}

		
	}
	public function changeActiveStatus($id) {

			$myencrypt = new MyEncrypt;
			$banner_id = $myencrypt->decode($id);
			
			$cur_up_data = array(
				"banner_status" => 'on'
			);
			$this->db->where('banner_id',$banner_id);
			$update_status = $this->db->update('promotionalbanner_control',$cur_up_data);

			if($update_status){
				$this->session->set_flashdata('success_slider', $this->lang->line('promotion_default_success'));
				redirect('admin/promotion');
			} else {
				$this->session->set_flashdata('error_slider', $this->lang->line('promotion_default_error'));
			    redirect('admin/promotion');
			}

		
	}

	/* validate image value */
	public function validate_image($str)
	{
		
		$config['upload_path'] = './content/banner/';
		$config['allowed_types'] = 'gif|jpg|png|jpeg';
		$config['encrypt_name'] = TRUE;
		$this->load->library('upload', $config);

		if ( ! $this->upload->do_upload('banner_image')) {
			$this->form_validation->set_message('validate_image', '<p><em class="text-danger">'.$this->upload->display_errors().'</em></p>');
			return false;
		} else {
			return true;
		}
		
	}

	

}

