<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;

class Registersettings extends BaseController {

	/**
	 * 
	 * Start 
	 * Create Date: 10 Aug, 2017
	 * This controller to manage register field settings.
	 * Created karthiga.
	 * @see http://ihyip.com/admin/loginsettings/
	 * Last Updated: 10 AUG, 2017
	 * End
	 * 
	 */

	public function __construct() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		// admin login only
		if($session->get('admin_login')) {

			// form validation library
			// $this->load->library('form_validation');

			$this->isSubadmin();


		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$session->set('last_page', current_url());
				return redirect()->to('admin/login');
			}
		}

 	}

 	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$session->set($array);

		} else {
			return redirect()->to('admin/login');
		}
	}

	private function isSubadmin() {
$this->db = db_connect();
	$myencrypt = new MyEncrypt(true);
	$this->common_model = model('CommonModel');
	$session = \Config\Services::session();
	$validation = \Config\Services::validation();
	$uri = service('uri');
	if(!$session->get('admin_login')) {
		return redirect()->to('admin/login');
	}
		if($session->get('user_type') == 'subadmin') {
			$controller = $this->router->controllerName();
			$pages = json_decode($session->get('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}
		}
	}

	public function index()
	{   
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

        $this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_settings')
		);
		
        $this->data['module_name'] = 'settings';
        // Function call for model
		$this->data['action'] = 'admin/registersettings';
		
		$site_data = $this->common_model->GetSettingall('register_field');
		if($site_data) {
			
			foreach ($site_data as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}

		}

		if($this->request->getPost()) {


            foreach ($site_data as $row) {

				$key_value = $row->site_key;
				
				if($this->request->getPost($key_value)){

					$sitedata = array(
						"site_value"	=>	$this->request->getPost($key_value)
					);
					$update_status = $this->db->table('site_controls')->where('settings_name','register_field')->where('site_key',$row->site_key)->update($sitedata);
				} else {
					$sitedata = array(
						"site_value"	=>	'0'
					);
					$update_status = $this->db->table('site_controls')->where('site_key',$row->site_key)->where('settings_name','register_field')->update($sitedata);
				}
				

			}


	        if($update_status) {
				$session->setFlashData('success_message', lang('language_lang.register_field_success_message'));
				return redirect()->to('admin/registersettings');
			} else {
				$session->setFlashData('error_message', lang('language_lang.register_field_error_message'));
				return redirect()->to('admin/registersettings');
			}
		}
		echo view('admin/settings/register',$this->data);

	}
	
}

