<?php
/**
	* 
	* Start 
	* Create Date: 17 Jun, 2016
	* This module file using for commmonly used method in all controller.
	* Created saravana kumar.
	* @see no link
	* Last Updated: 23 Jun, 2016
	* End
	* 
*/
namespace App\Models;
use CodeIgniter\Model;

Class CommonModel extends Model {

	protected static $arraycount;

	public function __construct(){
		$this->db = \Config\Database::connect();
		$this->session = session();
	}


	// get setting values
	public function GetSettingall($settingname) {
		$builder = $this->db->table('site_controls');
		
		$builder->where('settings_name',$settingname);
		
		$builder->select('site_key, site_value');
		// $builder->where($condition);
		$query = $builder->get();
		
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}

	public function GetSiteSettings($settingname) {
		$db      = \Config\Database::connect();
		$builder = $this->db->table('site_controls');
		$condition = "settings_name ='".$settingname."'";
		// $lang_id = $this->session->get('langid');
		$lang_id = 0;
		if($lang_id){
			$builder->where('language_id',$lang_id);
		} else {
			// $defult_lang_id = $this->defaultLang();
			$condition="language_id='1' or language_id='0'";
			$builder->where('language_id','1');
		}
		
		$builder->where('settings_name',$settingname);
		$builder->select('site_key, site_value');
		$query = $builder->get();
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}
public function get_arbit_duplicate($data){
         $this->db->where('plan_name',$data['plan_name'])->where('coid',$data['coid']);
         $query = $this->db->get('arbit_plans')->num_rows();
         return $query;
	}

	public function get_plan_details($data){
		$this->db->where('id',$data);
		$query = $this->db->get('arbit_plans')->row_array();
		return $query;
	}
	public function GetActiveArbitPlans(){
		$this->db->select('t1.coin_symbol,t1.coin_name,t1.coin_image,t1.uusersid,t1.coin_decimal,t2.*');
		$this->db->where('t1.status',1 and 't1.arbit_status=',1);
		$this->db->where('t2.coid = t1.coid');
		$result = $this->db->get('coin_info as t1, arbit_plans as t2')->result();
		return $result;
	}

	

    public function downlinescount($userid,$level)
	{
		// echo"<pre>";
		// print_r($this->session->get());
		// echo"</pre>";
		// die;
		$db  = \Config\Database::connect();
		$this->session = session();
		 $arraycount = array();

		$ucondition = "spillover_id = '".$userid."' and rankid != ''";
		$table = "uusers_matrix";

		$select_count = $this->GetRowCount($table,$ucondition);


		$select = $this->GetResults($table,$ucondition);

		




		if($select_count > 0)
		{
			$level++;
			for($i=0; $i<$select_count; $i++)
			{
				$userid = $select[$i]->uusersid;

			  $confirm = $db->table('history')->where('uusersid',$userid)->where('type','activation')->where('status',1)->get()->getRow();


                if($confirm){
				$arraycount[$level].= $userid.',';
			    }

				$this->downlinescount($userid,$level);

			}
		}
		if($arraycount[$level])
		$this->session->set("arraycount[".$level."]",$arraycount[$level]);
               
		        
		        return $this->session->get();
	}



	

	public function notokens($tablename,$condition=""){

		if($condition){
			$this->db->where($condition);
		}
		$this->db->select('*');
		$this->db->from($tablename);
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->num_rows();
		} else {
			return false;
		}

	}

	public function checkmail($str)
		{
			$this->form_validation = \Config\Services::validation();

			$this->db->select('*');
			$this->db->from('uusers');
			$this->db->where('email',$str);
			$query = $this->db->get();

			if ($query->num_rows()>0) {
			return true;
			} else {
			$this->form_validation->set_message('checkmail', lang('language_lang.forgot_email_error'));
			return false;

			}

		}

		public function captcha_check($str)
		{
			$this->form_validation = \Config\Services::validation();

			$this->load->library('recaptcha');
			$response = $this->recaptcha->verifyResponse($str);
			if (isset($response['success']) and $response['success'] === true) {
			return true;  
			}
			else
			{	
			$this->form_validation->set_message('captcha_check', ucwords(lang('language_lang.cap_err')));
			return false;
			}

		}
	

	public function GetSiteSettingsdefault($settingname) {
		
		$this->db->where('language_id','0');
		$this->db->where('settings_name',$settingname);
		
		$this->db->select('site_key, site_value');
		$this->db->from('site_controls');
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->result();
		} else {
			return false;
		}
	}

	// private function defaultLang() {
	// 	$builder = $this->db->table('language_controls');
	// 	$builder->where('language_name', $this->config->item('language'));
	// 	$builder->select('language_id');
	// 	$defult_lang_qry = $builder->get();
	// 	$defult_lang_id = $defult_lang_qry->getRow();
	// 	return $defult_lang_id->language_id;
	// }

		private function defaultLang() {
          
        $this->builder = $this->db->table('language_controls');

		$this->builder
		->where('language_name', $this->config->item('language'))
		->select('language_id');

		$defult_lang_qry = $this->builder->get();

		$defult_lang_id = $defult_lang_qry->getRow();
		
		return $defult_lang_id->language_id;
	}

	// get setting values
	public function defaultlangSettingall($settingname) {
        $builder = $this->db->table('site_controls');
		// $condition = "settings_name ='".$settingname."'";
		$defult_lang_id = $this->defaultLang();
		$builder->where('language_id',$defult_lang_id);
		$builder->where('settings_name',$settingname);
		$builder->select('site_key, site_value');
		
		// $builder->where($condition);
		$query = $builder->get();
		
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}

	// get setting values from selected language
	public function GetSettingall_lang($condition) {
		$builder = $this->db->table('site_controls');

		$builder->select('site_key, site_value');
		$builder->where($condition);
		$query = $builder->get();
		
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}

	// get table results


	public function Getslider($tablename, $condition='')
	{	
		$builder = $this->db->table($tablename);

		if($condition){
			$builder->where($condition);
		}
		$builder->select('*');
		//$builder->group_by('pre_slider_id');

		$query = $builder->get();
	
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}

		


	public function GetResults($tablename, $condition='') {
		$db      = \Config\Database::connect();

		$builder = $db->table($tablename);
		if($condition){
			$builder->where($condition);
		}
		$builder->select('*');
		$query = $builder->get();
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}

	public function tottokens($tablename,$condition){

		if($condition){
			$this->db->where($condition);
		}
		$this->db->select_sum('notokens');
		$this->db->from($tablename);

		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->row();
		} else {
			return false;
		}

	}

	// get table results
	public function GetTopInvest($tablename, $condition='') {

		if($condition){
			$this->db->where($condition);
		}
		$this->db->select_sum('amount');
		$this->db->select('uusersid,date');
		$this->db->from($tablename);
		$this->db->group_by('uusersid');
		$this->db->order_by('amount','DESC');
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->result();
		} else {
			return false;
		}
	}

	// get table results
	public function GetResultslast($tablename, $condition='') {
     
     $this->builder = $this->db->table($tablename);
   
		if($condition){
			$this->builder->where($condition);
		}

		$this->builder->select('*');
		$this->builder->orderBy('historyid','DESC');

		$query = $this->builder->get();
		
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}

	
	// get table results
	public function GetUserlastResults($tablename, $condition='') {

		if($condition){
			$this->db->where($condition);
		}
		$this->db->select('*');
		$this->db->from($tablename);
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->result();
		} else {
			return false;
		}
	}

	// get table results
	public function GetRow($tablename,$condition) {
		$db      = \Config\Database::connect();
		$builder = $this->db->table($tablename);
		
		$builder->select('*');
		$builder->where($condition);
		$query = $builder->get();
		$num=$query->getNumRows();
		
		if ($num>0) {
			return $query->getRow();
		} else {
			return false;
		}
	}

	//get row count

	public function GetRowCount($tablename,$condition) {
		$db      = \Config\Database::connect();
		$builder = $this->db->table($tablename);
		
		$builder->select('*');
		$builder->where($condition);
		$query = $builder->get();
		
		if ($query != '') {
			$num = $query->getNumRows();
			return $num;
		} else {
			return false;
		}
	}


	// get distinct value table results
	public function Getdistinct($tablename) {
		$builder = $this->db->table($tablename);
		$builder->select('uusers_ip');
		$builder->distinct('uusers_ip');
		$query = $builder->get();
		
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}

	// get limit results
	public function GetLimitedRes($tablename, $condition='', $limit) {
       $builder = $this->db->table($tablename);
		if($condition){
			$builder->where($condition);
		}
		
		$builder->select('*');
		
		
		// $builder->limit($limit);
		$query = $builder->get($limit);
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}

	// get limit results
	public function GetLimitedHis($tablename,$order,$limit) {

		$db      = \Config\Database::connect();


		$builder = $this->db->table($tablename);
		
		$builder->select('*');
		
		$builder->orderBy($order,'DESC');
		// $builder->limit($limit);
		$query = $builder->get($limit);
		// echo $builder->last_query();
		
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}

	// get limit results
	public function GetLimiteddeposit($tablename,$condition,$order) {

		
		$this->db->select('*');
		
		$this->db->from($tablename);
		$this->db->where($condition);

		$this->db->order_by($order,'DESC');
		$query = $this->db->get();
		// echo $this->db->last_query();
		
		if ($query->num_rows()>0) {
			return $query->num_rows();
		} else {
			return false;
		}
	}

	public function Getdashresult($condition,$limit) {
		$db      = \Config\Database::connect();
		$builder = $db->table('history');
		$builder->select('history.amount, history.date, history.transactionid, uusers.username, payment_controls.payment_value,payment_controls.payment_name');
	    $builder->join('uusers', 'history.uusersid = uusers.uusersid', 'inner');
	    $builder->join('payment_controls', 'history.payment_id = payment_controls.payment_id', 'inner');
	    $builder->where($condition);
	    $builder->where('payment_controls.payment_key','logo');
	    $builder->orderBy('history.date','DESC');
	    $query = $builder->get($limit);
	    if ($query->getNumRows() > 0 ) {
	    	return $query->getResult();
		} else {
			return false;
		}
	}

	public function Getcurrencypairname()
	{	
		$db      = \Config\Database::connect();
	  	$builder = $this->db->table('coin_info');
	  	$builder->select('coin_info.coin_name, coin_info.coin_image, coin_info.coin_symbol,currency_pair.status,currency_pair.mark_curr,currency_pair.cid');
	  	$builder->join('currency_pair', 'coin_info.coid = currency_pair.curid', 'inner');
	  	$query = $builder->get();
	  	if ($query->getNumRows() > 0 )
	  {
	  	return $query->getResult();
	  }
	  else
	  {
		return false;
	  }
	}	

	Public function GetCustomer($MemberId,$tablename){

		$db      = \Config\Database::connect();
	  	$builder = $this->db->table($tablename);
	  	
		$condition = "uusersid =" . "'" . $MemberId . "'";
		$builder->select('*');
		$builder->where($condition);
	
		$query = $builder->get();

		if ($query->getNumRows()>0) {
			return $query->getRow();
		} else {
			return false;
		}	
	}
				

	public function Getpaymentimgresult($condition) {
		
		$this->db->select('history.amount, history.date, history.transactionid, uusers.username, payment_controls.payment_value,payment_controls.payment_name');
	    $this->db->from('history');
	    $this->db->join('uusers', 'history.uusersid = uusers.uusersid', 'inner');
	    $this->db->join('payment_controls', 'history.payment_id = payment_controls.payment_id', 'inner');
	    $this->db->where($condition);
	    $query = $this->db->get();
	    if ($query->num_rows() > 0 ) {
	    	return $query->result();
		} else {
			return false;
		}
	}

public function GetCms(){
		// $lang_id = $this->session->userdata('langid');
		// if($lang_id){
		// 	$this->db->where('page_controls.language_id',$lang_id);
		// } else {
		// 	$defult_lang_id = $this->defaultLang();
		// 	$this->db->where('page_controls.language_id',$defult_lang_id);
		// }
		$db      = \Config\Database::connect();
	    $builder = $this->db->table('page_controls');
		// $builder->select('page_title,page_content,page_controls.language_id,language_name');
	    $builder->join('language_controls', 'page_controls.language_id = language_controls.language_id', 'inner'); 
	    $builder->groupBy('page_url');
	    $query = $builder->get();
	    return $query->getResult();
	}

	public function GetCMSpage($page_title){
		$db      = \Config\Database::connect();
	    $builder = $this->db->table('page_controls');
		
		$builder->select('page_title,page_content,page_controls.language_id,language_name');
	    $builder->join('language_controls', 'page_controls.language_id = language_controls.language_id', 'inner'); 
		$builder->where('page_url',$page_title);
	    $query = $builder->get();
	   

	    return $query->getResult();
	}

	public function Getuseronline($status){
		
		$this->db->select('date_format( lastaccess, "%Y-%m-%d %H" ) as lastaccess');
	    $this->db->from('uusers_online');
	    $this->db->join('uusers', 'uusers_online.uusers_id = uusers.uusersid', 'inner'); 
		$this->db->where('status',$status);
		
	    $query = $this->db->get();
	    // echo $this->db->last_query();
	    return $query->getResult();
	}

	public function Getuseronlinecount($status){
		
		$this->db->select('page_title,page_content,page_controls.language_id,language_name');
	    $this->db->from('uusers_online');
	    $this->db->join('uusers', 'uusers_online.uusers_id = uusers.uusersid', 'inner'); 
		$this->db->where('status',$status);
	    $query = $this->db->get();
	    // echo $this->db->last_query();
	    return $query->num_rows();
	}

	
	public function Getpageinfo($page_title,$lang_id){

		$db      = \Config\Database::connect();
	    $builder = $this->db->table('page_controls');
		
		$builder->select('page_content,page_title,page_url');
	    
		$builder->where('page_url',$page_title);
		$builder->where('language_id',$lang_id);
	    $query = $builder->get();
	    // echo $this->db->last_query();
	    return $query->getRow();
	}

	public function GetCMSpageLang($page_url,$lang_id){

		$db      = \Config\Database::connect();
		$builder = $this->db->table('page_controls');
		$builder->select('page_content,page_controls.language_id,language_name');
	    $builder->join('language_controls', 'page_controls.language_id = language_controls.language_id', 'inner'); 
		$builder->where('page_url',$page_url);
		$builder->where('page_controls.language_id',$lang_id);
	    $query = $builder->get();
	    // echo $this->db->last_query();
	    return $query->getResult();
	}

	public function GetuserCMS($page_url,$lang_id){
		
		$this->builder = $this->db->table('page_controls');

		$this->builder->select('page_content, page_title');
	    $this->builder->join('language_controls', 'page_controls.language_id = language_controls.language_id', 'inner'); 
		$this->builder->where('page_url',$page_url);
		$this->builder->where('page_controls.language_id',$lang_id);
		$this->builder->where('page_controls.page_status','1');
	    $query = $this->builder->get();
	    // echo $this->db->last_query();
	    return $query->getRow();
	}


	public function GetPaymentsName($condition) {

		$db      = \Config\Database::connect();
		$builder = $this->db->table('payment_controls');
		$builder->where($condition);
		// $builder->select('payment_name');
		$builder->select('*');
		
		// $builder->group_by('payment_name');
		$query = $builder->get();
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}

	public function GetPayment($paymentid) {

		$db      = \Config\Database::connect();
		$builder = $this->db->table('payment_controls');
		$builder->where('payment_id',$paymentid);
		// $builder->where('payment_name',$paymentname);
		$builder->select('payment_id, payment_name, payment_key, payment_value');
		$builder->orderBy('payid', 'DESC');
		$query = $builder->get();
		// echo $this->db->last_query();
		if ($query->getNumRows()>0) {
			// pr($query->result());
			return $query->getResult();
		} else {
			return false;
		}
	}

	// check admin password
	public function getPassword($username){

		$db      = \Config\Database::connect();
		$builder = $this->db->table('admin');
		$builder->where('username',$username);
		$builder->where('status','1');
		$builder->select('*');
		$query = $builder->get();
		if ($query->getNumRows() == 1) {
			$row = $query->getRow();
			return $row;
		} else {
			return false;
		}
	}

	public function GetUser($uusersid){

		$db      = \Config\Database::connect();
	    $builder = $this->db->table('uusers');
		$builder->select('uusers.*,uusers_security.*');
	    $builder->join('uusers_security', 'uusers.uusersid = uusers_security.uusersid', 'inner'); 
	    // $builder->join('rank_controls', 'uusers.rankid = rank_controls.rankid', 'left'); 
	    $builder->where('uusers.uusersid',$uusersid);
	    $query = $builder->get();
	    
	    return $query->getRow();
	}

	public function GetFaq(){

		$db      = \Config\Database::connect();
	    $builder = $this->db->table('faq_controls');
		$builder->select('*');
	    $builder->join('language_controls', 'faq_controls.language_id = language_controls.language_id', 'inner'); 
	    $query = $builder->get();
	    return $query->getResult();
	}

	public function GetNews(){

		$db      = \Config\Database::connect();
	    $builder = $this->db->table('news_controls');

		$builder->select('*');
	    $builder->join('language_controls', 'news_controls.language_id = language_controls.language_id', 'inner'); 
	    $query = $builder->get();
	    return $query->getResult();
	}

	public function getMailTemplates() {

		$db      = \Config\Database::connect();
	    $builder = $this->db->table('mail_template');
		$builder->select('*');
	  $builder->join('mailtemplates', 'mail_template.subject = mailtemplates.mailid', 'inner'); 
	    // $builder->where('mailtemplates.template_name',$subject);
	    $query = $builder->get();
	    if ($query->getNumRows() > 0 ) {
	    	return $query->getResult();
		} else {
			return false;
		}
	}

	public function getMailTemplate($subject) {
		$db      = \Config\Database::connect();
	    $builder = $this->db->table('mail_template');
		$builder->select('*');
	    $builder->join('mailtemplates', 'mail_template.subject = mailtemplates.mailid', 'inner'); 
	    // $builder->where('mailtemplates.template_name',$subject);
	    $builder->where('mailtemplates.mailid',$subject);

	    $query = $builder->get();
	    if ($query->getNumRows() > 0 ) {
	    	return $query->getRow();
		} else {
			return false;
		}
	}

	public function GetUsername($tablename,$condition) {
		
		$this->db->select('username');
		$this->db->from($tablename);
		$this->db->where($condition);
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->row();
		} else {
			return false;
		}
	}

	public function GetEarnings($tablename,$condition){

		$db      = \Config\Database::connect();
		$builder = $this->db->table($tablename);
		$builder->select('sum(amount) as earnamt');
		$builder->where($condition);
		$query = $builder->get();
		
		if ($query->getNumRows()>0) {
			return $query->getRow();
		} else {
			return false;
		}
	}


	// get table results
	public function GetPackages($condition='') {
			return false;
	}

	public function sumofhistory($condition) {

		$db      = \Config\Database::connect();
	    $builder = $this->db->table('history');
		$builder->selectSum('amount');
	    $builder->where($condition);
	    $query = $builder->get();
	    
	    if ($query->getNumRows() > 0 ) {
	    	$tot_amount = $query->getRow();
	    	return $tot_amount->amount;
		} else {
			return false;
		}
	}

	public function sumofhistorybtc($condition) {

		$db      = \Config\Database::connect();
	    $builder = $this->db->table('history');
		$builder->selectSum('btc_amount');
	    $builder->where($condition);
	    $query = $builder->get();
	    
	    if ($query->getNumRows() > 0 ) {
	    	$tot_amount = $query->getRow();
	    	return $tot_amount->btc_amount;
		} else {
			return false;
		}
	}		

	public function RecordCount($tablename, $condition) {
		$db      = \Config\Database::connect();
	    $builder = $this->db->table($tablename);
		$builder->select('*');
	    $builder->where($condition);
	    $query = $builder->get();
	    
	    if ($query->getNumRows() > 0 ) {
	    	return $query->getNumRows();
		} else {
			return false;
		}
	}

	public function Depositcount($tablename, $condition) {

		$db      = \Config\Database::connect();
	    $builder = $this->db->table($tablename);
		$builder->select('COUNT(*) as coun','date');
	    $builder->where($condition);
	    $builder->groupBy('DATE(date)');
	    $query = $builder->get();
	    
	    if ($query->getNumRows() > 0 ) {
	    	return $query->getResult();
		} else {
			return false;
		}
	}

	public function GetDate($tablename,$condition){
		$this->db->select('count(date) as check_date');
		$this->db->from($tablename);
		$this->db->where($condition);
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->row();
		} else {
			return false;
		}	
	}
    
    public function GetAdminmail($tablename){
		$this->db->select('email');
		$this->db->from($tablename);
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->row();
		} else {
			return false;
		}	
	}

	public function GetAdmin($tablename){
		$this->db->select('*');
		$this->db->from($tablename);
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->row();
		} else {
			return false;
		}	
	}
	
	public function getUserpassword($username){

		$db      = \Config\Database::connect();
		$builder = $this->db->table('uusers');
		// $this->db->where('status','1');
		$builder->select('uusers.*,uusers_security.changeip,uusers_security.change_browser,uusers_security.two_factor');
		
		$builder->join('uusers_security', 'uusers.uusersid = uusers_security.uusersid', 'left');
		$builder->where('uusers.username',$username);
		$query = $builder->get();
		if ($query->getNumRows() == 1) {
			$row = $query->getRow();
			return $row;
		} else {
			return false;
		}
	}

	public function getUsersid($email)
	{

		$db      = \Config\Database::connect();
		$builder = $this->db->table('uusers');

		$builder->where('username',$email);

		$builder->select('*');

		$query = $builder->get();

		


		if ($query->getNumRows()>0) {
			
			return $query->getRow();
		} else {
			return false;
		}




	}

	public function PaymentName($paymentname) {
		$builder = $this->db->table('payment_controls');
		$builder->where('payment_name',$paymentname);
		$builder->where('payment_key','logo');
		$builder->select('payment_id, payment_name, payment_key, payment_value');
		$query = $builder->get();
		if ($query->getNumRows()>0) {
			
			return $query->getRow();
		} else {
			return false;
		}
	}

	public function DepositData() {

		$this->db->select('deposit.*, plans.rate, package.*,periord.periord_name');
		$this->db->where('deposit.status','active');
		$this->db->from('deposit');
		$this->db->join('plans', 'deposit.planid = plans.planid', 'left');
		$this->db->join('package', 'package.packageid = plans.packageid', 'left');
		$this->db->join('periord', 'periord.periord_id = package.periord_id', 'left');
		// $condition = "deposit.run_date < DATE_SUB(NOW(),INTERVAL 5 MINUTE)";
		//$condition = "deposit.run_date < '".date('Y-m-d H:i:s')."'";
		//$condition = "(deposit.invest_date > '".date('Y-m-d H:i:s')."' OR deposit.run_date < '".date('Y-m-d H:i:s')."')";
		// LIKE '%2017-09-12%'
		$condition = "(deposit.invest_date LIKE '%".date('Y-m-d')."%' OR deposit.run_date LIKE  '%".date('Y-m-d')."%')";

		$this->db->where($condition);
		// $this->db->limit('5');
		$query = $this->db->get();


		
		if ($query->num_rows()>0) {
			return $query->result();
		} else {
			return false;
		}
	}

	public function successDeposit($depositid) {

		$this->db->select('deposit.*, plans.rate, package.*,periord.periord_name');
		$this->db->from('deposit');
		$this->db->join('plans', 'deposit.planid = plans.planid', 'left');
		$this->db->join('package', 'package.packageid = plans.packageid', 'left');
		$this->db->join('periord', 'periord.periord_id = package.periord_id', 'left');
		$this->db->where('deposit.status','pending');
		$this->db->where('deposit.depositid', $depositid);
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->row();
		} else {
			return false;
		}
	}

	// get setting values
	public function GetMultiSetting() {

		$db      = \Config\Database::connect();
		$builder = $this->db->table('site_controls');
		$in_condition = "settings_name IN ('login', 'user', 'referral', 'register_field')";
		$builder->where($in_condition);

		// $builder->where_in("settings_name",$in_condition);
		$builder->select('site_key, site_value');
		// $builder->where($condition);
		$query = $builder->get();
		
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}
	
	public function getDepositData($depositid) {
		$db      = \Config\Database::connect();
		$builder = $this->db->table('deposit');
		$builder->select('deposit.*, deposit.status as dstatus'/*plans.rate, plans.plan_name, package.*,periord.periord_name*/);
		$builder->where('deposit.status','active');
		// $builder->join('plans', 'deposit.planid = plans.planid', 'left');
		// $builder->join('package', 'package.packageid = plans.packageid', 'left');
		// $builder->join('periord', 'periord.periord_id = package.periord_id', 'left');
		// $condition = "deposit.run_date < DATE_SUB(NOW(),INTERVAL 5 MINUTE)";
		// $condition = "deposit.run_date < '".date('Y-m-d H:i:s')."'";
		$builder->where('deposit.depositid',$depositid);
		// $builder->limit('5');
		$query = $builder->get();
		if ($query->getNumRows()>0) {
			return $query->getRow();
		} else {
			return false;
		}
	}

	public function earningDepositData($depositid) {

		$this->db->select('deposit.*, deposit.status as dstatus, plans.rate, plans.plan_name, package.*,periord.periord_name');
		// $this->db->where("deposit.status != 'pending'");
		$this->db->from('deposit');
		$this->db->join('plans', 'deposit.planid = plans.planid', 'left');
		$this->db->join('package', 'package.packageid = plans.packageid', 'left');
		$this->db->join('periord', 'periord.periord_id = package.periord_id', 'left');
		// $condition = "deposit.run_date < DATE_SUB(NOW(),INTERVAL 5 MINUTE)";
		// $condition = "deposit.run_date < '".date('Y-m-d H:i:s')."'";
		$this->db->where('deposit.depositid',$depositid);
		// $this->db->limit('5');
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->row();
		} else {
			return false;
		}
	}

	public function Depositlist() {

		$this->db->select('deposit.*, deposit.status as dstatus, plans.rate, plans.plan_name, package.*,periord.periord_name');
		$this->db->from('deposit');
		$this->db->join('plans', 'deposit.planid = plans.planid', 'left');
		$this->db->join('package', 'package.packageid = plans.packageid', 'left');
		$this->db->join('periord', 'periord.periord_id = package.periord_id', 'left');
		$this->db->where('deposit.status','active');
		$this->db->where('deposit.uusersid', $this->session->userdata('uusersid'));
		// $this->db->limit('5');
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->result();
		} else {
			return false;
		}
	}

	public function GetUsers() {

		$db      = \Config\Database::connect();
		$builder = $this->db->table('uusers');
		
		$builder->select('uusers.*, country.Country');
		$builder->join('country', 'uusers.country = country.iso_2', 'left');
		$builder->where('uusers.status', '1');
		$query = $builder->get();
		
		if ($query->getNumRows()>0) {
			return $query->getResult();
		} else {
			return false;
		}
	}

	public function Getdashresultsumby($condition,$limit) {

		$db      = \Config\Database::connect();
		$builder = $this->db->table('history');
		$builder->select('history.amount, history.date, history.transactionid, uusers.username, payment_controls.payment_value,payment_controls.payment_name');
	    $builder->join('uusers', 'history.uusersid = uusers.uusersid', 'inner');
	    $builder->join('payment_controls', 'history.payment_id = payment_controls.payment_id', 'inner');
	    $builder->where($condition);
	    $builder->where('payment_controls.payment_key','logo');
	    // $builder->limit($limit);
	    $builder->orderBy('history.amount','DESC');
	    $query = $builder->get($limit);
	    if ($query->getNumRows() > 0 ) {
	    	return $query->getResult();
		} else {
			return false;
		}
	}

	public function userdownlinerank($uusersid){

		// SELECT uusers_matrix.*, uusers.rankid FROM `uusers_matrix` LEFT JOIN uusers ON uusers_matrix.uusersid = uusers.uusersid WHERE uusers_matrix.uusersid = '2' 
		
		$this->db->select('uusers_matrix.*,uusers.rankid');
	    $this->db->from('uusers_matrix');
	    $this->db->join('uusers', 'uusers_matrix.uusersid = uusers.uusersid', 'left'); 
		$this->db->where('uusers_matrix.uusersid',$uusersid);
	    $query = $this->db->get();
	    // echo $this->db->last_query();
	    return $query->row();
	}

	public function GetSiteSett($settingname) {

		$condition = "settings_name ='".$settingname."'";
		
		$this->db->where('settings_name',$settingname);
		$this->db->select('site_key, site_value');
		$this->db->from('site_controls');
		$this->db->group_by('site_key');
		
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->result();
		} else {
			return false;
		}
	}
	
// NEW

	// Count rows
	public function GetCounts($tablename, $condition='') {

		if($condition){
			$this->db->where($condition);
		}
		
		$this->db->select('*');
		$this->db->from($tablename);
		$query = $this->db->get();
		return $query->num_rows();
		
	}
	public function GetAddress($tablename, $condition='', $limit) {

		if($condition){
			$this->db->where($condition);
		}
		
		$this->db->select('*');
		$this->db->from($tablename);
		$this->db->limit($limit);
		$query = $this->db->get();
		
		if ($query->num_rows()>0) {
			return $query->row();
		} else {
			return false;
		}
	}

	public function today_profit($userid,$exchange=''){
		
		if($exchange=='')
		    $exchange='5';

        $date=date("Y-m-d");
        //$date='2024-12-05';
        $trade_profit_query= $this->db->query("select sum(comm_price)as comm_price from api_trade_history where uuserid='".$userid."' and date='".$date."' and type='2' and exchange='".$exchange."'")->getRow();
		$today_profit = $trade_profit_query->comm_price;

		
		if ($today_profit <= 0) {
			$today_profit = '0.00';
		}

		return $today_profit;
	}

	public function total_profit($userid,$exchange='')
	{
	    if($exchange=='')
		    $exchange='5';
		//$trade_profit_query = $this->db->table('history')->selectSum('amount')->where('uusersid',$userid)->where('type','trade_profit')->orderBy('historyid','DESC')->get()->getRow();

  //$trade_profit_query = $this->db->table('api_trade_history')->selectSum('comm_price')->where('uuserid',$userid)->where('type','2')->orderBy('id','DESC')->getRow();

       $trade_profit_query= $this->db->query("select sum(comm_price)as comm_price from api_trade_history where uuserid='".$userid."' and type='2' and exchange='".$exchange."'")->getRow();
		$total_profit = $trade_profit_query->comm_price;

		// $circle_profit_query = $this->db->table('history')->selectSum('amount')->where('uusersid',$userid)->where('type','circle_profit')->orderBy('historyid','DESC')->get()->getRow();
		
		// $circle_profit = $circle_profit_query->amount;
		
		// $total_profit = $trade_profit + $circle_profit;

		if ($total_profit <= 0) {
			$total_profit = '0.00';
		}

		return $total_profit;
	}

	public function today_reward_profit($userid) {
		$trade_profit_query = $this->db->table('history')->selectSum('amount')->where('uusersid',$userid)->where('type','commissions')->like('date', date('Y-m-d'))->orderBy('historyid','DESC')->get()->getRow();
		$trade_profit = $trade_profit_query->amount;
		if ($trade_profit <= 0) {
			$trade_profit = '0.00';
		}
		return $trade_profit;
	}

	public function total_reward_profit($userid){
		$trade_profit_query = $this->db->table('history')->selectSum('amount')->where('uusersid',$userid)->where('type','commissions')->orderBy('historyid','DESC')->get()->getRow();
        $trade_profit = $trade_profit_query->amount;

		if ($trade_profit <= 0) {
			$trade_profit = '0.00';
		}

		return $trade_profit;
	}

	public function date_profit($date){
		$trade_profit_query = $this->db->table('history')->selectSum('amount')->where('uusersid',$userid)->where('type','trade_profit')->like('date', $date)->orderBy('historyid','DESC')->get()->getRow();

		$trade_profit = $trade_profit_query->amount;

		$circle_profit_query = $this->db->table('history')->selectSum('amount')->where('uusersid',$userid)->where('type','circle_profit')->like('date',$date)->orderBy('historyid','DESC')->get()->getRow();
		
		$circle_profit = $circle_profit_query->amount;
		
		$today_profit = $trade_profit + $circle_profit;

		if ($today_profit <= 0) {
			$today_profit = '0.00';
		}

		return $today_profit;
	}

}