<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php
		$session = session();
		$validation = \Config\Services::validation();
		helper('form');

		 echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<!-- /theme JS files -->
	

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>

    <!-- ckeditor JS files 
	<script type="text/javascript" src="<?php echo base_url();?>assets/ckeditor/ckeditor.js"></script>-->

	<!-- ckeditor JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/ckeditor/ckeditor.js');?>"></script>
	<script src="<?php echo base_url('assets/boots/js/jquery.js');?>"></script>
</head>

<body class="navbar-top-md-md">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.footer_page_title'); ?></span></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
						    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
						<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.footer_page_title'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
                	</div>
                	
					<div class="panel-body">
						<form class="form-horizontal footersetting" action="<?=site_url($action);?>" method="post" enctype="multipart/form-data">

							<?php 
								if($validation->listErrors()) { 
									$form_err_data = str_replace('<p>', '', $validation->listErrors());
									$form_err_data = str_replace('</p>', '', $form_err_data);
									$form_err_data = str_replace('.', '', $form_err_data);
							?>
									
									<script type="text/javascript">
									
									(function( $ ) {
										$.jGrowl.defaults.closer = false;
								        var from_daa = '<?php $form_err_data;?>';
										$.jGrowl(from_daa, {
								            header: '<?php echo lang("language_lang.error");?>',
								            theme: 'bg-danger'
								        });
								    
									})(jQuery);


									</script>
							<?php
								}
							?>

							<!-- Text Area -->
							<div class="form-group <?php if($validation->getError('footer1')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.Footer_1'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-11">
									<textarea rows="5" name="footer1" cols="5" class="form-control ckeditor" ><?php echo set_value('footer1',isset($this->data['footer1']) ? $this->data['footer1'] : ''); ?></textarea>
									<?php echo $validation->getError('footer1', '<span class="help-block">', '</span>'); ?>
								</div>
							</div>
							<!-- /Text Area -->

							<!-- Text Area -->
							<div class="form-group <?php if($validation->getError('footer2')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.Footer_2'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-11">
									<textarea rows="5" name="footer2" cols="5" class="ckeditor form-control" ><?php echo set_value('footer2',isset($this->data['footer2']) ? $this->data['footer2'] : ''); ?></textarea>
									<?php echo $validation->getError('footer2', '<span class="help-block">', '</span>'); ?>
								</div>
							</div>
		

							<!-- Text Area -->
							<div class="form-group <?php if($validation->getError('footer_note')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.Footer_Note'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-11">
									<textarea rows="5" name="footer_note" cols="5" class="form-control ckeditor" ><?php echo set_value('footer_note',isset($this->data['footer_note']) ? $this->data['footer_note'] : ''); ?></textarea>
									<?php echo $validation->getError('footer_note', '<span class="help-block">', '</span>'); ?>
								</div>
							</div>
							<!-- /Text Area -->

						
							<div class="text-right col-lg-9">
								<button type="submit" class="btn btn-primary"><?php echo lang('language_lang.button_update'); ?> <i class="icon-arrow-right14 position-right"></i></button>
							</div>
						</form>
					</div>
				</div>
				<!-- /horizotal form -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
	jQuery.noConflict();
	(function( $ ) {
	$(function() {

		$(document).ready(function() {

			$.jGrowl.defaults.closer = false;

			<?php if($session->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($session->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>

		    $('.footersetting').formValidation({
		    	framework: 'bootstrap',
		    	excluded: [':disabled'],
		        icon: {
		            valid: 'glyphicon glyphicon-ok',
		            invalid: 'glyphicon glyphicon-remove',
		            validating: 'glyphicon glyphicon-refresh'
		        },
		        fields: {
		            footer_note: {
		                message: '<?php echo lang("language_lang.footer_text_invalid"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.footer_text_required"); ?>'
		                    },
		                    stringLength: {
		                        min: 5,
		                        message: '<?php echo lang("language_lang.footer_text_long"); ?>'
		                    }
		                }
		            },
		            footer1: {
		                message: '<?php echo lang("language_lang.footer1_text_invalid"); ?>',
		               
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.footer1_text_required"); ?>'
		                    },
		                    stringLength: {
		                        min: 5,
		                        message: '<?php echo lang("language_lang.footer1_text_long"); ?>'
		                    }
		                }
		            },
		            footer2: {
		                message: '<?php echo lang("language_lang.footer2_text_invalid"); ?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.footer2_text_required"); ?>'
		                    },
		                    stringLength: {
		                        min: 5,
		                        message: '<?php echo lang("language_lang.footer2_text_long"); ?>'
		                    }
		                }
		            },
		         
		        
		            
		        }
		    })
			.find('[name="footer_note"], [name="footer1"], [name="footer2"], [name="footer3"], [name="footer4"]')
			.each(function() {
				$(this)
	            .ckeditor()
	            .editor
	                .on('change', function(e) {
	                    $('.footersetting').formValidation('revalidateField', e.sender.name);

	                });
	         });
             $('[name="footer1"]').ckeditor();
             $('[name="footer2"]').ckeditor();
             $('[name="footer3"]').ckeditor();
             $('[name="footer4"]').ckeditor();

	          // .find('[name="footer1"]')
	          //   .ckeditor()
	          //   .editor
	          //       .on('change', function() {
	          //           $('.footersetting').formValidation('revalidateField', 'footer1');
	          //       });      
	                
	        $('#icon-bck').on('click',function() {
				window.history.back();
			});
		});

	});
	})(jQuery);

	
	</script>

</body>
</html>
