<!doctype html>
<html lang="en" translate="no" class="w-[640px] mx-auto md:w-full">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Asset Wallet - Overview History</title>
    <?php echo view('user/layout/head');?>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.8/css/dataTables.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs4/dt-1.10.18/b-1.5.6/sc-2.0.0/sl-1.3.0/datatables.min.css">
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.3/themes/base/jquery-ui.css">
  </head>

  <?php 
$user_ag = $_SERVER['HTTP_USER_AGENT'];

if(preg_match('/(Mobile|Android|Tablet|GoBrowser|[0-9]x[0-9]*|uZardWeb\/|Mini|Doris\/|Skyfire\/|iPhone|Fennec\/|Maemo|Iris\/|CLDC\-|Mobi\/)/uis',$user_ag))
{
	$deviceType='mobile';
}
else
{
	$deviceType='computer';
}
?>

  <style>
    .items-owner-box {
    border: 1px solid #403D52;
    border-radius: 8px;
    padding: 0 0 0;
    margin-top: 10px;
    }
    .style-two.items-owner {
    padding: 15px 20px 0;
    min-height:140px;
    overflow:auto;
    }
    .style-two .items-owner-thumb {
    float: left;
    margin-right: 10px;
    }
    .style-two .items-owner-title {
    float: left;
    }
    .items-owner-title h5 {
    font-size: 16px;
    color: #5D82FF;
    font-weight: 400;
    margin: 0;
    }
    .style-two .items-owner-title span {
    color: #fff;
    font-style: inherit;
    padding-left: 6px;
    line-height: 21px;
    font-size:14px;
    margin-top:10px;
    }
    .style-two .item-price {
    text-align: right;
    }
    .style-two.upper.items-owner {
    border-bottom: none;
    padding: 15px 20px 0;
    }
    .style-two .item-price p {
    color: #fff;
    line-height: 22px;
    }
    .float {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0; /* Optional: Add some padding for spacing */
    border-bottom: none; /* Optional: Add a border for visual separation */
    }
    .mode{
    padding:10px;
    border:1px solid #ddd;
    margin-bottom:10px;
    margin-left:20px;
    }
    .toggle-icon {
    position: relative;
    top: 10px;
    right: 10px;
    cursor: pointer;
    }
    .toggle-icon i {
    font-size: 20px;
    }
    .show {
    display: block !important;
    }
    .hide {
    display: none !important;
    }
    .left { text-align: left;}
    .right {  text-align: right;}
    .btn-success { border-radius:0px;background:green;font-size:12px;}
    .btn-danger { border-radius:0px;background:red;font-size:12px;}
    .pagination {
    display: flex;
    justify-content: center;
    margin-top: 20px;
    }
    .pagination-btn {
    background: #007bff;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
    margin: 0 5px;
    }
    .pagination-btn:disabled {
    background: #6c757d;
    cursor: not-allowed;
    }
    #pageInfo {
    align-self: center;
    margin: 0 10px;
    }
    #myItems { padding:10px;}
    .modal-backdrop.show { opacity:1; position:relative;}
    .text-primary {font-size:15px;}
    .btn-danger {width:100px;padding:10px;border-radius:10px;}
    .btn-success {width:100px;padding:10px;border-radius:10px;}
 
  </style>

<?php 

if($deviceType=='computer')
{
?>
<style>
 .description {padding-top:30px;float:right;}
</style>
<?php 
}
else
{
?>
<style>
 .description {padding-top:30px;clear:both;}
</style>
<?php 
}
?>
  <body class="reg-overflow">
      <section class="banner-bg overall-bg ">
      <div class="container">
        <!---header start---->
        <?php echo view('user/layout/header');?>
        <!---header end---->
        <!---banner start---->
        <div class="row">
          <div class="col-lg-12">
            <?php 
              use App\Libraries\MyEncrypt;
              use App\Helpers\site_helper;
              use App\Helpers\form_helper;
              $this->db = db_connect();
              $this->session = session();
              $this->common_model = model('CommonModel');
              helper('form_helper');
              
              
              $id = 'NyYmemh5aXA=';
                      
              $myencrypt = new MyEncrypt;
              $coinid = $myencrypt->decode($id);
              $user=$this->session->get('uusersid');
              $buy_bal=curbalance($this->session->get('uusersid'),$coinid);
              $bal=str_replace(",","", $buy_bal);
              
              ?>
            <div class="dash-wrap">
              <div class="title text-center py-1">
                <h2 class="text-primary">Asset Wallet Summary</h2>
              </div>
              <div class="team-profit-content">
                <div class="row">
                  <div class="col-lg-6  col-sm-6 py-2">
                    <div class="team-list">
                      <p class="fw-bold text-white mb-0">Total Assets Accumulated</p>
                      <h5 class="fw-bold text-white">
                        <br>
                      <?php echo number_format($earnings,2); ?> USDT</h4>
                    </div>
                  </div>
                  <div class="col-lg-6  col-sm-6 py-2"  >
                    <div class="team-list">
                      <p class="fw-bold text-white mb-0">Total Deduction </p>
                      <h5 class="fw-bold text-white">
                      <br>
                      <?php echo  number_format($expense,2); ?> USDT</h4>
                    </div>
                  </div>
                </div>
              </div>
              <div class="operation-content">
                <h3 class="text-primary py-1"> <span id="total_count"> <?php echo $total_count;?> </span> Records <a href="" data-bs-toggle="modal" data-bs-target="#staticBackdrop1" data-bs-whatever="@fat" class="text-decoration-none"><i class="fa fa-filter" id="balance_load" style="float:right;color:#fff;"></i></a> </h3>
              </div>
              <br>
              <div class="modal fade" id="staticBackdrop1" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" style="display: none;" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                  <div class="modal-content" style="border-radius:30px;padding: 11px;" >
                    <div class="modal-header" style="padding-top: 11px;margin-bottom:-15px;">
                      <p class="modal-title" id="staticBackdropLabel" style="padding-left:170px;"><b>Records Filter</b></p>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                      <div class="row col-lg-12 mt-3">
                        <div class="form-check form-check-right mb-3" style="font-size: 14px;">
                          <div class="form-group">
                            <label class="btn btn-default">Start Date</label>
                            <input type="text" name="start_date" id="start_date" class="form-control" required>
                          </div>
                          <div class="form-group">
                            <label class="btn btn-default">End Date</label>
                            <input type="text" name="end_date" id="end_date" class="form-control" required>
                          </div>
                          <div id="date_err" style="color:red;font-size:12px;font-weight:bold;"></div>
                        </div>
                      </div>
                    </div>
                    <div class="modal-footer" >
                      <button  type="button" class="btn btn-secondary" name="button"  id="confirm">Search</button>
                      <button  type="button" class="btn btn-secondary" name="button"  id="reset">Reset</button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="profit-content" id="myItems">
                <?php 
                  $i=0;
                  if ($records) 
                  {
                   foreach ($records as $value) 
                   {

                 
                       
                      $type=str_replace('_',' ',$value->type);
                      $type=ucwords($type);
                    $i++;
                    ?>
                <div class="items-owner-box">
                  <div class="items-owner style-two">
                   
                    <div class="items-owner-title">
                      <h5 style="margin-top:10px;"><?php echo $type;?> </h5>
                      <br>
                      <span><?php echo $value->date;?></span>
                    </div>
                    <div class="item-price">
                      <label class="btn btn-success">+ <?php echo number_format($value->amount,4);?></label>
                    </div>
                    <div class="description">
                        <span style="color:#fff;"><?php echo $value->description;?> </span>
                    </div>
                   
                  </div>
                  
                </div>
                <?php } }?>
              </div>
              <div class="pagination">
                <button id="prevPage" class="pagination-btn" onclick="changePage('prev')">« Previous</button>
                <span id="pageInfo"></span>
                <button id="nextPage" class="pagination-btn" onclick="changePage('next')">Next »</button>
              </div>
            </div>
            <!---banner end---->
          </div>
        </div>
      </div>
      <?php echo view('user/layout/footer');?>
      </div>
    </section>
    <?php echo view('user/layout/footer-script');?>
    <script src="<?php echo base_url();?>/styles/new_style/js/notify.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.js"></script>
    <script src="https://code.jquery.com/ui/1.13.3/jquery-ui.js"></script>
    <script>
      $( function() {
             $( "#start_date").datepicker({
                 dateFormat: 'yy-mm-dd'
             });
               $( "#end_date").datepicker({
                 dateFormat: 'yy-mm-dd'
             });
         } );
      
      let currentPage = 1;
      const itemsPerPage = 10; // Number of items per page
      let totalPages =1;
      let start_date='';
      let end_date='';
      
      document.addEventListener('DOMContentLoaded', function() {
      loadPage(currentPage,start_date,end_date);
      });
      
      
      
      function loadPage(page,start_date,end_date)
      {
        var uusersid='<?php echo $this->session->get('uusersid');?>';
        $.ajax({
        'method': 'POST',
        'url': '<?php echo base_url("/assetwallet_records");?>',
        data:{'uusersid':uusersid,"page":page,"itemsPerPage":itemsPerPage,"start_date":start_date,"end_date":end_date},
        success:function(data)
        {
      // alert('ok');
         var data= JSON.parse(data);
         console.log(data.totalPages);
         const myItems = document.getElementById('myItems');
         myItems.innerHTML = '';
      
         if (data.items.length === 0) {
             myItems.innerHTML = `<div class="faq_accordian mb-3">
                     <div class="accordion" style="margin:10px;text-align:center;color:red;"> No Records Found</div></div>`;
         }
         else
         {
          var value="<?php if(!empty($value->date)) {  echo date('d-M-Y',strtotime($value->date)); } else { echo "";} ?>";
      
         data.items.forEach(item => {
             myItems.innerHTML += `
                <div class="items-owner-box">
                  <div class="items-owner style-two">
                   
                    <div class="items-owner-title">
                      <h5 style="margin-top:10px;">${item.type}</h5>
                      <br>
                      <span>${item.date}</span>
                    </div>
                    <div class="item-price">
                      ${item.amount}
                    </div>
                    <div class="description">
                        <span style="color:#fff;">${item.description}</span>
                    </div>
                   
                  </div>
                  
                </div>
             
             `; });
         }
      
      totalPages=data.totalPages;
      start_date=start_date;
      end_date=end_date;
      
      
      document.getElementById('total_count').innerHTML=data.totalitems;
      document.getElementById('prevPage').disabled = !data.hasPrev;
         document.getElementById('nextPage').disabled = !data.hasNext;
         document.getElementById('pageInfo').innerText = `Page ${page} of ${data.totalPages}`;
      }
      })
      
      
      
      }
      
      function changePage(direction) {
      
      if (direction === 'prev' && currentPage > 1) {
      currentPage--;
      } else if (direction === 'next' && currentPage < totalPages) {
      currentPage++;
      }
      
      loadPage(currentPage,start_date,end_date);
      }
      
      
      $('#confirm').click(function(){
      $("#date_err").html("");
      var start_date=$("#start_date").val();
      var end_date=$("#end_date").val();
      
      if(start_date!='' && end_date=='')
      {
      $("#date_err").html("Start and End date Must Required");
      }
      else if(start_date=='' && end_date!='')
      {
      $("#date_err").html("Start and End date Must Required");
      }
      else
      {
      
      $('#staticBackdrop1').modal('hide');
      let currentPage = 1;
      loadPage(currentPage,start_date,end_date);
      }
      
      });
      
      $('#reset').click(function(){
      let currentPage = 1;
      $("#start_date").val('');
      $("#end_date").val('');
      
      $('#staticBackdrop1').modal('hide');
      
      loadPage(currentPage);
      });
    </script>
  </body>
</html>
