var express = require('express');
const crypto  = require('crypto');
const solanaWeb3 = require('@solana/web3.js');
const { TronWeb } = require('tronweb');
const Wallet = require('ethereumjs-wallet');
const Web3 = require('web3');
const cors = require('cors');




var app = express();
app.use(express.json());      

app.use(express.urlencoded({ extended: true }));

const corsOptions = {
  methods: ['GET', 'POST'],
};

// Enable CORS for all routes with the specified options
app.use(cors(corsOptions));

app.get('/wallet', function (req, res) {
  res.send('Hello World!');
});

app.get('/wallet/get_address', function (req, res) {


const keypair = solanaWeb3.Keypair.generate();

  res.json({
    publicKey: keypair.publicKey.toBase58(),
    secretKey: Buffer.from(keypair.secretKey).toString('base64'), // Encode secret key for safe transfer
  });

});


app.get('/wallet/btc_address', function (req, res) {


const bitcoin = require('bitcoinjs-lib');
const ECPairFactory = require('ecpair').default;
const ecc = require('tiny-secp256k1');
const ECPair = ECPairFactory(ecc);
const network = bitcoin.networks.bitcoin;

 const keyPair = ECPair.makeRandom({ network: network });

// Extract the public key
//const pubkey = keyPair.publicKey;

//const pubkey = Buffer.from(keyPair.publicKey);

const pubkey = Buffer.from(keyPair.publicKey,'hex');


const { address: p2pkhAddress } = bitcoin.payments.p2pkh({
  pubkey: pubkey,
  network: network,
});


const privateKey = keyPair.toWIF(); 

   const wallet = {
            address: p2pkhAddress,
            privateKey: privateKey,
        };

  res.json(wallet);

});


app.get('/wallet/eth_address', function (req, res) {

const web3 = new Web3();
const account = web3.eth.accounts.create();

// Display the generated account details
console.log("Private Key:", account.privateKey);
console.log("Public Key:", account.address);
res.json(account);

  const wallet = {
            address: account,
            privateKey: account.privateKey,
        };

        // Send wallet information in the response
res.json(wallet);
 
 

});




app.get('/wallet/tron-address', async (req, res) => {
    try {
        // Generate a private key
        const privateKey = crypto.randomBytes(32).toString('hex');
        console.log(privateKey);
        const tronWeb = new TronWeb({fullHost:'https://api.trongrid.io',privateKey: privateKey });
        
        // Use tronWeb
        console.log(tronWeb.defaultAddress);

        // Create a wallet using TronWeb's utilities
        const wallet = {
            address: tronWeb.address.fromPrivateKey(privateKey),
            privateKey: privateKey,
        };

        // Send wallet information in the response
        res.json(wallet);
    } catch (error) {
        console.error("Error generating Tron address:", error);
        res.status(500).send("Error generating Tron address");
    }
});


app.post('/wallet/validate-address', (req, res) => {
 
 const web3 = new Web3();
  const { address } = req.body;

//console.log(req.body);

/*res.json({
        message: 'Data received',
        receivedData: address
    });*/
  // Check if the address is provided
  if (!address) {
    return res.status(400).json({valid: false, message: 'The address is required.' });
  }

  // Validate Ethereum address using Web3
  const isValid = web3.utils.isAddress(address);

  if (isValid) {
    res.json({ valid: true, message: 'The address is valid.' });
  } else {
    res.json({ valid: false, message: 'Address not matched for that network.' });
  }
});


app.post('/wallet/validate-btc', (req, res) => {
 
 const bitcoinAddressValidation = require('bitcoin-address-validation');
  const { address } = req.body;


  if (!address) {
    return res.status(400).json({valid: false, message: 'The address is required.' });
  }

  // Validate Ethereum address using Web3

  
  const isValid = bitcoinAddressValidation.validate(address);

  if (isValid) {
    res.json({ valid: true, message: 'The address is valid.' });
  } else {
    res.json({ valid: false, message: 'Address not matched for that network.' });
  }
});


app.post('/wallet/validate-tron', (req, res) => {
 
 
 const tronWeb = new TronWeb({
    fullHost: 'https://api.trongrid.io' // Or use your custom TRON node
});

  const { address } = req.body;

  if (!address) {
    return res.status(400).json({valid: false, message: 'The address is required.' });
  }

  // Validate Ethereum address using Web3

  
    const isValid = tronWeb.isAddress(address);
  if (isValid) {
    res.json({ valid: true, message: 'The address is valid.' });
  } else {
    res.json({ valid: false, message: 'Address not matched for that network.' });
  }
});


app.post('/wallet/validate-sol', (req, res) => {
 
 const { address } = req.body;

  if (!address) {
    return res.status(400).json({valid: false, message: 'The address is required.' });
  }
  
  function isValidSolanaAddress(address) {
    try {
        const publicKey = new solanaWeb3.PublicKey(address);
        return true; // If no error is thrown, it's a valid Solana address
    } catch (error) {
        return false; // If an error is thrown, it's not a valid Solana address
    }
}

  // Validate Ethereum address using Web3

  if (isValidSolanaAddress(address)) { 
    res.json({ valid: true, message: 'The address is valid.' });
  } else {
    res.json({ valid: false, message: 'Address not matched for that network.' });
  }
});



app.post('/wallet/validate-ethprivate', (req, res) => {
 
 const web3 = new Web3();
  const { private_key } = req.body;

  if (!private_key) {
    return res.status(400).json({valid: false, message: 'The privatekey is required.' });
  }

 
 function getAddressFromPrivateKey(privateKey) {
  try {
    // Web3 will throw an error if the private key is invalid
    const account = web3.eth.accounts.privateKeyToAccount(privateKey);
    
    // Return the Ethereum address if valid
    return account.address;
  } catch (error) {
    // If the private key is invalid, return null or an error message
    return null;
  }
}
 
  
  const address = getAddressFromPrivateKey(private_key);

  if (address) {
    res.json({ valid: true, message: address });
  } else {
    res.json({ valid: false, message: 'privatekey not matched for that network.' });
  }
});


app.post('/wallet/validate-solprivate', (req, res) => {
 
 const web3 = new Web3();
  const { private_key } = req.body;

  if (!private_key) {
    return res.status(400).json({valid: false, message: 'The privatekey is required.' });
  }

 
 function getAddressFromPrivateKey(privateKey) {
  try {
    // Web3 will throw an error if the private key is invalid
    const account = web3.eth.accounts.privateKeyToAccount(privateKey);
    
    // Return the Ethereum address if valid
    return account.address;
  } catch (error) {
    // If the private key is invalid, return null or an error message
    return null;
  }
}
 
 const address = getAddressFromPrivateKey(private_key);

  if (address) {
    res.json({ valid: true, message: address });
  } else {
    res.json({ valid: false, message: 'privatekey not matched for that network.' });
  }
});


app.post('/wallet/validate-tronprivate', (req, res) => {
 const bs58 = require('bs58');

  const { private_key } = req.body;

  if (!private_key) {
    return res.status(400).json({valid: false, message: 'The privatekey is required.' });
  }

 
 function validateTronPrivateKey(privateKey) {
    let hexPrivateKey;

    // Check if the private key is in base58 format
    if (privateKey.length === 34 && /^[A-Za-z0-9]+$/.test(privateKey)) {
        try {
            // Convert base58 to hex
            hexPrivateKey = bs58.decode(privateKey).toString('hex');
        } catch (error) {
            return { valid: false, error: 'Invalid base58 private key format' };
        }
    } else if (/^0x[a-fA-F0-9]{64}$/.test(privateKey)) {
        // If it's already a valid hex string
        hexPrivateKey = privateKey;
    } else {
        return { valid: false, error: 'Invalid private key format' };
    }

    try {
        // Initialize TronWeb with the private key
        const tronWeb = new TronWeb({
            fullHost: 'https://api.trongrid.io',
        });

        // Create a Tron account object from the hex private key
        const account = tronWeb.accounts.privateKeyToAccount(hexPrivateKey);

        // Check if the derived address is valid
        if (!account.address) {
            return { valid: false, error: 'Invalid private key' };
        }

        return { valid: true, address: account.address };
    } catch (error) {
        return { valid: false, error: error.message };
    }
}
 
 const address = validateTronPrivateKey(private_key);

  if (address) {
    res.json({ valid: true, message: address });
  } else {
    res.json({ valid: false, message: 'privatekey not matched for that network.' });
  }
});


app.listen(3000, function () {
  console.log('Example app listening on port 3000!');
});