declare enum Network {
    mainnet = "mainnet",
    testnet = "testnet",
    regtest = "regtest"
}
declare enum AddressType {
    p2pkh = "p2pkh",
    p2sh = "p2sh",
    p2wpkh = "p2wpkh",
    p2wsh = "p2wsh",
    p2tr = "p2tr"
}
type AddressInfo = {
    bech32: boolean;
    network: Network;
    address: string;
    type: AddressType;
};
declare const getAddressInfo: (address: string) => AddressInfo;
declare const validate: (address: string, network?: Network) => boolean;
export { getAddressInfo, Network, AddressType, AddressInfo, validate };
export default validate;
