<?php 


namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;

class Interestsettings extends BaseController {

/**
* 
* Start 
* Create Date: 24 Jun, 2016
* This controller to manage referral setting page.
* Created karthiga.
* @see http://ihyip.com/admin/referralsettings/
* Last Updated: 28 Jun, 2016
* End
* 
*/

public function __construct() {
$this->db = db_connect();
$myencrypt = new MyEncrypt(true);
$this->common_model = model('CommonModel');

helper(['form','url','html']);
$session = \Config\Services::session();
$validation = \Config\Services::validation();
$uri = service('uri');
if(!$session->get('admin_login')) {
return redirect()->to('admin/login');
}

// admin login only
if($session->get('admin_login')) {

// form validation library
// $this->load->library('form_validation');
$this->isSubadmin();

} else {
$session->set('last_page', current_url());
return redirect()->to('admin');
}

}

private function isSubadmin() {
$this->db = db_connect();
$myencrypt = new MyEncrypt(true);
$this->common_model = model('CommonModel');
$session = \Config\Services::session();
$validation = \Config\Services::validation();
$uri = service('uri');
if(!$session->get('admin_login')) {
return redirect()->to('admin/login');
}

if($session->get('user_type') == 'subadmin') {
$controller = $this->router->controllerName();
$pages = json_decode($session->get('permission'));

if(!in_array(ucfirst($controller), $pages)) {
return redirect()->to('admin');
}
}
}



public function index()
{


$this->db = db_connect();
$myencrypt = new MyEncrypt(true);


$this->common_model = model('CommonModel');
$session = \Config\Services::session();
$validation = \Config\Services::validation();
$uri = service('uri');
if(!$session->get('admin_login')) {
return redirect()->to('admin/login');
}
$this->data['breadcrumbs'] = array();

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_home'),
'href' => base_url().'admin'
);

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_settings')
);

$this->data['action'] = 'interestsettings';

$this->data['module_name'] = 'settings';


if($this->request->getpost())
{

$this->db = db_connect();
$this->common_model = model('CommonModel');

foreach ($this->request->getpost() as $key => $value) {

$keys = explode('_', $key);
$plan_id = 1;
$cr_date = date('Y-m-d', $keys[1]);

$condition = "DATE(cr_date) = '".$cr_date."'";
$interest_data = $this->common_model->GetRow('daily_interest',$condition);

if($interest_data) {

$data =  array(
"rate" => $value
);

$this->db = db_connect();
$query_status = $this->db->table('daily_interest')->where('DATE(cr_date)',$cr_date)->update($data);


}
else
{

$data =  array(
"plan_id" => $plan_id,
"rate" => $value,
"cr_date" => $cr_date
);

$query_status = $this->db->table('daily_interest')->insert($data);	

}

}


if($query_status) 
{
$session->setFlashData('success_message', 'Interest Settings Added Successfully');
return redirect()->to('admin/interestsettings');
} 
else 
{
$session->setFlashData('error_message', 'Failed to Update Interest Setttings');
return redirect()->to('admin/interestsettings');
}

}
echo view('admin/settings/interest',$this->data);

}


	public function edit($id)
	{

	$this->db = db_connect();
	$myencrypt = new MyEncrypt(true);
	$this->common_model = model('CommonModel');
	$session = \Config\Services::session();
	$validation = \Config\Services::validation();
	$uri = service('uri');
	if(!$session->get('admin_login')) {
	return redirect()->to('admin/login');
	}


	$this->data['breadcrumbs'] = array();

	$this->data['breadcrumbs'][] = array(
	'text' => lang('language_lang.text_home'),
	'href' => base_url().'admin'
	);

	$this->data['breadcrumbs'][] = array(
	'text' => lang('language_lang.text_settings')
	);
	$this->data['module_name'] = 'settings';
	$this->data['action'] =  'admin/packagesettings/edit/'.$id;

	$this->data['package'] = $this->db->query("SELECT * FROM package_settings where id = '".$id."'")->getRow();

	if($this->request->getpost())
	{

	$this->db = db_connect();
	$this->common_model = model('CommonModel');
	$id = $this->request->getPost('id');


	$condition = "id = '".$id."'";
	$interest_data = $this->common_model->GetRow('package_settings',$condition);

	if($interest_data) {

	$data =  array(
	"package_name" => $this->request->getPost('package_name'),
	"min_amt" => $this->request->getPost('min_amt'),
	"max_amt" => $this->request->getPost('max_amt'),
	"duration" => $this->request->getPost('duration'),
	"payout" => $this->request->getPost('payout'),
	"status" => $this->request->getPost('status'),
	"level" => $this->request->getPost('level'),
	);


	$this->db = db_connect();
	$query_status = $this->db->table('package_settings')->where('id',$id)->update($data);


	}
	else
	{

	$data =  array(
	"min_amt" => $this->request->getPost('min_amt'),
	"max_amt" => $this->request->getPost('max_amt'),
	"duration" => $this->request->getPost('duration'),
	"payout" => $this->request->getPost('payout'),
	"status" => $this->request->getPost('status'),
	"level" => $this->request->getPost('level'),
	);

	$query_status = $this->db->table('package_settings')->insert($data);	

	}


	if($query_status) 
	{
	$session->setFlashData('success_message', 'Package Settings Added Successfully');
	return redirect()->to('admin/packagesettings');
	} 
	else 
	{
	$session->setFlashData('error_message', 'Package Settings Update Interest Setttings');
	return redirect()->to('admin/packagesettings');
	}

	}

	echo view('admin/settings/packagesettings',$this->data);

	}



public function add()
{

$this->db = db_connect();
$myencrypt = new MyEncrypt(true);
$this->common_model = model('CommonModel');
$session = \Config\Services::session();
$validation = \Config\Services::validation();
$uri = service('uri');
if(!$session->get('admin_login')) {
return redirect()->to('admin/login');
}


$this->data['breadcrumbs'] = array();

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_home'),
'href' => base_url().'admin'
);

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_settings')
);
$this->data['module_name'] = 'settings';
$this->data['action'] =  'admin/packagesettings/add';

$this->data['package'] = array();

	if($this->request->getpost())
	{

	$this->db = db_connect();
	$this->common_model = model('CommonModel');
	$id = $this->request->getPost('id');


	$condition = "id = '".$id."'";
	$interest_data = $this->common_model->GetRow('package_settings',$condition);

	if($interest_data) {

	$data =  array(
	"package_name" => $this->request->getPost('package_name'),
	"min_amt" => $this->request->getPost('min_amt'),
	"max_amt" => $this->request->getPost('max_amt'),
	"duration" => $this->request->getPost('duration'),
	"payout" => $this->request->getPost('payout'),
	"status" => $this->request->getPost('status'),
	"level" => $this->request->getPost('level'),
	);


	$this->db = db_connect();
	$query_status = $this->db->table('package_settings')->where('id',$id)->update($data);


	}
	else
	{

	$data =  array(
	"package_name" => $this->request->getPost('package_name'),
	"min_amt" => $this->request->getPost('min_amt'),
	"max_amt" => $this->request->getPost('max_amt'),
	"duration" => $this->request->getPost('duration'),
	"payout" => $this->request->getPost('payout'),
	"status" => $this->request->getPost('status'),
	"level" => $this->request->getPost('level'),
	);

	$query_status = $this->db->table('package_settings')->insert($data);	

	}


	if($query_status) 
	{
	$session->setFlashData('success_message', 'Package Settings Added Successfully');
	return redirect()->to('admin/packagesettings');
	} 
	else 
	{
	$session->setFlashData('error_message', 'Package Settings Update Interest Setttings');
	return redirect()->to('admin/packagesettings');
	}

	}

	echo view('admin/settings/packagesettings',$this->data);

	}

public function packagesettings()
{

$this->db = db_connect();
$myencrypt = new MyEncrypt(true);
$this->common_model = model('CommonModel');
$session = \Config\Services::session();
$validation = \Config\Services::validation();
$uri = service('uri');
if(!$session->get('admin_login')) {
return redirect()->to('admin/login');
}


$this->data['breadcrumbs'] = array();

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_home'),
'href' => base_url().'admin'
);

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_settings')
);
$this->data['module_name'] = 'settings';
$this->data['action'] =  'admin/packagesettings';

$this->data['package'] = $this->db->query("SELECT * FROM package_settings")->getRow();

if($this->request->getpost())
{

$this->db = db_connect();
$this->common_model = model('CommonModel');
$id = $this->request->getPost('id');


$condition = "id = '".$id."'";
$interest_data = $this->common_model->GetRow('package_settings',$condition);

if($interest_data) {

$data =  array(
"min_amt" => $this->request->getPost('min_amt'),
"max_amt" => $this->request->getPost('max_amt'),
"duration" => $this->request->getPost('duration'),
"status" => $this->request->getPost('status'),
"level" => $this->request->getPost('level'),
);


$this->db = db_connect();
$query_status = $this->db->table('package_settings')->where('id',$id)->update($data);


}
else
{

$data =  array(
"min_amt" => $this->request->getPost('min_amt'),
"max_amt" => $this->request->getPost('max_amt'),
"duration" => $this->request->getPost('duration'),
"status" => $this->request->getPost('status'),
"level" => $this->request->getPost('level'),
);

$query_status = $this->db->table('package_settings')->insert($data);	

}


if($query_status) 
{
$session->setFlashData('success_message', 'Package Settings Added Successfully');
return redirect()->to('admin/packagesettings');
} 
else 
{
$session->setFlashData('error_message', 'Package Settings Update Interest Setttings');
return redirect()->to('admin/packagesettings');
}

}


echo view('admin/settings/package_list',$this->data);

}



public function pack_delete($id)
{



$this->db = db_connect();
$myencrypt = new MyEncrypt(true);
$this->common_model = model('CommonModel');
$session = \Config\Services::session();
$validation = \Config\Services::validation();
$uri = service('uri');
if(!$session->get('admin_login')) {
	return redirect()->to('admin/login');
}

$myencrypt = new MyEncrypt;

$this->db = db_connect();
$delete = $this->db->query("DELETE FROM package_settings where id = '".$id."'");

$this->session = \Config\Services::session();
if($delete)
{	
	$this->session->setFlashData('success_message', lang('Package Successfully Deleted'));
	return redirect()->to('admin/packagesettings');
}
else
{
	
	$this->session->setFlashData('error_message', lang('Trader Cannot be Deleted'));
	return redirect()->to('admin/packagesettings');
}
}


/// pool Investment Settings  start  ////


public function pool_invest(){

$this->db = db_connect();
$myencrypt = new MyEncrypt(true);
$this->common_model = model('CommonModel');
$session = \Config\Services::session();
$validation = \Config\Services::validation();
$uri = service('uri');
if(!$session->get('admin_login')) {
return redirect()->to('admin/login');
}


$this->data['breadcrumbs'] = array();

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_home'),
'href' => base_url().'admin'
);

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_settings')
);
$this->data['module_name'] = 'settings';
$this->data['action'] =  'admin/pool_invest';

$site_data = $this->common_model->GetSettingall('pool_invest');

if($site_data) {

foreach ($site_data as $row) {
$this->data[$row->site_key] = $row->site_value;
}

} 


if($this->request->getPost()) {
/// form validation and set rules


$validation->setRules([
'robot_fee' => ['label' => 'Robot Fee', 'rules' => 'trim|required'],
'robot_trade_volume' => ['label' => 'Robot Trade Volume ', 'rules' => 'required'],
]);

if ($validation->withRequest($this->request)->run() == TRUE) {

foreach ($site_data as $row) {

$key_value = $row->site_key;

if($this->request->getPost($key_value)){

$sitedata = array(
"site_value"	=>	$this->request->getPost($key_value)
);

$update_status = $this->db->table('site_controls')->where('settings_name','pool_invest')->where('site_key',$row->site_key)->update($sitedata);

} else {


$sitedata = array(
"site_value"	=>	'0'
);

if($row->site_key !='pool_invest_level' &&  $row->site_key !='pool_level')
{

  $update_status = $this->db->table('site_controls')->where('settings_name','pool_invest')->where('site_key',$row->site_key)->update($sitedata);

}
else
{
  $update_status = 1;
}

}

}

if($update_status) {
$session->setFlashData('success_message',"Pool Investment Settings Update Successfully");
return redirect()->to('admin/pool_invest');
} else {
$session->setFlashData('error_message',"Pool Investment Settings Update Not Successfully");
return redirect()->to('admin/pool_invest');
}
}
}

echo view('admin/settings/pool_invest',$this->data);
}

/// pool Investment Settings  end  ////


/// pool Investment Settings  start  ////


public function level_set(){

$this->db = db_connect();
$myencrypt = new MyEncrypt(true);
$this->common_model = model('CommonModel');
$session = \Config\Services::session();
$validation = \Config\Services::validation();
$uri = service('uri');
if(!$session->get('admin_login')) {
return redirect()->to('admin/login');
}


$this->data['breadcrumbs'] = array();

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_home'),
'href' => base_url().'admin'
);

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_settings')
);
$this->data['module_name'] = 'settings';
$this->data['action'] =  'admin/level_set';

$site_data = $this->common_model->GetSettingall('pool_invest');

if($site_data) {

foreach ($site_data as $row) {
$this->data[$row->site_key] = $row->site_value;
}

} 


if($this->request->getPost()) {
/// form validation and set rules

if($this->request->getpost())
{

$reward_profit = $this->request->getpost('levelcommission');
$reward_profit = implode(',',$reward_profit);

$sitedata = array(
"site_value"	=>	$reward_profit,
);

$update_status = $this->db->table('site_controls')->where('settings_name','pool_invest')->where('site_key','pool_level')->update($sitedata);


if($update_status) {
$session->setFlashData('success_message',"Pool Interest Level Settings Update Successfully");
return redirect()->to('admin/level_set');
} else {
$session->setFlashData('error_message',"Pool Interest Level Settings Update Not Successfully");
return redirect()->to('admin/level_set');
}
}
}

echo view('admin/settings/level_set',$this->data);
}




public function bonus_level_set(){

$this->db = db_connect();
$myencrypt = new MyEncrypt(true);
$this->common_model = model('CommonModel');
$session = \Config\Services::session();
$validation = \Config\Services::validation();
$uri = service('uri');
if(!$session->get('admin_login')) {
return redirect()->to('admin/login');
}


$this->data['breadcrumbs'] = array();

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_home'),
'href' => base_url().'admin'
);

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_settings')
);
$this->data['module_name'] = 'settings';
$this->data['action'] =  'admin/bonus_level_set';

$site_data = $this->common_model->GetSettingall('pool_invest');

if($site_data) {

foreach ($site_data as $row) {
$this->data[$row->site_key] = $row->site_value;
}

} 


if($this->request->getPost()) {
/// form validation and set rules

if($this->request->getpost())
{

$reward_profit = $this->request->getpost('levelcommission');
$reward_profit = implode(',',$reward_profit);

$sitedata = array(
"site_value"	=>	$reward_profit,
);

$update_status = $this->db->table('site_controls')->where('settings_name','pool_invest')->where('site_key','pool_invest_level')->update($sitedata);


if($update_status) {
$session->setFlashData('success_message',"Pool Interest Level Settings Update Successfully");
return redirect()->to('admin/bonus_level_set');
} else {
$session->setFlashData('error_message',"Pool Interest Level Settings Update Not Successfully");
return redirect()->to('admin/bonus_level_set');
}
}
}

echo view('admin/settings/bonus_level_set',$this->data);
}
/// pool Investment Settings  end  ////

/// pool Investment list active  ////

public function active_pools()
{

$this->db = db_connect();
$myencrypt = new MyEncrypt(true);
$this->common_model = model('CommonModel');
$session = \Config\Services::session();
$validation = \Config\Services::validation();
$uri = service('uri');

if(!$session->get('admin_login')) {
return redirect()->to('admin/login');
}

$this->data['breadcrumbs'] = array();

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_home'),
'href' => base_url('admin')
);
$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.users_page_text')
);

$this->data['module_name'] = 'user';

$this->data['result'] = $this->db->query("SELECT * from deposit where status = 'active'  order by depositid desc")->getResult();

echo view('admin/pool_investment_list',$this->data);

}

/// pool Investment list active end ////



/// pool Investment list request_pools  ////

public function request_pools()
{

$this->db = db_connect();
$myencrypt = new MyEncrypt(true);
$this->common_model = model('CommonModel');
$session = \Config\Services::session();
$validation = \Config\Services::validation();
$uri = service('uri');

if(!$session->get('admin_login')) {
return redirect()->to('admin/login');
}

$this->data['breadcrumbs'] = array();

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_home'),
'href' => base_url('admin')
);
$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.users_page_text')
);

$this->data['module_name'] = 'user';

$this->data['result'] = $this->db->query("SELECT * from deposit where status = 'matured'  and request_status='1' order by depositid desc")->getResult();

echo view('admin/pool_investment_request',$this->data);

}

/// pool Investment list request_pools end ////



/// pool Investment list completed_pools  ////

public function completed_pools()
{

$this->db = db_connect();
$myencrypt = new MyEncrypt(true);
$this->common_model = model('CommonModel');
$session = \Config\Services::session();
$validation = \Config\Services::validation();
$uri = service('uri');

if(!$session->get('admin_login')) {
return redirect()->to('admin/login');
}

$this->data['breadcrumbs'] = array();

$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.text_home'),
'href' => base_url('admin')
);
$this->data['breadcrumbs'][] = array(
'text' => lang('language_lang.users_page_text')
);

$this->data['module_name'] = 'user';


$this->data['result'] = $this->db->query("SELECT * from deposit where status = 'released'  order by depositid desc")->getResult();

echo view('admin/pool_investment_completed',$this->data);

}

/// pool Investment list completed_pools end ////


/*---------------------------------  Pool Trading investment claim_pack -------------------------------*/

public function claim_pack_release(){
    
$this->db = db_connect();
$this->common_model = model('CommonModel');
$session = \Config\Services::session();

$package_id = $this->request->getPost('deposit_id');

$check_pack = $this->db->query("SELECT * from deposit where depositid = '".$package_id."'")->getRow();

if($check_pack)
{

	if($check_pack->status=="matured")
	{

	$deposit_data = array(
	'request_status' => 1, 
	'status' =>'released',
	);

	$builder = $this->db->table('deposit');
	$builder->where('depositid',$check_pack->depositid);
	$builder->update($deposit_data);

	$json['result'] = 'ok';
	$session->setFlashData('success_message',"Pool Investment Request Update Successfully");

	}
	else
	{
	$json['result'] = 'notok';
	$json['message'] ="Invalid Claim Package.....";
	$session->setFlashData('success_message',"Pool Investment Request Update Not Successfully");
	}

	}
	else
	{
	$json['result'] = 'notok';
	$json['message'] ="Invalid Claim Package.....";
	$session->setFlashData('success_message',"Pool Investment Request Update Not Successfully");
}

echo json_encode($json);

}

/*---------------------------  Pool Trading investment claim_pack -------------------------------*/



public function view($id)
{

	$this->db = db_connect();
	$myencrypt = new MyEncrypt(true);
	$this->common_model = model('CommonModel');
	$session = \Config\Services::session();
	$validation = \Config\Services::validation();
	$uri = service('uri');

	if(!$session->get('admin_login')) {
	return redirect()->to('admin/login');
	}

	$this->data['breadcrumbs'] = array();

	$this->data['breadcrumbs'][] = array(
	'text' => lang('language_lang.text_home'),
	'href' => base_url('admin')
	);
	$this->data['breadcrumbs'][] = array(
	'text' => lang('language_lang.users_page_text')
	);

	$this->data['module_name'] = 'user';

	$this->data['result'] = $this->db->query("SELECT * from history where depositid='".$id."' and type='pool_interest' order by depositid desc")->getResult();

    $this->data['total_amount'] = $this->db->query("SELECT sum(amount) as amount from history where depositid='".$id."' and type='pool_interest' order by depositid desc")->getRow();

	echo view('admin/pool_earn_history',$this->data);

}


}

