<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;

class Loginsettings extends BaseController {

	/**
	 * 
	 * Start 
	 * Create Date: 21 Jun, 2016
	 * This controller to manage login setting page.
	 * Created karthiga.
	 * @see http://ihyip.com/admin/loginsettings/
	 * Last Updated: 24 Jun, 2016
	 * End
	 * 
	 */

	public function __construct() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		// admin login only
		if($session->get('admin_login')) {

			// form validation library
			// $this->load->library('form_validation');

			$this->isSubadmin();


		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$session->set('last_page', current_url());
				return redirect()->to('admin/login');
			}
		}

 	}

 	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$session->set($array);

		} else {
			return redirect()->to('admin/login');
		}
	}

	private function isSubadmin() {
      $session = session();
		if($session->get('user_type') == 'subadmin') {
			$controller = $this->router->fetch_class();
			$pages = json_decode($session->get('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}
		}
	}

	public function index()
	{   
        $this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
        $this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_settings')
		);
		
        $this->data['module_name'] = 'settings';
        // Function call for model
		$this->data['action'] =  'admin/loginsettings';
		
		$site_data = $this->common_model->GetSettingall('login');
		
		if($site_data) {
			
			foreach ($site_data as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}

		} else {
			$site_data_default = $this->common_model->defaultlangSettingall('login');
			foreach ($site_data_default as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}
		}
		
		

		if($this->request->getPost()) {
            $validation->setRules([
            	'log_auth_limit' => ['label' => lang('language_lang.User_authentication_limit'), 'rules' => 'trim|required|numeric' ]
            ]);
			// $this->form_validation->set_rules('log_auth_limit', lang('language_lang.User_authentication_limit') , 'trim|required|numeric');
			
			// check form validate
			if ($validation->withRequest($this->request)->run() == TRUE) {
				// $lang_id = ($session->get('langid')) ? $session->get('langid') : '1';

    //         	$condition = "settings_name ='login' AND language_id = '".$lang_id."'";
				// $data_avail = $this->common_model->GetSettingall_lang($condition);

		
				// if($data_avail) {

	                foreach ($site_data as $row) {

						$key_value = $row->site_key;
						
						if($this->request->getPost($key_value)){
							$sitedata = array(
								"site_value"	=>	$this->request->getPost($key_value)
							);
							$update_status = $this->db->table('site_controls')->where('settings_name','login')->where('site_key',$row->site_key)->update($sitedata);
						} else {

							$sitedata = array(
								"site_value"	=>	'0'
							);
						
							$update_status = $this->db->table('site_controls')->where('settings_name','login')->where('site_key',$row->site_key)->update($sitedata);

						}

					}
				// } 

                if($update_status) {
					$session->setFlashData('success_message', lang('language_lang.login_success_message'));
					return redirect()->to('admin/loginsettings');
				} else {
					$session->setFlashData('error_message', lang('language_lang.login_error_message'));
					return redirect()->to('admin/loginsettings');
				}

			}
			
		}
		echo view('admin/settings/login',$this->data);

	}
	
}

