<?php

namespace App\Controllers\User;
use App\Views;
use App\Models\CommonModel;
use App\Models\userdash_model;
use App\Libraries\MyEncrypt;

class Myreferral extends BaseController {

	public function __construct() {
		
		helper('site_helper');	

		$status = site_info('site_status');

		if($status!='on'){
			redirect('offline');
		}
		  $this->userdash_model = model('userdash_model');
		  $this->common_model = model('CommonModel');
		  $session = \Config\Services::session();
	}

	
	public function index()  {
		$this->db = db_connect();

		$session = \Config\Services::session();
		if(!($session->get('user_login') || $session->get('admin_login')))
		{			
			return redirect()->to('login');
		}
     
		$site_data = $this->common_model->GetSettingall('infobox');
		if($site_data) {
			
			foreach ($site_data as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}

		} else {
			$site_data_default = $this->common_model->defaultlangSettingall('infobox');
			foreach ($site_data_default as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}
		}

		$site_lang_data = $this->common_model->GetSiteSettings('site');
		
		
		if($site_lang_data){	
			$site_data = array_merge($site_data, $site_lang_data);
		}

		foreach ($site_data as $row) {
			$this->data[$row->site_key] = $row->site_value;
		}


		// user login only
		if($session->get('user_login') || $session->get('admin_login')) {

			$languageid = ($session->get('user_langid')) ? $session->get('user_langid'): '1';
			
			$reff_comm_condition = "type IN ('commissions')";
			$this->data['total_ref_comm'] = $this->userdash_model->MyHistoryData($reff_comm_condition);

			$reff_condition = "referral_id = '".$session->get('uusersid')."'";
			$this->data['total_sponser'] = $this->userdash_model->MySponserCount($reff_condition);

			$reff_condition = "referral_id = '".$session->get('uusersid')."' AND status='0'";
			$this->data['new_sponser'] = $this->userdash_model->MySponserCount($reff_condition);

			$reff_condition = "referral_id = '".$session->get('uusersid')."' AND status='2'";
			$this->data['pending_sponser'] = $this->userdash_model->MySponserCount($reff_condition);

			$reff_condition = "referral_id = '".$session->get('uusersid')."' AND status='1'";
			$this->data['active_sponser'] = $this->userdash_model->MySponserCount($reff_condition);
			
			$this->data['sponsers'] = $this->userdash_model->MySponsers();

			$user = $this->db->query("SELECT * FROM uusers where uusersid='".$session->get('uusersid')."'")->getRow(); 
			
			$this->data['referral_url'] = base_url().'/register/'.$user->invitation_code;
			$this->data['invitation_code'] = $user->invitation_code;

	        $reff_condition = "referral_id = '".$session->get('uusersid')."'";
			$this->data['ref_name'] = $this->userdash_model->MySponsersLevel($reff_condition);

		   echo view('user/myreferral',$this->data);

		} 
		else {
			$session->set('user_last_page', current_url());
			redirect('user/login');
		}
	}

	public function referral($id=''){
		
		$referral_id = ($id) ? $id : $this->uri->segment(2);

		if($referral_id)
		{
			
			$this->data['countries'] = $this->common_model->GetResults('country');
			$this->data['questions'] = $this->common_model->GetResults('securityquestion_control');
		    $this->data['action'] =  base_url().'user/register';

		    $site_data = $this->common_model->GetSettingall('login');
		    
			if($site_data) 
			{
				foreach ($site_data as $row) 
				{
					$this->data[$row->site_key] = $row->site_value;
				}
			}

			$sponser_data = $this->common_model->GetSettingall('user');
			
			if($sponser_data) 
			{
				foreach ($sponser_data as $row) 
				{
					$this->data[$row->site_key] = $row->site_value;
				}
			}
			
			$register_setting = $this->common_model->GetMultiSetting();

			foreach ($register_setting as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}

		    if($this->data['log_captcha_status'] == 'on')
		    {
				$this->load->library('mathcaptcha');
		        $this->mathcaptcha->init();

		        $math_captcha_question = $this->mathcaptcha->get_question();
	            $this->load->helper('captcha');
                $img_name = time().'.jpg';
                $img_path = 'captcha/';
                $im = imagecreate('150', '50');
                $text = array(245,171,53);
                $bg_color   = imagecolorallocate ($im, 34, 49, 63);
                $text_color = imagecolorallocate ($im, 255, 255, 255);
                ImageFilledRectangle($im, 0, 0, 150, 50, $bg_color);   
                $cap = imagestring($im, 12, 45, 18, $math_captcha_question, $text_color);
                $cp = ImageJPEG($im, $img_path.$img_name);
                $this->data['ur'] = $img_path.$img_name;
			}
			$this->data['sponsor_details'] = $this->common_model->GetRow("uusers","username = '".$referral_id."'");
			
			// $this->data['sponsor_details'] = $this->common_model->GetUser($this->data['ref_user']);

			// $sponsor_details = $this->common_model->GetUser($ref_user);
			$this->data['reff_name'] = $referral_id;

			$this->load->view('user/register',$this->data);

		}

	}
	public function test($id) {
		// echo $id;exit;
		$this->load->library('Commission');
		$comm = new commission();
		// $comm->setforcematrix($id);
		$comm->Commission_calc($id);
	}
	
	
}

