<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Main navbar -->
		<?php $this->load->view('admin/common_header'); ?>
	<!-- /main navbar -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/tables/datatables/datatables.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/tables/datatables/extensions/responsive.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/forms/selects/select2.min.js"></script>

	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/app.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/pages/datatables_responsive.js"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/jgrowl.min.js"></script>
    
    <link href="<?php echo base_url();?>assets/css/icons/fontawesome/styles.min.css" rel="stylesheet" type="text/css">

    <!-- Theme JS files -->
	
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/forms/selects/bootstrap_select.min.js"></script>
	<!-- select box JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/pages/form_bootstrap_select.js"></script>
	<!-- /select box JS files -->


	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/bootbox.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/sweet_alert.min.js"></script>
	<!-- /theme JS files -->
</head>
<style>
.icons-list > li {
    display: inline-block;
    font-size: 26px;
    }
    .heading-elements .icons-list {
    margin-top: 5px;
}

</style>
<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php $this->load->view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php $this->load->view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo $this->lang->line('promo_banner_title_lbl'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php $this->load->view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo $this->lang->line('promo_banner_title_lbl'); ?></h5>
						<div class="heading-elements">
						    <ul class="icons-list">
							<li><a href="<?php echo base_url();?>admin/promotion/add" class="icon-plus-circle2"></a></li>
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>
					<table class="table datatable-responsive-row-control table-hover">
						<colgroup>
							<col width="5%">
							<col width="15%">
							<col width="20%">
							<col width="20%">
							<col width="20%">
							<col width="20%">
						</colgroup>
						<thead>
							<tr>
								<th></th>
								<th class=""><?php echo $this->lang->line('exp_report_sno');?></th>
								<th style="width: 100%;" class="text-center"><?php echo $this->lang->line('banner_title_lbl');?></th>
								<th class="text-center"><?php echo $this->lang->line('banner_image_lbl');?></th>
								<th class="text-center"><?php echo $this->lang->line('lbl_slider_description');?></th>
								<th class="text-center"><?php echo $this->lang->line('lbl_slider_status');?></th>
								<th class="text-center"><?php echo $this->lang->line('lbl_action');?></th>
							</tr>
						</thead>
						<tbody>
						<?php
							if($banner_data) {
								$row_count = count($banner_data);
								$this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt;
								$i=1;
								foreach ($banner_data as $row) {
									if($row->banner_status=='on'){
										$label_status = 'label-success';
										$status = $this->lang->line('active');
									} else {
										$label_status = 'label-danger';
										$status = $this->lang->line('in_active');
									}
							?>
							<tr>
							    <td></td>
							    <td><?php echo $i; ?></td>
								<td class=""><?php echo ucfirst($row->banner_title);?></td>
							    <td class="text-center"><img src="<?php echo base_url().'content/banner/'.$row->banner_image;?>" alt="<?php echo ucfirst($row->banner_title);?>" width="300" height="150"/></td>
							    <td class=""><?php echo $row->banner_description;?></td>
								<?php if($row->banner_status=='on'){ ?>
								         <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" onclick="changeStatus('<?php echo $myencrypt->encode($row->banner_id); ?>')" href="javascript:void(0)"><?php echo $status;?></a></span></td>
								<?php } else {?>
 								         <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" onclick="changeActiveStatus('<?php echo $myencrypt->encode($row->banner_id); ?>')" href="javascript:void(0)"><?php echo $status;?></a></span></td>
                                <?php } ?>
								<td class="text-center">
									<ul class="icons-list">
										<li class="dropdown">
											<a href="#" class="dropdown-toggle" data-toggle="dropdown">
												<i class="icon-menu9"></i>
											</a>

											<ul class="dropdown-menu dropdown-menu-right <?php if($row_count=='1' || $row_count=='2') { echo 'inline-drop'; }?>">
												<li><a href="<?php echo base_url().'admin/promotion/add/'.$myencrypt->encode($row->banner_id);?>"><i class="fa fa-edit"></i> <?php echo $this->lang->line('edit');?></a></li>
												<li><a onclick="confirmdelete('<?php echo $myencrypt->encode($row->banner_id);?>')" href="javascript:void(0)" ><i class="fa fa-remove"></i> <?php echo $this->lang->line('delete');?></a></li>
											</ul>
										</li>
									</ul>
								</td>
							</tr>
						<?php 

							$i++;	}
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
				</div>
				<!-- /basic responsive configuration -->


			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		
	(function($) {

	    $(document).ready(function() {

	    	$.jGrowl.defaults.closer = false;

				<?php if($this->session->flashdata('error_slider')) { ?>
					$.jGrowl("<?php echo $this->session->flashdata('error_slider');?>", {
			            header: 'Error!',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($this->session->flashdata('success_slider')) { ?>
	                $.jGrowl("<?php echo $this->session->flashdata('success_slider');?>", {
			            header: '<?php echo $this->lang->line("success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

	            $('#icon-bck').on('click',function() {
					window.history.back();
				});

				

		});

	})(jQuery);
	
	function changeStatus(valus) {
         swal({
            title: "<?php echo $this->lang->line('promotion_change_status');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url();?>admin/promotion/changeStatus/"+valus;
            }
            else {
              return false;
            }
		
		});
	}
	function changeActiveStatus(valus) {
		swal({
            title: "<?php echo $this->lang->line('promotion_change_status');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url();?>admin/promotion/changeActiveStatus/"+valus;
            }
            else {
              return false;
            }
		
		});
	}
	function confirmdelete(value) {
		swal({
            title: "<?php echo $this->lang->line('promotion_delete_status');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url();?>admin/promotion/delete/"+value;
            }
            else {
              return false;
            }

		});
    }

	
	</script>

</body>
</html>
