<!doctype html>
<html lang="en" translate="no" class="w-[640px] mx-auto md:w-full">
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>Asset Balance</title>
      <?php echo view('user/layout/head');?>
   </head>
   <body class="reg-overflow">
      <section class="dash-banner-bg banner-bg">
         <div class="container">
            <!---header start---->
            <?php echo view('user/layout/header');?>
            <!---header end---->
            <!---banner start---->
            <div class="row">
               <div class="col-lg-12">
                  <div class="dash-wrap">
                     <div class="title text-center pb-4 pt-3">
                        <h2 class="text-primary ">My Assets</h2>
                     </div>


                     <?php 
                        if($this->session->getFlashData('success_message')) 
                        {
                        ?>
                     <p class="frgtpwd frgtpwd1 mt-5"><i class="fa fa-thumbs-up"></i><?php echo $this->session->getFlashData('success_message');?></p>
                     <?php 
                        } 
                        else if($this->session->getFlashData('error_message')) 
                        { 
                        ?>
                     <p class="frgtpwd frgtpwd1 frgtpwdred mt-5"><i class="fa fa-thumbs-down"></i><?php echo $this->session->getFlashData('error_message');?></p>
                     <?php 
                        } 
                        ?>
                     <div class="income-sec">
                        <div class="total-income d-flex align-items-center">
                           <div class="ref-content text-start">
                              <h5 class="text-white">Total Income (USDT)</h5>
                           </div>
                           <div class="ref-copy">
                              <a class="text-decoration-none"><i class="fa fa-wallet"></i></a>
                           </div>
                        </div>
                        <?php
                           use App\Libraries\MyEncrypt;
                           use App\Helpers\site_helper;
                           use App\Helpers\form_helper;
                           $this->db = db_connect();
                           $this->session = session();
                           $user=$this->session->get('uusersid');
                           $coinid='1';
                           $buy_bal=curbalance($this->session->get('uusersid'),$coinid);
                           $bal=str_replace(",","", $buy_bal);
                           
                           $user_data=$this->db->query("select * from uusers where uusersid='".$user."'")->getRow();

                           ?>

                  
                        <a class="menu-list d-flex align-items-center justify-content-center text-decoration-none mt-2">
                           <div class="total-income-content d-flex align-items-center ">
                              <div class="usd-ico text-white">
                                 <iconify-icon icon="cryptocurrency:usdt"></iconify-icon>
                              </div>
                              <span class="ms-1 me-2">USDT Assets</span>
                           </div>
                        </a>
                        <h2 class="text-center text-white"><?php echo $bal;?></h2>
                     </div>
                     <!---banner end---->
                     <!---statistic start---->
                     <div class="row">
                        <div class="col-lg-12">
                           <ul class=" list-unstyled static asset-list mb-0 text-center">
                              <li>
                                 <a href="<?php echo base_url();?>/asset/recharge" class="text-decoration-none">
                                    <iconify-icon icon="icon-park-outline:add"></iconify-icon>
                                    <h6 class="text-white-50">Recharge </h6>
                                 </a>
                              </li>
                              
                              <?php 
                              if($user_data->user_withdraw=='1')
                              {
                              ?>
                              <li>
                                 <a href="<?php echo base_url();?>/withdrawfund" class="text-decoration-none">
                                    <iconify-icon icon="gg:arrow-down-r"></iconify-icon>
                                    <h6 class="text-white-50">Withdraw</h6>
                                 </a>
                              </li>
                              <?php 
                              }
                              
                              ?>
                              <?php 
                              if($user_data->user_transfer=='1')
                              {
                              ?>
                              <li>
                                 <a href="<?php echo base_url();?>/transfer" class="text-decoration-none">
                                    <iconify-icon icon="icon-park-outline:file-withdrawal-one"></iconify-icon>
                                    <h6 class="text-white-50">Transfer </h6>
                                 </a>
                              </li>
                              <?php
                              }
                              ?>
                           </ul>
                        </div>
                     </div>
                     <!---statistic end---->
                     <!---trading profit start---->
                     <!---trading profit end---->
                     <div class="transaction mt-4">
                        <div class="container">
                           <div class="row">
                              <div class=" col-sm-12">
                                 <div class="table-responsive trans position-relative">
                                    <div class="head_trans mb-4">
                                       <h4 class="fw-bold text-primary text-center"> Last 10 Transaction</h4>
                                    </div>
                                    <table class="payment-info">
                                       <tbody>
                                          <?php 
                                             if($history)
                                             {
                                             foreach($history as $row)
                                             {
                                             
                                              $date = $row->date;
                                              
                                              if($row->type=='activation')
                                              {
                                                  $symbol="-";
                                              }
                                              else
                                              
                                              {
                                                  $symbol="+";
                                              }
                                             
                                              // print_r($date);
                                              
                                              if($row->type=='fuel' || $row->type=='deducted_gaswallet')
                                              {
                                                  $description_check=str_replace('fuel fee deduction for order no','',$row->description);
                                                  
                                                  $get_order=$this->db->query("select * from api_trade_history where order_id='".trim($description_check)."'")->getRow();
                                                  if($get_order)
                                                  {
                                                      $base=substr($get_order->pair,0,-4);
                                                      $pair=$base.'/USDT';
                                                      $description='Fuel Fee &nbsp;: ['.$pair.'&nbsp;TurnOver &nbsp;:&nbsp;'.$get_order->comm_price.']';
                                                  }
                                                  else
                                                  {
                                                      $description='';
                                                  }
                                              }
                                              else
                                              {
                                                  $description=$row->description;
                                              }
                                             
                                             ?>
                                          <tr>
                                             <th>Amount</th>
                                             <th><?php echo number_format($row->amount,4);?></th>
                                          </tr>
                                          <tr>
                                             <td>
                                                <p class="fw-light text-white-50 mb-0"><?php echo $date;?></p>
                                                <p class="fs-5 fw-normal">Remark</p>
                                             </td>
                                             <td><?php echo $description;?></td>
                                          </tr>
                                          <?php } } else {?>
                                          <tr>
                                             <td><img src="<?php echo base_url() ;?>/assets/images/norecord1.svg" alt="No records found"></td>
                                          </tr>
                                          <?php } ?>
                                       </tbody>
                                    </table>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <?php echo view('user/layout/footer');?>
      <?php echo view('user/layout/footer-script');?>
   </body>
</html>