<!doctype html>
<html lang="en" translate="no" class="w-[640px] mx-auto md:w-full">
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>Recharge</title>
      <?php echo view('user/layout/head');?>
   </head>
   <style>
      .para
      {
      text-align:justify;
      color:#fff;
      }
      .ref-copy .copyLink {
      color:#fff;
      top: 50%;
      right: 25px;
      cursor: pointer;
      transform: translateY(-50%);
      }
      .ref-copy .copyLink:hover:after {
      opacity: 1;
      transform: translateY(0) translateX(-50%);
      }
      .ref-copy .copyLink:after {
      content: attr(tooltip);
      width: 140px;
      bottom: -13px;
      /* left: 50%; */
      padding: 5px;
      border-radius: 4px;
      font-size: 0.8rem;
      opacity: 0;
      pointer-events: none;
      position: absolute;
      background:linear-gradient(180deg, rgba(179,137,34,1) 0%, rgba(140,98,10,1) 50%, rgba(179,137,34,1) 100%, rgba(14,72,62,1) 100%);
      color: #000;
      transform: translateY(-10px) translateX(-50%);
      transition: all 300ms ease;
      text-align: center;
      }
      .referral .title p
      {
         font-size:13px;
      }

   </style>
   
   <?php 
   $user_ag = $_SERVER['HTTP_USER_AGENT'];

    if(preg_match('/(Mobile|Android|Tablet|GoBrowser|[0-9]x[0-9]*|uZardWeb\/|Mini|Doris\/|Skyfire\/|iPhone|Fennec\/|Maemo|Iris\/|CLDC\-|Mobi\/)/uis',$user_ag))
    {
    	$deviceType='mobile';
    }
    else
    {
    	$deviceType='computer';
    }
    ?>
    
    <?php 

    if($deviceType=='computer')
    {
    ?>
    <style>
     .referral .title
     {
         padding: 0px 64px;
     }
    </style>
    <?php 
    }
    else
    {
    ?>
    <style>
      .referral .title
     {
         padding: 0px;
     }
    </style>
    <?php 
    }
    ?>


   
   <body class="reg-overflow">
      <section class="dash-banner-bg banner-bg referral profile">
         <div class="container">
         <?php echo view('user/layout/header');?>
         <?php 
             use App\Libraries\MyEncrypt;
             use App\Helpers\site_helper;
             use App\Libraries\WalletCoreAPI;
            $this->session = \Config\Services::session();
            $this->db = db_connect();
            $session = session();

            $this->form_validation =  \Config\Services::validation();
            $list = \Config\Services::validation()->listErrors();
                     
            $coinid='1';
            $buy_bal=curbalance($this->session->get('uusersid'),$coinid);


            function sign($params){
               ksort($params);
               $string = "";
               foreach($params as $value){
               $string .= $value;
               }
               $sha1Encrypt = sha1($string);
               $encryptedstring = md5($sha1Encrypt);
               return $encryptedstring;
               }
               function encryptAll($params)
               {
                   $paramsEncrypt=array(
                       'merchantId'=>$params['merchantId'],
                       'chainTypeId'=>encrypt($params['chainTypeId'], $params['secretKey'])
                       );
                       return $paramsEncrypt;
               }
               function encrypt($data, $secret)
               {
                   //Take first 8 bytes of $key and append them to the end of $key.
                   $subkey = substr($secret, 0, 8);
                   // Encrypt data
                   $encData = openssl_encrypt($data, "DES-EDE3-CBC", $secret, OPENSSL_RAW_DATA, $subkey);
                   return bin2hex($encData);
               }        

               
            $bal=str_replace(",","", $buy_bal);

            $public_data=$this->db->query("select * from payment_controls where payment_id='9' and payment_key='private_key'")->getRow();
            $private_data=$this->db->query("select * from payment_controls where payment_id='9' and payment_key='public_key'")->getRow();
            $private_key = $public_data->payment_value;
            $public_key = $private_data->payment_value;

            $get_user_info=$this->db->query("select * from uusers where uusersid='".$this->session->get('uusersid')."'")->getRow();

            if($get_user_info->new_entry=='0')
            {
               $get_verification=$this->db->query("select * from payment_controls where payment_id='17' and payment_key='pay_mode'")->getRow();
               $public_data=$this->db->query("select * from payment_controls where payment_id='17' and payment_key='merchant_id'")->getRow();
               $private_data=$this->db->query("select * from payment_controls where payment_id='17' and payment_key='secret_key'")->getRow();

            }
            else
            {
               $get_verification=$this->db->query("select * from payment_controls where payment_id='18' and payment_key='pay_mode'")->getRow();
               $public_data=$this->db->query("select * from payment_controls where payment_id='18' and payment_key='merchant_id'")->getRow();
               $private_data=$this->db->query("select * from payment_controls where payment_id='18' and payment_key='secret_key'")->getRow();

            }

            $payment_mode=$get_verification->payment_value;
         
            if($payment_mode=='manual')
            {  
               $get_address=$this->db->query("select * from payment_controls where payment_id='18' and payment_key='address'")->getRow();
               $address=$get_address->payment_value;

            }
            else
            {
               $merchantID = $public_data->payment_value;
               $secretKey = $private_data->payment_value;
               $address='';
               $error='No Address available';

               $uusersid = $this->session->get('uusersid');
               $get_user_address=$this->db->query("select * from pay_address where userid='".$uusersid."' and payment_type='1'")->getRow();
               if($get_user_address)
               {  
                     $address=$get_user_address->address;
               }
               else
               {

                  $date = date('Y/m/d h:i:s a', time());
                  $date = (int) filter_var($date, FILTER_SANITIZE_NUMBER_INT);
                  $params=array(
                  'merchantId'=>$merchantID,
                  'chainTypeId'=>5,
                  'secretKey'=>$secretKey,
                  );
                  
                  $paramEncrypt = encryptAll($params);
                  $signature = sign($paramEncrypt);
                  $paramEncrypt['sign'] = $signature;

                  $ch = curl_init("https://en-payment.pay-mate.co/CW/createorder");
                  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                  curl_setopt($ch, CURLOPT_POSTFIELDS, $paramEncrypt);

                  $response = curl_exec($ch);
                  
                 
                  if($response)
                  {
                      $response=json_decode($response,true);
                     
                        
                        if(!empty($response['Success']))
                        {
                        
                             $address=$response['WalletAddress'];
    
                             if($address!='')
                             {
                                  $this->db->query("insert into pay_address set address='".$address."', userid='".$uusersid."',payment_id='17',payment_type='1',date='".date("Y-m-d H:i:s")."'");
                             }
                        }
                        else
                        {
                            $error=$response['Message'];
                        }
                      
                  }
                  else
                  {
                     $error="No response received from End point";
                  }
                  
                  // close the connection, release resources used
                  curl_close($ch);
                }
               

            }

         
            
         ?>
         <!---header end---->
         <!---banner start---->
         
         <?php if($session->getFlashData('success_message')) 
                     {?>
                        <div class="row"><div class="col-lg-12 ">
                          <p class="frgtpwd frgtpwd1"><i class="fa fa-thumbs-up"></i><?php echo $session->getFlashData('success_message');?></p></div></div>
                    <?php } 
                          elseif ($session->getFlashData('error_message')) 
                          { ?>
                             <div class="row"><div class="col-lg-12">  <p class="frgtpwd frgtpwd1 frgtpwdred"><i class="fa fa-thumbs-down"></i><?php echo $session->getFlashData('error_message');?></p></div></div>
                    <?php } 
                          else { }?>
                       <div style="clear:both;"><br></div>
         <div class="dash-wrap">
         <div class="title text-center py-2">
         <h2 class="text-primary">Recharge</h2>
         </div>
         <div class="row">
         <div class="col-lg-12">
         <div class="income-sec">
         <div class="total-income d-flex align-items-center">
         <div class="ref-content text-start">
         <h5 class="text-white">
         USDT Balance :<?php echo number_format($bal,4);?>USDT
         </h5>
         </div>
         </div>
         </div>
         <div class="text-center">
         <h3 class="text-white mt-5">Network Chain :<br> USDT (BEP20)</h3>
         </div>

         <?php 
         if($address!='')
         {
         ?>
         <br>
         <div class="qr-code text-center">
         <img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=<?php echo $address;?>" alt="deposit address" style="border:1px solid;margin-bottom:10px;">
         </div>
         <?php 
         }
         ?>
         </div>
         <div class="col-lg-12">
         <div class="title text-center">
         <div class="ref-form-list mt-5" >
         <div class="ref-form d-flex align-items-center">
         <?php 
         if($address!='')
         {
         ?>
         <div class="ref-content text-start">
         <p class="text-white mb-0">USDT Address</p>
         <h5 class="text-white" id="test" ><?php echo $address;?></h5>
         </div>
         <div class="ref-copy">
         <span class="copyLink text-decoration-none" id="copy" >
         <i class="fa-regular fa-copy"></i>
         </span>
         </div>
         <?php 
         }
         else
         {
            echo "<p style='color:red;'>".$error."</p>";
         }
         ?>
         </div>
         </div>
         </div>

         <?php 
         if($payment_mode=='manual')
         { 
         ?>
         <div class="reg-page mt-5 ">
                                 <form class="steps-validation transfer" method="post"  id="pin" action="" enctype="multipart/form-data">
                                    <div class="row" style="margin-top:20px ">
                                       <div class="col-sm-12 <?php if($this->form_validation->getError('amount')) echo "has-error";?>">
                                          <div class="form-block form-group mb-3 user-box" >
                                          <label class="text-white">Amount</label>
                                          <br><br>
                                             <input name="amount" class="form-control" type="text" id="amount" placeholder="Deposit Amount" value="" />
                                             <div id="amount_error" style="color:red;font-size:13px;"></div>
                                             <?php echo $this->form_validation->getError('amount', '<span class="help-block">', '</span>'); ?>
                                          </div>
                                       </div>
                                       <div class="col-sm-12  <?php if($this->form_validation->getError('recv_id')) echo "has-error";?>">
                                          <label class="text-white">Attach Transaction Proof</label>
                                          <br><br>
                                          <div class="form-block  mb-3 user-box">
                                             <input name="attachment" class="form-control"   type="file" id="attachment"  placeholder="Receiver ID" value="" />
                                             <span id="name-error" style="color:red"></span>
                                             <?php echo $this->form_validation->getError('recv_id', '<span class="help-block">', '</span>'); ?>
                                          </div>
                                       </div>
                                    
                                      
                                    <div class="col-lg-12 mt-2">
                                    
                                       <div align="center">
                                          <button type="button" id="trans" name="trans" class="btn btn-primary mb-5" Onclick="makedeposit();">Deposit Request</button>
                                       </div>
                                    </div>
                                 </form>
                              </div>
               </div>
               <?php 
                }
               ?>
       
         <div class="title para" style="margin-top:20px">
         <p> <iconify-icon icon="clarity:success-standard-solid" class="me-2"></iconify-icon> Do not deposit any non-USDT (BEP20) assets to the above address, otherwise the assets will not be retrieved. </p>
         <p> <iconify-icon icon="clarity:success-standard-solid" class="me-2"></iconify-icon> After recharging to the provided address, please confirm the entire network node. Your account will be credited after 3 network confirmations. </p>
         <p> <iconify-icon icon="clarity:success-standard-solid" class="me-2"></iconify-icon>Minimum deposit amount: 1 USDT (BEP20). Deposits below the minimum amount will not be credited to the account and cannot be refunded. </p>
         <p> <iconify-icon icon="clarity:success-standard-solid" class="me-2"></iconify-icon> Please note: transferring and recharging the block reward (Coinbase) is not supported, and such transfers will not be credited to your account. </p>
         <p> <iconify-icon icon="clarity:success-standard-solid" class="me-2"></iconify-icon>Your recharge address will remain stable and will not change frequently; you can continue to recharge as usual. In the event of any changes, we will make every effort to notify you through website announcements or email. </p>
         <p> <iconify-icon icon="clarity:success-standard-solid" class="me-2"></iconify-icon> Please ensure the security of your computer and browser to prevent any tampering or leakage of information. </p>
         </div>
         </div>
         </div>
         </div>
         <?php echo view('user/layout/footer');?>
         </div>
      </section>
      <script type="text/javascript">
         const input = document.getElementById("test");
         console.log(input);
         const copyButton = document.getElementById("copy");
         const copyText = (e) => {
         var temp = $("<input>");
         $("body").append(temp);
         temp.val($(input).html()).select();
         document.execCommand("copy");
         e.currentTarget.setAttribute("tooltip", "Copied!");
         };
         const resetTooltip = (e) => {
         e.currentTarget.setAttribute("tooltip", "Copy to clipboard");
         };
         copyButton.addEventListener("click", (e) => copyText(e));
         copyButton.addEventListener("mouseover", (e) => resetTooltip(e));
      </script>
      <script>
      function makedeposit()
      {
         var amount = $("#amount").val();
         if(amount=='0' || amount=='')
         {
            $("#amount_error").html('Please Enter Deposit amount');
         }
         else
         {
            var l=/^[0-9.]+$/;
            
            if(l.test(amount))
            {
               if(parseFloat(amount) < 1)
               {
                  $("#amount_error").html('Minium 1 USDT Deposit Needed');
               }  
               else
               {
                  $("#pin").submit();
               }
            }
            else
            {
               $("#amount_error").html('Amount must be numeric values');
            }

         }
           
               
      }

      </script>
      <?php echo view('user/layout/footer-script');?>
   </body>
</html>