<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php
	$session = session();
	helper('form');
	$validation = \Config\Services::validation();
	$this->common_model = model('CommonModel');
$header_data = $this->common_model->GetSiteSettings('site');

if(!$header_data) {
	$header_data = $this->common_model->GetSettingall('site');
}

foreach ($header_data as $row) {
	$headers[$row->site_key] = $row->site_value;
}



?>
	<title><?php echo $headers['site_meta_title'];?></title>
	<meta name="keywords" content="<?php echo $headers['site_meta_key'];?>" />
	<meta name="description" content="<?php echo $headers['site_meta_description'];?>" />
	
	<link rel="icon" href="<?=base_url("content/favicon/".site_info('site_favicon'))?>" type="image/ico">

	<!-- Global stylesheets -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
	<link href="<?php echo base_url('assets/css/icons/icomoon/styles.css');?>" rel="stylesheet" type="text/css">
	<link href="<?php echo base_url('assets/css/bootstrap.css');?>" rel="stylesheet" type="text/css">
	<link href="<?php echo base_url('assets/css/core.css');?>" rel="stylesheet" type="text/css">
	<link href="<?php echo base_url('assets/css/components.css');?>" rel="stylesheet" type="text/css">
	<link href="<?php echo base_url('assets/css/colors.css');?>" rel="stylesheet" type="text/css">
	<!-- /global stylesheets -->

	<!-- Bootsrap swith and validation css files -->	
	<link href="<?php echo base_url('assets/boots/css/bootstrap-switch.css');?>" rel="stylesheet" type="text/css">
	<link href="<?php echo base_url('assets/boots/css/formValidation.min.css');?>" rel="stylesheet" type="text/css">
	
	<!-- Core JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/loaders/pace.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/libraries/jquery.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/libraries/bootstrap.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/loaders/blockui.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/ui/nicescroll.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/ui/drilldown.js');?>"></script>
	<!-- /core JS files -->


	<!-- file upload JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/uploaders/fileinput.min.js');?>"></script>

	<!-- date picker JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/libraries/jquery_ui/interactions.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/libraries/jquery_ui/widgets.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/libraries/jquery_ui/effects.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/extensions/mousewheel.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/libraries/jquery_ui/globalize/globalize.js');?>"></script>

	
	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>
	

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<!-- /theme JS files -->

	<!-- date picker JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/jqueryui_forms.js');?>"></script>

	<!-- file upload JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/boots/js/fileinput.min.js');?>"></script>
	
	<!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url('assets/boots/js/bootstrap-switch.js');?>"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    <!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/ckeditor/ckeditor.js');?>"></script>
	<!-- select box theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/bootstrap_select.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/select2.min.js');?>"></script>

	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>

	 <!-- select box JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/form_bootstrap_select.js');?>"></script>
	<!-- /select box JS files -->
    
    

</style>
</head>

<body class="navbar-top-md-md">
	<!-- <div class="pre_loader"></div> -->
	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.faq_title'); ?></span></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
			
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title">
						<?php 
						if(isset($faq_data->faq_id)) { 
                           echo lang('language_lang.faq_edit_data');
                        }
                        else{
                           echo lang('language_lang.faq_add_data');

                        }


                        ?>
						</h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
                	</div>
                	
					<div class="panel-body">
						<form class="form-horizontal faq" action="<?=site_url($action);?>" method="post" enctype="multipart/form-data">
							<?php 
								if($validation->listErrors()) { 
									$form_err_data = str_replace('<p>', '', $validation->listErrors());
									$form_err_data = str_replace('</p>', '', $form_err_data);
									$form_err_data = str_replace('.', '', $form_err_data);
							?>
									
									<script type="text/javascript">
									
									(function( $ ) {
										$.jGrowl.defaults.closer = false;
								        var from_daa = '<?php $form_err_data;?>';
										$.jGrowl(from_daa, {
								            header: '<?php echo lang("language_lang.Error");?>',
								            theme: 'bg-danger'
								        });
								    
									})(jQuery);


									</script>
							<?php
								}
							?>
							
							<input type="hidden" name="faq_url" id="faq_url" class="form-control" placeholder="" value="<?php echo set_value('faq_question',isset($faq_data->faq_question) ? ucfirst($faq_data->faq_question) : ''); ?>">

							<div class="form-group  <?php if($validation->getError('faq_question')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.faq_question'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-6">
									<div style="width:100%" class="input-group">
									<textarea  name="faq_question" class="form-control elastic" cols="4" rows="3" placeholder="<?php echo lang('language_lang.plac_Question'); ?>"><?php echo set_value('faq_question',isset($faq_data->faq_question) ? ucfirst($faq_data->faq_question) : ''); ?></textarea>
									</div>
									<?php echo $validation->getError('faq_question', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>

							<div class="form-group   <?php if($validation->getError('faq_answer')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.faq_answer'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-6">
									<div style="width:100%" class="input-group">
							        <textarea class="form-control elastic" name="faq_answer" rows="8" cols="4" placeholder="<?php echo lang('language_lang.plac_Answer'); ?>"><?php echo set_value('faq_answer',isset($faq_data->faq_answer) ? ucfirst($faq_data->faq_answer) : ''); ?></textarea>
									</div>
									<?php echo $validation->getError('faq_answer', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>
                            <div class="form-group  <?php if($validation->getError('language_id')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.lab_language'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-4">
									<div style="width:100%;" class="input-group">
										<select class="bootstrap-select form-control" name="language_id">
											<?php 
												if(isset($faq_data->language_id)) {
													$selected_lang = $faq_data->language_id;
												} else {
													$selected_lang = '';
												}
												foreach ($languages as $row) { 
											?>
												<option <?php if($selected_lang==strtolower($row->language_id)) { echo 'selected';} ?> value='<?php echo strtolower($row->language_id);?>' ><?php echo ucfirst($row->language_name);?></option>	
											<?php	
												}
											?>
										</select>
									</div>
									<?php echo $validation->getError('language_id', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
								</div>
							</div> 

							<?php 
								if(isset($faq_data->faq_id)) { 
									$faq_status = $faq_data->faq_status;
								} else {
									$faq_status = '';
								}
							?>
							<!-- Switch single -->
							<div class="form-group <?php if($validation->getError('faq_status')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo lang('language_lang.faq_status'); ?> </label>
								<div class="col-lg-6">
									<div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" <?php if($faq_status==='1' || $faq_status===''){ echo 'checked="checked"'; }   ?> name="faq_status" data-on-color="success" data-off-color="danger" data-on-text="<?php echo lang('language_lang.On');?>" data-off-text="<?php echo lang('language_lang.Off');?>" class="switchery">
										</label>
									</div>
									<?php echo $validation->getError('faq_status', '<label class="validation-error-label">', '</label>'); ?>
								</div>
							</div>
							<!-- /switch single -->

							<?php 
								if(isset($faq_data->faq_id)) { 
							?>
							<input type="hidden" name="faq_id" value="<?php echo $faq_data->faq_id;?>"/>
							<?php } ?>

							<div class="text-right col-lg-7">
								<button type="submit" class="btn btn-primary"><?php if(isset($faq_data->faq_id)) {  echo lang('language_lang.button_update'); } else { echo lang('language_lang.button_save'); } ?> <i class="icon-arrow-right14 position-right"></i></button>
							</div>
						</form>
					</div>
				</div>
				<!-- /horizotal form -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->
		

		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		jQuery.noConflict();
		(function( $ ) {
		$(function() {

			$(document).ready(function() {

				$.jGrowl.defaults.closer = false;

				<?php if($session->getFlashData('error_message')) { ?>
					$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
			            header: '<?php echo lang("language_lang.error");?>',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($session->getFlashData('success_message')) { ?>
	                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
			            header: '<?php echo lang("language_lang.success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

			    $('.faq').formValidation({
			    	framework: 'bootstrap',
			    	excluded: [':disabled'],
			        icon: {
			            // valid: 'glyphicon glyphicon-ok',
			            // invalid: 'glyphicon glyphicon-remove',
			            validating: 'glyphicon glyphicon-refresh'
			        },
			        fields: {
			            faq_question: {
			                message: '<?php echo lang("language_lang.faq_question_valid");?>',
			                validators: {
			                    notEmpty: {
			                        message: '<?php echo lang("language_lang.faq_question_required");?>'
			                    }
			                }
			            },
			            faq_answer: {
			                message: '<?php echo lang("language_lang.faq_answer_valid");?>',
			                validators: {
			                    notEmpty: {
			                        message: '<?php echo lang("language_lang.faq_answer_required");?>'
			                    }
			                }
			            }


			            
			        }
			    })
				

			});
		    // $('[name="page_content"]').ckeditor();
		 	$('#icon-bck').on('click',function() {
				window.history.back();
			});
			
		    $(".switchery").bootstrapSwitch();
		    // $("#countries").msDropdown();

		});
		})(jQuery);
	
	</script>

</body>
</html>
