<!DOCTYPE html>
<html lang="en">
<head>
    <!-- header -->
		<?php 

		$this->session = session();
		$validation = \Config\Services::validation();


		echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<!-- /theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/bootstrap_select.min.js');?>"></script>
	

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>

    <!-- ckeditor JS files 
	<script type="text/javascript" src="<?php echo base_url();?>assets/ckeditor/ckeditor.js"></script>-->

	<!-- ckeditor JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/ckeditor/ckeditor.js');?>"></script>
	<script src="<?php echo base_url('assets/boots/js/jquery.js');?>"></script>

	<!-- select box JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/form_bootstrap_select.js');?>"></script>
	<!-- /select box JS files -->
	
</head>

<body class="navbar-top-md-md">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.tickt_detail'); ?></span></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->

				<div class="row">
					<div class="col-lg-9">

                    
						<!-- Comments -->
						<div class="panel panel-flat">
							<div class="panel-heading">
								<h5 class="panel-title text-semiold"><i class="icon-bubbles4 position-left"></i> <? echo lang('language_lang.ticket_conversat_lbl'); ?></h5>
								<div class="heading-elements">
									<a class="btn bg-blue btn-xs btn-icon" data-action="reload"><i class="icon-reload-alt"></i></a>
			                	</div>
							</div>

							<div class="panel-body">
					
								<ul class="media-list content-group-lg stack-media-on-mobile">
									<?php 
									if($con_date) { 
										foreach ($con_date as $row) {

				                    		if($row->adminid == '0'){
				                        		$name = 'Admin';
				                     		}
				                     		else 
				                     		{
				                      			$condition = "uusersid = '".$row->uusersid."'";
				                      			$username = $this->common_model->GetRow('uusers',$condition);
				                      			$name = $username->username;
				                     		}
                     						if($row->tkt_status == 'close'){
												$class = "label bg-danger";
											}
											elseif ($row->tkt_status == 'new') {
												$class = "label bg-primary";
											}
											else {
												$class = "label bg-grey-400";
											}

				                   ?>
									<li class="media">
										<div class="media-left">
											<a href="#"><img src="<?php echo base_url('styles/img/usr.png');?>" class="img-circle img-sm" alt=""></a>
										</div>

										<div class="media-body">
											<div class="media-heading">
												<a href="#" class="text-semibold"><?php echo ucfirst($name); ?></a>
												<span class="media-annotation dotted"><?php echo $row->con_date; ?></span>
											</div>

											<p><?php echo $row->tkt_message; ?></p>

											<ul class="list-inline list-inline-separate text-size-small">
												<li><?php echo $row->ticket_no; ?> <a><i class="icon-arrow-up22 text-success"></i></a><a><i class="icon-arrow-down22 text-danger"></i></a></li>
												<li><span class="<?php echo $class; ?>"><?php echo ucfirst($row->tkt_status); ?></span></li>
											</ul>
										</div>
									</li>
									<?php } } ?>
								</ul>

                               <?php if($ticket_data->ticket_status != 'close') { ?>

								<h6 class="text-semibold"><i class="icon-pencil7 position-left"></i> <? echo lang('language_lang.ticket_posttic_lbl'); ?></h6>
								<form class="form-horizontal form-user" action="<?=site_url($action);?>" method="post" enctype="multipart/form-data">
									<?php 
										if($validation->listErrors()) { 
											$form_err_data = str_replace('<p>', '', $validation->listErrors());
											$form_err_data = str_replace('</p>', '', $form_err_data);
											$form_err_data = str_replace('.', '', $form_err_data);
									?>
									
										<script type="text/javascript">
										
										(function( $ ) {
											$.jGrowl.defaults.closer = false;
									        var from_daa = '<?php $form_err_data;?>';
											$.jGrowl(from_daa, {
									            header: '<?php echo lang("language_lang.error");?>',
									            theme: 'bg-danger'
									        });
									    
										})(jQuery);

										</script>
									<?php
										}
									?>
									<div class="content-group">
										<div class="form-group ">   
							                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.lbl_status'); ?>:</label>
							                <div class="col-lg-2">
												<select id="" name="status" class="bootstrap-select form-control">
													<option value="3" <?php echo ($ticket_data->ticket_status == 'reopen') ?  "selected" : "" ;  ?>><?php echo lang('language_lang.ticket_reopen_lbl'); ?></option>
													<option value="4" <?php echo ($ticket_data->ticket_status == 'close') ?  "selected" : "" ;  ?>><?php echo lang('language_lang.ticket_close_lbl'); ?></option>
													<option value="0" <?php echo ($ticket_data->ticket_status == 'new') ?  "selected" : "" ;  ?>><?php echo lang('language_lang.ticket_new_lbl'); ?></option>
													<option value="2" <?php echo ($ticket_data->ticket_status == 'fixed') ?  "selected" : "" ;  ?>><?php echo lang('language_lang.ticket_fixed_lbl'); ?></option>
													<option value="1" <?php echo ($ticket_data->ticket_status == 'onhold') ?  "selected" : "" ;  ?>><?php echo lang('language_lang.ticket_onhold_lbl'); ?></option>
												</select>
										    </div>
										</div>

										<div class="form-group <?php if($validation->getError('message')) echo "has-error";?>">
											<div class="col-lg-12">
												<textarea rows="5" name="message" cols="5" class="form-control ckeditor" ></textarea>
												<?php echo $validation->getError('message', '<span class="help-block">', '</span>'); ?>
											</div>
										</div>
										
									</div>
								  	<input type="hidden" name="tkt" value="<?php echo $ticket_data->ticket_no; ?>">
									<div class="text-right">
										<button type="submit" class="btn bg-blue"><i class="icon-arrow-right14"></i> <?php echo lang('language_lang.lbl_submit'); ?></button>
									</div>
								</form>
								<?php } ?>
							</div>
						</div>
						<!-- /comments --> 
					</div>
           			<div class="col-lg-3">

						<!-- Task details -->
						<div class="panel panel-flat">
							<div class="panel-heading">
								<h6 class="panel-title"><i class="icon-files-empty position-left"></i> <?php echo lang('language_lang.tickt_detail'); ?></h6>
								<div class="heading-elements">
									<ul class="icons-list">
				                		<li><a data-action="collapse"></a></li>
				                		<li><a data-action="reload"></a></li>
				                		<li><a data-action="close"></a></li>
				                	</ul>
			                	</div>
							</div>
                            <?php 
                            	if($ticket_data->ticket_status == 'close'){
									$class = "label bg-danger";
								}
								elseif ($ticket_data->ticket_status == 'new') {
									$class = "label bg-primary";
								}
								else{
									$class = "label bg-grey-400";
								} 
							?>
							<table class="table table-borderless table-xs content-group-sm">
								<tbody>
									<tr>
										<td><i class="icon-user position-left"></i> <?php echo lang('language_lang.plac_smtp_username'); ?>:</td>
										<td class="text-right"><span class="pull-right"><?php echo ($username->username) ? $username->username : 'unknown'; ?></span></td>
									</tr>
									<tr>
										<td><i class="icon-alarm-add position-left"></i> <?php echo lang('language_lang.tickt_postdt'); ?>:</td>
										<td class="text-right">
										<?php echo $ticket_data->post_date; ?>
										</td>
									</tr>
									<tr>
										<td><i class="icon-alarm-check position-left"></i> <?php echo lang('language_lang.tickt_last_reply'); ?>:</td>
										<td class="text-right">
										<?php if($lat_date) { echo $lat_date->con_date; } else { echo "Nil"; } ?>
											
										</td>
									</tr>
									
									<tr>
										<td><i class="icon-history position-left"></i> <?php echo lang('language_lang.tickt_subject'); ?>:</td>
										<td class="text-right">
										<?php echo $ticket_data->subject; ?>
											
										</td>
									</tr>

									<tr>
										<td><i class="icon-history position-left"></i> <?php echo lang('language_lang.ticket_no_lbl'); ?>:</td>
										<td class="text-right">
										<?php echo $ticket_data->ticket_no; ?>
											
										</td>
									</tr>
									
									<tr>
										<td><i class="icon-file-check position-left"></i> <?php echo lang('language_lang.lbl_status'); ?>:</td>
										<td class="text-right">
										<span class="<?php echo $class; ?>"><?php echo $ticket_data->ticket_status; ?></span>
											
										</td>
									</tr>
								</tbody>
							</table>

						</div>
						<!-- /task details -->

					</div>
            	</div>

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

    </div>
	<!-- /page container -->

	<script type="text/javascript">
	jQuery.noConflict();
	(function( $ ) {
	$(function() {

		$(document).ready(function() {

			$.jGrowl.defaults.closer = false;

			<?php if($this->session->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo $this->session->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($this->session->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo $this->session->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>

		    $('.form-user').formValidation({
		    	framework: 'bootstrap',
		    	excluded: [':disabled'],
		        icon: {
		            // valid: 'glyphicon glyphicon-ok',
		            // invalid: 'glyphicon glyphicon-remove',
		            validating: 'glyphicon glyphicon-refresh'
		        },
		        fields: {
		            message: {
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.ticket_err_reply"); ?>'
		                    },
		                     stringLength: {
	                                min: 10,
	                                message: '<?php echo lang("language_lang.tick_reply_exceed");?>'
                        	}

		                }
		            }
		            
		            
		        }
		    })
		    .find('[name="message"]')
					.ckeditor()
		            .editor
	                .on('change', function() {
	                    $('.form-user').formValidation('revalidateField', 'message');
	                });
	    $('[name="message"]').ckeditor();
		});
	    
	    $('#icon-bck').on('click',function() {
			window.history.back();
		});

	});
	})(jQuery);

	
	</script>

</body>
</html>
