<!doctype html>
<html lang="en" translate="no" class="w-[640px] mx-auto md:w-full">
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>Revenue</title>
      <?php echo view('user/layout/head');?>
      <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.8/css/dataTables.dataTables.min.css">
      <link rel="stylesheet" href="https://cdn.datatables.net/v/bs4/dt-1.10.18/b-1.5.6/sc-2.0.0/sl-1.3.0/datatables.min.css">
      <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.3/themes/base/jquery-ui.css">
   </head>
   <style>
   .pagination {
  display: flex;
  justify-content: center;
  margin-top: 20px;
}
  
   
      .text-primary {font-size:15px;}
      .accordion-toggle
      {
         background:#121212 !important;
         border-radius:20px !important;
         border:1px solid #ffad00 !important;
         margin:10px 0px 10px 0px !important;
      }
      .asset-user-static
      {
         display :flex !important;
         justify-content:space-between !important;
      }
      .pagination {
    display: flex;
    justify-content: center;
    margin-top: 20px;
}
.modal-backdrop.show { opacity:1; position:relative;}

.pagination-btn {
    background: #007bff;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
    margin: 0 5px;
}

.pagination-btn:disabled {
    background: #6c757d;
    cursor: not-allowed;
}
#pageInfo {
    align-self: center;
    margin: 0 10px;
}
   </style>
   <body class="reg-overflow">
      <section class="dash-banner-bg banner-bg">
         <div class="container">
         <!---header start---->
         <?php echo view('user/layout/header');?>
         <!---header end---->
         <!---banner start---->
         <div class="row">
            <div class="col-lg-12">
               <?php 
                  use App\Libraries\MyEncrypt;
                  use App\Helpers\site_helper;
                  use App\Helpers\form_helper;
                  $this->db = db_connect();
                  $this->session = session();
                  $this->common_model = model('CommonModel');
                  helper('form_helper');
                  
                  
                  $id = 'NyYmemh5aXA=';
                          
                  $myencrypt = new MyEncrypt;
                  $coinid = $myencrypt->decode($id);
                  $user=$this->session->get('uusersid');
                  $buy_bal=curbalance($this->session->get('uusersid'),$coinid);
                  $bal=str_replace(",","", $buy_bal);
                  
                  if(!empty($datewis_profit_count))
                    $datewis_profit_count=$datewis_profit_count;
                  else
                    $datewis_profit_count=0;
                  ?>
               <div class="dash-wrap">
                  <div class="title text-center py-1">
                     <h2 class="text-primary ">Revenue</h2>
                  </div>
      
                  <div class="team-profit-content">
                     <div class="row">
                        <div class="col-lg-6  col-sm-6 py-2">
                           <div class="team-list">
                              <p class="fw-light text-white-50 mb-0">Today's total Profit(USDT)
                              </p>
                              <h5 class="fw-bold text-white">
                              <?php echo  number_format($today_profit,8); ?> USDT</h4>
                           </div>
                        </div>
                        <div class="col-lg-6  col-sm-6 py-2"  >
                           <div class="team-list">
                              <p class="fw-light text-white-50 mb-0">Cumulative profit(USDT)</p>
                              <h5 class="fw-bold text-white">
                              <?php echo  number_format($total_profit,8); ?> USDT</h4>
                           </div>
                        </div>
                     </div>
                  </div>


                  <div class="operation-content">
                 <h3 class="text-primary py-1"> <span id="total_count"> <?php echo $datewis_profit_count;?> </span> Records <a href="" data-bs-toggle="modal" data-bs-target="#staticBackdrop1" data-bs-whatever="@fat" class="text-decoration-none"><i class="fa fa-filter" id="balance_load" style="float:right;color:#fff;"></i></a> </h3>
                 </div>
                 <br>


                 <div class="modal fade" id="staticBackdrop1" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" style="display: none;" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content" style="border-radius:30px;padding: 11px;" >

                    <div class="modal-header" style="padding-top: 11px;margin-bottom:-15px;">
                    <p class="modal-title" id="staticBackdropLabel" style="padding-left:170px;"><b>Records Filter</b></p>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                    </div>

<div class="modal-body">

<div class="row col-lg-12 mt-3">
<div class="form-check form-check-right mb-3" style="font-size: 14px;">

    <div class="form-group">
       <label class="btn btn-default">Start Date</label>
        <input type="text" name="start_date" id="start_date" class="form-control" required>
    </div>
    
    <div class="form-group">
    <label class="btn btn-default">End Date</label>
    <input type="text" name="end_date" id="end_date" class="form-control" required>
    </div>


    <div id="date_err" style="color:red;font-size:12px;font-weight:bold;"></div>
</div>
</div>


</div>
<div class="modal-footer" >

      <button  type="button" class="btn btn-secondary" name="button"  id="confirm">Search</button>
      <button  type="button" class="btn btn-secondary" name="button"  id="reset">Reset</button>
   
</div>

</div>
</div>
</div>

                 <div class="profit-content" id="myItems">
                  <?php 
                                       $i=0;
                                       if (!empty($datewis_profit)) {
                                        foreach ($datewis_profit as $value) 
                                        {
                                            $profit=$this->db->query("select sum(comm_price) as profit from `api_trade_history` where date='".$value->date."' and uuserid = '".$user."' AND `type` = '2'  ORDER BY `id` DESC")->getRow();
                                            if($profit)
                                            {
                                                $profit_amount=$profit->profit;
                                            }
                                            else
                                            {
                                                $profit_amount='0';
                                            }
                                            
                                         $i++;
                                         ?>
                  <div class="faq_accordian mb-3"  >
                     <div class="accordion">
                        <div class="row">
                           <div class="col-md-10 offset-md-1">
                              <div class="team-right accordion-toggle " style="">
                                 <ul class="mb-0 mt-0 asset-user-static  list-unstyled" style="">
                                    <li>
                                    <a class="text-white" href="<?php echo base_url();?>/profit_details/<?php echo date('d-M-Y',strtotime($value->date));?>">
                                       <p class="text-white-50 mb-0" style="align-content:center">Date</p>
                                       <b class="text-white"><?php echo date('d-M-Y',strtotime($value->date));?></b>
                                          </a>
                                    </li>
                                    <li>
                                    <a class="text-white" href="<?php echo base_url();?>/profit_details/<?php echo date('d-M-Y',strtotime($value->date));?>">
                                       <p class="text-white-50 mb-0">Total Profit</p>
                                       <b class="text-white"><?php echo number_format($profit_amount,4); ?></b>
                                          </a>
                                    </li>
                                    <li style="margin-top:10px">
                                       <b ><a class="text-white " href="<?php echo base_url();?>/profit_details/<?php echo date('d-M-Y',strtotime($value->date));?>"><i class="fa-solid fa-greater-than"></i></a></b>
                                    </li>
                                 </ul>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
      <?php } }?>
      </div>


      <div class="pagination">
                            <button id="prevPage" class="pagination-btn" onclick="changePage('prev')">« Previous</button>
                            <span id="pageInfo"></span>
                            <button id="nextPage" class="pagination-btn" onclick="changePage('next')">Next »</button>
                        </div>
                   </div>
                       
                       
                    
                     <!---banner end---->
                  </div>
               </div>
            </div>
            <?php echo view('user/layout/footer');?>
         </div>
      </section>
      <?php echo view('user/layout/footer-script');?>
      <script src="<?php echo base_url();?>/styles/new_style/js/notify.js"></script>
      <script src="https://code.jquery.com/jquery-3.7.1.js"></script>
      <script src="https://code.jquery.com/ui/1.13.3/jquery-ui.js"></script>
     <script>

         $( function() {
                $( "#start_date").datepicker({
                    dateFormat: 'yy-mm-dd'
                });
                  $( "#end_date").datepicker({
                    dateFormat: 'yy-mm-dd'
                });
            } );

let currentPage = 1;
const itemsPerPage = 10; // Number of items per page
let totalPages =1;
let start_date='';
let end_date='';

document.addEventListener('DOMContentLoaded', function() {
loadPage(currentPage,start_date,end_date);
});



function loadPage(page,start_date,end_date)
{
    var uusersid='<?php echo $this->session->get('uusersid');?>';
    $.ajax({
        'method': 'POST',
        'url': '<?php echo base_url("/revenue_records");?>',
         data:{'uusersid':uusersid,"page":page,"itemsPerPage":itemsPerPage,"start_date":start_date,"end_date":end_date},
        success:function(data)
        {
         // alert('ok');
            var data= JSON.parse(data);
            console.log(data.totalPages);
            const myItems = document.getElementById('myItems');
            myItems.innerHTML = '';

            if (data.items.length === 0) {
                myItems.innerHTML = `<div class="faq_accordian mb-3">
                        <div class="accordion" style="margin:10px;text-align:center;color:red;"> No Records Found</div></div>`;
            }
            else
            {

            data.items.forEach(item => {
                myItems.innerHTML += `
                <div class="faq_accordian mb-3"  >
                     <div class="accordion">
                        <div class="row">
                           <div class="col-md-10 offset-md-1">
                              <div class="team-right accordion-toggle " style="">
                                 <ul class="mb-0 mt-0 asset-user-static  list-unstyled" style="">
                                    <li>
                                    <a class="text-white " href="<?php echo base_url();?>/profit_details/${item.date}">
                                       <p class="text-white-50 mb-0" style="align-content:center">Date</p>
                                       <b class="text-white">${item.date}</b>
                                       </a>
                                    </li>
                                    <li>
                                    <a class="text-white " href="<?php echo base_url();?>/profit_details/${item.date}">
                                       <p class="text-white-50 mb-0">Total Profit</p>
                                       <b class="text-white">${item.profit}</b>
                                       </a>
                                    </li>
                                    <li style="margin-top:10px">
                                       <b ><a class="text-white " href="<?php echo base_url();?>/profit_details/${item.date}"><i class="fa-solid fa-greater-than"></i></a></b>
                                    </li>
                                 </ul>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                
                `; });
            }
       
        totalPages=data.totalPages;
        start_date=start_date;
        end_date=end_date;
 
    
        document.getElementById('total_count').innerHTML=data.totalitems;
         document.getElementById('prevPage').disabled = !data.hasPrev;
            document.getElementById('nextPage').disabled = !data.hasNext;
            document.getElementById('pageInfo').innerText = `Page ${page} of ${data.totalPages}`;
        }
      })


      
}
         
function changePage(direction) {
   
   if (direction === 'prev' && currentPage > 1) {
       currentPage--;
   } else if (direction === 'next' && currentPage < totalPages) {
       currentPage++;
   }
   
   loadPage(currentPage,start_date,end_date);
}


$('#confirm').click(function(){
    $("#date_err").html("");
    var start_date=$("#start_date").val();
    var end_date=$("#end_date").val();
  
    if(start_date!='' && end_date=='')
    {
        $("#date_err").html("Start and End date Must Required");
    }
    else if(start_date=='' && end_date!='')
    {
        $("#date_err").html("Start and End date Must Required");
    }
    else
    {
    
        $('#staticBackdrop1').modal('hide');
        let currentPage = 1;
        loadPage(currentPage,start_date,end_date);
    }

});

$('#reset').click(function(){
    let currentPage = 1;
    $("#start_date").val('');
    $("#end_date").val('');
 
    $('#staticBackdrop1').modal('hide');
    
    loadPage(currentPage);
});
      </script>
   </body>
</html>