/* ------------------------------------------------------------------------------
*
*  # Responsive extension for Datatables
*
*  Specific JS code additions for datatable_responsive.html page
*
*  Version: 1.0
*  Latest update: Aug 1, 2015
*
* ---------------------------------------------------------------------------- */
jQuery.noConflict();
(function( $ ) {
$(function() {


    // Table setup
    // ------------------------------

    var rowCount = $('table#myTable tr:last').index() + 1;

    // Setting datatable defaults
    $.extend( $.fn.dataTable.defaults, {
        autoWidth: false,
        responsive: true,
        columnDefs: [{ 
            orderable: false,
            width: '100px',
            targets: [ 5 ]
        }],
        dom: '<"datatable-header"fl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
        language: {
            search: '<span>Filter:</span> _INPUT_',
            lengthMenu: '<span>Show:</span> _MENU_',
            paginate: { 'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;' }
        },
        drawCallback: function () {
            // if($('tbody tr:last').index() + 1 == 1){
            //     $(this).find('tbody tr:first').find('.dropdown, .btn-group').addClass('dropdown inline-drop');    
            // } else {
                // $(this).find('tbody tr:first').find('.dropdown, .btn-group').addClass('dropdown');    
            // }
            
            $(this).find('tbody tr').slice(-2).find('.dropdown, .btn-group').addClass('dropup');
        },
        preDrawCallback: function() {
            $(this).find('tbody tr').slice(-2).find('.dropdown, .btn-group').removeClass('dropup');
            // $(this).find('tbody tr:last-child').find('.dropdown, .btn-group').addClass('dropup');
        }
    });


    // Basic responsive configuration
    $('.datatable-responsive').DataTable();


    // Column controlled child rows
    $('.datatable-responsive-column-controlled').DataTable({
        responsive: {
            details: {
                type: 'column'
            }
        },
        columnDefs: [
            {
                className: 'control',
                orderable: false,
                targets:   0
            },
            { 
                width: "100px",
                targets: [6]
            },
            { 
                orderable: false,
                targets: [6]
            }
        ],
        order: [1, 'asc']
    });


    // Control position
    $('.datatable-responsive-control-right').DataTable({
        responsive: {
            details: {
                type: 'column',
                target: -1
            }
        },
        columnDefs: [
            {
                className: 'control',
                orderable: false,
                targets: -1
            },
            { 
                width: "100px",
                targets: [5]
            },
            { 
                orderable: false,
                targets: [5]
            }
        ]
    });

    $('.datatable-responsive-user').DataTable({
        responsive: {
            details: {
                type: 'column',
                target: 'tr'
            }
        },
        columnDefs: [
            {
                className: 'control',
                orderable: false,
                targets:   0
            },
            { 
                width: "100px",
                targets: [8]
            },
            { 
                orderable: false,
                targets: [8]
            }
        ],
        order: [1, 'asc']

    });

    $('.datatable-responsive-history').DataTable({
        responsive: {
            details: {
                type: 'column',
                target: 'tr'
            }
        },
        columnDefs: [
            {
                className: 'control',
                orderable: false,
                targets:   -1
            },
            { 
                width: "100px",
                targets: [7]
            },
            { 
                orderable: false,
                targets: [7]
            }
        ],
        order: [1, 'asc']

    });

    $('.datatable-responsive-referral').DataTable({
        responsive: {
            details: {
                type: 'column',
                target: 'tr'
            }
        },
        columnDefs: [
            {
                className: 'control',
                orderable: false,
                targets:   0
            },
            { 
                width: "100px",
                targets: [3]
            },
            { 
                orderable: false,
                targets: [3]
            }
        ],
        order: [1, 'asc']

    });


    $('.datatable-responsive-block-ip').DataTable({
        responsive: {
            details: {
                type: 'column',
                target: 'tr'
            }
        },
        columnDefs: [
            {
                className: 'control',
                orderable: false,
                targets:   0
            },
            { 
                width: "100px",
                targets: [2]
            },
            { 
                orderable: false,
                targets: [2]
            }
        ],
        order: [1, 'asc']
        // processing: true,
        // serverSide: true,
        // sAjaxSource: 'http://192.168.2.13/saravanan/zhyip/source/admin/users/dataview'

    });

    $('.datatable-responsive-row-payment').DataTable({
        responsive: {
            details: {
                type: 'column',
                target: 'tr'
            }
        },
        columnDefs: [
            {
                className: 'control',
                orderable: false,
                targets:   0
            },
            { 
                width: "100px",
                targets: [4]
            },
            { 
                orderable: false,
                targets: [4]
            }
        ],
        order: [1, 'desc']
        // processing: true,
        // serverSide: true,
        // sAjaxSource: 'http://192.168.2.13/saravanan/zhyip/source/admin/users/dataview'

    });


    // Whole row as a control
    // var table = $('.datatable-responsive-row-control').DataTable({
    $('.datatable-responsive-row-control').DataTable({
        responsive: {
            details: {
                type: 'column',
                target: 'tr'
            }
        },
        columnDefs: [
            {
                className: 'control',
                orderable: false,
                targets:   0
            },
            { 
                width: "100px",
                targets: [2]
            },
            { 
                orderable: false,
                targets: [2]
            }
        ],
        order: [1, 'asc']
        // processing: true,
        // serverSide: true,
        // sAjaxSource: 'http://192.168.2.13/saravanan/zhyip/source/admin/users/dataview'

    });

    $('.datatable-responsive-row-control1').DataTable();

    // setInterval( function () {
    //     table.ajax.url( 'http://192.168.2.13/saravanan/zhyip/source/admin/users/dataview' ).load();
    // }, 10000 );


    // $('.datatable-responsive-row-history').DataTable({
    //     ajax: "http://192.168.2.118/saravanan/zhyipsvn/source/admin/history/testdata"
    // });



    // External table additions
    // ------------------------------

    // Add placeholder to the datatable filter option
    $('.dataTables_filter input[type=search]').attr('placeholder','Type to filter...');


    // Enable Select2 select for the length option
    $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity,
        width: 'auto'
    });
    
});
})(jQuery);