<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;

class Footersettings extends BaseController {

	/**
	 * 
	 * Start 
	 * Create Date: 21 Jun, 2016
	 * This controller to manage footer setting page.
	 * Created karthiga.
	 * @see http://ihyip.com/admin/footersettings/
	 * Last Updated: 1 Augest, 2016
	 * End
	 * 
	 */

	public function __construct() {
$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		// admin login only
		if($session->get('admin_login')) {

			// form validation library
			// $this->load->library('form_validation');
			$this->isSubadmin();

		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$session->set('last_page', current_url());
				return redirect()->to('admin/login');
			}
		}
		
	}

	private function isSubadmin() {
$this->router = service('router');
	$session = session();
		if($session->get('user_type') == 'subadmin') {
			$controller = $this->router->fetch_class();
			$pages = json_decode($session->get('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}
		}
	}

	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {
			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$session->set($array);
		} else {
			return redirect()->to('admin/login');
		}
	}

	public function index()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_settings')
		);
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  'admin/footersettings';

		$site_data = $this->common_model->GetSettingall('footer');
		
		if($site_data) {
			
			foreach ($site_data as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}

		} else {
			$site_data_default = $this->common_model->defaultlangSettingall('footer');
			foreach ($site_data_default as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}
		}
				
		

		if($this->request->getPost()) {
            $validation->setRules([
            	'footer_note' => ['label'=>lang('language_lang.Footer_Note'), 'rules'=> 'trim|required'],
            	'footer1' => ['label'=>lang('language_lang.Footer_1'), 'rules'=> 'trim|required'],
            	'footer2' => ['label'=>lang('language_lang.Footer_2'), 'rules'=> 'trim|required']
            ]);
			// $this->form_validation->set_rules('footer_note', lang('language_lang.Footer_Note'), 'trim|required');
			// $this->form_validation->set_rules('footer1', lang('language_lang.Footer_1'), 'trim|required');
			// $this->form_validation->set_rules('footer2', lang('language_lang.Footer_2'), 'trim|required');
			//$this->form_validation->set_rules('footer3', lang('language_lang.Footer_3'), 'trim|required');
			//$this->form_validation->set_rules('footer4', lang('language_lang.Footer_4'), 'trim|required');
			// check form validate
			if ($validation->withRequest($this->request)->run() == TRUE) {
				

                foreach ($site_data as $row) {

					$key_value = $row->site_key;
					
					if($this->request->getPost($key_value)){

						$sitedata = array(
							"site_value"	=>	$this->request->getPost($key_value)
						);
						$db      = \Config\Database::connect();
                        $builder = $db->table('site_controls'); 
						$builder->where('settings_name','footer');
						$builder->where('site_key',$key_value);
						$update_status = $builder->update($sitedata);

					} 

				}

				if($update_status) {
					$session->setFlashData('success_message', lang('language_lang.footer_success_message'));
					return redirect()->to('admin/footersettings');
				} else {
					$session->setFlashData('error_message', lang('language_lang.footer_error_message'));
					return redirect()->to('admin/footersettings');
				}

				
			}
			
		}
		echo view('admin/settings/footer',$this->data);

	}
	
}

