<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Ticketdetails extends CI_Controller {

	/**
	 * 
	 * Start 
	 * Create Date: 19 september, 2016
	 * This controller to manage ticketdetails page.
	 * Created karthiga.
	 * @see http://zhyip.com/admin/ticketdetails/
	 * Last Updated: 19 september, 2016
	 * End
	 * 
	*/

	public function __construct() {
		parent::__construct();
		// admin login only
		if($this->session->userdata('admin_login')) {
			// form validation library
			$this->load->library('form_validation');

			// custom encryption
			$this->load->library('MyEncrypt');
			$myencrypt = new MyEncrypt;
		} else {
			$this->session->set_userdata('last_page', current_url());
			redirect('admin/login');
		}
	}

	public function index()
	{
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('support_lbl')
		
		);
		$this->data['module_name'] = 'settings';

		$this->data['ticketlist'] = $this->common_model->GetResults('tickets');		

		$this->load->view('admin/tickets',$this->data);

	}

}

