<?php require('header.php');?>

    <div class="content">
        <div class="py-4 px-3 px-md-4">
            <div class="card mb-3 mb-md-4">

                <div class="card-body">
                    <!-- Breadcrumb -->
                    <nav class="d-none d-md-block" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#">Settings</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Binance API Settings</li>
                        </ol>
                    </nav>
                    <!-- End Breadcrumb -->

                    <div class="mb-3 mb-md-4 d-flex justify-content-between">
                        <div class="h3 mb-0">Update API settings</div>
                    </div>
                     <!-- Form -->
                    <div>
                        <form>
                            <div id="dis" class="err"></div>
                            <div class="form-row">
                                <div class="form-group col-12 col-md-12">
                                    <label for="name">API KEY</label>
                                    <input type="text" class="form-control" value="" id="api_key" name="api_key" placeholder="API KEY">
                                    <div id="key_err" class="err"></div>
                                </div>
                                <div class="form-group col-12 col-md-12">
                                    <label for="email">API Secret</label>
                                    <input type="text" class="form-control" value="" id="api_secret" name="api_secret" placeholder="API Secret">
                                    <div id="secret_err" class="err"></div>
                                </div>

                                <div class="form-group col-12 col-md-12">
                                    <label for="email">IP Address</label>
                                    <input type="text" class="form-control" value="" id="ip_address" name="ip_address" placeholder="User IP">
                                </div>
                            </div>
                           
                            <button type="button" class="btn btn-primary float-right" onclick="update_binace();">Update</button>
                        </form>
                    </div>
                    <!-- End Form -->
                </div>
            </div>


    
            <script>
                function update_binace()
                {
                    var api_key=$("#api_key").val();
                    var api_secret=$("#api_secret").val();

                    $("#key_err").html('');
                    $("#secret_err").html('');

                    var flag=0;
                    if(api_key=='')
                    {
                        flag=1;
                        $("#key_err").html('Please Enter API KEY');
                    }
                    if(api_secret=='')
                    {
                        flag=1;
                        $("#secret_err").html('Please Enter API Secret');
                    }

                    if(flag!='1')
                    {

                        $("#dis").html('Please Wait Data Request Progressing...');
                        $.ajax({
                            type: "POST",
                            url: "binance_verify",
                            data:{api_key:api_key,api_secret:api_secret},
                            success: function(msg) {
                                var msg = msg.trim();
                                if(msg=='success')
                                {
                                    window.location='binance.php';
                                }
                                else
                                {
                                    $("#dis").html("<div class='alert alert-danger'><strong>Error !</strong>"+ msg +"</div>");
                                }
                            }
                        });

                    }
                }
            </script>
      <?php
      require('footer.php');
      ?>