<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;
class Message extends BaseController {

	/**
	 * 
	 * Start 
	 * Create Date: 6 July, 2016
	 * This controller to manage message page.
	 * Created karthiga.
	 * @see http://ihyip.com/admin/message/
	 * Last Updated: 6 July, 2016
	 * End
	 * 
	 */

	public function __construct() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		// admin login only
		if($session->get('admin_login')) {
			// form validation library

			// custom encryption
			$myencrypt = new MyEncrypt;
			$this->isSubadmin();

		} else {
			return redirect()->to('admin/login');
		}

	}

	private function isSubadmin() {
        $this->router = service('router');
        $session = session();
		if($session->get('user_type') == 'subadmin') {
			$controller = $this->router->fetch_class();
			$pages = json_decode($session->get('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}
		}
	}

	public function index()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_extra')
		
		);
		$this->data['module_name'] = 'settings';
		$this->data['message_data'] = $this->common_model->GetResults('message_controls');
        

		echo view('admin/message',$this->data);

	}
	public function add($id='') {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.message_text'),
			'href' => base_url('admin/message')
		);
		
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  'admin/message/add';
        $this->data['user_list'] = $this->common_model->GetResults('uusers'); 
		if($id) {
			$news_id = $myencrypt->decode($id);
			$condition = "message_id = '".$message_id."'";
			$this->data['message_data'] = $this->common_model->GetRow('message_controls', $condition);
			
		}


		if($this->request->getPost()) {
			
			$validation->setRules([
				'message_content' => ['label' => lang("language_lang.message_content"), 'rules' => 'trim|required'],
				'start_date' => ['label' => lang("language_lang.message_startdate"), 'rules' => 'trim|required'],
				'user_id' => ['label' => lang("language_lang.message_users"), 'rules' => 'trim|required'],
				'expire_days' => ['label' => lang("language_lang.message_expiredays"), 'rules' => 'trim|required']
			]);
			// form validation
			// $this->form_validation->set_rules('message_content', lang("language_lang.message_content"), 'trim|required');
			// $this->form_validation->set_rules('start_date', lang("language_lang.message_startdate"), 'trim|required');
			// $this->form_validation->set_rules('user_id[]', lang("language_lang.message_users"), 'trim|required');
   //          $this->form_validation->set_rules('expire_days', lang("language_lang.message_expiredays"), 'trim|required|is_numeric()');
            
			// check form validate
			if ($validation->withRequest($this->request)->run() == TRUE) {
				$userlist = json_encode($this->request->getPost('user_id')); 
			 	$message_data = array(
					"user"	=>	$userlist,
					"message_content"	=>	$this->request->getPost('message_content'),
					"start_date"     =>  date('Y-m-d',strtotime($this->request->getPost('start_date'))),
					"expire_days"	=>	$this->request->getPost('expire_days'),
					"message_status"	=>	($this->request->getPost('message_status')) ? '1' : '0' 
				);
					
				$query_status = $this->db->table('message_controls')->insert($message_data);

				if($query_status) {
					$session->setFlashData('success_message', lang('language_lang.message_success_message'));
					return redirect()->to('admin/message');
				} else {
					$session->setFlashData('error_message', lang('language_lang.message_error_message'));
					return redirect()->to('admin/message');
				}
			}
		}
		echo view('admin/addmessage',$this->data);
	}
	public function edit($id=''){
        $this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.message_title'),
			'href' => base_url('admin/message')
		);
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  'admin/message/edit';
        $this->data['user_list'] = $this->common_model->GetResults('uusers'); 
		if($id) {
			$myencrypt = new MyEncrypt;
			$message_id = $myencrypt->decode($id);
			
			$condition = "message_id = '".$message_id."'";
			$this->data['message_data'] = $this->common_model->GetRow('message_controls', $condition);
			
		}

		if($this->request->getPost()) {
			$validation->setRules([
				'message_content' => ['label' => lang("language_lang.message_content"), 'rules' => 'trim|required'],
				'start_date' => ['label' => lang("language_lang.message_startdate"), 'rules' => 'trim|required'],
				'user_id' => ['label' => lang("language_lang.message_users"), 'rules' => 'trim|required'],
				'expire_days' => ['label' => lang("language_lang.message_expiredays"), 'rules' => 'trim|required']
			]);
			//form validation
   //          $this->form_validation->set_rules('message_content', lang("language_lang.message_content"), 'trim|required');
			// $this->form_validation->set_rules('start_date', lang("language_lang.message_startdate"), 'trim|required');
			// $this->form_validation->set_rules('user_id[]', lang("language_lang.message_users"), 'trim|required');
   //          $this->form_validation->set_rules('expire_days', lang("language_lang.message_expiredays"), 'trim|required|is_numeric()');
            
			if ($validation->withRequest($this->request)->run() == TRUE) {

                $message_id = $this->request->getPost('message_id');
				$userlist = json_encode($this->request->getPost('user_id'));
				
				$time = strtotime(str_replace('-', '/', $this->request->getPost('start_date')));
				$var = date('Y-m-d',$time);
		 	    $message_data = array(
					"user"	=>	$userlist,
					"message_content"	=>	$this->request->getPost('message_content'),
					"start_date"     =>  $var,
					"expire_days"	=>	$this->request->getPost('expire_days'),
					"message_status"	=>	($this->request->getPost('message_status')) ? '1' : '0' 
			    );
					
				
				$query_status = $this->db->table('message_controls')->where('message_id',$message_id)->update($message_data);
						
				if($query_status) {
					$session->setFlashData('success_message', lang('language_lang.message_success_message'));
					return redirect()->to('admin/message');
				} else {
					$session->setFlashData('error_message', lang('language_lang.message_error_message'));
					return redirect()->to('admin/message');
				}
			}
			
		}
		echo view('admin/addmessage',$this->data);	

	}

	public function delete($id) {
		$session = session();
		$myencrypt = new MyEncrypt;
		$message_id = $myencrypt->decode($id);
		if(isset($message_id)){
			
			
			$delete_status = $this->db->table('message_controls')->where('message_id',$message_id)->delete();

			if($delete_status) {
				$session->setFlashData('success_message', lang('language_lang.message_delete_success_message'));
				return redirect()->to('admin/message');
			} else {
				$session->setFlashData('error_message', lang('language_lang.message_delete_error_message'));
				return redirect()->to('admin/message');
			}	
			
		} else {
			return redirect()->to('admin/message');
		}
	}

	public function changeStatus($id) {
		 $session = session();
			$myencrypt = new MyEncrypt;
			$message_id = $myencrypt->decode($id);
		
			$cur_up_data = array(
				"message_status" => '0'
			);
			$update_status = $this->db->table('message_controls')->where('message_id',$message_id)->update($cur_up_data);

			if($update_status){
				$session->setFlashData('success_message', lang('language_lang.message_default_success'));
                return redirect()->to('admin/message');
			} else {
				$session->setFlashData('error_message', lang('language_lang.message_default_error'));
				return redirect()->to('admin/message');
			}

		
	}
	public function changeActiveStatus($id) {
            $session = session();
			$myencrypt = new MyEncrypt;
			$message_id = $myencrypt->decode($id);
			
			$cur_up_data = array(
				"message_status" => '1'
			);
			$update_status = $this->db->table('message_controls')->where('message_id',$message_id)->update($cur_up_data);

			if($update_status){
				$session->setFlashData('success_message', lang('language_lang.message_default_success'));
				return redirect()->to('admin/message');
			} else {
				$session->setFlashData('error_message', lang('language_lang.message_default_error'));
			    return redirect()->to('admin/message');
			}

		
	}

	

}

