<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;


class Faq extends BaseController {

	/**
	 * 
	 * Start 
	 * Create Date: 1 July, 2016
	 * This controller to manage faq page.
	 * Created karthiga.
	 * @see http://ihyip.com/admin/faq/
	 * Last Updated: 1 July, 2016
	 * End
	 * 
	 */

	public function __construct() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		// admin login only
		if($session->get('admin_login')) {
			// form validation library

			// custom encryption
			$myencrypt = new MyEncrypt;
			$this->isSubadmin();
			
		} else {
			$session->set('last_page', current_url());
			return redirect()->to('admin/login');
		}

	}

	private function isSubadmin() {
$session =session();
$this->router = service('router');
		if($session->get('user_type') == 'subadmin') {
			$controller = $this->router->fetch_class();
			$pages = json_decode($session->get('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}
		}
	}

	public function index()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_extra')
		
		);
		// $this->data['breadcrumbs'][] = array(
		// 	'text' => lang('language_lang.faq_text'),
		// 	'href' => base_url().'admin/faq'
		// );
		$this->data['module_name'] = 'settings';
		$this->data['faq_data'] = $this->common_model->GetFaq();
        $this->data['languages'] = $this->common_model->GetResults('language_controls');

		echo view('admin/faq',$this->data);

	}
	public function add($id='') {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_extra'),
			'href' => base_url().'admin/cms'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.faq_text'),
			'href' => base_url().'admin/faq'
		);
		
		$this->data['languages'] = $this->common_model->GetResults('language_controls');
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  'admin/faq/add';

		if($id) {
			$faq_id = $myencrypt->decode($id);
			$condition = "faq_id = '".$faq_id."'";
			$this->data['faq_data'] = $this->common_model->GetRow('faq_controls', $condition);
			
		}

		if($this->request->getPost()) {
            $validation->setRules([
            	'faq_question' => ['label'=>lang("language_lang.faq_question"),'rules'=>'trim|required'],
            	'faq_answer' => ['label'=>lang("language_lang.faq_answer"),'rules'=>'trim|required'],
            ]);
			// $this->form_validation->set_rules('faq_question', lang("language_lang.faq_question"), 'trim|required|is_unique[faq_controls.faq_question]');
			// $this->form_validation->set_rules('faq_question', lang("language_lang.faq_question"), 'trim|required');
			// $this->form_validation->set_rules('faq_answer', lang("language_lang.faq_answer"), 'trim|required');
			

			// check form validate
			if ($validation->withRequest($this->request)->run() == TRUE) {
                 
				 	$pagedata = array(
						"faq_question"	=>	$this->request->getPost('faq_question'),
                        "faq_url"	    =>	strtolower(str_replace(" ", "-", $this->request->getPost('faq_question'))), 						
						"faq_answer"	=>	$this->request->getPost('faq_answer'),
						"language_id"   =>  $this->request->getPost('language_id'),
						"faq_status"	=>	($this->request->getPost('faq_status')) ? '1' : '0'
					);
					
					$query_status = $this->db->table('faq_controls')->insert($pagedata);

				if($query_status) {
					$session->setFlashData('success_message', lang('language_lang.faq_success_message'));
					return redirect()->to('admin/faq');
				} else {
					$session->setFlashData('error_message', lang('language_lang.faq_error_message'));
					return redirect()->to('admin/faq');
				}
				
			} 
			
		}
		echo view('admin/addfaq',$this->data);
	}
	public function edit($id=''){
        $this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.faq_title'),
			'href' => base_url('admin/faq')
		);
		
		$this->data['languages'] = $this->common_model->GetResults('language_controls');
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  'admin/faq/edit';

		if($id) {
			$myencrypt = new MyEncrypt;
			$faq_id = $myencrypt->decode($id);
			
			$condition = "faq_id = '".$faq_id."'";
			$this->data['faq_data'] = $this->common_model->GetRow('faq_controls', $condition);
		}

		if($this->request->getPost()) {
			 $validation->setRules([
            	'faq_question' => ['label'=>lang("language_lang.faq_question"),'rules'=>'trim|required'],
            	'faq_answer' => ['label'=>lang("language_lang.faq_answer"),'rules'=>'trim|required'],
            ]);
   //          $this->form_validation->set_rules('faq_question', lang("language_lang.faq_question"), 'trim|required');
			// $this->form_validation->set_rules('faq_answer', lang("language_lang.faq_answer"), 'trim|required');			
			if ($validation->withRequest($this->request)->run() == TRUE) {

                    $lang_id = $this->request->getPost('language_id');
				    $faq_id = $this->request->getPost('faq_id');
					$this->request->getPost('faq_answer');
					
							$faq_data = array(
								"faq_question"	=>	$this->request->getPost('faq_question'),
		                        "faq_url"	    =>	strtolower(str_replace(" ", "-", $this->request->getPost('faq_question'))), 						
								"faq_answer"	=>	$this->request->getPost('faq_answer'),
								"language_id"   =>  $this->request->getPost('language_id'),
								"faq_status"	=>	($this->request->getPost('faq_status')) ? '1' : '0'
							);
							
							$query_status = $this->db->table('faq_controls')->where('faq_id',$faq_id)->update($faq_data);
						
				if($query_status) {
					$session->setFlashData('success_message', lang('language_lang.faq_success_message'));
					return redirect()->to('admin/faq');
				} else {
					$session->setFlashData('error_message', lang('language_lang.faq_error_message'));
					return redirect()->to('admin/faq');
				}
			}
			
		}
		echo view('admin/addfaq',$this->data);	

	}

	public function delete($id) {
		$session = session();
			$myencrypt = new MyEncrypt;
			$faq_id = $myencrypt->decode($id);
			if(isset($faq_id)){
				$delete_status = $this->db->table('faq_controls')->where('faq_id',$faq_id)->delete();
				

				if($delete_status) {
					$session->setFlashData('success_message', lang('language_lang.faq_delete_success_message'));
					return redirect()->to('admin/faq');
				} else {
					$session->setFlashData('error_message', lang('language_lang.faq_delete_error_message'));
					return redirect()->to('admin/faq');
				}	
				
			} else {
				return redirect()->to('admin/faq');
			}
	}

	public function changeStatus($id) {
		    $session = session();
			$myencrypt = new MyEncrypt;
			$faq_id = $myencrypt->decode($id);
		
			$cur_up_data = array(
				"faq_status" => '0'
			);
			$update_status = $this->db->table('faq_controls')->where('faq_id',$faq_id)->update($cur_up_data);

			if($update_status){
				$session->setFlashData('success_message', lang('language_lang.faq_default_success'));
                return redirect()->to('admin/faq');
			} else {
				$session->setFlashData('error_message', lang('language_lang.faq_default_error'));
				return redirect()->to('admin/faq');
			}

		
	}
	public function changeActiveStatus($id) {
            $session = session();
			$myencrypt = new MyEncrypt;
			$faq_id = $myencrypt->decode($id);
			
			$cur_up_data = array(
				"faq_status" => '1'
			);
			$update_status = $this->db->table('faq_controls')->where('faq_id',$faq_id)->update($cur_up_data);

			if($update_status){
				$session->setFlashData('success_message', lang('language_lang.faq_default_success'));
				return redirect()->to('admin/faq');
			} else {
				$session->setFlashData('error_message', lang('language_lang.faq_default_error'));
			    return redirect()->to('admin/faq');
			}

		
	}

	

}

