<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Main navbar -->
		<?php
		use App\Libraries\MyEncrypt;
         $session = session();
		 echo view('admin/common_header'); ?>
	<!-- /main navbar -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/datatables.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/extensions/responsive.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/select2.min.js');?>"></script>

	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/datatables_responsive.js');?>"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    
    <link href="<?php echo base_url('assets/css/icons/fontawesome/styles.min.css');?>" rel="stylesheet" type="text/css">

    <!-- Theme JS files -->
	
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/bootstrap_select.min.js');?>"></script>
	<!-- select box JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/form_bootstrap_select.js');?>"></script>
	<!-- /select box JS files -->


	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/bootbox.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/sweet_alert.min.js');?>"></script>
	<!-- /theme JS files -->
</head>
<style>
.icons-list > li {
    display: inline-block;
    font-size: 26px;
    }
    .heading-elements .icons-list {
    margin-top: 5px;
}

		.img
		{
			width:70px;
			height:70px;
		}

</style>
<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold">Trade Pairs Settings</h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo "Trade Pairs"?></h5>
						<div class="heading-elements">
						    <ul class="icons-list">
								<li><a href="<?php echo base_url('admin/tradepairs/add');?>" class="icon-plus-circle2"></a></li>
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>
					<table class="table datatable-responsive-row-control table-hover">
					<colgroup>
						<col width="20%">
						<col width="20%">
						<col width="20%">
						<col width="20%">
						<col width="20%">


					</colgroup>
						<thead>
							<tr><th></th>
								<th class="text-center"><?php echo 'Coin Name';?></th>
								<th class="text-center"><?php echo 'Pair Name';?></th>
							    <th class="text-center">Image</th>
								<th class="text-center"><?php echo lang('language_lang.news_status');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_action');?></th>
								
							</tr>
						</thead>
						<tbody>

                        <?php if($pairdata)
                        {
                          
                            foreach($pairdata as $row)
                            {

                                $myencrypt = new MyEncrypt;
							
									
									if($row->status=='1'){
										$label_status = 'label-success';
										$status = lang('language_lang.active');
									} else {
										$label_status = 'label-danger';
										$status = lang('language_lang.in_active');
									}

                        ?>
					
							<tr>
							    <td></td>
								<td class="text-center"><?php echo ucfirst($row->coin_name);?></td>
							    <td class="text-center"><?php echo strtoupper($row->pair_name);?></td>
                                <td class="text-center"><img src="<?php echo base_url();?>/styles/images/tradingpair_images/<?php echo $row->coin_image;?>" class="img"></td>
								<?php if($row->status=='1'){ ?>
								         <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" onclick="changeStatus('<?php echo $myencrypt->encode($row->id); ?>')" href="javascript:void(0)"><?php echo $status;?></a></span></td>
								<?php } else {?>
 								         <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" onclick="changeActiveStatus('<?php echo $myencrypt->encode($row->id); ?>')" href="javascript:void(0)"><?php echo $status;?></a></span></td>
                                <?php } ?>
                             
								<td class="text-center">
									<ul class="icons-list">
										<li class="dropdown">
											<a href="#" class="dropdown-toggle" data-toggle="dropdown">
												<i class="icon-menu9"></i>
											</a>

											<ul class="dropdown-menu dropdown-menu-right">
											
												<li><a onclick="confirmdelete('<?php echo $myencrypt->encode($row->id);?>')" href="javascript:void(0)" ><i class="fa fa-remove"></i> <?php echo lang('language_lang.delete');?></a></li>
											</ul>
										</li>
									</ul>
								</td>
							</tr>
					
                            <?php } }?>
			
						</tbody>
					</table>
				</div>
				<!-- /basic responsive configuration -->



		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		
	(function($) {



	    $(document).ready(function() {

	    	$.jGrowl.defaults.closer = false;

				<?php if($session->getFlashData('error_message')) { ?>
					$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
			            header: 'Error!',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($session->getFlashData('success_message')) { ?>
	                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
			            header: '<?php echo lang("language_lang.success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

	            $('#icon-bck').on('click',function() {
					window.history.back();
				});

				

				// $('#language_change').on('change', function() {
				//     console.log($this.val);
				// });
		});

	})(jQuery);
	
	function changeStatus(valus) {
         swal({
            title: "<?php echo lang('language_lang.confirm_status_change');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url('admin/tradepairs/changeStatus/');?>"+'/'+valus;
            }
            else {
              return false;
            }
		
		});
	}
	function changeActiveStatus(valus) {
		swal({
            title: "<?php echo lang('language_lang.confirm_status_change');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url('admin/tradepairs/changeActiveStatus/');?>"+'/'+valus;
            }
            else {
              return false;
            }
		
		});
	}
	function confirmdelete(value) {
		swal({
            title: "Do you want to delete this Pair?",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url('admin/tradepairs/delete/');?>"+'/'+value;
            }
            else {
              return false;
            }

		});
    }

	
	</script>

</body>
</html>
