<!doctype html>
<html lang="en" translate="no" class="w-[640px] mx-auto md:w-full">
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>Trade Quantify</title>
      <?php echo view('user/layout/head');?>
      <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.8/css/dataTables.dataTables.min.css">
      <link rel="stylesheet" href="https://cdn.datatables.net/v/bs4/dt-1.10.18/b-1.5.6/sc-2.0.0/sl-1.3.0/datatables.min.css">
  
 
   </head>
   <style>
      .nav-item
      {
      border:2px solid  rgba(140,98,10,1) !important;
      }
      .sam .active {
      background: linear-gradient(180deg, rgba(179,137,34,1) 0%, rgba(140,98,10,1) 50%, rgba(179,137,34,1) 100%, rgba(14,72,62,1) 100%) !important;
      border-radius: 0px !important;
      }
      .head {
      background: linear-gradient(180deg, rgba(179,137,34,1) 0%, rgba(140,98,10,1) 50%, rgba(179,137,34,1) 100%, rgba(14,72,62,1) 100%);
      color: #fff;
      border: 1px;
      }
      .dt-paging 
      {
      text-align:center ;
      margin-top:15px;
      }
      div.dt-container .dt-paging .dt-paging-button.disabled, div.dt-container .dt-paging .dt-paging-button.disabled:hover, div.dt-container .dt-paging .dt-paging-button.disabled:active {
      color: #fff !important;
      }
      div.dt-container .dt-paging .dt-paging-button {
      color: #fff !important;
      padding:0px 10px 0px 10px !important;
      }
      .dt-paging-button
      {
      font-size:20px !important;
      color:#fff !important;
      padding:0px 10px 0px 10px !important;
      }
      .dt-paging .current
      {
      border : 1px solid #e49a00 !important;
      /* border-radius : 20px !important; */
      background : #e49a00 !important;
      }
      .dt-empty
      {
      text-align:center !important;
      }
      .cards tbody tr {
      float: left;
      width: 19rem;
      margin: 0.5rem;
      border: 0.0625rem solid rgba(0, 0, 0, .125);
      border-radius: .25rem;
      box-shadow: 0.25rem 0.25rem 0.5rem rgba(0, 0, 0, 0.25);
      }
      .cards tbody td {
      display: block;
      }
      .cards thead {
      display: none;
      }
      .cards td:before {
      content: attr(data-label);
      position: relative;
      float: left;
      color: #808080;
      min-width: 4rem;
      margin-left: 0;
      margin-right: 1rem;
      text-align: left;   
      }
      tr.selected td:before {
      color: #CCC;
      }
      .table .avatar {
      width: 50px;
      }
      .cards .avatar {
      width: 150px;
      height: 150px;
      margin: 15px;
      }
      table.dataTable td,table.dataTable th
      {
      font-size:14px;
      color:#fff !important;
      }
      .btn-group {
      border-radius: .375rem;
      float: right;
      }
      table.dataTable.table-sm .sorting::before, table.dataTable.table-sm .sorting_asc::before, table.dataTable.table-sm .sorting_desc::before {
      top:15px;
      margin-right:10px;
      }
      table.dataTable.table-sm .sorting::after, table.dataTable.table-sm .sorting_asc::after, table.dataTable.table-sm .sorting_desc::after {
      top: 15px;
      margin-right:10px;
      }
      @media (max-width: 767.98px) { .border-sm-start-none { border-left: none !important; } }
      .card { background:transparent;}
      .notify {
      position: fixed;
      top: 10px;
      left: 10px;
      -moz-box-sizing: border-box;
      box-sizing: border-box;
      width: 350px;
      font-size: 14px;
      text-align: center;
      }
      /* Positions
      ========================================================================== */
      .notify-top-right,
      .notify-bottom-right {
      left: auto;
      right: 10px;
      }
      .notify-top-center,
      .notify-bottom-center {
      left: 50%;
      margin-left: -175px;
      }
      .notify-bottom-left,
      .notify-bottom-right,
      .notify-bottom-center {
      top: auto;
      bottom: 10px;
      }
      .notify button {
      -webkit-appearance: none;
      padding: 0;
      cursor: pointer;
      background: 0 0;
      border: 0;
      display: none;
      }
      /* Responsiveness
      ========================================================================== */
      /* Phones portrait and smaller */
      @media (max-width: 479px) {
      /*
      * Fit in small screen
      */
      .notify {
      left: 10px;
      right: 10px;
      width: auto;
      margin: 0;
      }
      }
      /* Sub-object: `notify-message`
      ========================================================================== */
      .notify-message {
      position: relative;
      cursor: pointer;
      }
      .notify .alert-default {
      background: #fff;
      border: 1px solid #e5e5e5;
      }
      .btn-sm {
      display: inline-block;
      padding: 10px 20px; /* Adjust padding as needed */
      border: none;
      text-align: center;
      text-decoration: none;
      cursor: pointer;
      border-radius: 5px;
      font-size: 12px;
      font-weight: bold;
      color: #fff;
      }
      .card.hidden {
    opacity: 0;
    pointer-events: none; /* Optionally disable pointer events on hidden cards */
}
.left-label{ float:left;font-size:14px;font-weight:400;color:orange;}
.right-label{ float:right;font-size:14px;font-weight:400;color:orange;}

.spin {
      animation: spin 1s infinite;
    }

    @keyframes spin {
      from { transform: rotate(0deg); }
      to { transform: rotate(360deg); }
    }
    .green { color:green;}
    .blue { color:blue;}
    .orange { color:orange;}
    .red { color:red;}
    .btn.btn-default { border:1px solid #ddd !important;margin-bottom:20px !important; }
    .modal-backdrop.show { opacity:1; position:relative;}
   </style>
   <body class="reg-overflow">
      <section class="dash-banner-bg banner-bg">
         <div class="container">
         <!---header start---->
         <?php echo view('user/layout/header');?>
         <!---header end---->
         <!---banner start---->
         <div class="row">
            <div class="col-lg-12">
               <?php 
                  use App\Libraries\MyEncrypt;
                  use App\Helpers\site_helper;
                  use App\Helpers\form_helper;
                  $this->db = db_connect();
                  $this->session = session();
                  $uusersid = $this->session->get('uusersid');

                  if(!empty($this->session->get('exchange')))
                     $exchange=$this->session->get('exchange');
                  else
                     $exchange='1';
                  
                  function formatTradingPair($pair) 
                  {
                    $base = substr($pair, 0, -4);  // Extract the base currency (all but the last 4 characters)
                    $quote = substr($pair, -4);    // Extract the quote currency (last 4 characters)
                    return strtoupper($base) . '/' . strtoupper($quote); // Combine and convert to lowercase
                  }
                  $this->common_model = model('CommonModel');
                  helper('form_helper');
                  $buy_bal='0';
                  $bind_api =$this->db->query("SELECT * FROM bind_process WHERE uusersid='".$uusersid."'")->getRow();
                  if(!empty($bind_api))
                  $bind_api = true;
                  else
                  $bind_api = false;
                  $required_pairs = ['1INCH','ADA','AAVE','ATOM','ALGO','AION','AVAX','AKRO','ANT','APE','BAT','BTC','BCH','BNB','BTCST','BAKE','BOME','BONK','CRV','COMP','CAKE','COS','DOGE','DASH','DOT','ETH','EOS','ETC','FTM','FTT','FIL','GALA','GRT','GMT','HBAR','HOT','IOTA','ICP','IOST','JST','KAVA','KSM','LTC','LINK','LIT','LUNA','MANA','MATIC','MDX','NEO','NOT','OMG','ONT','PEPE','QTUM','REEF','RSR','SUN','SHIB','SLP','SOL','SUSHI','SXP','TRX','THETA','TFUEL','UNI','VET','WRX','XRP','XMR','XEM','XLM','XTZ','YFI','YFII','ZEC','ZEN'];
                  $tradSets = $this->common_model->GetResults('adminsettings','');
                  $tradSet = $tradSets[0];
                  $activation='';
                  $usdt_balance='0';
                  $sno=0;
                  
                  
                  function get_tradeinfo($symbol,$live_price,$userid)
                  {
                     
                     $CI = db_connect();
                     $CI->session = session();

                     if(!empty($CI->session->get('exchange')))
                     $exchange=$CI->session->get('exchange');
                    else
                     $exchange='1';

                    $uusersid = $userid;
                 
                  
                  $trade_process =$CI->query("SELECT * FROM trade_process WHERE pair='".$symbol."' and uusersid='".$uusersid."' and exchange='".$exchange."'  and trade_status!= 2")->getRow();
                  
                  if(!$trade_process){
                     $trade_process =$CI->query("SELECT * FROM user_strategy WHERE uusersid='".$uusersid."'")->getRow();
                     
                  }
                  $pair =$CI->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and pair='".$symbol."' and trade_status!= 2 and exchange='".$exchange."' order by id desc")->getRow();
                  if(!empty($pair))
                  {
                     $sync_strategy_status = $pair->sync_strategy_status ? $pair->sync_strategy_status : 0;
                     $manual_buy = $CI->table('api_manual_trade')->where('trade_process_id',$pair->id)->where('type',1)->where('exchange',$exchange)->where('status','1')->get()->getRow();
                     $manual_sell = $CI->table('api_manual_trade')->where('trade_process_id',$pair->id)->where('type',2)->where('exchange',$exchange)->where('status','1')->get()->getRow();
                     $pair_trade_status=$pair->trade_status;
                  }
                  else
                  {
                     $sync_strategy_status='0';
                     $pair_trade_status='';
                  }
                  
                  $qury = $CI->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' AND  pair = '".$symbol."' and trade_status!= 2 and exchange='".$exchange."' ")->getResult();
                  if(!empty($qury))
                  {
                   $qry=$qury[0];
                   $qury = $CI->query("SELECT * FROM user_strategy WHERE uusersid='".$uusersid."'")->getResult();
                   $qry=$qury[0];
                   $first_buy_amount=$qry->first_buy_amount;
                   $open_position_doubled=$qry->open_position_doubled;
                   $margin_column_limit=$qry->margin_column_limit;
                   $whole_profit_ratio=$qry->whole_profit_ratio;
                   $whole_profit_callback=$qry->whole_profit_callback;
                   $buyin_callback=$qry->buyin_callback;
                   $sub_position_callback=$qry->sub_position_callback;
                   $strategy_mode=$qry->strategy_mode;
                   
                   
                  }
                  else
                  {
                  
                   $qry='';
                   $qury = $CI->query("SELECT * FROM user_strategy WHERE uusersid='".$uusersid."'")->getResult();
                   $qry=$qury[0];
                   
                   $first_buy_amount=$qry->first_buy_amount;
                   $open_position_doubled=$qry->open_position_doubled;
                   $margin_column_limit=$qry->margin_column_limit;
                   $whole_profit_ratio=$qry->whole_profit_ratio;
                   $whole_profit_callback=$qry->whole_profit_callback;
                   $buyin_callback=$qry->buyin_callback;
                   $sub_position_callback=$qry->sub_position_callback;
                   $strategy_mode=$qry->strategy_mode;
                  }
                  if(!empty($pair)) 
                  { 
                  
                  
                        $api_trade_data = array(
                        'trade_process_id' => $pair->id,
                        'uuserid' => $uusersid,
                        'type' => '1',
                        'status' => 0,
                        'exchange' => $exchange
                        );
                  
                         $last_call_drop_data = array(
                           'trade_process_id' => $pair->id,
                           'uuserid' => $uusersid,
                           'exchange' => $exchange
                         );
                  
                         $api_trade_data1 = array(
                           'trade_process_id' => $pair->id,
                           'uuserid' => $uusersid,
                           'type' => '2',
                           'description' => 'manual_sell',
                           'exchange' => $exchange,
                           'status' => 0
                         );
                  
                         $api_trade_data2 = array(
                           'trade_process_id' => $pair->id,
                           'uuserid' => $uusersid,
                           'type' => '1',
                           'status' => 0,
                           'exchange' => $exchange,
                           'margin_call_drops = ' => 0
                         );
                  
                  
                          $profit_where = array(
                             'uuserid' => $uusersid,
                             'type' => '3',
                             'trade_process_id' => $pair->id,
                             'exchange' => $exchange,
                             'status' => 0
                         );
                  
                  
                        if($pair->strategy_mode == 1)
                        {
                              $total_contract = $CI->table('api_trade_history')->selectSum('received_amount')->where($api_trade_data)->get()->getRow();
                              $total_usdt  = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data)->get()->getRow();
                              if($total_contract->received_amount && $total_usdt->quantity)
                                 $avg_position_amount = $total_usdt->quantity / $total_contract->received_amount;
                              else
                                 $avg_position_amount = 0;
                        }
                        else
                        {
                              if($pair->strategy_mode == 3) 
                              {
                     
                              $total_contract = $CI->table('api_trade_history')->selectSum('received_amount')->where($api_trade_data)->where('margin_call_drops <=',4)->get()->getRow();
                              $total_usdt = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data)->where('margin_call_drops <=',4)->get()->getRow();
                              if($total_contract->received_amount && $total_usdt->quantity)
                                 $avg_position_amount = $total_usdt->quantity / $total_contract->received_amount;
                              else
                                 $avg_position_amount = 0;
                           }else{
                              $total_contract = $CI->table('api_trade_history')->selectSum('received_amount')->where($api_trade_data)->where('margin_call_drops <=',4)->get()->getRow();
                              $total_usdt = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data)->where('margin_call_drops <=',4)->get()->getRow();
                              $total_contract2 = $CI->table('api_trade_history')->selectSum('received_amount')->where($profit_where)->get()->getRow();
                              $total_contract = $total_contract->received_amount + $total_contract2->received_amount;
                              $total_usdt2 =$CI->table('api_trade_history')->selectSum('quantity')->where($profit_where)->get()->getRow();
                              $total_usdt = $total_usdt->quantity + $total_usdt2->quantity;
                              if($total_contract && $total_usdt)
                                 $avg_position_amount = $total_usdt / $total_contract;
                              else
                                 $avg_position_amount = 0;
                           }
                     }
                  
                     $last_call_drop = $CI->table('api_trade_history')->where($last_call_drop_data)->orderBy('id','DESC')->get()->getRow();
                     $last_average = $avg_position_amount;
                     $avg_price = round($last_average,8) * $pair->whole_profit_ratio / 100;
                     $max_increase_price = $last_average + $avg_price ;
                     $max_increase_price = round($max_increase_price,8);
                     $max_down_percentage = $max_increase_price * $pair->whole_profit_callback / 100;
                     $max_down_price = $max_increase_price - $max_down_percentage;
                     $max_down_price = round($max_down_price,8);
                     if(intval($max_increase_price) > 999)
                        $max_increase_price = number_format($max_increase_price,2);
                     else
                        $max_increase_price = number_format($max_increase_price,8);
                                
                        if($last_call_drop->type == 2)
                              $max_increase_price = $last_call_drop->live_price + $price_down;
                        
                        $tradeupdate['take_profit_trigger'] = $max_increase_price ? "> ".$max_increase_price : "";
                        $trade_where_new = array(
                        'uuserid' => $uusersid,
                        'type' => '1',
                        'status' => 0,
                        'trade_process_id' => $pair->id,
                        );
                        
                        $last_buy_recheck = $CI->table('api_trade_history')->where($trade_where_new)->orderBy('margin_call_drops','DESC')->get()->getRow();
                        $last_margin_call_drop = $last_buy_recheck->margin_call_drops ? $last_buy_recheck->margin_call_drops : 0;
                        $call_perc = explode(',', $pair->margincall_drop)[$last_margin_call_drop];
                        $tradeupdate['margin_call_drops'] = $call_perc;
                              
                        if($last_call_drop->type == 1)
                           $price_down = $last_call_drop->live_price * $call_perc / 100;
                        else
                           $price_down = $last_call_drop->live_price * $pair->buyin_callback / 100;
                        
                        $down_price = $last_call_drop->live_price - $price_down;
                        
                        $tradeupdate['down_price']  = "< ".$down_price;
                        
                        $total_position_amount = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data)->get()->getRow();
                        
                        $total_sell_amount = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data1)->get()->getRow();
                        $total_position_amount->quantity = $total_position_amount->quantity - $total_sell_amount->quantity;
                        $tradeupdate['current_position_amount'] = $last_call_drop->quantity;
                        $total_position_quantity = $CI->table('api_trade_history')->selectSum('received_amount')->where($api_trade_data)->get()->getRow();
                        $total_sell_quantity = $CI->table('api_trade_history')->selectSum('received_amount')->where($api_trade_data1)->get()->getRow();
                        $total_position_quantity->received_amount = $total_position_quantity->received_amount - $total_sell_quantity->received_amount;
                        
                        if($total_position_amount->quantity > 0)
                        {
                           $tradeupdate['trade_position_amount'] = number_format($total_position_amount->quantity,5);  
                        } 
                        else 
                        {
                           $tradeupdate['trade_position_amount'] = 0.00;
                        }
                        
                        if($total_position_quantity->received_amount > 0) 
                        {
                              $tradeupdate['trade_position_quantity'] = number_format($total_position_quantity->received_amount,5);
                        }
                        else
                        {
                              $tradeupdate['trade_position_quantity'] = 0.00;
                        }
                                 
                           if ($avg_position_amount > 0) {
                           $tradeupdate['trade_avg_position'] = $avg_position_amount;
                           }else{
                           $tradeupdate['trade_avg_position'] = 0.00;
                           }
                        
                                 $call_drop = $CI->table('api_trade_history')->where($api_trade_data)->where('margin_call_drops !=',0)->orderBy('id','DESC')->get()->getRow();
                                 
                                 if(!empty($call_drop)){
                                    if($call_drop->margin_call_drops == $trade_process->margin_column_limit){
                                       $tradeupdate['down_price'] = "Limit Reached";
                                       $tradeupdate['margin_call_drops'] = "0";
                                    }
                              }
                        
                        
                                 
                              if(!empty($call_drop)){
                                 if ($call_drop->margin_call_drops != '' || $call_drop->margin_call_drops != '0') {
                                    $tradeupdate['trade_number_of_call'] = $call_drop->margin_call_drops;
                                 }else{
                                    $tradeupdate['trade_number_of_call'] = '0';
                                 }
                              }
                              else
                              {
                                 $tradeupdate['trade_number_of_call'] = '0';
                              }
                        
                                    $api_trade_data = array(
                                    'trade_process_id' => $pair->id,
                                    'uuserid' => $uusersid,
                                    'exchange' => $exchange,
                                    'type' => '1',
                                    );
                        
                                    $tradeupdate['live_price'] = $live_price;
                                 
                                    $check_percentage=0;
                                    if($avg_position_amount == 0 &&  $tradeupdate['trade_position_amount'] == 0){
                                    $check_percentage = '0';
                                    }
                        
                                    else if ($avg_position_amount > $live_price) {
                                    
                                    $check_percentage = ($avg_position_amount - $live_price);
                                    $check_percentage = $check_percentage  / $avg_position_amount;
                                    $check_percentage = $check_percentage  * 100 ;
                                    $check_percentage = '-'.number_format($check_percentage,2).'%';
                                    }elseif ($avg_position_amount == $live_price) {
                                    
                                    $check_percentage = '0';
                                    }else{
                                    
                                    $check_percentage = $live_price - $avg_position_amount;
                                    $check_percentage = $check_percentage  / $live_price;
                                    $check_percentage = $check_percentage  * 100 ;
                                    }
                        
                        
                                    $tradeupdate['trade_rate_percentage'] = $check_percentage;
                                   if ($avg_position_amount > $live_price) 
                                    {
                                       $check_percentage1 = ($avg_position_amount - $live_price) / $avg_position_amount;
                                       $check_percentage1 = $check_percentage1  * 100 ;
                                       $check_percentage1 = '-'.number_format($check_percentage1,2).'%';
                                    }
                                    elseif($avg_position_amount == $live_price) 
                                    {
                                       $check_percentage1 = '0.00';
                                    }
                                    else
                                    {
                                       $check_percentage1 = ($live_price - $avg_position_amount) / $live_price;
                                       $check_percentage1 = $check_percentage1  * 100 ;
                                    }
                        
                        
                              $tradeupdate['trade_estimate_price'] = $check_percentage1;
                                    
                        
                        $total_sell_amount = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data1)->get()->getRowArray();
                        
                        $total_position_amount1 = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data)->get()->getRowArray();
                        
                        $total_position_amount = $total_position_amount1['quantity'] - $total_sell_amount['quantity'];
                        $total_position_amount = number_format($total_position_amount,4);
                        
                        $tradeupdate['trade_remain_amount'] = $tradeupdate['trade_position_amount'];
                  
                     return $tradeupdate;
                  
                     }
                  }
                  
                  ?>
               <div class="dash-wrap">
                  <div class="title text-center py-1">
                     <h2 class="text-primary ">Trading Quantify</h2>
                  </div>


               
                  <?php



                  if($bind_api=='')
                  {
                     ?>
                         <div class="row justify-content-center mt-3">
                                 <div class="col-md-12 col-xl-12">
                                    <div class="card shadow-0 border rounded-3">
                                       <div class="card-body" style="margin:70px 0px;">
                                          <div class="row">
                                          <div  class="text-center mt-90 relative"><p class="text-base font-normal text-white mb-3"> Bind platform to continue trading </p>
                                             <a  href="<?php echo base_url();?>/apikeylist" class="btn btn-primary ">
                                             <p  class="text-white font-normal" style="margin-top:20px;"> Bind Platform </p></a>
                                          </div>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                        </div>
                     <?php 
                     
                  }
                  else
                  {
                     ?>


                     <?php 

                     $buy_bal=curbalance($uusersid);
                     $uusersid =$this->session->get("uusersid");
                     $activation =  $this->db->query("SELECT * FROM history WHERE type='activation' and uusersid='".$uusersid."' AND status='1'")->getRow();
                     if($activation)
                     {
                     $activation = true;
                     }
                     else
                     {
                     $activation = false;
                     }
                     $referral1=$this->db->query("SELECT * FROM bind_process WHERE uusersid='".$uusersid."'");
                     $ref=$referral1->getRow();
                     $usdt_balance='0';
                     $key = $ref->api_key;
                     $secret = $ref->secret_key;
                     $api = new Binance\API($key,$secret);
                     $ticker='';
                     $balances = $api->balances($ticker);     
                     if($balances)
                        $usdt_balance = $balances['USDT']['available'];
                     else
                        $usdt_balance='0';
                    
                        


                    

                     $get_pairs=$this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and trade_status!= 2 order by id asc")->getResult();
                     
                     $get_active=array();
                     foreach($get_pairs as $pair_infos)
                     {  
                        $pair_info_value[]=substr($pair_infos->pair,0, -4);
                        
                     }
                     if($pair_info_value!='')
                     {
                        $calculated_pairs=array_unique(array_merge($pair_info_value,$required_pairs), SORT_REGULAR);
                     }
                     else
                     {
                        $calculated_pairs=$required_pairs;
                     }
                     
                    
                     $i=0;
                    foreach ($calculated_pairs as $market_pair) 
                    {
                        $update_symbol = $market_pair . 'USDT';
                        $marketpair = $api->prevDay();
                        if(isset($marketpair['lastPrice']))
                        {
                           $output[$i]['symbol'] = $update_symbol;
                           $output[$i]['price'] = isset($marketpair['lastPrice']) ? $marketpair['lastPrice'] : null;
                           $output[$i]['change'] = isset($marketpair['priceChangePercent']) ? $marketpair['priceChangePercent'] : null;
                           
                        }
                        $i++;
                    }
                    
                       
                     $k = 0;
                     if($output)
                     {
                     foreach ($output as $key => $value) 
                     {
                        $output[$k] = $value;
                        $k++;
                     }
                     $output =  array_unique($output,SORT_REGULAR);
                     }
                     
                     $min_gas_required =$tradSet->min_fuel;
			         $min_gas_fee= $tradSet->min_fuel_fee;
                  
                  ?>

                  <div class="operation-content">
                 <h3 class="text-primary py-1">Balance Account USDT : <span id="balance_update"><?php echo number_format($usdt_balance,2);?></span> <i class="fa fa-refresh" id="balance_load" style="float:right;color:#fff;"></i> </h3>
                 </div>
                 <br>

                    <span class="left-label">Bound with Binance &nbsp; <i class="fa fa-check-circle"></i></span>

                  
                    <a href="" data-bs-toggle="modal" data-bs-target="#staticBackdrop1" data-bs-whatever="@fat" class="text-decoration-none"> <span class="right-label"><i class="fa fa-question-circle"></i> &nbsp;Trading Status</span> </a>
                    <div syle="clear:both"><br></div>



                    <div class="modal fade" id="staticBackdrop1" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" style="display: none;" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" role="document">
<div class="modal-content" style="border-radius:30px;padding: 11px;" >

<div class="modal-header" style="padding-top: 11px;margin-bottom:-15px;">
<p class="modal-title" id="staticBackdropLabel" style="padding-left:170px;"><b>Trading Status Info</b></p>
<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

</div>

<div class="modal-body" style="height:400px;overflow-y:scroll;">

<div class="row col-lg-12 mt-3">
<div class="form-check form-check-right mb-3" style="font-size: 14px;">
   <lable class="btn btn-default"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>
   <h5>Bot Is on Trading</h5>
   <p>Indicates that the trading bot is currently active and executing trades.</p>
   <hr>

   <lable class="btn btn-default"><i class="fa fa-pause blue"></i> <span class="blue"> Pause </span></lable>
   <h5>Pause Trade</h5>
   <p>Trading activities are temprorarily halted or paused.</p>
   <hr>


   <lable class="btn btn-default"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>
   <h5>Insufficent USDT</h5>
   <p>There is not enough USDT(Tether) available on the exchange platform  to carry out the desired transaction.</p>
   <hr>



   <lable class="btn btn-default"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>
   <h5>Insufficent Gas Fuel</h5>
   <p>There is an inadequate amount of fuel available in the bot gas wallet, needed for top up fuel for transaction fees.</p>
   <hr>

   <lable class="btn btn-default"><i class="fa fa-warning orange"></i> <span class="orange"> Coin </span></lable>
   <h5>Coin</h5>
   <p>There isn't enough of a specific cryptocurrency  or token available on the exchange platform intended transaction</p>
   <hr>

 
 <lable class="btn btn-default"><i class="fa fa-warning orange"></i> <span class="orange"> Robot</span></lable>
 <h5>Robot Expired</h5>
 <p>The automated trading robot has reached its expiration date and is no longer functional.</p>
 <hr>

 <lable class="btn btn-default"><i class="fa fa-warning orange"></i> <span class="orange">API Key</span></lable>
 <h5> API key is invalid/expired </h5>
 <p>The API key used unable to  access on trading functionalitie.</p>
 <hr>

 <lable class="btn btn-default"><i class="fa fa-times-circle red"></i> <span class="red">Cover</span></lable>
 <h5> Failed to cover </h5>
 <p>The attempt to execute a cover action, likely realted to risk management or position protection, was unsuccessful.</p>
 <hr>

 <lable class="btn btn-default"><i class="fa fa-times-circle red"></i> <span class="red">Liquidation</span></lable>
 <h5> Failed Liquidate</h5>
 <p>The attempt to liquidate assets selling them off, was unsuccessful.</p>
 <hr>


</div>
</div>

</div>

</div>
</div>
</div>

 

                  <div class="team-tab">
                     <ul class="nav sam d-flex justify-content-center ps-0" id="pills-tab" role="tablist">
                        <li class="nav-item" role="presentation">
                           <button class="nav-link active" id="pills-dep2-tab " data-bs-toggle="pill" data-bs-target="#pills-dep2"
                              type="button" role="tab" aria-controls="pills-dep2" aria-selected="true">
                              <div class="make-list">
                                 <div class="process">
                                    <span>All</span>
                                 </div>
                              </div>
                           </button>
                        </li>
                        <li class="nav-item" role="presentation">
                           <button class="nav-link" id="pills-dep3-tab " data-bs-toggle="pill" data-bs-target="#pills-dep3"
                              type="button" role="tab" aria-controls="pills-dep3" aria-selected="true">
                              <div class="make-list">
                                 <div class="process">
                                    <span>Single</span>
                                 </div>
                              </div>
                           </button>
                        </li>
                        <li class="nav-item" role="presentation">
                           <button class="nav-link" id="pills-dep4-tab " data-bs-toggle="pill" data-bs-target="#pills-dep4"
                              type="button" role="tab" aria-controls="pills-dep4" aria-selected="true">
                              <div class="make-list">
                                 <div class="process">
                                    <span>Cycle</span>
                                 </div>
                              </div>
                           </button>
                        </li>
                     </ul>
                     <div class="tab-content" id="pills-tabContent">
                        <div class="tab-pane fade show active  " id="pills-dep2" role="tabpanel" aria-labelledby="pills-dep2-tab">
                           <div class="search-bar my-2">
                              <form class="form-inline my-2 my-lg-0">
                                 <input class="form-control mr-sm-2"  onkeyup="myFunction()" id="myFilter" type="search" placeholder="Search...." aria-label="Search">
                              </form>
                           </div>

                           <div class="row justify-content-center mb-3" id="myItems">
                           <div class="col-md-12 col-xl-12">
                           <?php
                       
                              if($output)
                              {
                               foreach ($output as $key => $value) 
                               {
                                   $symbol = formatTradingPair($value['symbol']);
                                   $live_price = $value['price'];
                                   $tradeupdate='';
                                   if($value['symbol']!='')
                                   {
                                    $tradeupdate=get_tradeinfo($value['symbol'],$live_price,$uusersid);
                                   }
                                   $pair =$this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and pair='".$value['symbol']."' and trade_status!= 2 and exchange='".$exchange."' order by id desc")->getRow();

                                    ?>
                          
                            
                                 <div class="card shadow-0 border rounded-3 mt-3">
                                    <div class="card-body">
                                       <div class="row">
                                          <div class="col-md-12 col-lg-2 col-xl-2 mb-4 mb-lg-0">
                                             <div class="bg-image hover-zoom ripple rounded ripple-surface">
                                                <img src="<?php echo base_url('styles/images/tradingpair_images/'.$value['symbol'].'.png');?>"
                                                   style="width:65px;" />
                                                <a href="#!">
                                                   <div class="hover-overlay">
                                                      <div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div>
                                                   </div>
                                                </a>
                                             </div>
                                          </div>
                                          <div class="col-md-6 col-lg-6 col-xl-6">
                                             <h5 style="color:#fff;" class="card-title"><?php echo $value['symbol'];?> 
                                             <?php 
                                             if(!empty($pair)) 
                                             {
                                                
                                                if($pair->trade_status==1)
                                                {
                                                   $gas_balance = gas_wallet_bal($uusersid);
                                                   
									               if($gas_balance>=$min_gas_required)
                                                  {
                                                         $api_trade_datas = array(
                                                            'trade_log' => '1',
                                                            'trade_status' => '1'
                                                            
                                                           );
                                                         $trade_update = $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                                   ?>
                                                   <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>
                                                      <?php
                                                      }
                                                      else
                                                      {
                                                         $api_trade_datas = array(
                                                            'trade_log' => '2',
                                                            'trade_status' => '0'
                                                            
                                                           );
                                                         $trade_update = $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();

                                                         ?>
                                                        <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>
                                                         
                                                         <?php
                                                         }

                                                }
                                                else
                                                {
                                                   if($pair->trade_log=='1')
                                                   {
                                                   ?>
                                                   <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-pause blue"></i> <span class="blue"> Pause </span></lable>
                                                   <?php 
                                                   }
                                                   else
                                                   {
                                                        $gas_balance = gas_wallet_bal($uusersid);
                                                        
                                                          if($gas_balance>=$min_gas_required)
                                                            {
                                                         $api_trade_datas = array(
                                                            'trade_log' => '1',
                                                            'trade_status' => '1'
                                                            
                                                           );
                                                         $trade_update = $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                                            }
                                                        
                                                      ?>
                                                       <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> fuel </span></lable>
                                                      <?php 

                                                   }
                                                }
                                             }
                                          ?>
                                          <br>
                                          </h5> 
                                             <div class="mt-1 mb-0 text-muted small">
                                                <span  class="text-primary"> • No.of Margin call : <?php if(!empty($tradeupdate['trade_number_of_call'])) { echo $tradeupdate['trade_number_of_call']; } else { echo 0; }?></span>
                                                <br>
                                                <span  class="text-primary"> • Filled Amount (USDT) : <?php if(!empty($tradeupdate['trade_position_amount'])) { echo $tradeupdate['trade_position_amount']; } else echo 0;?></span>
                                             </div>
                                             <hr>
                                             <div class="mb-2 text-muted small">
                                                <span  class="text-primary"> • Position Quantity: <?php if(!empty($tradeupdate['trade_position_quantity'])) { echo $tradeupdate['trade_position_quantity']; } else { echo 0;}?></span>
                                                <br>
                                                <span  class="text-primary"> • Current Price : <?php echo $live_price;?></span>
                                                <br>
                                                <span  class="text-primary"> • Average Price : <?php if(!empty($tradeupdate['trade_avg_position'])) { echo number_format($tradeupdate['trade_avg_position'],8); } else { echo 0; };?></span>
                                                <br>
                                             </div>
                                          </div>
                                          <div class="col-md-6 col-lg-4 col-xl-4 border-sm-start-none border-start">
                                             <div class="d-flex flex-row align-items-center mb-1">
                                                <?php 
                                                   if(!empty($tradeupdate['trade_rate_percentage']))
                                                   {
                                                      $trade_percentage=$tradeupdate['trade_rate_percentage'];
                                                   }
                                                   else
                                                   {
                                                      $trade_percentage='0';
                                                   }
                                                    
                                                   if($trade_percentage=='')
                                                      $trade_percentage='0';
                                                   
                                                   ?>
                                                <h6 class="mb-1 me-1 text-white">
                                                Rate of Return : <label class="text-whit"><?php echo $trade_percentage;?></label></h4>
                                             </div>
                                             <div class="d-flex flex-column mt-4">
                                                <?php
                                                   if(!empty($pair)) 
                                                   {
                                                      
                                                   if($pair->trade_status == 0) 
                                                   {
                                                      ?>
                                                <button data-mdb-button-init data-mdb-ripple-init class="btn btn-success btn-sm mt-2" id="start_button" Onclick="start_button('<?php echo $value['symbol'];?>');" type="button">
                                                Resume
                                                </button>
                                                <?php 
                                                   }
                                                   else if($pair->trade_status==1)
                                                   {
                                                      ?>
                                                <button data-mdb-button-init data-mdb-ripple-init class="btn btn-warning btn-sm mt-2" type="button" style="color:#fff;" Onclick="pause_button('<?php echo $value['symbol'];?>');">
                                                Pause
                                                </button>
                                                <?php
                                                   }
                                                   else if($pair->trade_status == 2)
                                                   {
                                                      ?>
                                             
                                                <?php 
                                                   } 
                                                   
                                                   if($pair->trade_status == 0 || $pair->trade_status == 1)
                                                   {
                                                      ?>
                                                <button data-mdb-button-init data-mdb-ripple-init class="btn btn-danger btn-sm mt-2" type="button" style="color:#fff;" Onclick="stop_button('<?php echo $value['symbol'];?>');">
                                                Stop
                                                </button>
                                                <?php 
                                                   } 
                                                   
                                                   
                                                   }
                                                   else
                                                   { 
                                                   ?>
                                               
                                                <?php
                                                   }
                                                   ?>
                                                <button class="btn btn-primary btn-sm mt-2" type="button" style="color:#fff;" onclick="view_trade('<?php echo $value['symbol'];?>');">View Trade</button>
                                                <!--<button data-mdb-button-init data-mdb-ripple-init class="btn btn-primary btn-sm" type="button">Details</button>
                                                   <button data-mdb-button-init data-mdb-ripple-init class="btn btn-outline-primary btn-sm mt-2" type="button">
                                                   Add to wishlist
                                                   </button>-->
                                             </div>
                                          </div>
                                       </div>
                                    </div>
                                    </div>
                         
                           <?php 
                              }
                              
                              
                              }
                              
                              ?>
                                
                                 </div>

                           </div>
                        </div>
                        <div class="tab-pane fade" id="pills-dep3" role="tabpanel" aria-labelledby="pills-dep3-tab">
                           <div class="search-bar my-2">
                              <form class="form-inline my-2 my-lg-0">
                                 <input class="form-control mr-sm-2" onkeyup="myFunction1()" id="myFilter1" type="search" placeholder="Search...." aria-label="Search">
                              </form>
                           </div>

                           <div class="row justify-content-center mb-3" id="myItems1">
                           <div class="col-md-12 col-xl-12">
                           <?php 
                              $sno=0;
                              $pair =$this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and trade_status!= '2' order by id desc")->getResult();
                              $j=0;
                              if($output)
                              {
                                 foreach ($output as $key => $value) {
                                    foreach($pair as $key => $value1){
                                    if($value['symbol'] == $value1->pair){
                                          $output3[$j] = $value;
                                    }
                                    }
                                    $j++;
                                    }
                                   
                              
                              }
                              if(!empty($output3))
                              {
                                    foreach ($output3 as $key => $value) 
                                    {
                                       $pair =$this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and pair='".$value['symbol']."' and trade_status!= 2 order by id desc")->getRow();
                                       if(!empty($pair))
                                       {
                                          $sync_strategy_status = $pair->sync_strategy_status ? $pair->sync_strategy_status : 0;
                                          $manual_buy = $this->db->table('api_manual_trade')->where('trade_process_id',$pair->id)->where('type',1)->where('status','1')->get()->getRow();
                                          $manual_sell = $this->db->table('api_manual_trade')->where('trade_process_id',$pair->id)->where('type',2)->where('status','1')->get()->getRow();
                                          $pair_trade_status=$pair->trade_status;
                                       }
                                       else
                                       {
                                          $sync_strategy_status='0';
                                          $pair_trade_status='';
                                       }
                              
                                       $live_price = $value['price'];
                                       
                                       $tradeupdate='';
                                       if($value['symbol']!='')
                                       {
                                        $tradeupdate=get_tradeinfo($value['symbol'],$live_price,$uusersid);
                                       }
                              
                                     ?>
                         
                                 <div class="card shadow-0 border rounded-3">
                                    <div class="card-body">
                                       <div class="row">
                                          <div class="col-md-12 col-lg-2 col-xl-2 mb-4 mb-lg-0">
                                             <div class="bg-image hover-zoom ripple rounded ripple-surface">
                                                <img src="<?php echo base_url('styles/images/tradingpair_images/'.$value['symbol'].'.png');?>"
                                                   style="width:65px;" />
                                                <a href="#!">
                                                   <div class="hover-overlay">
                                                      <div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div>
                                                   </div>
                                                </a>
                                             </div>
                                          </div>
                                          <div class="col-md-6 col-lg-6 col-xl-6">
                                             <h5 style="color:#fff;" class="card-title"><?php echo $value['symbol'];?>
                                             
                                             <?php 
                                             if(!empty($pair)) 
                                             {
                                                
                                                if($pair->trade_status==1)
                                                {
                                                   $gas_balance = gas_wallet_bal($uusersid);
                                                   
									               if($gas_balance>=$min_gas_required)
                                                  {
                                                         $api_trade_datas = array(
                                                            'trade_log' => '1',
                                                            'trade_status' => '1'
                                                            
                                                           );
                                                         $trade_update = $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                                   ?>
                                                   <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>
                                                      <?php
                                                      }
                                                      else
                                                      {
                                                         $api_trade_datas = array(
                                                            'trade_log' => '2',
                                                            'trade_status' => '0'
                                                            
                                                           );
                                                         $trade_update = $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();

                                                         ?>
                                                        <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>
                                                         
                                                         <?php
                                                         }

                                                }
                                                else
                                                {
                                                   if($pair->trade_log=='1')
                                                   {
                                                   ?>
                                                   <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-pause blue"></i> <span class="blue"> Pause </span></lable>
                                                   <?php 
                                                   }
                                                   else
                                                   {
                                                        $gas_balance = gas_wallet_bal($uusersid);
                                                          if($gas_balance>=$min_gas_required)
                                                            {
                                                         $api_trade_datas = array(
                                                            'trade_log' => '1',
                                                            'trade_status' => '1'
                                                            
                                                           );
                                                         $trade_update = $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                                            }
                                                        
                                                      ?>
                                                       <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> fuel </span></lable>
                                                      <?php 

                                                   }
                                                }
                                             }
                                          ?>
                                          <br>
                                             </h5>
                                             <div class="mt-1 mb-0 text-muted small">
                                                <span  class="text-primary"> • No.of Margin call : <?php if(!empty($tradeupdate['trade_number_of_call'])) { echo $tradeupdate['trade_number_of_call']; } else { echo 0; }?></span>
                                                <br>
                                                <span  class="text-primary"> • Filled Amount (USDT) : <?php if(!empty($tradeupdate['trade_position_amount'])) { echo $tradeupdate['trade_position_amount']; } else echo 0;?></span>
                                             </div>
                                             <hr>
                                             <div class="mb-2 text-muted small">
                                                <span  class="text-primary"> • Position Quantity: <?php if(!empty($tradeupdate['trade_position_quantity'])) { echo $tradeupdate['trade_position_quantity']; } else { echo 0;}?></span>
                                                <br>
                                                <span  class="text-primary"> • Current Price : <?php echo $live_price;?></span>
                                                <br>
                                                <span  class="text-primary"> • Average Price : <?php if(!empty($tradeupdate['trade_avg_position'])) { echo number_format($tradeupdate['trade_avg_position'],8); } else { echo 0; };?></span>
                                                <br>
                                             </div>
                                          </div>
                                          <div class="col-md-6 col-lg-4 col-xl-4 border-sm-start-none border-start">
                                             <div class="d-flex flex-row align-items-center mb-1">
                                                <?php 
                                                   if(!empty($tradeupdate['trade_rate_percentage']))
                                                   {
                                                      $trade_percentage=$tradeupdate['trade_rate_percentage'];
                                                   }
                                                   else
                                                   {
                                                      $trade_percentage='0';
                                                   }
                                                   
                                                   ?>
                                                <h6 class="mb-1 me-1 text-white">
                                                Rate of Return : <label class="text-whit"><?php echo $trade_percentage;?></label></h4>
                                             </div>
                                             <div class="d-flex flex-column mt-4">
                                                <?php
                                                   if(!empty($pair)) 
                                                   {
                                                      
                                                   if($pair->trade_status == 0) 
                                                   {
                                                      ?>
                                                <button data-mdb-button-init data-mdb-ripple-init class="btn btn-success btn-sm mt-2" id="start_button" Onclick="start_button('<?php echo $value['symbol'];?>');" type="button">
                                                Resume
                                                </button>
                                                <?php 
                                                   }
                                                   else if($pair->trade_status==1)
                                                   {
                                                      ?>
                                                <button data-mdb-button-init data-mdb-ripple-init class="btn btn-warning btn-sm mt-2" type="button" style="color:#fff;" Onclick="pause_button('<?php echo $value['symbol'];?>');">
                                                Pause
                                                </button>
                                                <?php
                                                   }
                                                   else if($pair->trade_status == 2)
                                                   {
                                                      ?>
                                             
                                                <?php 
                                                   } 
                                                   
                                                   if($pair->trade_status == 0 || $pair->trade_status == 1)
                                                   {
                                                      ?>
                                                <button data-mdb-button-init data-mdb-ripple-init class="btn btn-danger btn-sm mt-2" type="button" style="color:#fff;" Onclick="stop_button('<?php echo $value['symbol'];?>');">
                                                Stop
                                                </button>
                                                <?php 
                                                   } 
                                                   
                                                   
                                                   }
                                                   else
                                                   { 
                                                   ?>
                                             
                                                <?php
                                                   }
                                                   ?>
                                                <button class="btn btn-primary btn-sm mt-2" type="button" style="color:#fff;" onclick="view_trade('<?php echo $value['symbol'];?>');">View Trade</button>
                                             </div>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                          
                           <?php 
                              }
                              }
                              
                              ?>

                           </div>
                           </div>
                        </div>
                        <div class="tab-pane fade" id="pills-dep4" role="tabpanel" aria-labelledby="pills-dep4-tab">
                           <div class="search-bar my-2">
                              <form class="form-inline my-2 my-lg-0">
                                 <input class="form-control mr-sm-2" onkeyup="myFunction2()" id="myFilter2"  type="search" placeholder="Search...." aria-label="Search">
                              </form>

                              <div class="row justify-content-center mb-3" id="myItems2">
                              <div class="col-md-12 col-xl-12">
                              <?php 
                                 $sno=0;
                                $pair =$this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and trade_status!= 2 order by id desc")->getResult();
                              
                                $j=0;
                                 if($output)
                                 {
                                    foreach ($output as $key => $value) 
                                    {
                                       
                                       foreach($pair as $key => $value1)
                                       {
                                          if($value['symbol'] == $value1->pair)
                                          {
                                             $output4[$j] = $value;
                                          }
                                       }
                                       
                                       $j++;
                                    }
                                     
                                 
                                 }

                                 
                                 if(!empty($output4))
                                 {
                                       foreach ($output4 as $key => $value) 
                                       {
                                          $pair =$this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and pair='".$value['symbol']."' and trade_status!= 2 order by id desc")->getRow();
                                          if(!empty($pair))
                                          {
                                             $sync_strategy_status = $pair->sync_strategy_status ? $pair->sync_strategy_status : 0;
                                             $manual_buy = $this->db->table('api_manual_trade')->where('trade_process_id',$pair->id)->where('type',1)->where('status','1')->get()->getRow();
                                             $manual_sell = $this->db->table('api_manual_trade')->where('trade_process_id',$pair->id)->where('type',2)->where('status','1')->get()->getRow();
                                             $pair_trade_status=$pair->trade_status;
                                          }
                                          else
                                          {
                                             $sync_strategy_status='0';
                                             $pair_trade_status='';
                                          }
                                 
                                          $live_price = $value['price'];
                                          $tradeupdate='';
                                        if($value['symbol']!='')
                                        {
                                          $tradeupdate=get_tradeinfo($value['symbol'],$live_price,$uusersid);
                                        }
                                 
                                 
                                    ?>
                            
                                    <div class="card shadow-0 border rounded-3">
                                       <div class="card-body">
                                          <div class="row">
                                             <div class="col-md-12 col-lg-2 col-xl-2 mb-4 mb-lg-0">
                                                <div class="bg-image hover-zoom ripple rounded ripple-surface">
                                                   <img src="<?php echo base_url('styles/images/tradingpair_images/'.$value['symbol'].'.png');?>"
                                                      style="width:65px;" />
                                                   <a href="#!">
                                                      <div class="hover-overlay">
                                                         <div class="mask" style="background-color: rgba(253, 253, 253, 0.15);"></div>
                                                      </div>
                                                   </a>
                                                </div>
                                             </div>
                                             <div class="col-md-6 col-lg-6 col-xl-6">
                                                <h5 style="color:#fff;" class="card-title"><?php echo $value['symbol'];?><?php 
                                             if(!empty($pair)) 
                                             {
                                                
                                                if($pair->trade_status==1)
                                                {
                                                   $gas_balance = gas_wallet_bal($uusersid);
                                                   
									               if($gas_balance>=$min_gas_required)
                                                  {
                                                         $api_trade_datas = array(
                                                            'trade_log' => '1',
                                                            'trade_status' => '1'
                                                            
                                                           );
                                                         $trade_update = $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                                   ?>
                                                   <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>
                                                      <?php
                                                      }
                                                      else
                                                      {
                                                         $api_trade_datas = array(
                                                            'trade_log' => '2',
                                                            'trade_status' => '0'
                                                            
                                                           );
                                                         $trade_update = $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();

                                                         ?>
                                                        <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>
                                                         
                                                         <?php
                                                         }

                                                }
                                                else
                                                {
                                                   if($pair->trade_log=='1')
                                                   {
                                                   ?>
                                                   <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-pause blue"></i> <span class="blue"> Pause </span></lable>
                                                   <?php 
                                                   }
                                                   else
                                                   {
                                                        $gas_balance = gas_wallet_bal($uusersid);
                                                          if($gas_balance>=$min_gas_required)
                                                            {
                                                         $api_trade_datas = array(
                                                            'trade_log' => '1',
                                                            'trade_status' => '1'
                                                            
                                                           );
                                                         $trade_update = $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                                            }
                                                        
                                                      ?>
                                                       <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> fuel </span></lable>
                                                      <?php 

                                                   }
                                                }
                                             }
                                          ?>
                                          <br></h5>
                                                <div class="mt-1 mb-0 text-muted small">
                                                   <span  class="text-primary"> • No.of Margin call : <?php if(!empty($tradeupdate['trade_number_of_call'])) { echo $tradeupdate['trade_number_of_call']; } else { echo 0; }?></span>
                                                   <br>
                                                   <span  class="text-primary"> • Filled Amount (USDT) : <?php if(!empty($tradeupdate['trade_position_amount'])) { echo $tradeupdate['trade_position_amount']; } else echo 0;?></span>
                                                </div>
                                                <hr>
                                                <div class="mb-2 text-muted small">
                                                   <span  class="text-primary"> • Position Quantity: <?php if(!empty($tradeupdate['trade_position_quantity'])) { echo $tradeupdate['trade_position_quantity']; } else { echo 0;}?></span>
                                                   <br>
                                                   <span  class="text-primary"> • Current Price : <?php echo $live_price;?></span>
                                                   <br>
                                                   <span  class="text-primary"> • Average Price : <?php if(!empty($tradeupdate['trade_avg_position'])) { echo number_format($tradeupdate['trade_avg_position'],8); } else { echo 0; };?></span>
                                                   <br>
                                                </div>
                                             </div>
                                             <div class="col-md-6 col-lg-4 col-xl-4 border-sm-start-none border-start">
                                                <div class="d-flex flex-row align-items-center mb-1">
                                                   <?php 
                                                      if(!empty($tradeupdate['trade_rate_percentage']))
                                                      {
                                                         $trade_percentage=$tradeupdate['trade_rate_percentage'];
                                                      }
                                                      else
                                                      {
                                                         $trade_percentage='0';
                                                      }
                                                   ?>
                                                   <h6 class="mb-1 me-1 text-white">
                                                   Rate of Return : <label class="text-whit"><?php echo $trade_percentage;?></label></h4>
                                                </div>
                                                <div class="d-flex flex-column mt-4">
                                                   <?php
                                                      if(!empty($pair)) 
                                                      {
                                                         
                                                      if($pair->trade_status == 0) 
                                                      {
                                                         ?>
                                                   <button data-mdb-button-init data-mdb-ripple-init class="btn btn-success btn-sm mt-2" id="start_button" Onclick="start_button('<?php echo $value['symbol'];?>');" type="button">
                                                   Resume
                                                   </button>
                                                   <?php 
                                                      }
                                                      else if($pair->trade_status==1)
                                                      {
                                                         ?>
                                                   <button data-mdb-button-init data-mdb-ripple-init class="btn btn-warning btn-sm mt-2" type="button" style="color:#fff;" Onclick="pause_button('<?php echo $value['symbol'];?>');">
                                                   Pause
                                                   </button>
                                                   <?php
                                                      }
                                                      else if($pair->trade_status == 2)
                                                      {
                                                         ?>
                                                  
                                                   <?php 
                                                      } 
                                                      
                                                      if($pair->trade_status == 0 || $pair->trade_status == 1)
                                                      {
                                                         ?>
                                                   <button data-mdb-button-init data-mdb-ripple-init class="btn btn-danger btn-sm mt-2" type="button" style="color:#fff;" Onclick="stop_button('<?php echo $value['symbol'];?>');">
                                                   Stop
                                                   </button>
                                                   <?php 
                                                      } 
                                                      
                                                      
                                                      }
                                                      else
                                                      { 
                                                      ?>
                                                  
                                                   <?php
                                                      }
                                                      ?>
                                                   <button class="btn btn-primary btn-sm mt-2" type="button" style="color:#fff;" onclick="view_trade('<?php echo $value['symbol'];?>');">View Trade</button>
                                                </div>
                                             </div>
                                          </div>
                                       </div>
                                    </div>
                             
                              <?php 
                                 }
                                 }
                                 ?>
                                     </div>
                                     </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <?php 
                  }
                  ?>
               </div>
            </div>

         
            <?php echo view('user/layout/footer');?>
         </div>
      </section>
      <?php echo view('user/layout/footer-script');?>
      <script src="<?php echo base_url();?>/styles/new_style/js/notify.js"></script>
      <script type="text/javascript">
         function view_trade(str)
         {
           window.location="<?php echo base_url();?>/tradedetails/"+str;
         }
         
         function myFunction() {
    var input, filter, cards, cardContainer, h5, title, i;
    input = document.getElementById("myFilter");
    filter = input.value.toUpperCase();
    cardContainer = document.getElementById("myItems");
    cards = cardContainer.getElementsByClassName("card");
    for (i = 0; i < cards.length; i++) {
        title = cards[i].querySelector(".card-body h5.card-title");
        if (title.innerText.toUpperCase().indexOf(filter) > -1) {
            cards[i].style.display = "";
        } else {
            cards[i].style.display = "none";
        }
    }
}

function myFunction1() {
    var input, filter, cards, cardContainer, h5, title, i;
    input = document.getElementById("myFilter1");
    filter = input.value.toUpperCase();
    cardContainer = document.getElementById("myItems1");
    cards = cardContainer.getElementsByClassName("card");
    for (i = 0; i < cards.length; i++) {
        title = cards[i].querySelector(".card-body h5.card-title");
        if (title.innerText.toUpperCase().indexOf(filter) > -1) {
            cards[i].style.display = "";
        } else {
            cards[i].style.display = "none";
        }
    }
}


function myFunction2() {
 
    var input, filter, cards, cardContainer, h5, title, i;
    input = document.getElementById("myFilter2");
    filter = input.value.toUpperCase();
    cardContainer = document.getElementById("myItems2");
    cards = cardContainer.getElementsByClassName("card");
    for (i = 0; i < cards.length; i++) {
        title = cards[i].querySelector(".card-body h5.card-title");
        if (title.innerText.toUpperCase().indexOf(filter) > -1) {
            cards[i].style.display = "";
        } else {
            cards[i].style.display = "none";
        }
    }
}
      </script>
      <script type="text/javascript">
          function start_button(str)
         {
            var avaialabe_fuel_fee     =  '<?php echo $buy_bal ? $buy_bal : 0;?>';
            var fuel_fee               = '<?php echo $tradSet->min_fuel_fee ? $tradSet->min_fuel_fee : 0 ;?>';
            var activate               = '<?php echo $activation ? $activation : 0; ?>';
            var usdt_balance = '<?php echo $usdt_balance ? $usdt_balance : 0 ;?>';
            var uusersid='<?php echo $this->session->get('uusersid');?>';
            var first_order_amount='<?php echo $first_buy_amount;?>';
            if(activate)
            {
               if(parseFloat(avaialabe_fuel_fee.replace(',','')) > parseFloat(fuel_fee) )
               {
         
                     if(<?php echo $bind_api ? $bind_api : 0;?>)
                     {
                        $.notify(' <i class="fas fa-check-circle"></i>  Please wait.', 'success'); 
         
                           $.ajax({
                           'method': 'POST',
                           'url': '<?php echo base_url("/tradingprocess");?>',
                              data:{'id':str,'uusersid':uusersid,'uri':str,'pair':str },
                           success:function(msg)
                           {
                              $.notify(' <i class="fas fa-check-circle"></i>  Trade started successfully', 'success'); 
                              window.location.reload();
                           }
                        })
                     }
                     else
                     {
                        $.notify(' <i class="fas fa-exclamation-triangle"></i>  Please bind your api to start the trade. ', 'danger');
                     }
         
               }
               else
               {
                  
                   $.notify(' <i class="fas fa-exclamation-triangle"></i>  Please recharge fuel. ', 'danger');
               }
            }
            else
            {
               $.notify(' <i class="fas fa-exclamation-triangle"></i>  Please activate the robot first ', 'danger');
            }    
         
         }
         
         function pause_button(str)
         {
            var uusersid='<?php echo $this->session->get('uusersid');?>';
            $.ajax({
            'method': 'POST',
            'url': '<?php echo base_url("/tradingprocess1");?>',
               data:{'id':str,'uusersid':uusersid,'uri':str },
            success:function(msg)
            {
               $.notify(' <i class="fas fa-check-circle"></i>  Trade paused successfully', 'success'); 
               window.location.reload();
            }
            })
         
         }
         
         function stop_button(str)
         {
            var pair_id="<?php if(!empty($pair)){ echo $pair->id;}?>";
            var uusersid='<?php echo $this->session->get('uusersid');?>';
            $.ajax({
            'method': 'POST',
            'url': '<?php echo base_url("/tradingprocess2");?>',
               data:{'id':str,'uusersid':uusersid,'uri':str,'pair':pair_id,'exchange':'1' },
            success:function(msg)
            {
               $.notify(' <i class="fas fa-check-circle"></i>  Trade stopped successfully', 'success'); 
               // console.log(msg);
               window.location.reload();
            }
            })
         
         }

         
      document.getElementById('balance_load').addEventListener('click', function() {

   
this.classList.add('spin');
read_function();
setTimeout(() => {

  this.classList.remove('spin');
}, 1000); // Duration of the animation in milliseconds
});


         function read_function()
         {
            var uusersid='<?php echo $this->session->get('uusersid');?>';
            var exchange_id='<?php echo $exchange;?>';
            $.ajax({
            'method': 'POST',
            'url': '<?php echo base_url("/balance_update");?>',
               data:{'exchange':exchange_id,'uusersid':uusersid},
            success:function(msg)
            {
               $("#balance_update").html(msg);
            }
            })
         }
         
         
      </script>

   </body>
</html>
