<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php $this->load->view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/tables/datatables/datatables.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/tables/datatables/extensions/responsive.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/forms/selects/select2.min.js"></script>

	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/app.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/pages/datatables_responsive.js"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/jgrowl.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/sweet_alert.min.js"></script>

</head>
<style>
.icons-list > li {
    display: inline-block;
    font-size: 26px;
    }
    .heading-elements .icons-list {
    margin-top: 5px;
}
</style>
<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">
		<!-- Main navbar -->
		<?php $this->load->view('admin/mainnav'); ?>
		<!-- /main navbar -->
		<!-- Second navbar -->
		<?php $this->load->view('admin/secondnav'); ?>
		<!-- /second navbar -->
	</div>
	<!-- /fixed navbars wrapper -->
	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left" id="icon-bck"></i> <span class="text-semibold"><?php echo $this->lang->line('menu_addr_settings'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $this->lang->line('menu_addr_settings'); ?></li><?php } } ?>
				</ul>
			</div>
			<?php $this->load->view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->
	<!-- Page container -->
	<div class="page-container">
		<!-- Page content -->
		<div class="page-content">
			<!-- Main content -->
			<div class="content-wrapper">
				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo $this->lang->line('menu_addr_settings'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><label style="padding:5px;background-color:#eee;border:1px solid #ccc;"><a href="<?php echo base_url();?>admin/addrsettings/add" class="icon-plus-circle2">  Import Address </a>  </label> </li>
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>

					<table class="table datatable-responsive-row-control table-hover">
						<col width="20%">
  						<col width="20%">
  						<col width="20%">
  						<col width="20%">
  						
						<thead>
							<tr>
								<th></th>
								<th class="text-center"><?php echo $this->lang->line('label_payaddress');?></th>
								<th class="text-center"><?php echo $this->lang->line('label_payaddr_name');?></th>
								<th class="text-center"><?php echo $this->lang->line('label_payaddr_status');?></th>
								<th class="text-center"><?php echo $this->lang->line('lbl_action');?></th>
							</tr>
						</thead>
						<tbody>
						<?php 
							if($pay_address) {
								
								$this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt;
								foreach ($pay_address as $row) {
									
									if($row->status=='1'){
										$label_status = 'label-success';
										$status = $this->lang->line('available');
									}
									else if($row->status=='2'){
										$label_status = 'label-assign';
										$status = $this->lang->line('assign');
									}
									else if($row->status=='3'){
										$label_status = 'label-paid';
										$status = $this->lang->line('paid');
									}

									 else {
										$label_status = 'label-danger';
										$status = $this->lang->line('unavailable');
									}
									
							?>
							<tr>
							<td></td>
								<td class="text-center"><a href="http://etherscan.io/address/<?php echo $row->payment_value;?>" target="_blank"><?php echo ucfirst($row->payment_value); ?></a></td>
								<td class="text-center"><?php echo ucfirst($row->payment_name); ?></td>
								<td class="text-center"><span class="label <?php echo $label_status; ?>"><?php echo $status;?></span></td>
								<td class="text-center">
								<?php
									if($row->status=='1'){
								?>
								<a onclick="confirmdelete('<?php echo $myencrypt->encode($row->pid);?>')" href="javascript:void(0)" ><i class="fa fa-remove"></i> <?php echo $this->lang->line('delete');?></a>
								<?php
								}
								else
								{
									echo "---";
								}
								?>

								</td>

								
							</tr>
						<?php 

								}
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
					
				</div>
				<!-- /basic responsive configuration -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
	(function($) {

	    $(document).ready(function() {
			$.jGrowl.defaults.closer = false;

			<?php if($this->session->flashdata('error_message')) { ?>
				$.jGrowl("<?php echo $this->session->flashdata('error_message');?>", {
		            header: '<?php echo $this->lang->line("error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($this->session->flashdata('success_message')) { ?>
                $.jGrowl("<?php echo $this->session->flashdata('success_message');?>", {
		            header: '<?php echo $this->lang->line("success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>
            
            $('#icon-bck').on('click',function() {
				window.history.back();
			});
		});

	})(jQuery);
	function makeDefault(valus) {
		swal({
            title: "<?php echo $this->lang->line('lbl_default_language');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            cancelButtonColor: true,
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
				var valus1 =  valus;
				jQuery.ajax({
		            type: 'post',
		            url:'<?php echo base_url();?>admin/addrsettings/makedefaults',
		            data: {'id':valus1},
		            success : function(resp)
		            {
		                if(resp==1)
		                    window.location.href = "<?php echo base_url();?>admin/addrsettings";
		                else
		                    console.log('fail');
		            }
		        });
		    }
		});
	}

	function confirmdelete(value) {
		swal({
            title: "<?php echo $this->lang->line('delete_address');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            cancelButtonColor: true,
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
            	window.location.href = "<?php echo base_url();?>admin/addrsettings/delete/"+value;
            }
        });
    }
	</script>

</body>
</html>
