<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Ranksettings extends CI_Controller {

	/**
	 * 
	 * Start 
	 * Create Date: 21 Jul, 2017
	 * This controller to manage user filiter in rank.
	 * Created saravana kumar.
	 * @see http://ihyip.com/admin/sitesettings/
	 * Last Updated: 23 Jun, 2016
	 * End
	 * 
	 */

	public function __construct() {
		parent::__construct();

		// admin login only
		if($this->session->userdata('admin_login')) {

			// form validation library
			$this->load->library('form_validation');
			$this->isSubadmin();
			
		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$this->session->set_userdata('last_page', current_url());
				redirect('admin/login');
			}
		}

	}

	private function isSubadmin() {

		if($this->session->userdata('user_type') == 'subadmin') {
			$controller = $this->router->fetch_class();
			$pages = json_decode($this->session->userdata('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				redirect('admin');
			}
		}
	}

	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$this->session->set_userdata($array);

		} else {
			redirect('admin/login');
		}
	}

	public function index()
	{
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_rank')
		);


		$this->data['module_name'] = 'settings';
		$this->data['rank_data'] = $this->common_model->GetResults('rank_controls');

		$this->load->view('admin/settings/rank',$this->data);

	}
	public function add($id='') {

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_settings'),
			'href' => base_url().'admin/sitesettings'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_rank'),
			'href' => base_url().'admin/ranksettings'
		);
		
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  base_url().'admin/ranksettings/add';

		if($id) {
			$myencrypt = new MyEncrypt;
			$rankid = $myencrypt->decode($id);
			$condition = "rankid = '".$rankid."'";
			$this->data['rank_data'] = $this->common_model->GetRow('rank_controls', $condition);
		}

		if($this->input->post()) {

			if($this->input->post('rankid')) {
				
				$rankid = $this->input->post('rankid');
				$this->form_validation->set_rules('name', $this->lang->line("label_cur_name"), 'trim|required|alpha|edit_unique[rank_controls.rankname'.$rankid.']');
				
			} else {
				$this->form_validation->set_rules('name', $this->lang->line("label_cur_name"), 'trim|required|alpha|is_unique[rank_controls.rankname]');
			}
			/*
			foreach ($this->input->post('commission') as $key => $value) {
				if($value) {
					$this->form_validation->set_rules('commission[$key]', $this->lang->line('lbl_commission'), 'trim|required|numeric');	
				}
			}
			*/
			
			
			$this->form_validation->set_rules('description', $this->lang->line("label_rank_description"), 'trim|required');
			$this->form_validation->set_rules('turnover', $this->lang->line("label_rank_turnover"), 'trim|required|numeric');
			

			// check form validate
			if ($this->form_validation->run() == TRUE) {

				$commission = '';
				foreach ($this->input->post('commission') as $key => $value) {
					if($value) {
						$commission .= $value.',';
					}
				}

				if($this->input->post('rankid')) {

					$currencydata = array(
						"rankname"	=>	strtolower($this->input->post('name')),
						"description"	=>	strtolower($this->input->post('description')),
						"type"	=>	strtolower($this->input->post('type')),
						"turnover"	=>	$this->input->post('turnover'),
						"levelcommission"	=>	rtrim($commission,','),
						"status"	=>	($this->input->post('status')) ? '1' : '0'
					);
					
					$this->db->where('rankid',$this->input->post('rankid'));
					$query_status = $this->db->update('rank_controls',$currencydata);

				} else {

					$currencydata = array(
						"rankname"	=>	strtolower($this->input->post('name')),
						"description"	=>	strtolower($this->input->post('description')),
						"type"	=>	strtolower($this->input->post('type')),
						"turnover"	=>	$this->input->post('turnover'),
						"levelcommission"	=>	rtrim($commission,','),
						"status"	=>	($this->input->post('status')) ? '1' : '0'
					);
					
					$query_status = $this->db->insert('rank_controls',$currencydata);
					$rankid = $this->db->insert_id();

				}

				if($query_status) {
					$this->session->set_flashdata('success_message', $this->lang->line('rank_success_message'));
					redirect('admin/ranksettings');
				} else {
					$this->session->set_flashdata('error_message', $this->lang->line('rank_error_message'));
					redirect('admin/ranksettings');
				}
			} 
		}
		$this->load->view('admin/settings/addrank',$this->data);
	}

	public function delete($id) {
		if($id) {
			$myencrypt = new MyEncrypt;
			
			$rankid = $myencrypt->decode($id);

			if($rankid!=1){

				$condition = "rankid = '".$rankid."' ";
				$curr_data = $this->common_model->GetRow('rank_controls',$condition);
				
				if($curr_data->currency_default) {

					$curr_up_data = array(
						"currency_default" => '1'
					);
					$this->db->where('rankid', '1');
					$update_status = $this->db->update('rank_controls',$curr_up_data);

					$this->db->where('rankid',$rankid);
					$delete_status = $this->db->delete('rank_controls');

				} else {
					$this->db->where('rankid',$rankid);
					$delete_status = $this->db->delete('rank_controls');
				}

				if($delete_status) {
					$this->session->set_flashdata('success_message', $this->lang->line('rankdel_success_message'));
					redirect('admin/ranksettings');
				} else {
					$this->session->set_flashdata('error_message', $this->lang->line('rankdelerr_success_message'));
					redirect('admin/ranksettings');
				}	
				
			} else {
				$this->session->set_flashdata('error_message', $this->lang->line('rankdel_error_message'));
				redirect('admin/ranksettings');
			}

		} else {
			redirect('admin/ranksettings');
		}
		if($id) {
			$myencrypt = new MyEncrypt;
			$rankid = $myencrypt->decode($id);

			// $condition = "rankid = '".$rankid."' ";
			// $curr_data = $this->common_model->GetRow('rank_controls',$condition);
			// echo $curr_data->currency_default;
			$this->db->where('rankid',$rankid);
			$delete_status = $this->db->delete('rank_controls');

			if($delete_status) {
				$this->session->set_flashdata('success_message', $this->lang->line('cur_success_message'));
				redirect('admin/ranksettings');
			} else {
				$this->session->set_flashdata('error_message', $this->lang->line('cur_error_message'));
				redirect('admin/ranksettings');
			}
		} else {
			redirect('admin/ranksettings');
		}
	}
	public function makedefaults() {
		if($this->input->post()) {
			$myencrypt = new MyEncrypt;
			$rankid = $myencrypt->decode($this->input->post('id'));
			$condition = "rankid = '".$rankid."' ";
			$curr_data = $this->common_model->GetRow('rank_controls',$condition);
			if($curr_data->currency_default==0)
			{
				$cur_up_data = array(
					"currency_default" => '0'
				);
				$this->db->update('rank_controls',$cur_up_data);

				$cur_up_data1 = array(
					"currency_default" => '1',
					"currency_status"	=> '1'
				);

				$this->db->where('rankid',$rankid);
				$default_status = $this->db->update('rank_controls',$cur_up_data1);

				if($default_status){
					$this->session->set_flashdata('success_message', $this->lang->line('cur_success_message_default'));
					echo 1;
				} else {
					$this->session->set_flashdata('error_message', $this->lang->line('cur_error_message_default'));
					echo 0;
				}

			}

		}
	}

}

