<!doctype html>
<html lang="en" class="w-[640px]">
  <head>
    <?php echo view('user/layout/head');?>
  </head>
  <style>
    .notify {
    position: fixed;
    top: 10px;
    left: 10px;
    -moz-box-sizing: border-box;
    box-sizing: border-box;
    width: 350px;
    font-size: 14px;
    text-align: center;
    }
    /* Positions
    ========================================================================== */
    .notify-top-right,
    .notify-bottom-right {
    left: auto;
    right: 10px;
    }
    .notify-top-center,
    .notify-bottom-center {
    left: 50%;
    margin-left: -175px;
    }
    .notify-bottom-left,
    .notify-bottom-right,
    .notify-bottom-center {
    top: auto;
    bottom: 10px;
    }
    .notify button {
    -webkit-appearance: none;
    padding: 0;
    cursor: pointer;
    background: 0 0;
    border: 0;
    display: none;
    }
    /* Responsiveness
    ========================================================================== */
    /* Phones portrait and smaller */
    @media (max-width: 479px) {
    /*
    * Fit in small screen
    */
    .notify {
    left: 10px;
    right: 10px;
    width: auto;
    margin: 0;
    }
    }
    /* Sub-object: `notify-message`
    ========================================================================== */
    .notify-message {
    position: relative;
    cursor: pointer;
    }
    .notify .alert-default {
    background: #fff;
    border: 1px solid #e5e5e5;
    }
    .spin {
    animation: spin 1s infinite;
    }
    @keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
    }
    .modal-backdrop {
    --bs-backdrop-zindex: none !important;
    }
    .green { color:green;}
    .blue { color:blue;}
    .orange { color:orange;}
    .red { color:red;}
    .btn.btn-default { border:1px solid #ddd !important;margin-bottom:20px !important; }
    .cs
    {
    float:right;
    background:#fff;
    margin-top:32px;
    }
    /* Improved dropdown styles */
    /* Pagination styles */
    .pagination {
    display: flex;
    justify-content: center;
    align-items: center;
    margin: 20px 0;
    }
    .pagination-btn {
    background: #007bff;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
    margin: 0 5px;
    transition: background-color 0.3s;
    }
    #pairSearch::placeholder {
    color: black !important;
    }
    #pairSearch {
    color: black;
    }
    .pagination-btn:hover:not(:disabled) {
    background: #0056b3;
    }
    .pagination-btn:disabled {
    background: #6c757d;
    cursor: not-allowed;
    opacity: 0.65;
    }
    #pageInfo {
    font-size: 1rem;
    color: #6c757d;
    }
    /* Dropdown fixes */
    .dropdown-menu.show {
    display: block;
    }
    #pairList {
    padding: 0.5rem 0;
    }
    .highlight-pair {
    animation: highlightFlash 2s;
    border: 2px solid #4CAF50 !important;
    box-shadow: 0 0 15px rgba(76, 175, 80, 0.5) !important;
    }
    @keyframes highlightFlash {
    0% { background-color: rgba(76, 175, 80, 0.1); }
    50% { background-color: rgba(76, 175, 80, 0.3); }
    100% { background-color: transparent; }
    }
    .dropdown-item {
    padding: 0.5rem 1rem;
    clear: both;
    font-weight: 400;
    color: #212529;
    text-align: inherit;
    text-decoration: none;
    white-space: nowrap;
    background-color: transparent;
    border: 0;
    display: flex;
    align-items: center;
    }
    .dropdown-item:hover {
    background-color: #f8f9fa;
    }
    /* Responsive adjustments */
    @media (max-width: 576px) {
    .pagination {
    flex-wrap: wrap;
    }
    .pagination-btn {
    padding: 8px 15px;
    margin: 5px;
    }
    #pageInfo {
    flex-basis: 100%;
    text-align: center;
    margin: 5px 0;
    }
    }
  </style>
  <style>
    .dropdown-item {
    display: flex !important;
    align-items: center;
    }
  </style>
  <body class="section-overflow">
    <!--banner start -->
    <section class="banner-bg overall-bg ">
      <div class="container">
        <?php echo view('user/layout/header');?>
      </div>
      <?php 
        use App\Libraries\MyEncrypt;
        use App\Helpers\site_helper;
        use App\Helpers\form_helper;
        $this->db = db_connect();
        $this->session = session();
        $uusersid = $this->session->get('uusersid');
        
        if(!empty($this->session->get('exchange')))
           $exchange=$this->session->get('exchange');
        else
           $exchange='1';
        
        
        
        function formatTradingPair($pair) 
        {
          $base = substr($pair, 0, -4);  // Extract the base currency (all but the last 4 characters)
          $quote = substr($pair, -4);    // Extract the quote currency (last 4 characters)
          return strtoupper($base) . '/' . strtoupper($quote); // Combine and convert to lowercase
        }
        $this->common_model = model('CommonModel');
        helper('form_helper');
        $buy_bal=gas_wallet_bal($uusersid);
        $bind_api =$this->db->query("SELECT * FROM bind_process WHERE uusersid='".$uusersid."' and type='".$exchange."'")->getRow();
        if(!empty($bind_api))
        $bind_api = true;
        else
        $bind_api = false;
        //$required_pairs = ['1INCH','ADA','AAVE','ATOM','ALGO','AION','AVAX','AKRO','ANT','APE','BAT','BTC','BCH','BNB','BTCST','BAKE','BOME','BONK','CRV','COMP','CAKE','COS','DOGE','DASH','DOT','ETH','EOS','ETC','FTM','FTT','FIL','GALA','GRT','GMT','HBAR','HOT','IOTA','ICP','IOST','JST','KAVA','KSM','LTC','LINK','LIT','LUNA','MANA','MATIC','MDX','NEO','NOT','OMG','ONT','PEPE','QTUM','REEF','RSR','SUN','SHIB','SLP','SOL','SUSHI','SXP','TRX','THETA','TFUEL','UNI','VET','WRX','XRP','XMR','XEM','XLM','XTZ','YFI','YFII','ZEC','ZEN'];
        $tradSets = $this->common_model->GetResults('adminsettings','');
        $tradSet = $tradSets[0];
        $activation='';
        $usdt_balance='0';
        $sno=0;
        $get_pairs=$this->db->query("select * from tradepair_list where status='1'")->getResult();
        
        function get_tradeinfo($symbol,$live_price,$userid)
        {
          
           $CI = db_connect();
           $CI->session = session();
        
           if(!empty($CI->session->get('exchange')))
           $exchange=$CI->session->get('exchange');
          else
           $exchange='1';
        
          $uusersid = $userid;
        
        
        $trade_process =$CI->query("SELECT * FROM trade_process WHERE pair='".$symbol."' and uusersid='".$uusersid."' and exchange='".$exchange."' and trade_status!= 2")->getRow();
        
        if(!$trade_process)
        {
           $trade_process =$CI->query("SELECT * FROM user_strategy WHERE uusersid='".$uusersid."'")->getRow();
        }
        $pair =$CI->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and pair='".$symbol."' and trade_status!= 2 and exchange='".$exchange."' order by id desc")->getRow();
        if(!empty($pair))
        {
           $sync_strategy_status = $pair->sync_strategy_status ? $pair->sync_strategy_status : 0;
           $manual_buy = $CI->table('api_manual_trade')->where('trade_process_id',$pair->id)->where('type',1)->where('exchange',$exchange)->where('status','1')->get()->getRow();
           $manual_sell = $CI->table('api_manual_trade')->where('trade_process_id',$pair->id)->where('type',2)->where('exchange',$exchange)->where('status','1')->get()->getRow();
           $pair_trade_status=$pair->trade_status;
        }
        else
        {
           $sync_strategy_status='0';
           $pair_trade_status='';
        }
        
        $qury = $CI->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' AND  pair = '".$symbol."' and trade_status != 2 and exchange='".$exchange."' ")->getResult();
        if(!empty($qury))
        {
         $qry=$qury[0];
         //$qury = $CI->query("SELECT * FROM user_strategy WHERE uusersid='".$uusersid."'")->getResult();
         //$qry=$qury[0];
         $first_buy_amount=$qry->first_buy_amount;
         $open_position_doubled=$qry->open_position_doubled;
         $margin_column_limit=$qry->margin_column_limit;
         $whole_profit_ratio=$qry->whole_profit_ratio;
         $whole_profit_callback=$qry->whole_profit_callback;
         $buyin_callback=$qry->buyin_callback;
         $sub_position_callback=$qry->sub_position_callback;
         $strategy_mode=$qry->strategy_mode;
         
         
        }
        else
        {
        
         $qry='';
         $qury = $CI->query("SELECT * FROM user_strategy WHERE uusersid='".$uusersid."'")->getResult();
         $qry=$qury[0];
         
         $first_buy_amount=$qry->first_buy_amount;
         $open_position_doubled=$qry->open_position_doubled;
         $margin_column_limit=$qry->margin_column_limit;
         $whole_profit_ratio=$qry->whole_profit_ratio;
         $whole_profit_callback=$qry->whole_profit_callback;
         $buyin_callback=$qry->buyin_callback;
         $sub_position_callback=$qry->sub_position_callback;
         $strategy_mode=$qry->strategy_mode;
        }
        if(!empty($pair)) 
        { 
        
        
              $api_trade_data = array(
              'pair' => $pair->pair,
              'uuserid' => $uusersid,
              'type' => '1',
              'trade_close' => 0,
              'exchange' => $exchange
              );
              
               $api_trade_data_margin= array(
                'pair' => $pair->pair,
                'uuserid' => $uusersid,
                'type' => '1',
                'trade_close' => '0',
                'exchange' => $exchange_id 
              );
              
        
               $last_call_drop_data = array(
                 'trade_process_id' => $pair->id,
                 'uuserid' => $uusersid,
                 'trade_close' => '0',
                 'exchange' => $exchange
               );
        
               $api_trade_data1 = array(
                 'trade_process_id' => $pair->id,
                 'uuserid' => $uusersid,
                 'type' => '2',
                 'description' => 'manual_sell',
                 'exchange' => $exchange,
                 'trade_close' => 0
               );
        
               $api_trade_data2 = array(
                 'trade_process_id' => $pair->id,
                 'uuserid' => $uusersid,
                 'type' => '1',
                 'trade_close' => 0,
                 'exchange' => $exchange,
                 'margin_call_drops = ' => 0
               );
        
        
                $profit_where = array(
                   'uuserid' => $uusersid,
                   'type' => '3',
                   'trade_process_id' => $pair->id,
                   'exchange' => $exchange,
                   'trade_close' => 0
               );
        
        
              if($pair->strategy_mode == 1)
              {
                    $total_contract = $CI->table('api_trade_history')->selectSum('received_amount')->where($api_trade_data)->get()->getRow();
                    $total_usdt  = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data)->get()->getRow();
                    if($total_contract->received_amount && $total_usdt->quantity)
                       $avg_position_amount = $total_usdt->quantity / $total_contract->received_amount;
                    else
                       $avg_position_amount = 0;
              }
              else
              {
                    if($pair->strategy_mode == 3) 
                    {
           
                    $total_contract = $CI->table('api_trade_history')->selectSum('received_amount')->where($api_trade_data)->where('margin_call_drops <=',4)->get()->getRow();
                    $total_usdt = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data)->where('margin_call_drops <=',4)->get()->getRow();
                    if($total_contract->received_amount && $total_usdt->quantity)
                       $avg_position_amount = $total_usdt->quantity / $total_contract->received_amount;
                    else
                       $avg_position_amount = 0;
                 }else{
                    $total_contract = $CI->table('api_trade_history')->selectSum('received_amount')->where($api_trade_data)->where('margin_call_drops <=',4)->get()->getRow();
                    $total_usdt = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data)->where('margin_call_drops <=',4)->get()->getRow();
                    $total_contract2 = $CI->table('api_trade_history')->selectSum('received_amount')->where($profit_where)->get()->getRow();
                    $total_contract = $total_contract->received_amount + $total_contract2->received_amount;
                    $total_usdt2 =$CI->table('api_trade_history')->selectSum('quantity')->where($profit_where)->get()->getRow();
                    $total_usdt = $total_usdt->quantity + $total_usdt2->quantity;
                    if($total_contract && $total_usdt)
                       $avg_position_amount = $total_usdt / $total_contract;
                    else
                       $avg_position_amount = 0;
                 }
           }
        
           $last_call_drop = $CI->table('api_trade_history')->where($last_call_drop_data)->orderBy('id','DESC')->get()->getRow();
           $last_average = $avg_position_amount;
           if(!empty($last_average))
           {
              //$avg_price = round($last_average,8) * $pair->whole_profit_ratio / 100;
              $avg_price=round($last_average,8);
              $avg_price=str_replace(',','',$last_average);
              
              if(!empty($pair->whole_profit_ratio))
              {
                  $avg_price = $avg_price * $pair->whole_profit_ratio / 100;
              }
              else
              {
                  $avg_price=$avg_price;
              }
              
           }
           else
              $avg_price='0';
              
             
             
           $max_increase_price = $last_average + $avg_price ;
           $max_increase_price = round($max_increase_price,8);
           if(!empty($pair->whole_profit_ratio))
           {
              $max_down_percentage = $max_increase_price * $pair->whole_profit_callback / 100;
           }
           else
           {
               $max_down_percentage = $max_increase_price * 0.1;
           }
           $max_down_price = $max_increase_price - $max_down_percentage;
           $max_down_price = round($max_down_price,8);
           if(intval($max_increase_price) > 999)
              $max_increase_price = number_format($max_increase_price,2);
           else
              $max_increase_price = number_format($max_increase_price,8);
                      
              if($last_call_drop->type == 2)
                    $max_increase_price = $last_call_drop->live_price + $price_down;
              
              $tradeupdate['take_profit_trigger'] = $max_increase_price ? "> ".$max_increase_price : "";
              $trade_where_new = array(
              'uuserid' => $uusersid,
              'type' => '1',
              'trade_close' => 0,
              'trade_process_id' => $pair->id,
              );
              
              $last_buy_recheck = $CI->table('api_trade_history')->where($trade_where_new)->orderBy('margin_call_drops','DESC')->get()->getRow();
              $last_margin_call_drop = $last_buy_recheck->margin_call_drops ? $last_buy_recheck->margin_call_drops : 0;
              $call_perc = explode(',', $pair->margincall_drop)[$last_margin_call_drop];
              $tradeupdate['margin_call_drops'] = $call_perc;
                    
              if($last_call_drop->type == 1)
              {
                   if(!empty($call_perc))
                      $price_down = $last_call_drop->live_price * $call_perc / 100;
                   else
                      $price_down = $last_call_drop->live_price * 0.1;
              }
              else
                 $price_down = $last_call_drop->live_price * $pair->buyin_callback / 100;
              
              $down_price = $last_call_drop->live_price - $price_down;
              
              $tradeupdate['down_price']  = "< ".$down_price;
              
              $total_position_amount = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data)->get()->getRow();
              
              $total_sell_amount = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data1)->get()->getRow();
              
              $total_position_amount->quantity = $total_position_amount->quantity - $total_sell_amount->quantity;
              
              
              $tradeupdate['current_position_amount'] = $last_call_drop->quantity;
              $total_position_quantity = $CI->table('api_trade_history')->selectSum('received_amount')->where($api_trade_data)->get()->getRow();
              $total_sell_quantity = $CI->table('api_trade_history')->selectSum('received_amount')->where($api_trade_data1)->get()->getRow();
              $total_position_quantity->received_amount = $total_position_quantity->received_amount - $total_sell_quantity->received_amount;
              
              if($total_position_amount->quantity > 0)
              {
                  
                  print_r($tradeupdate['trade_position_amount']);
                 $tradeupdate['trade_position_amount'] = number_format($total_position_amount->quantity,5);  
              } 
              else 
              {
                 $tradeupdate['trade_position_amount'] = 0.00;
              }
              
              /*if($total_position_quantity->received_amount > 0) 
              {
                    $tradeupdate['trade_position_quantity'] = number_format($total_position_quantity->received_amount,5);
              }
              else
              {
                    $tradeupdate['trade_position_quantity'] = 0.00;
              }*/
              
              
              $total_position_qty = $CI->table('api_trade_history')->selectSum('received_amount')->where("trade_process_id",$pair->id)->where("trade_close",'0')->where('type','1')->orderBy('id','DESC')->get()->getRow();
          	$total_position_qty1=number_format($total_position_qty->received_amount,8);
          	$total_position_qty1=str_replace(",",'',$total_position_qty1);
          	
          	
          	$total_position_qty2 = $CI->table('api_trade_history')->selectSum('received_amount')->where("trade_process_id",$pair->id)->where("description",'manual_sell')->where('type','2')->orderBy('id','DESC')->get()->getRow();
              $total_position_qty2=number_format($total_position_qty2->received_amount,8);
              $total_position_qty2=str_replace(",",'',$total_position_qty2);
          
              /*$total_position_quantity= $total_position_qty1-$total_position_qty2;
                
              $CQuantity = $total_position_quantity * 0.1/100;
              $total_position_quantity = $total_position_quantity - $CQuantity;*/
              
               $CQuantity = $total_position_qty1 * 0.1/100;
               $CQuantity = number_format($CQuantity,8);
               $CQuantity=str_replace(",",'',$CQuantity);
             
               
               
              
               $total_position_quantity= $total_position_qty1-$CQuantity - $total_position_qty2;
        
          
            if($total_position_quantity  > 0) 
            {
              $tradeupdate['trade_position_quantity'] = number_format($total_position_quantity,8);
            }
            else 
            {
               $tradeupdate['trade_position_quantity'] = 0.00;
            }
                       
                 if ($avg_position_amount > 0) {
                 $tradeupdate['trade_avg_position'] = $avg_position_amount;
                 }else{
                 $tradeupdate['trade_avg_position'] = 0.00;
                 }
              
                       $call_drop = $CI->table('api_trade_history')->where($api_trade_data_margin)->where('margin_call_drops !=',0)->orderBy('id','DESC')->get()->getRow();
                       
                       if(!empty($call_drop)){
                          if($call_drop->margin_call_drops == $trade_process->margin_column_limit){
                             $tradeupdate['down_price'] = "Limit Reached";
                             $tradeupdate['margin_call_drops'] = "0";
                          }
                    }
              
              
                       
                    if(!empty($call_drop)){
                       if ($call_drop->margin_call_drops != '' || $call_drop->margin_call_drops != '0') {
                          $tradeupdate['trade_number_of_call'] = $call_drop->margin_call_drops;
                       }else{
                          $tradeupdate['trade_number_of_call'] = '0';
                       }
                    }
                    else
                    {
                       $tradeupdate['trade_number_of_call'] = '0';
                    }
              
                          $api_trade_data = array(
                          'trade_process_id' => $pair->id,
                          'uuserid' => $uusersid,
                          'exchange' => $exchange,
                          'type' => '1',
                          );
              
                          $tradeupdate['live_price'] = $live_price;
                       
                          $check_percentage=0;
                          if($avg_position_amount == 0 &&  $tradeupdate['trade_position_amount'] == 0){
                          $check_percentage = '0';
                          }
              
                          else if ($avg_position_amount > $live_price) 
                          {
                          
                          $check_percentage = ($avg_position_amount - $live_price);
                          $check_percentage = $check_percentage  / $avg_position_amount;
                          $check_percentage = $check_percentage  * 100 ;
                          $check_percentage = '-'.number_format($check_percentage,2).'%';
                          }elseif ($avg_position_amount == $live_price) {
                          
                          $check_percentage = '0';
                          }else{
                          
                          $check_percentage = $live_price - $avg_position_amount;
                          $check_percentage = $check_percentage  / $live_price;
                          $check_percentage = $check_percentage  * 100 ;
                          }
              
              
                          $tradeupdate['trade_rate_percentage'] = $check_percentage;
                         if ($avg_position_amount > $live_price) 
                          {
                             $check_percentage1 = ($avg_position_amount - $live_price) / $avg_position_amount;
                             $check_percentage1 = $check_percentage1  * 100 ;
                             $check_percentage1 = '-'.number_format($check_percentage1,2).'%';
                          }
                          elseif($avg_position_amount == $live_price) 
                          {
                             $check_percentage1 = '0.00';
                          }
                          else
                          {
                             $check_percentage1 = ($live_price - $avg_position_amount) / $live_price;
                             $check_percentage1 = $check_percentage1  * 100 ;
                          }
              
              
                    $tradeupdate['trade_estimate_price'] = $check_percentage1;
                          
              
              $total_sell_amount = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data1)->get()->getRowArray();
              
              $total_position_amount1 = $CI->table('api_trade_history')->selectSum('quantity')->where($api_trade_data)->get()->getRowArray();
              
              $total_position_amount = $total_position_amount1['quantity'] - $total_sell_amount['quantity'];
              $total_position_amount = number_format($total_position_amount,4);
              
              $tradeupdate['trade_remain_amount'] = $tradeupdate['trade_position_amount'];
        
           return $tradeupdate;
        
           }
        }
        
        ?>
      <section class="dash-wrap quantify-wrap">
        <div class="container">
          <?php
            if($bind_api=='')
            {
               ?>
          <div class="row justify-content-center mt-3">
            <div class="col-md-12 col-xl-12">
              <div class="card shadow-0 border rounded-3">
                <div class="card-body" style="margin:70px 0px;">
                  <div class="row">
                    <div  class="text-center mt-90 relative">
                      <p class="text-base font-normal text-primary mb-3"> Bind platform to continue trading </p>
                      <a  href="<?php echo base_url();?>/apikeylist" class="btn btn-primary ">
                        <p  class="text-white font-normal" style="margin-top:20px;"> Bind Platform </p>
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <?php 
            }
            else
            {
               ?>
          <?php 
            $uusersid =$this->session->get("uusersid");
            $activation =  $this->db->query("SELECT * FROM history WHERE type='activation' and uusersid='".$uusersid."' AND status='1'")->getRow();
            if($activation)
            {
            $activation = true;
            }
            else
            {
            $activation = false;
            }
            
            if ($exchange == '1')  // Binance
            {
                $referral1 = $this->db->query("SELECT * FROM bind_process WHERE uusersid='" . $uusersid . "' and type='1'");
                $ref = $referral1->getRow();
                $usdt_balance = '0';
                $key = $ref->api_key;
                $secret = $ref->secret_key;
                $balances = binance_balance($key, $secret);
            
                if($balances) 
                {
                    $usdt_balance = $balances;
                }
                else 
                {
                    $usdt_balance = '0';
                }
            }
            else if ($exchange == '5')  // Bybit
            {
                $usdt_balance = '0';
                $get_api_bind = $this->db->query("SELECT * FROM bind_process WHERE uusersid='" . $uusersid . "' and type='5'")->getRow();
                
                if ($get_api_bind) 
                {
                    $key = $get_api_bind->api_key;
                    $secret = $get_api_bind->secret_key;
                    $account = $get_api_bind->account;
                    $acc_type = $account == 1 ? 'CONTRACT' : 'UNIFIED';
                    $bybitApi = new App\Libraries\BybitApi($key, $secret);
                    $usdt_balance = $bybitApi->getBalance('USDT', $acc_type);
                }
            }
            
           
            else  // fallback
            {
            $usdt_balance = '0';
            }
            
               
            
            $get_pairs=$this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and trade_status!= 2 and exchange='".$exchange."' order by id asc")->getResult();
            
            $get_active=array();
            foreach($get_pairs as $pair_infos)
            {  
               $pair_info_value[]=substr($pair_infos->pair,0, -4);
               
            }
            if($pair_info_value!='')
            {
               $calculated_pairs=array_unique(array_merge($pair_info_value,$required_pairs), SORT_REGULAR);
            }
            else
            {
               $calculated_pairs=$required_pairs;
            }
            
            
            
            if($exchange=='1')
            {
            
                //$data_binance = json_decode(@file_get_contents('https://revotechbot.com/trading_pairs.json'), true);
                //$data_binance=getpairs($exchange);
                $i=0;
               foreach ($calculated_pairs as $market_pair) 
               {
                   $update_symbol = $market_pair . 'USDT';
                   $marketpair=$this->db->query("select * from tradepair_list where pair_name='".$market_pair."'")->getRow();
                    if($marketpair)
                   {
                       $output[$i]['symbol'] = $update_symbol;
                       $output[$i]['price'] = isset($marketpair->lastPrice) ? $marketpair->lastPrice : null;
                       $output[$i]['change'] = isset($marketpair->priceChangePercent) ? $marketpair->priceChangePercent : null;
                        $i++;
                       
                   }
                   
                   
               }
            }
            else if ($exchange == '5') // Bybit
            {
                
                 $get_api_bind=$this->db->query("SELECT * FROM bind_process WHERE uusersid='".$uusersid."' and type='5'")->getRow();
                 if($get_api_bind)
                 {
                 $key = $get_api_bind->api_key;
                  $secret = $get_api_bind->secret_key;
                 }
                 else
                 {
                    $key='of3MneVy7FCSAvxAXl';
                    $secret='VpcyfXxVZyBwQZqJ3D3SNonEoPGDgLaav8vN';
                 }
            
                 $bybitApi = new App\Libraries\BybitApi($key, $secret);
                 $lists = $bybitApi->ticker(['category' => 'spot', 'baseCoin' => 'USDT']); 
                 $output=[];
                 $b=0;
                 /*if($lists)
                 {
                    foreach ($lists as  $value) {
                    if(substr($value['symbol'], -4) == "USDT"){
                       if(in_array(substr_replace($value['symbol'] ,"",-4), $required_pairs)){
                          $output[$b]['symbol'] = $value['symbol'];
                          $output[$b]['price'] = $value['lastPrice'];
                          $output[$b]['change'] = $value['price24hPcnt'];
            
                          $b++; 
                       } 
                    
                    }
                 }
              }*/
              
              $b=0;
               foreach ($calculated_pairs as $market_pair) 
               {
                   $update_symbol = $market_pair.'USDT';
                   
                   if($lists)
                   {
                       foreach ($lists as $value) 
                       {
                           if ($value['symbol'] === $update_symbol) 
                           {
                              $output[$b]['symbol'] = $value['symbol'];
                               $output[$b]['price'] = isset($value['lastPrice']) ? $value['lastPrice'] : null;
                               $output[$b]['change'] = isset($value['price24hPcnt']) ? $value['price24hPcnt'] : null;
                               $b++; 
                           }
                       }
                       
                   }
               }
            }
              
           else // default fallback
            {
               $output = [];
            }
            
            $k = 0;
            if($output)
            {
                foreach ($output as $key => $value) 
                {
                   $output[$k] = $value;
                   $k++;
                }
                $output =  array_unique($output,SORT_REGULAR);
            }
            
            $min_gas_required =$tradSet->min_fuel;
            $min_gas_fee= $tradSet->min_fuel_fee;
            
            
            ?>
          <div class="row">
            <div class="col-12">
              <div class="quantify-header d-flex align-items-center text-white justify-content-between">
                <div class="trade-content ms-2">
                  <h6 class="text-white fw-semibold aleo mb-0 align-items-center">
                  Balance Account USDT
                </div>
                <div class="repeat-icon d-flex align-items-center">
                  <h5 class="text-white me-2 fw-bold" id="balance_update"><?php echo number_format($usdt_balance,2);?>
                  </h5>
                  <iconify-icon icon="mage:reload-reverse" id="balance_load" class="fs-3"></iconify-icon>
                </div>
              </div>
            </div>
          </div>
          <!-- <div class="row">
            <div class="col-12">
              <div class="search-container">
                <div class="search-box-wrapper">
                  <button class="search-btn">
                  <i class="fas fa-search"></i>
                  </button>
                  <input  onkeyup="myFunction()" id="myFilter" type="search" placeholder="Search...." aria-label="Search" class="search-box">
                </div>
              </div>
            </div>
            </div> -->
          <!-- Search Dropdown -->
          <div class="row m-4">
            <div class="col-9 col-md-9">
              <div class="dropdown">
                <button class="btn btn-outline-primary dropdown-toggle w-100 form-control" type="button" id="pairDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                <i class="fas fa-search me-2"></i> Search Trading Pairs
                </button>
                <div class="dropdown-menu w-100 p-2" aria-labelledby="pairDropdown">
                  <div class="input-group mb-2">
                    <span class="input-group-text"><i class="fas fa-search"></i></span>
                    <input type="text" class="form-control" onclick="filterPairs()" id="pairSearch" placeholder="Type to search...">
                  </div>
                  <div id="pairList" style="max-height: 300px; overflow-y: auto;">
                    <?php foreach($all_pairs as $pair): ?>
                    <a class="dropdown-item d-flex align-items-center py-2" href="#" onclick="selectPair('<?php echo $pair; ?>'); return false;">
                    <img src="<?php echo base_url('styles/images/tradingpair_images/'.$pair.'USDT.png'); ?>" width="24" height="24" class="me-2">
                    <?php echo $pair; ?>
                    </a>
                    <?php endforeach; ?>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-3 col-md-3 d-flex align-items-center justify-content-end">
              <button class="btn form-control btn-outline-primary me-2" onclick="resetFilter()">
              <i class="fas fa-sync-alt me-1"></i>
              </button>
              <!-- <span class="text-muted">
                Showing <?php echo min($perPage, count($required_pairs)); ?> of <?php echo $total_pairs; ?> pairs
                </span> -->
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <div class="trade-sts py-4 ">
                <div class="quan d-flex align-items-center text-white justify-content-between">
                  <div class="trade-content  d-flex align-items-center">
                    <iconify-icon icon="mynaui:question-octagon-solid"></iconify-icon>
                    <?php 
                      if ($exchange == '1') {
                         $exchange_name = 'Binance';
                      } 
                         else if ($exchange == '5') {
                         $exchange_name = 'Bybit';
                      }
                         else if ($exchange == '8') {
                         $exchange_name = 'Bingx';
                      } else if ($exchange == '7') {
                         $exchange_name = 'Bitget';
                      }
                      ?>
                    <h6 class="text-white fw-semibold aleo mb-0 align-items-center me-2 ms-2">Bound With <?php echo $exchange_name;?> </h6>
                    <div class="tick-icon">
                      <iconify-icon icon="lets-icons:check-fill"></iconify-icon>
                    </div>
                  </div>
                  <div class="trade-icon d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#staticBackdrop1" data-bs-whatever="@fat"  >
                    <iconify-icon icon="mynaui:question-octagon-solid"></iconify-icon>
                    <h5 class="text-white me-2 fw-bold mb-0">Trading Status
                    </h5>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div syle="clear:both"><br></div>
          <div class="modal fade" id="staticBackdrop1" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content" style="border-radius:30px;padding: 11px;" >
                <div class="modal-header" style="padding-top: 11px;margin-bottom:-15px;">
                  <p class="modal-title" id="staticBackdropLabel" style="padding-left:170px;"><b>Trading Status Info</b></p>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="height:400px;overflow-y:scroll;">
                  <div class="row col-lg-12 mt-3">
                    <div class="form-check form-check-right mb-3" style="font-size: 14px;">
                      <lable class="btn btn-default"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>
                      <h5>Bot Is on Trading</h5>
                      <p>Indicates that the trading bot is currently active and executing trades.</p>
                      <hr>
                      <lable class="btn btn-default"><i class="fa fa-pause blue"></i> <span class="blue"> Pause </span></lable>
                      <h5>Pause Trade</h5>
                      <p>Trading activities are temprorarily halted or paused.</p>
                      <hr>
                      <lable class="btn btn-default"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>
                      <h5>Insufficent USDT</h5>
                      <p>There is not enough USDT(Tether) available on the exchange platform  to carry out the desired transaction.</p>
                      <hr>
                      <lable class="btn btn-default"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>
                      <h5>Insufficent Gas Fuel</h5>
                      <p>There is an inadequate amount of fuel available in the bot gas wallet, needed for top up fuel for transaction fees.</p>
                      <hr>
                      <lable class="btn btn-default"><i class="fa fa-warning orange"></i> <span class="orange"> Coin </span></lable>
                      <h5>Coin</h5>
                      <p>There isn't enough of a specific cryptocurrency  or token available on the exchange platform intended transaction</p>
                      <hr>
                      <lable class="btn btn-default"><i class="fa fa-warning orange"></i> <span class="orange"> Robot</span></lable>
                      <h5>Robot Expired</h5>
                      <p>The automated trading robot has reached its expiration date and is no longer functional.</p>
                      <hr>
                      <lable class="btn btn-default"><i class="fa fa-warning orange"></i> <span class="orange">API Key</span></lable>
                      <h5> API key is invalid/expired </h5>
                      <p>The API key used unable to  access on trading functionalitie.</p>
                      <hr>
                      <lable class="btn btn-default"><i class="fa fa-times-circle red"></i> <span class="red">Cover</span></lable>
                      <h5> Failed to cover </h5>
                      <p>The attempt to execute a cover action, likely realted to risk management or position protection, was unsuccessful.</p>
                      <hr>
                      <lable class="btn btn-default"><i class="fa fa-times-circle red"></i> <span class="red">Liquidation</span></lable>
                      <h5> Failed Liquidate</h5>
                      <p>The attempt to liquidate assets selling them off, was unsuccessful.</p>
                      <hr>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="quantify-tab">
            <div class="row">
              <div class="col-12">
                <div class="tab-mine">
                  <div class="team-tab">
                    <ul class="nav nav-pills d-flex  ps-0" id="pills-tab" role="tablist" style="display:none;">
                      <li class="nav-item active" role="presentation">
                        <button class="nav-link " id="pills-dep1-tab " data-bs-toggle="pill" data-bs-target="#pills-dep1"
                          type="button" role="tab" aria-controls="pills-dep1" aria-selected="false" tabindex="-1">
                          <div class="make-list">
                            <div class="process"> <span class="">All</span> </div>
                          </div>
                        </button>
                      </li>
                      <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-dep2-tab " data-bs-toggle="pill" data-bs-target="#pills-dep2"
                          type="button" role="tab" aria-controls="pills-dep2" aria-selected="false" tabindex="-1">
                          <div class="make-list">
                            <div class="process"> <span class="">Single</span> </div>
                          </div>
                        </button>
                      </li>
                      <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-dep3-tab " data-bs-toggle="pill" data-bs-target="#pills-dep3"
                          type="button" role="tab" aria-controls="pills-dep3" aria-selected="false" tabindex="-1">
                          <div class="make-list">
                            <div class="process"> <span class="">Cycle</span> </div>
                          </div>
                        </button>
                      </li>
                    </ul>
                    <div class="tab-content" id="pills-tabContent">
                      <div class="tab-pane fade show active" id="pills-dep1" role="tabpanel" aria-labelledby="pills-dep1-tab">
                        <?php
                          $usdt_balance=str_replace(',','',$usdt_balance);
                          
                            if($output)
                            {
                              foreach ($output as $key => $value) 
                              {
                                 $symbol = formatTradingPair($value['symbol']);
                                 $live_price = $value['price'];
                                 $tradeupdate='';
                                 if($value['symbol']!='')
                                 {
                                  $tradeupdate=get_tradeinfo($value['symbol'],$live_price,$uusersid);
                                 }
                                 $pair =$this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and pair='".$value['symbol']."' and trade_status!= 2 and exchange='".$exchange."' order by id desc")->getRow();
                                 $base = substr($value['symbol'], 0, -4);
                                 $pair_disp=$base.'/USDT';
                                  ?>
                        <?php
                          $last_margin=0;
                            
                          if(!empty($pair)) 
                          {
                             $call_limit=$trade_process->margin_column_limit;
                             //echo "select * from api_trade_history where trade_process_id='".$pair->id."' and type='1' and margin_call_drops!='0' order by id desc limit 1";
                             
                            
                             $get_last_trade=$this->db->query("select * from api_trade_history where trade_process_id='".$pair->id."' and type='1' and trade_close='0' and margin_call_drops!='0' order by id desc limit 1")->getRow();
                             if($get_last_trade)
                             {
                                 $last_margin=$get_last_trade->margin_call_drops;
                             }
                             else
                             {
                                 $last_margin=0;
                             }
                            
                            
                            if($pair->trade_status==1)
                            {
                                $uusersid =$this->session->get("uusersid");
                                $gas_balance = gas_wallet_bal($uusersid);
                                
                                
                                
                                if(!empty($tradeupdate['trade_position_amount'])) 
                                {
                                    $filed_amount=$tradeupdate['trade_position_amount'];
                                }
                                else
                                {
                                    $filed_amount='0';
                                }
                                
                               $filed_amount=str_replace(',','',$filed_amount);
                                $set_flag=0;
                                if($min_gas_required > $gas_balance)
                                {
                                    //echo "1";
                                    $api_trade_datas = array(
                                        'trade_log' => '2',
                                        'trade_status' => '0'
                                      );
                                    
                                    $display_mode=' <lable class=""btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>';
                                    $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();                                                            
                                }
                                else if($filed_amount > $usdt_balance)
                                {
                                   
                                   
                                    /*if($call_limit > $last_margin)
                                    {
                                    
                                     /*$api_trade_datas = array(
                                        'trade_log' => '3',
                                        'trade_status' => '0'
                                        
                                       );
                                      $display_mode=' <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                      $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();*/    
                                      
                                      /*$display_mode=' <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                    }*/
                                    
                                      /*$get_response=$this->db->query("select * from trade_process where id='".$pair->id."' and trade_log='3' and trade_status='0'")->getRow();
                                      if($get_response)
                                      {
                                        $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                      }
                                      else
                                      {
                                          $api_trade_datas = array(
                                            'trade_log' => '1',
                                            'trade_status' => '1'
                                           );
                                           
                                         $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>';
                                         $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                        
                                      }*/
                                      
                                       $api_trade_datas = array(
                                        'trade_log' => '3',
                                        'trade_status' => '0'
                                        
                                       );
                                      $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                      $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                    
                                }
                                else
                                {
                                    //echo "3";
                                     $api_trade_datas = array(
                                        'trade_log' => '1',
                                        'trade_status' => '1'
                                        
                                       );
                                       
                                     $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>';
                                     $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                    
                                }
                                
                                //$this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                
                               
                                echo $display_mode; 
                               
                          
                          
                            }
                            else
                            {
                                $uusersid =$this->session->get("uusersid");
                                $gas_balance = gas_wallet_bal($uusersid);
                                
                               if(!empty($tradeupdate['trade_position_amount'])) 
                               {
                                   $filed_amount=$tradeupdate['trade_position_amount'];
                               }
                               else
                               {
                                   $filed_amount='0';
                               }
                               
                              
                             $filed_amount=str_replace(',','',$filed_amount);
                             
                             
                                
                               
                               if($pair->trade_log=='1')
                               {
                                   if($min_gas_required > $gas_balance)
                                   {
                                       $display_mode='<lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>';
                                   }
                                   else if($filed_amount > $usdt_balance)
                                   {
                                   
                                       /*if($call_limit > $last_margin)
                                       {
                                           $display_mode='<lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                       }*/
                                       $display_mode='<lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                       
                                   }
                                   echo $display_mode;
                                   
                                   
                               ?>
                        <!--<lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-pause blue"></i> <span class="blue"> Pause </span></lable>-->
                        <?php 
                          }
                          else
                          {
                              $uusersid =$this->session->get("uusersid");
                              $gas_balance = gas_wallet_bal($uusersid);
                          
                              
                               if(!empty($tradeupdate['trade_position_amount'])) 
                               {
                                   $filed_amount=$tradeupdate['trade_position_amount'];
                               }
                               else
                               {
                                   $filed_amount='0';
                               }
                               
                              
                             $filed_amount=str_replace(',','',$filed_amount);
                               $set_flag=0;
                               if($min_gas_required > $gas_balance)
                               {
                                   //echo "5";
                                   $api_trade_datas = array(
                                       'trade_log' => '2',
                                       'trade_status' => '0'
                                     );
                                   $trade_update = $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                   $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>';
                                   
                               }
                               else if($filed_amount > $usdt_balance)
                               {
                                  
                                   
                                   //echo "6";
                                     /*$api_trade_datas = array(
                                       'trade_log' => '3',
                                       'trade_status' => '0'
                                       
                                      );
                                   $display_mode=' <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';*/
                                   
                                   /*$get_response=$this->db->query("select * from trade_process where id='".$pair->id."' and trade_log='3' and trade_status='0'")->getRow();
                                   if($get_response)
                                   {
                                       $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                   }
                                   else
                                   {
                                        $api_trade_datas = array(
                                       'trade_log' => '1',
                                       'trade_status' => '1'
                                      );
                                      
                                    $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>';
                                    $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                       
                                   }*/
                                   
                                   $api_trade_datas = array(
                                        'trade_log' => '3',
                                        'trade_status' => '0'
                                        
                                       );
                                      $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                      $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                               }
                               else
                               {
                                    //echo "7";
                                    $api_trade_datas = array(
                                       'trade_log' => '1',
                                       'trade_status' => '1'
                                       
                                      );
                                      
                                    $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>';
                                    $trade_update = $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                   
                               }
                               echo $display_mode; 
                              
                          }
                          }
                          }
                          ?>
                        <!-- Taping content st-->
                        <div class="quantify-box py-4 myItems">
                          <div class="row">
                            <div class="col-6">
                              <div class="trade-using-coin d-flex align-items-center">
                                <div class="btc-ico">
                                  <img style="width:30px;height:29px" src="<?php echo base_url('styles/images/tradingpair_images/'.$value['symbol'].'.png');?>" alt="">
                                </div>
                                <div class="value-coin">
                                  <h4 class="text-white mb-0 quantify-box-title"><?php echo $pair_disp;?> </h4>
                                </div>
                              </div>
                              <div class="qunatify-calls">
                                <a href="">
                                  <h6 class="text-white-50 fw-semibold"> No of Calls : <?php echo $last_margin;?></h6>
                                </a>
                              </div>
                            </div>
                            <div class="col-6">
                              <div class="pause-btn text-end">
                                <?php
                                  if(!empty($pair)) 
                                  {
                                     
                                  if($pair->trade_status == 0) 
                                  {
                                     ?>
                                <button data-mdb-button-init data-mdb-ripple-init class="btn-outline-primary" id="start_button"  Onclick="start_button('<?php echo $value['symbol'];?>');" type="button">
                                Resume
                                </button>
                                <?php 
                                  }
                                  else if($pair->trade_status==1)
                                  {
                                     ?>
                                <button data-mdb-button-init data-mdb-ripple-init class="btn-outline-primary" type="button"   Onclick="pause_button('<?php echo $value['symbol'];?>');">
                                Pause
                                </button>
                                <?php
                                  }
                                  else if($pair->trade_status == 2)
                                  {
                                     ?>
                                <?php 
                                  } 
                                  
                                  if($pair->trade_status == 0 || $pair->trade_status == 1)
                                  {
                                     ?>
                                <!--<button data-mdb-button-init data-mdb-ripple-init class="btn btn-danger btn-sm mt-2" type="button" style="color:#fff;" Onclick="stop_button('<?php echo $value['symbol'];?>');">
                                  Stop
                                  </button>-->
                                <?php 
                                  } 
                                  
                                  
                                  }
                                  else
                                  { 
                                  ?>
                                <?php
                                  }
                                  ?>
                                <button class="btn-outline-primary" type="button"  style="margin:10px" onclick="view_trade('<?php echo $value['symbol'];?>');">View Trade</button>
                              </div>
                            </div>
                          </div>
                          <div class="qunatify-inner-sec">
                            <div class="quantify-inner-box d-flex align-items-center justify-content-between">
                              <div class="quantify-inner-box-left">
                                <small class="text-white-50 fs-6">Filled Amount (USDT)</small>
                                <h6 class="text-white fw-medium aleo"> <?php if(!empty($tradeupdate['trade_position_amount'])) { echo $tradeupdate['trade_position_amount']; } else echo 0;?></h6>
                              </div>
                              <?php 
                                if(!empty($tradeupdate['trade_rate_percentage']))
                                {
                                   $trade_percentage=$tradeupdate['trade_rate_percentage'];
                                }
                                else
                                {
                                   $trade_percentage='0';
                                }
                                   
                                if($trade_percentage=='')
                                   $trade_percentage='0';
                                
                                ?>
                              <div class="quantify-inner-box-right">
                                <small class="text-white-50 fs-6">Return Rate</small>
                                <h6 class="text-success fw-medium aleo"><?php echo $trade_percentage;?></h6>
                              </div>
                            </div>
                            <div class="row">
                              <div class="col-6">
                                <ul class="quantify-history quantify-history-left text-start list-unstyled mb-0">
                                  <li>Quantify</li>
                                  <li>Current Price</li>
                                  <li>Avg Price</li>
                                  <li>Coverage Price</li>
                                  <li>Liquidation Price</li>
                                </ul>
                              </div>
                              <div class="col-6">
                                <ul class="quantify-history quantify-history-right text-end list-unstyled mb-0">
                                  <li> <?php if(!empty($tradeupdate['trade_position_quantity'])) { echo $tradeupdate['trade_position_quantity']; } else { echo 0;}?></li>
                                  <li><?php echo number_format($live_price,9);?></li>
                                  <li><?php if(!empty($tradeupdate['trade_avg_position'])) { echo number_format($tradeupdate['trade_avg_position'],8); } else { echo 0; };?></li>
                                  <li><?php if(!empty($tradeupdate['down_price'])) { echo $tradeupdate['down_price'] ;} else { echo "< 0.0";}?></li>
                                  <li><?php if(!empty($tradeupdate['take_profit_trigger'])) { echo $tradeupdate['take_profit_trigger'];} else { echo "> 0.0";}?></li>
                                </ul>
                              </div>
                            </div>
                          </div>
                        </div>
                        <!-- Taping content end-->
                        <?php 
                          }
                          
                          
                          }
                          
                          ?>
                      </div>
                      <div class="tab-pane fade  show" id="pills-dep2" role="tabpanel"
                        aria-labelledby="pills-dep2-tab">
                        <?php 
                          $sno=0;
                          $pair =$this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and trade_status!= '2' and strategy_type='Single strategy' and exchange='".$exchange."' order by id desc")->getResult();
                          $j=0;
                          if($output)
                          {
                             foreach ($output as $key => $value) {
                                foreach($pair as $key => $value1){
                                if($value['symbol'] == $value1->pair){
                                      $output3[$j] = $value;
                                }
                                }
                                $j++;
                                }
                               
                          
                          }
                          if(!empty($output3))
                          {
                                foreach ($output3 as $key => $value) 
                                {
                                   $pair =$this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and pair='".$value['symbol']."' and trade_status!='2' and strategy_type='Single strategy' order by id desc")->getRow();
                                   if(!empty($pair))
                                   {
                                      $sync_strategy_status = $pair->sync_strategy_status ? $pair->sync_strategy_status : 0;
                                      $manual_buy = $this->db->table('api_manual_trade')->where('trade_process_id',$pair->id)->where('type',1)->where('status','1')->get()->getRow();
                                      $manual_sell = $this->db->table('api_manual_trade')->where('trade_process_id',$pair->id)->where('type',2)->where('status','1')->get()->getRow();
                                      $pair_trade_status=$pair->trade_status;
                                   }
                                   else
                                   {
                                      $sync_strategy_status='0';
                                      $pair_trade_status='';
                                   }
                          
                                   $live_price = $value['price'];
                                   
                                   $tradeupdate='';
                                   if($value['symbol']!='')
                                   {
                                    $tradeupdate=get_tradeinfo($value['symbol'],$live_price,$uusersid);
                                   }
                                   
                                        $base = substr($value['symbol'], 0, -4);
                                  $pair_disp=$base.'/USDT';
                          
                                 ?>
                        <?php 
                          if(!empty($pair)) 
                          {
                             
                              $call_limit=$trade_process->margin_column_limit;
                              
                              $get_last_trade=$this->db->query("select * from api_trade_history where trade_process_id='".$pair->id."' order by id desc limit 1")->getRow();
                              if($get_last_trade)
                              {
                                  $last_margin=$get_last_trade->margin_call_drops;
                              }
                              else
                              {
                                  $last_margin=0;
                              }
                              
                             if($pair->trade_status==1)
                             {
                                 $uusersid =$this->session->get("uusersid");
                                 $gas_balance = gas_wallet_bal($uusersid);
                                 
                                 if(!empty($tradeupdate['trade_position_amount'])) 
                                 {
                                     $filed_amount=$tradeupdate['trade_position_amount'];
                                 }
                                 else
                                 {
                                     $filed_amount='0';
                                 }
                                 
                                 $filed_amount=str_replace(',','',$filed_amount);
                                 $set_flag=0;
                                 if($min_gas_required > $gas_balance)
                                 {
                                     $api_trade_datas = array(
                                         'trade_log' => '2',
                                         'trade_status' => '0'
                                       );
                                     $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                     $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>';
                                     
                                 }
                                 else if($filed_amount > $usdt_balance)
                                 {
                                     /*if($call_limit > $last_margin)
                                     {
                                       $api_trade_datas = array(
                                         'trade_log' => '3',
                                         'trade_status' => '0'
                                         
                                        );
                                       $display_mode=' <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                     }*/
                                     
                                     $get_response=$this->db->query("select * from trade_process where id='".$pair->id."' and trade_log='3' and trade_status='0'")->getRow();
                                     if($get_response)
                                     {
                                       $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                      }
                                      else
                                      {
                                           $api_trade_datas = array(
                                             'trade_log' => '1',
                                             'trade_status' => '1'
                                            );
                                            
                                          $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>';
                                          $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                     
                                      }
                                 }
                                 else
                                 {
                                      $api_trade_datas = array(
                                         'trade_log' => '1',
                                         'trade_status' => '1'
                                         
                                        );
                                        
                                      $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>';
                                     $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                 }
                                 
                                 $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                 
                                
                                 //echo $display_mode; 
                                
                          
                          
                             }
                             else
                             {
                                if($pair->trade_log=='1')
                                {
                                    
                                     if($min_gas_required > $gas_balance)
                                       {
                                           $display_mode='<lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>';
                                       }
                                       else if($filed_amount > $usdt_balance)
                                       {
                                           if($call_limit > $last_margin)
                                           {
                                               $display_mode='<lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                           }
                                       }
                                       echo $display_mode;
                                ?>
                        <!--<lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-pause blue"></i> <span class="blue"> Pause </span></lable>-->
                        <?php 
                          }
                          else
                          {
                              $uusersid =$this->session->get("uusersid");
                              $gas_balance = gas_wallet_bal($uusersid);
                              
                               if(!empty($tradeupdate['trade_position_amount'])) 
                               {
                                   $filed_amount=$tradeupdate['trade_position_amount'];
                               }
                               else
                               {
                                   $filed_amount='0';
                               }
                               $filed_amount=str_replace(',','',$filed_amount);
                           
                               $set_flag=0;
                               if($min_gas_required > $gas_balance)
                               {
                                   $api_trade_datas = array(
                                       'trade_log' => '2',
                                       'trade_status' => '0'
                                     );
                                   $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                   $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>';
                                   
                               }
                               else if($filed_amount > $usdt_balance)
                               {
                                   /*if($call_limit > $last_margin)
                                   {
                                     $api_trade_datas = array(
                                       'trade_log' => '3',
                                       'trade_status' => '0'
                                       
                                      );
                                   $display_mode=' <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                   }*/
                                   
                                   $get_response=$this->db->query("select * from trade_process where id='".$pair->id."' and trade_log='3' and trade_status='0'")->getRow();
                                   if($get_response)
                                   {
                                     $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                   }
                                   else
                                   {
                                        $api_trade_datas = array(
                                       'trade_log' => '1',
                                       'trade_status' => '1'
                                        );
                                      
                                        $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>';
                                        $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                   
                                   }
                               }
                               else
                               {
                                    $api_trade_datas = array(
                                       'trade_log' => '1',
                                       'trade_status' => '1'
                                       
                                      );
                                      
                                    $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>';
                                   $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                               }
                           
                                $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                //echo $display_mode; 
                              
                          }
                          }
                          }
                          ?>
                        <!-- Taping content st-->
                        <div class="quantify-box py-4 myItems">
                          <div class="row">
                            <div class="col-6">
                              <div class="trade-using-coin d-flex align-items-center">
                                <div class="btc-ico">   <img style="width:30px;height:29px" src="<?php echo base_url('styles/images/tradingpair_images/'.$value['symbol'].'.png');?>" alt=""></div>
                                <div class="value-coin">
                                  <h4 class="text-white quantify-box-title"> <?php echo $pair_disp;?></h4>
                                </div>
                              </div>
                              <div class="qunatify-calls">
                                <a href="">
                                  <h6 class="text-white-50 fw-semibold"> No of Calls : <?php echo $last_margin;?></h6>
                                </a>
                              </div>
                            </div>
                            <div class="col-6">
                              <div class="pause-btn text-end">
                                <?php
                                  if(!empty($pair)) 
                                  {
                                     
                                  if($pair->trade_status == 0) 
                                  {
                                     ?>
                                <button data-mdb-button-init data-mdb-ripple-init class="btn-outline-primary" id="start_button" style="margin:10px" Onclick="start_button('<?php echo $value['symbol'];?>');" type="button">
                                Resume
                                </button>
                                <?php 
                                  }
                                  else if($pair->trade_status==1)
                                  {
                                     ?>
                                <button data-mdb-button-init data-mdb-ripple-init class="btn-outline-primary" type="button" style="margin:10px"  Onclick="pause_button('<?php echo $value['symbol'];?>');">
                                Pause
                                </button>
                                <?php
                                  }
                                  else if($pair->trade_status == 2)
                                  {
                                     ?>
                                <?php 
                                  } 
                                  
                                  if($pair->trade_status == 0 || $pair->trade_status == 1)
                                  {
                                     ?>
                                <!--<button data-mdb-button-init data-mdb-ripple-init class="btn btn-danger btn-sm mt-2" type="button" style="color:#fff;" Onclick="stop_button('<?php echo $value['symbol'];?>');">
                                  Stop
                                  </button>-->
                                <?php 
                                  } 
                                  
                                  
                                  }
                                  else
                                  { 
                                  ?>
                                <?php
                                  }
                                  ?>
                                <button class="btn-outline-primary" type="button" style="margin:10px" onclick="view_trade('<?php echo $value['symbol'];?>');">View Trade</button>
                                </a>
                              </div>
                            </div>
                          </div>
                          <div class="qunatify-inner-sec">
                            <div class="quantify-inner-box d-flex align-items-center justify-content-between">
                              <div class="quantify-inner-box-left">
                                <small class="text-white-50 fs-6">Filled Amount (USDT)</small>
                                <h6 class="text-white fw-medium aleo"><?php if(!empty($tradeupdate['trade_position_amount'])) { echo $tradeupdate['trade_position_amount']; } else echo 0;?></h6>
                              </div>
                              <?php 
                                if(!empty($tradeupdate['trade_rate_percentage']))
                                {
                                   $trade_percentage=$tradeupdate['trade_rate_percentage'];
                                }
                                else
                                {
                                   $trade_percentage='0';
                                }
                                
                                ?>
                              <div class="quantify-inner-box-right">
                                <small class="text-white-50 fs-6">Return Rate</small>
                                <h6 class="text-success fw-medium aleo"><?php echo $trade_percentage;?></h6>
                              </div>
                            </div>
                            <div class="row">
                              <div class="col-6">
                                <ul class="quantify-history quantify-history-left text-start list-unstyled mb-0">
                                  <li>Quantify</li>
                                  <li>Current Price</li>
                                  <li>Avg Price</li>
                                  <li>Coverage Price</li>
                                  <li>Liquidation Price</li>
                                </ul>
                              </div>
                              <div class="col-6">
                                <ul class="quantify-history quantify-history-right text-end list-unstyled mb-0">
                                  <li><?php if(!empty($tradeupdate['trade_position_quantity'])) { echo $tradeupdate['trade_position_quantity']; } else { echo 0;}?></li>
                                  <li><?php echo $live_price;?></li>
                                  <li>><?php if(!empty($tradeupdate['trade_avg_position'])) { echo number_format($tradeupdate['trade_avg_position'],8); } else { echo 0; };?></li>
                                  <li><?php if(!empty($tradeupdate['down_price'])) { echo $tradeupdate['down_price'] ;} else { echo "< 0.0";}?></li>
                                  <li><?php if(!empty($tradeupdate['take_profit_trigger'])) { echo $tradeupdate['take_profit_trigger'];} else { echo "> 0.0";}?></li>
                                </ul>
                              </div>
                            </div>
                          </div>
                        </div>
                        <!-- Taping content end-->
                        <?php 
                          }
                          }
                          
                          ?>
                      </div>
                      <div class="tab-pane fade  show" id="pills-dep3" role="tabpanel"
                        aria-labelledby="pills-dep3-tab">
                        <?php 
                          $sno=0;
                          $pair =$this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and trade_status!='2' and strategy_type!='Single strategy' and exchange='".$exchange."' order by id desc")->getResult();
                          
                          $j=0;
                          if($output)
                          {
                             foreach ($output as $key => $value) 
                             {
                                
                                foreach($pair as $key => $value1)
                                {
                                   if($value['symbol'] == $value1->pair)
                                   {
                                      $output4[$j] = $value;
                                   }
                                }
                                
                                $j++;
                             }
                              
                          
                          }
                          
                          
                          if(!empty($output4))
                          {
                                foreach ($output4 as $key => $value) 
                                {
                                   $pair =$this->db->query("SELECT * FROM trade_process WHERE uusersid='".$uusersid."' and pair='".$value['symbol']."' and trade_status!='2' and strategy_type!='Single strategy' order by id desc")->getRow();
                                   if(!empty($pair))
                                   {
                                      $sync_strategy_status = $pair->sync_strategy_status ? $pair->sync_strategy_status : 0;
                                      $manual_buy = $this->db->table('api_manual_trade')->where('trade_process_id',$pair->id)->where('type',1)->where('status','1')->get()->getRow();
                                      $manual_sell = $this->db->table('api_manual_trade')->where('trade_process_id',$pair->id)->where('type',2)->where('status','1')->get()->getRow();
                                      $pair_trade_status=$pair->trade_status;
                                   }
                                   else
                                   {
                                      $sync_strategy_status='0';
                                      $pair_trade_status='';
                                   }
                          
                                   $live_price = $value['price'];
                                   $tradeupdate='';
                                 if($value['symbol']!='')
                                 {
                                   $tradeupdate=get_tradeinfo($value['symbol'],$live_price,$uusersid);
                                 }
                                 
                                      $base = substr($value['symbol'], 0, -4);
                                     $pair_disp=$base.'/USDT';
                          
                          
                             ?>
                        <?php 
                          if(!empty($pair)) 
                          {
                              
                              $call_limit=$trade_process->margin_column_limit;
                              
                              $get_last_trade=$this->db->query("select * from api_trade_history where trade_process_id='".$pair->id."' order by id desc limit 1")->getRow();
                              if($get_last_trade)
                              {
                                  $last_margin=$get_last_trade->margin_call_drops;
                              }
                              else
                              {
                                  $last_margin=0;
                              }
                             
                             if($pair->trade_status==1)
                             {
                                 $uusersid =$this->session->get("uusersid");
                                 $gas_balance = gas_wallet_bal($uusersid);
                                 
                                 if(!empty($tradeupdate['trade_position_amount'])) 
                                 {
                                     $filed_amount=$tradeupdate['trade_position_amount'];
                                 }
                                 else
                                 {
                                     $filed_amount='0';
                                 }
                                 
                                 $filed_amount=str_replace(',','',$filed_amount);
                                 $set_flag=0;
                                 if($min_gas_required > $gas_balance)
                                 {
                                     $api_trade_datas = array(
                                         'trade_log' => '2',
                                         'trade_status' => '0'
                                       );
                                     $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                     $display_mode=' <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>';
                                     
                                 }
                                 else if($filed_amount > $usdt_balance)
                                 {
                                     
                                     /*if($call_limit > $last_margin)
                                     {
                                          $api_trade_datas = array(
                                         'trade_log' => '3',
                                         'trade_status' => '0'
                                         );
                                         $display_mode=' <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                     }*/
                                     
                                     $get_response=$this->db->query("select * from trade_process where id='".$pair->id."' and trade_log='3' and trade_status='0'")->getRow();
                                     if($get_response)
                                     {
                                         $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                     }
                                     else
                                     {
                                          $api_trade_datas = array(
                                             'trade_log' => '1',
                                             'trade_status' => '1'
                                            );
                                            
                                          $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>';
                                          $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                         
                                     }
                                 }
                                 else
                                 {
                                      $api_trade_datas = array(
                                         'trade_log' => '1',
                                         'trade_status' => '1'
                                         
                                        );
                                        
                                      $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>';
                                     $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                 }
                                 
                                
                                 
                                
                                // echo $display_mode; 
                                
                          
                          
                             }
                             else
                             {
                                if($pair->trade_log=='1')
                                {
                                    
                                     if($min_gas_required > $gas_balance)
                                    {
                                        $display_mode='<lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>';
                                    }
                                    else if($filed_amount > $usdt_balance)
                                    {
                                        if($call_limit > $last_margin)
                                        {
                                            $display_mode='<lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                        }
                                    }
                                    echo $display_mode;
                                ?>
                        <!--<lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-pause blue"></i> <span class="blue"> Pause </span></lable>-->
                        <?php 
                          }
                          else
                          {
                              $uusersid =$this->session->get("uusersid");
                              $gas_balance = gas_wallet_bal($uusersid);
                              
                               if(!empty($tradeupdate['trade_position_amount'])) 
                               {
                                   $filed_amount=$tradeupdate['trade_position_amount'];
                               }
                               else
                               {
                                   $filed_amount='0';
                               }
                           
                               $filed_amount=str_replace(',','',$filed_amount);
                               $set_flag=0;
                               if($min_gas_required > $gas_balance)
                               {
                                   $api_trade_datas = array(
                                       'trade_log' => '2',
                                       'trade_status' => '0'
                                     );
                                   $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                   $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> Fuel </span></lable>';
                                   
                               }
                               else if($filed_amount > $usdt_balance)
                               {
                                   /*if($call_limit > $last_margin)
                                   {
                                     $api_trade_datas = array(
                                       'trade_log' => '3',
                                       'trade_status' => '0'
                                       
                                      );
                                   $display_mode=' <lable class="btn btn-default" style="float:right;background:#fff;"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                   }*/
                                   
                                   $get_response=$this->db->query("select * from trade_process where id='".$pair->id."' and trade_log='3' and trade_status='0'")->getRow();
                                   if($get_response)
                                   {
                                       $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-warning orange"></i> <span class="orange"> USDT </span></lable>';
                                   }
                                   else
                                   {
                                        $api_trade_datas = array(
                                       'trade_log' => '1',
                                       'trade_status' => '1'
                                      );
                                      
                                    $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>';
                                    $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                                   
                                   }
                               }
                               else
                               {
                                    $api_trade_datas = array(
                                       'trade_log' => '1',
                                       'trade_status' => '1'
                                       
                                      );
                                      
                                    $display_mode=' <lable class="btn-outline-primary cs"><i class="fa fa-check-circle green"></i> <span class="green"> Trade </span></lable>';
                                   $this->db->table('trade_process')->set($api_trade_datas)->where("id",$pair->id)->update();
                               }
                           
                                   
                           
                          
                                   //echo $display_mode; 
                              
                          }
                          }
                          }
                          ?>
                        <div class="quantify-box py-4 myItems">
                          <div class="row">
                            <div class="col-6">
                              <div class="trade-using-coin d-flex align-items-center">
                                <div class="btc-ico">   <img style="width:30px;height:29px" src="<?php echo base_url('styles/images/tradingpair_images/'.$value['symbol'].'.png');?>" alt=""></div>
                                <div class="value-coin">
                                  <h4 class="text-white quantify-box-title">  <?php echo $pair_disp;?></h4>
                                </div>
                              </div>
                              <div class="qunatify-calls">
                                <a href="">
                                  <h6 class="text-white-50 fw-semibold"> No of Calls : <?php echo $last_margin;?></h6>
                                </a>
                              </div>
                            </div>
                            <div class="col-6">
                              <div class="pause-btn text-end">
                                <?php
                                  if(!empty($pair)) 
                                  {
                                     
                                  if($pair->trade_status == 0) 
                                  {
                                     ?>
                                <button data-mdb-button-init data-mdb-ripple-init class="btn-outline-primary" id="start_button" style="margin:10px" Onclick="start_button('<?php echo $value['symbol'];?>');" type="button">
                                Resume
                                </button>
                                <?php 
                                  }
                                  else if($pair->trade_status==1)
                                  {
                                     ?>
                                <button data-mdb-button-init data-mdb-ripple-init class="btn-outline-primary" type="button" style="margin:10px" Onclick="pause_button('<?php echo $value['symbol'];?>');">
                                Pause
                                </button>
                                <?php
                                  }
                                  else if($pair->trade_status == 2)
                                  {
                                     ?>
                                <?php 
                                  } 
                                  
                                  if($pair->trade_status == 0 || $pair->trade_status == 1)
                                  {
                                     ?>
                                <!--<button data-mdb-button-init data-mdb-ripple-init class="btn btn-danger btn-sm mt-2" type="button" style="color:#fff;" Onclick="stop_button('<?php echo $value['symbol'];?>');">
                                  Stop
                                  </button>-->
                                <?php 
                                  } 
                                  
                                  
                                  }
                                  else
                                  { 
                                  ?>
                                <?php
                                  }
                                  ?>
                                <button class="btn-outline-primary" type="button" style="margin:10px" onclick="view_trade('<?php echo $value['symbol'];?>');">View Trade</button>
                              </div>
                            </div>
                          </div>
                          <div class="qunatify-inner-sec">
                            <div class="quantify-inner-box d-flex align-items-center justify-content-between">
                              <div class="quantify-inner-box-left">
                                <small class="text-white-50 fs-6">Filled Amount (USDT)</small>
                                <h6 class="text-white fw-medium aleo"> <?php if(!empty($tradeupdate['trade_position_amount'])) { echo $tradeupdate['trade_position_amount']; } else echo 0;?></h6>
                              </div>
                              <?php 
                                if(!empty($tradeupdate['trade_rate_percentage']))
                                {
                                   $trade_percentage=$tradeupdate['trade_rate_percentage'];
                                }
                                else
                                {
                                   $trade_percentage='0';
                                }
                                ?>
                              <div class="quantify-inner-box-right">
                                <small class="text-white-50 fs-6">Return Rate</small>
                                <h6 class="text-success fw-medium aleo"><?php echo $trade_percentage;?></h6>
                              </div>
                            </div>
                            <div class="row">
                              <div class="col-6">
                                <ul class="quantify-history quantify-history-left text-start list-unstyled mb-0">
                                  <li>Quantify</li>
                                  <li>Current Price</li>
                                  <li>Avg Price</li>
                                  <li>Coverage Price</li>
                                  <li>Liquidation Price</li>
                                </ul>
                              </div>
                              <div class="col-6">
                                <ul class="quantify-history quantify-history-right text-end list-unstyled mb-0">
                                  <li><?php if(!empty($tradeupdate['trade_position_quantity'])) { echo $tradeupdate['trade_position_quantity']; } else { echo 0;}?></li>
                                  <li><?php echo $live_price;?></li>
                                  <li><?php if(!empty($tradeupdate['trade_avg_position'])) { echo number_format($tradeupdate['trade_avg_position'],8); } else { echo 0; };?></li>
                                  <li><?php if(!empty($tradeupdate['down_price'])) { echo $tradeupdate['down_price'] ;} else { echo "< 0.0";}?></li>
                                  <li><?php if(!empty($tradeupdate['take_profit_trigger'])) { echo $tradeupdate['take_profit_trigger'];} else { echo "> 0.0";}?></li>
                                </ul>
                              </div>
                            </div>
                          </div>
                        </div>
                        <!-- Taping content end-->
                        <?php 
                          }
                          }
                          ?>
                      </div>
                      <!---banner end---->
                    </div>
                    <!-- Pagination -->
                    <div class="pagination" style="margin-bottom:15px">
                      <button id="prevPage" class="pagination-btn" onclick="changePage('prev')" <?php echo ($current_page == 1) ? 'disabled' : ''; ?>>« Previous</button>
                      <!-- <span id="pageInfo" class="mx-3 align-self-center">Page <?php //echo $current_page; ?> of <?php //echo $total_pages; ?></span> -->
                      <button id="nextPage" class="pagination-btn" onclick="changePage('next')" <?php echo ($current_page == $total_pages) ? 'disabled' : ''; ?>>Next »</button>
                    </div>
                    
                    <p style="color:#fff;"><b>Trade Pilot:</b> Our mission is to empower investors by optimizing their profit potential, even during times when they are busy, asleep, or occupied with other commitments. Our cutting-edge platform ensures seamless and efficient trading, enabling investors to achieve consistent results without constant monitoring.</p>
                  
                  <div style="clear:both;height:20px;"><br></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <?php } ?>
        </div>
      </section>
      <!--footer start -->
      <?php echo view('user/layout/footer');?>
      <!--footer end -->
    </section>
    <?php echo view('user/layout/footer-script');?>
    <script>
      AOS.init({
      });
    </script>
    <script src="<?php echo base_url();?>/styles/new_style/js/notify.js"></script>
    <script type="text/javascript">
      function view_trade(str)
      {
        window.location="<?php echo base_url();?>/tradedetails/"+str;
      }
      
      function myFunction() {
      var input, filter, cards, cardContainer, h5, title, i;
      input = document.getElementById("myFilter");
      filter = input.value.toUpperCase();
      //cardContainer = document.getElementById("myItems");
      cards = document.getElementsByClassName("myItems");
      for (i = 0; i < cards.length; i++) {
      title = cards[i].querySelector(".value-coin .quantify-box-title");
      if (title.innerText.toUpperCase().indexOf(filter) > -1) {
         cards[i].style.display = "";
      } else {
         cards[i].style.display = "none";
      }
      }
      }
      
      function myFunction1() {
      var input, filter, cards, cardContainer, h5, title, i;
      input = document.getElementById("myFilter1");
      filter = input.value.toUpperCase();
      cardContainer = document.getElementById("myItems1");
      cards = cardContainer.getElementsByClassName("card");
      for (i = 0; i < cards.length; i++) {
      title = cards[i].querySelector(".card-body h5.card-title");
      if (title.innerText.toUpperCase().indexOf(filter) > -1) {
         cards[i].style.display = "";
      } else {
         cards[i].style.display = "none";
      }
      }
      }
      
      
      function myFunction2() {
      
      var input, filter, cards, cardContainer, h5, title, i;
      input = document.getElementById("myFilter2");
      filter = input.value.toUpperCase();
      cardContainer = document.getElementById("myItems2");
      cards = cardContainer.getElementsByClassName("card");
      for (i = 0; i < cards.length; i++) {
      title = cards[i].querySelector(".card-body h5.card-title");
      if (title.innerText.toUpperCase().indexOf(filter) > -1) {
         cards[i].style.display = "";
      } else {
         cards[i].style.display = "none";
      }
      }
      }
    </script>
    <script type="text/javascript">
      function start_button(str)
      {
         var avaialabe_fuel_fee     =  '<?php echo $buy_bal ? $buy_bal : 0;?>';
         var fuel_fee               = '<?php echo $tradSet->min_fuel_fee ? $tradSet->min_fuel_fee : 0 ;?>';
         var activate               = '<?php echo $activation ? $activation : 0; ?>';
         var fuel_gas               = '<?php echo $tradSet->min_fuel ? $tradSet->min_fuel : 10 ;?>';
         var usdt_balance = '<?php echo $usdt_balance ? $usdt_balance : 0 ;?>';
         var uusersid='<?php echo $this->session->get('uusersid');?>';
         var exchange ='<?php echo $this->session->get('exchange');?>';
        
         if(activate)
         {
            if(parseFloat(avaialabe_fuel_fee.replace(',',''))>=parseFloat(fuel_gas))
            {
      
                  if(<?php echo $bind_api ? $bind_api : 0;?>)
                  {
                     $.notify(' <i class="fas fa-check-circle"></i>  Please wait.', 'success'); 
      
                        $.ajax({
                        'method': 'POST',
                        'url': '<?php echo base_url("/traderesume");?>',
                           data:{'id':str,'uusersid':uusersid,'uri':str,'pair':str,'exchange':exchange },
                        success:function(msg)
                        {
                           $.notify(' <i class="fas fa-check-circle"></i>  Trade started successfully', 'success'); 
                           window.location.reload();
                        }
                     })
                  }
                  else
                  {
                     $.notify(' <i class="fas fa-exclamation-triangle"></i>  Please bind your api to start the trade. ', 'danger');
                  }
      
            }
            else
            {
               
                $.notify(' <i class="fas fa-exclamation-triangle"></i>  Please recharge fuel. '+avaialabe_fuel_fee, 'danger');
            }
         }
         else
         {
            $.notify(' <i class="fas fa-exclamation-triangle"></i>  Please activate the robot first ', 'danger');
         }    
      
      }
      
      
      function pause_button(str)
      {
         var uusersid='<?php echo $this->session->get('uusersid');?>';
         $.ajax({
         'method': 'POST',
         'url': '<?php echo base_url("/tradingprocess1");?>',
            data:{'id':str,'uusersid':uusersid,'uri':str },
         success:function(msg)
         {
            $.notify(' <i class="fas fa-check-circle"></i>  Trade paused successfully', 'success'); 
            window.location.reload();
         }
         })
      
      }
      
      function stop_button(str)
      {
         var pair_id="<?php if(!empty($pair)){ echo $pair->id;}?>";
         var uusersid='<?php echo $this->session->get('uusersid');?>';
         $.ajax({
         'method': 'POST',
         'url': '<?php echo base_url("/tradingprocess2");?>',
            data:{'id':str,'uusersid':uusersid,'uri':str,'pair':pair_id,'exchange':'1' },
         success:function(msg)
         {
            $.notify(' <i class="fas fa-check-circle"></i>  Trade stopped successfully', 'success'); 
            // console.log(msg);
            window.location.reload();
         }
         })
      
      }
      
      
      document.getElementById('balance_load').addEventListener('click', function() {
      
      
      this.classList.add('spin');
      read_function();
      setTimeout(() => {
      
      this.classList.remove('spin');
      }, 1000); // Duration of the animation in milliseconds
      });
      
      
      function read_function()
      {
         var uusersid='<?php echo $this->session->get('uusersid');?>';
         var exchange_id='<?php echo $exchange;?>';
         $.ajax({
         'method': 'POST',
         'url': '<?php echo base_url("/balance_update");?>',
            data:{'exchange':exchange_id,'uusersid':uusersid},
         success:function(msg)
         {
            $("#balance_update").html(msg);
         }
         })
      }
      
      
    </script>
    <script>
      document.addEventListener('DOMContentLoaded', function() {
          // Initialize Bootstrap dropdowns
          const dropdowns = document.querySelectorAll('.dropdown-toggle');
          dropdowns.forEach(dropdown => {
              dropdown.addEventListener('click', function(e) {
                  e.preventDefault();
                  const dropdownMenu = this.nextElementSibling;
                  dropdownMenu.classList.toggle('show');
              });
          });
      
          // Close dropdown when clicking outside
          document.addEventListener('click', function(e) {
              if (!e.target.matches('.dropdown-toggle') && !e.target.closest('.dropdown-menu')) {
                  const openMenus = document.querySelectorAll('.dropdown-menu.show');
                  openMenus.forEach(menu => {
                      menu.classList.remove('show');
                  });
              }
          });
      
          // Search/filter function for dropdown items
      function filterPairs() {
      const input = document.getElementById('pairSearch');
      const filter = input.value.toUpperCase();
      const pairList = document.getElementById('pairList');
      const items = Array.from(document.querySelectorAll('#pairList .dropdown-item'));
      
      // First show all items
      items.forEach(item => {
        item.style.display = "flex";
      });
      
      if (filter) {
        // Sort items - matching items first
        items.sort((a, b) => {
            const aText = a.textContent.toUpperCase();
            const bText = b.textContent.toUpperCase();
            
            const aMatch = aText.includes(filter);
            const bMatch = bText.includes(filter);
            
            if (aMatch && !bMatch) return -1;
            if (!aMatch && bMatch) return 1;
            return 0;
        });
        
        // Re-append sorted items to maintain order
        items.forEach(item => pairList.appendChild(item));
        
        // Hide non-matching items if you want
        items.forEach(item => {
            const text = item.textContent.toUpperCase();
            if (!text.includes(filter)) {
                item.style.display = "none";
            }
        });
      }
      }
      
          // Select pair function
          function selectPair(pair) {
              // First hide all items
              const cards = document.getElementsByClassName("myItems");
              for (let i = 0; i < cards.length; i++) {
                  cards[i].style.display = "none";
              }
              
              // Then show only the selected pair
              for (let i = 0; i < cards.length; i++) {
                  const title = cards[i].querySelector(".value-coin .quantify-box-title");
                  if (title && title.innerText.includes(pair)) {
                      cards[i].style.display = "";
                      
                      // Scroll to and highlight the card
                      setTimeout(() => {
                          cards[i].scrollIntoView({ behavior: 'smooth', block: 'center' });
                          cards[i].classList.add('highlight-pair');
                          setTimeout(() => cards[i].classList.remove('highlight-pair'), 2000);
                      }, 100);
                      
                      // Update dropdown button
                      const dropdownBtn = document.getElementById('pairDropdown');
                      if (dropdownBtn) {
                          dropdownBtn.innerHTML = `<i class="fas fa-check-circle me-2"></i> ${pair}`;
                      }
                      
                      // Close dropdown
                      const dropdownMenu = document.querySelector('.dropdown-menu.show');
                      if (dropdownMenu) {
                          dropdownMenu.classList.remove('show');
                      }
                      
                      return; // Exit after finding the pair
                  }
              }
              
              // If not found on current page, redirect to proper page
              const allPairs = <?php echo json_encode($all_pairs); ?>;
              const perPage = <?php echo $perPage; ?>;
              const pairIndex = allPairs.indexOf(pair);
              
              if (pairIndex >= 0) {
                  const page = Math.floor(pairIndex / perPage) + 1;
                  window.location.href = `?page=${page}&highlight=${encodeURIComponent(pair)}`;
              }
          }
      
          // On page load, check for highlight parameter
          const urlParams = new URLSearchParams(window.location.search);
          const highlightPair = urlParams.get('highlight');
          
          if (highlightPair) {
              // Clean up URL
              history.replaceState(null, '', window.location.pathname + '?page=' + urlParams.get('page'));
              
              // Select the highlighted pair
              selectPair(highlightPair);
          }
      
          // Reset filter function
          function resetFilter() {
              // Show all items
              const cards = document.getElementsByClassName("myItems");
              for (let i = 0; i < cards.length; i++) {
                  cards[i].style.display = "";
              }
              
              // Reset dropdown button
              const dropdownBtn = document.getElementById('pairDropdown');
              if (dropdownBtn) {
                  dropdownBtn.innerHTML = '<i class="fas fa-search me-2"></i> Search Trading Pairs';
              }
              
              // Reset search input
              const searchInput = document.getElementById('pairSearch');
              if (searchInput) {
                  searchInput.value = '';
              }
              
              // Show all items in dropdown
              const items = document.querySelectorAll('#pairList .dropdown-item');
              items.forEach(item => {
                  item.style.display = "flex";
              });
              
              // Reset to page 1
              window.location.href = '?page=1';
          }
      
          // Initialize search input event listener
          const pairSearch = document.getElementById('pairSearch');
          if (pairSearch) {
              pairSearch.addEventListener('keyup', filterPairs);
          }
      
          // Make functions available globally
          window.filterPairs = filterPairs;
          window.selectPair = selectPair;
          window.resetFilter = resetFilter;
      });
      
      // Pagination functions
      function changePage(direction) {
          const currentPage = <?php echo $current_page; ?>;
          const totalPages = <?php echo $total_pages; ?>;
          let newPage = currentPage;
          
          if (direction === 'prev' && currentPage > 1) {
              newPage = currentPage - 1;
          } else if (direction === 'next' && currentPage < totalPages) {
              newPage = currentPage + 1;
          }
          
          if (newPage !== currentPage) {
              window.location.href = `?page=${newPage}`;
          }
      }
    </script>
  </body>
</html>
