<?php
   use App\Libraries\MyEncrypt;
   use App\Models\CommonModel;
   $session = session();
   $validation =  \Config\Services::validation();
   $this->db = db_connect();
   
   $CommonModel = model('CommonModel');
   $header_data = $CommonModel->GetSiteSettings('site');
   if(!$header_data){
   	$header_data = $CommonModel->defaultlangSettingall('site');
   }
   foreach ($header_data as $row) 
   {
   	$headers[$row->site_key] = $row->site_value;
   }
   ?>

<!doctype html>
<html lang="en"  class="w-[640px]">
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <title><?php echo $headers['site_meta_title'];?></title>
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <meta name="keywords" content="<?php echo $headers['site_meta_key'];?>" />
      <meta name="description" content="<?php echo $headers['site_meta_description'];?>" />
      <!--Basic Bootstrap-->
      <link href="<?php echo base_url();?>/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
      <!--Font icons-->
      <link href="<?php echo base_url();?>/assets/css/all.css"  rel="stylesheet" type="text/css">
      <!--Carousel Slider-->
      <link href="<?php echo base_url();?>/assets/css/owl.carousel.min.css" rel="stylesheet" type="text/css">
      <link href="<?php echo base_url();?>/assets/css/owl.theme.default.min.css" rel="stylesheet" type="text/css">
      <!--fonts-->
      <link href="https://fonts.googleapis.com/css2?family=Mulish:ital,wght@0,200..1000;1,200..1000&display=swap" rel="stylesheet">
      <link href="https://fonts.googleapis.com/css2?family=Aleo:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
      <link href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap" rel="stylesheet">
      <!--animate CSS -->
      <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/aos.css">
      <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/animate.css">
      <!--Theme CSS -->
      <link rel="stylesheet" type="text/css" href="<?php echo base_url();?>/assets/css/style.css">
   </head>
   <style>
      .help-block {
    	color:red;
    	font-size:12px;
    	font-weight:bold;
    }
   </style>
   <body class="section-overflow">
      <section class="banner-bg bg-grade1 position-relative">
         <ul class="added-banner-images list-unstyled mb-0">
            <li><img src="<?php echo base_url();?>/assets/images/banner-number.png" alt=""></li>
            <li><img src="<?php echo base_url();?>/assets/images/banner-trade.png" alt=""></li>
            <li><img src="<?php echo base_url();?>/assets/images/banner-curve.png" alt=""></li>
            <li><img src="<?php echo base_url();?>/assets/images/banner-statistics.png" alt=""></li>
         </ul>
         <!-- common-header start-->
         <div class="container">
            <header class="pt-3 pb-3 position-relative">
               <div class="row">
                  <div class="col-6">
                     <div class="back-arrow">
                        <a href="<?php echo base_url();?>/login">
                           <iconify-icon icon="bi:arrow-left-circle-fill"></iconify-icon>
                        </a>
                     </div>
                  </div>
                  <div class="col-6">
                     <div class="common-icon d-flex align-items-center justify-content-end">
                        <div class="wallet-icon header-icon me-2">
                           <a href="<?php echo base_url();?>/user/asset" class="text-decoration-none ">
                              <iconify-icon icon="ph:wallet-bold"></iconify-icon>
                           </a>
                        </div>
                        <div class="header-icon">
                           <a href="<?php echo base_url();?>/news" class="text-decoration-none">
                              <iconify-icon icon="mdi:notifications-none"></iconify-icon>
                           </a>
                        </div>
                     </div>
                  </div>
               </div>
            </header>
            <!-- common-header end-->
         </div>
         <!-- wrapper-content start -->
         <section class="dash-wrap reg-wrap">
            <div class="container">
               <div class="row">
                  <div class="col-12">
                     <div class="banner position-relative  pt-3">
                        <div class="added-number">
                           <h5 class="fw-bold text-white">#010038</h5>
                        </div>
                        <div class="row">
                           <div class="col-6">
                              <div class="banner-content">
                                 <h2 class="fw-bold text-white">Hello,</h2>
                                 <h5 class="text-white"> Welcome</h5>
                                 <h1 class="text-primary aleo">Trade Pilot</h1>
                              </div>
                           </div>
                           <div class="col-6">
                              <div class="banner-img">
                                 <img src="<?php echo base_url();?>/assets/images/banner-img.png" alt="">
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-12">
                     <div class="form-page position-relative">
                        <div class="form-title text-center ">
                           <h1 class="text-white aleo  ">Sign Up</h1>
                        </div>
                        
                        <label for="" class="form-label text-primary"><i class="fa-solid fa-user me-2"></i>Personal Details </label>
                        <form class="create-user " id="register" method="post" action="<?php echo base_url();?>/user/register/reg">
                        <div class="col-12">
                          <div class="form-block  form-group  position-relative">
                            <span>Country</span>
                              <select class="form-control ps-2 form-arrow" name="country">
                              <option value="">  Country </option>
                              <?php foreach ($country as $country) 
                                    { 
                                          $ms="MY";
                                        
                                      ?>
                                 <option value="<?php echo $country->iso_2; ?>" <?php if($country->iso_2==$ms) { echo "selected==selected";}?>><?php echo $country->Country;?></option>
                                 <?php } ?>
                              </select>
                           </div>
                        </div>

                        <div class="col-12">
                           <div class="form-block  form-group  position-relative">
                              <span>Username</span>
                              <input type="text" class="form-control" placeholder="Username" name="username" id="username">
                           </div>
                        </div>

                        <div class="col-12">
                           <div class="form-block form-group  position-relative">
                              <span> Email</span>
                              <input type="text" class="form-control" placeholder=" Email id" id="email" name="email"  >
                           </div>
                        </div>

                        <div class="col-12">
                           <div class="form-block form-group  position-relative">
                              <span> Invitation Code </span>
                              <input type="text" class="form-control" placeholder="Invitation code" id="invitor_code" name="invitor_code" value="<?php echo $referral;?>">
                           </div>
                        </div>

                        <label for="" class="form-label  text-primary"><i class="fa-solid fa-lock me-2"></i>Security Details</label>
                        <div class="col-12">
                           <div class="form-block form-group  position-relative">
                           
                              <div class="form-ico">
                                 <iconify-icon icon="mdi:eye-off-outline" id="togglePasswordIcon"></iconify-icon>
                              </div>
                              <span>Password</span>
                              <input autocomplete="off"  type="password" class="form-control" placeholder="Enter Password" name="password" id="password">
                           </div>
                           <div id="pass_error" class="help-block"></div>
                        </div>

                        <div class="row" style="margin-top:10px">
                        <div class="col-sm-12">
                           <div class="rules">
                              <div id="disp1" style="display:none;">
                                 <p class="text-success mb-0">
                                    <iconify-icon icon="mdi:tick-circle-outline" class="me-2"></iconify-icon>
                                    Please ensure your entry consists of at least 8 characters
                                 </p>
                              </div>
                              <div id="disp1a">
                                 <p class="text-white mb-0">
                                    <iconify-icon icon="clarity:success-standard-solid" class="me-2"></iconify-icon>
                                    Please ensure your entry consists of at least 8 characters
                                 </p>
                              </div>
                              <div id="disp2" style="display:none;">
                                 <p class="text-success mb-0">
                                    <iconify-icon icon="mdi:tick-circle-outline" class="me-2"></iconify-icon>
                                    Please include at least 1 uppercase character in your entry.
                                 </p>
                              </div>
                              <div id="disp2a">
                                 <p class="text-white mb-0">
                                    <iconify-icon icon="clarity:success-standard-solid" class="me-2" ></iconify-icon>
                                    Please include at least 1 uppercase character in your entry.
                                 </p>
                              </div>
                              <div id="disp3" style="display:none;">
                                 <p class="text-success mb-0">
                                    <iconify-icon icon="mdi:tick-circle-outline" class="me2"></iconify-icon>
                                    Please ensure your entry contains at least 1 numerical digit
                                 </p>
                              </div>
                              <div id="disp3a">
                                 <p class="text-white mb-0">
                                    <iconify-icon icon="clarity:success-standard-solid" class="me-2"></iconify-icon>
                                    Please ensure your entry contains at least 1 numerical digit
                                 </p>
                              </div>
                              <div id="disp4" style="display:none;">
                                 <p class="text-success mb-0">
                                    <iconify-icon icon="mdi:tick-circle-outline" class="me-2"></iconify-icon>
                                    Please include at least 1 special character (e.g., ?/#~!) in your entry.
                                 </p>
                              </div>
                              <div id="disp4a">
                                 <p class="text-white">
                                    <iconify-icon icon="clarity:success-standard-solid" class="me-2"></iconify-icon>
                                    Please include at least 1 special character (e.g., ?/#~!) in your entry.
                                 </p>
                              </div>
                           </div>
                        </div>
                     </div>
                     <input type='hidden' name="ps_sudo1" id="ps_sudo1" value='0'>
                     <input type='hidden' name="ps_sudo2" id="ps_sudo2" value='0'>
                     <input type='hidden' name="ps_sudo3" id="ps_sudo3" value='0'>
                     <input type='hidden' name="ps_sudo4" id="ps_sudo4" value='0'>

                    

                        <div class="col-12">
                           <div class="form-block form-group  position-relative">
                              <div class="form-ico">
                                 <iconify-icon icon="mdi:eye-off-outline" id="togglePasswordIcon1"></iconify-icon>
                              </div>
                              <span>Security Pin</span>
                              <input type="password" class="form-control" placeholder="Security PIN" maxLength="6" name="trans_pin" id="trans_pin">
                           </div>
                        </div>

                        <div class="col-12">
                           <div class="form-block form-group position-relative">
                           <label for="" class="form-label text-primary"><i class="fa-solid fa-shield me-2"></i> Email Verification </label>
                              <div class="form-ico" style="margin-top:27px !important">
                              <button type="button" style="padding:5px 10px !important" name="getcode" id="getcode"  class="btn btn-primary">SEND</button>
                              </div>
                              <input type="text" class="form-control" name="code1" id="code1"  maxLength="6"  placeholder="Verfication Code">
                           </div>
                           <div id="otpmsg"></div>

                        </div>
 
                        <div class="col-12">
                           <p class="text-white mb-0">  *The TAC code will be sent to your registered email address</p>
                        </div>
                      

                        <div class="col-12">
                           <!-- <div class="checkbox mt-4">
                              <label class="text-white fw-bold fs-6">
                              <input type="checkbox" value="remember-me">
                              I have read the  <a href="" class="text-decoration-none inner-foot-link"> privacy agreement</a> </label>
                           </div> -->
                           <div class="form-btn my-4 text-center">
                           <button class="btn btn-primary" type="submit">
                           Register Your Account
                                 </button></div>
                        </div>

                        </form>

                     </div>
                  </div>
               </div>
            </div>
         </section>
         <!-- wrapper-content end-->
         <div class="container">
            <div class="row">
               <div class="cpy-rights text-center pt-4 ">
                  <h6 class="fs-6 text-black fw-bold">@ <?php echo date("Y");?> <a href="#">Trade Bot Auto Trading.</a> All Rights Reserved </h6>
               </div>
            </div>
         </div>
         </div>
      </section>
      <!-- Modal -->
      <div class="modal fade  modal-fullscreen" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
         <div class="modal-dialog">
            <div class="modal-content">
               <div class="modal-body">
                  <button type="button"    class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="float: right;"></button>
                  <div class="embed-responsive embed-responsive-16by9">

                  </div>
               </div>
            </div>
         </div>
      </div>
     

      <script src="<?php echo base_url();?>/styles/web_style/js/jquery.min.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/bootstrap.min.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/script.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/iconify-icon.min.js"></script>
      <script src="<?php echo base_url();?>/styles/web_style/js/owl.carousel.min.js"></script>

      <script>
         AOS.init({
         });
      </script>
      <!-- <script>
         // Get the country code select and phone number input
         const countryCodeSelect = document.getElementById('countryCode');
         const phoneNumberInput = document.getElementById('phoneNumber');
         
         // Event listener to update phone number field when country code changes
         countryCodeSelect.addEventListener('change', function() {
           const selectedCode = countryCodeSelect.value;
           phoneNumberInput.value = selectedCode + " ";  // Adds the country code with a space
         });
         
         // Initial value on page load (in case there's a default country code selected)
         phoneNumberInput.value = countryCodeSelect.value + " ";
      </script> -->

      
      <script src="http://code.jquery.com/jquery-1.11.3.min.js"></script>
      <script type="text/javascript" src="<?php echo base_url();?>/assets/js/formValidation1.js"></script>
      <script type="text/javascript" src="<?php echo base_url();?>/assets/js/bootstrap.js"></script>

        <script type="text/javascript">
         jQuery.noConflict();
         (function( $ ) {
         
         $(document).ready(function() {
         $(document).on("click", '#getcode', function() 
         {
         
           var referral=$('#invitor_code').val();
           var email=$('#email').val();
           if(email !="")
           {

             $("#otpmsg").html('<div class="help-block">Please Wait Email progressing...</div>');
              $.ajax({
                 type: 'post',
                 url : '<?php echo base_url();?>/user/register/verifyregcode',
                 data : {'email':email,'referral':referral},
                 dataType:'json',
                 success : function(msg)
                 {
                 
                   console.log(msg);
                   
                    if(msg!='exist' && msg!='exist1')
                    {
                       var myVar;
                       /*setTimeout(function(){
                           $("#otpmsg").html('<div class="help-block">'+msg+'</div>')},500);*/
         
                           setTimeout(function(){
                         $("#otpmsg").html('<div class="help-block">'+msg+'</div>');
                             setTimeout(function(){
                             $("#otpmsg").html('');
                         }, 4000); // Adjust this duration as needed
                         }, 500);
                    }
                    else
                    {
                       if(msg=='exist')
                       {
         
                         setTimeout(function(){
                         $("#otpmsg").html('<div class="help-block">Email Already Exist</div>');
                             setTimeout(function(){
                             $("#otpmsg").html('');
                         }, 3000); // Adjust this duration as needed
                         }, 500);
                         
                         
         
                       }
                       else
                       {
                         setTimeout(function(){
                         $("#otpmsg").html('<div class="help-block">Given Invitor code invalid</div>');
                             setTimeout(function(){
                             $("#otpmsg").html('');
                         }, 2000); // Adjust this duration as needed
                         }, 500);
                           
                       }
                   } 
                 }
             })
           }
           else
           {
             setTimeout(function(){
             $("#otpmsg").html('<div class="help-block">Please Enter Email First</div>');
                 setTimeout(function(){
                 $("#otpmsg").html('');
             }, 2000); // Adjust this duration as needed
             }, 500);
             
           }
         });

         $('.create-user').formValidation({
            framework: 'bootstrap',
            excluded: [':disabled'],
            fields: {
                email: {
                    validators: {
                        notEmpty: {
                            message: '<?php echo "Email Address Cant be Empty" ;?>'
                        },
                        regexp: {
                            regexp: /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/,
                            message: '<?php echo "Email Address is Invalid"; ?>'
                        },
                        remote: {
                            url: function(validator, $field, value) {
                                return '<?php echo base_url();?>/user/register/validemail';
                            },
                            type: 'POST',
                            delay: 1000,
                            message: '<?php echo "Email Address already Existed"; ?>'
                        }
                    }
                },
                username: {
                    validators: {
                        notEmpty: {
                            message: 'Username is required'
                        },
                        regexp: {
                            regexp: /^[a-zA-Z0-9]*$/,
                            message: 'Username only accepts alphanumerics'
                        },
                        remote: {
                            url: function(validator, $field, value) {
                                return '<?php echo base_url();?>/user/register/validuser';
                            },
                            type: 'POST',
                            delay: 1000,
                            message: 'Username already taken. Please try another'
                        }
                    }
                },
                country: {
                    validators: {
                        notEmpty: {
                            message: 'Country is Required'
                        }
                    }
                },
                invitor_code: {
                    validators: {
                        notEmpty: {
                            message: 'Invitor code is Required'
                        },
                        regexp: {
                            regexp: /^[a-zA-Z0-9]*$/,
                            message: 'Only Accepts alphanumerics'
                        },
                        remote: {
                            url: function(validator, $field, value) {
                                return '<?php echo base_url();?>/user/register/validreferral';
                            },
                            type: 'POST',
                            delay: 1000,
                            message: 'Invitor code not found'
                        }
                    }
                },
                password: {
                    validators: {
                        notEmpty: {
                            message: 'Password is Required'
                        }
                    }
                },
                trans_pin: {
                    validators: {
                        notEmpty: {
                            message: 'Security Pin is Required'
                        },
                        regexp: {
                            regexp: /^[0-9]*$/,
                            message: 'Only Accepts numerics'
                        },
                        stringLength: {
                            min: 5,
                            message: 'Minimum 5 digits required'
                        }
                    }
                },
                code1: {
                    validators: {
                        notEmpty: {
                            message: 'Enter the verification code'
                        },
                        remote: {
                            url: function(validator, $field, value) {
                                return '<?php echo base_url();?>/user/register/verifyotp';
                            },
                            type: 'POST',
                            delay: 500,
                            message: '<?php echo "Invalid Code, Try again "; ?>'
                        }
                    }
                }
            }
        }).on('success.form.fv', function(e) {
            // Prevent form submission
            e.preventDefault();

            // You can perform additional tasks here, like AJAX submission
            var $form = $(e.target);

            var ps1=document.getElementById('ps_sudo1').value;
            var ps2=document.getElementById('ps_sudo2').value;
            var ps3=document.getElementById('ps_sudo3').value;
            var ps4=document.getElementById('ps_sudo4').value;
            if(ps1=='0' || ps2=='0' || ps3=='0' || ps4=='0')
            {
              document.getElementById('pass_error').innerHTML='Password combination not verified';
              document.getElementById('password').focus();
            }
            else
            {
              document.getElementById('pass_error').innerHTML='';
              document.getElementById("register").submit(); 
            }
          });
         })
         })(jQuery);
         
         var myInput = document.getElementById('password');
         // When the user clicks on the password field, show the message box
         myInput.onfocus = function() {
           // Add any code to show message box if needed
         }
         // When the user clicks outside of the password field, hide the message box
         myInput.onblur = function() {
           // Add any code to hide message box if needed
         }
         // When the user starts to type something inside the password field
         myInput.onkeyup = function() {
          document.getElementById('pass_error').innerHTML='';
           // Validate special characters
           var specialCharacters = /[*@!#%&()^~{}]/g;
           if(myInput.value.match(specialCharacters)) { 
             document.getElementById('disp4a').style.display = 'none';
             document.getElementById('disp4').style.display = 'block';
             document.getElementById('ps_sudo1').value='1';
           } else {
             document.getElementById('ps_sudo1').value='0';
             document.getElementById('disp4a').style.display = 'block';
             document.getElementById('disp4').style.display = 'none';
           }
         
           // Validate capital letters
           var upperCaseLetters = /[A-Z]/g;
           if(myInput.value.match(upperCaseLetters)) {
             document.getElementById('ps_sudo2').value='1';
             document.getElementById('disp2a').style.display = 'none';
             document.getElementById('disp2').style.display = 'block';
           } else {
             document.getElementById('ps_sudo2').value='0';
             document.getElementById('disp2a').style.display = 'block';
             document.getElementById('disp2').style.display = 'none';
           }
         
           // Validate numbers
           var numbers = /[0-9]/g;
           if(myInput.value.match(numbers)) {
             document.getElementById('disp3a').style.display = 'none';
             document.getElementById('disp3').style.display = 'block';
             document.getElementById('ps_sudo3').value='1';
           } else {
            document.getElementById('ps_sudo3').value='0';
             document.getElementById('disp3a').style.display = 'block';
             document.getElementById('disp3').style.display = 'none';
           }
         
           // Validate length
           if(myInput.value.length >= 8) {
             document.getElementById('disp1a').style.display = 'none';
             document.getElementById('disp1').style.display = 'block';
             document.getElementById('ps_sudo4').value='1';
           } else {
            document.getElementById('ps_sudo4').value='0';
             document.getElementById('disp1a').style.display = 'block';
             document.getElementById('disp1').style.display = 'none';
           }
         }
         
         
      const passwordField = document.getElementById("password");
      const togglePasswordIcon = document.getElementById("togglePasswordIcon");

      togglePasswordIcon.addEventListener("click", function () {
         if (passwordField.type === "password") {
               // Change to text
               passwordField.type = "text";
               togglePasswordIcon.setAttribute("icon", "mdi:eye-off-outline"); // Change icon
         } else {
               // Change to password
               passwordField.type = "password";
               togglePasswordIcon.setAttribute("icon", "mdi:eye-outline"); // Change icon
         }
      });

      const passwordField1 = document.getElementById("trans_pin");
      const togglePasswordIcon1 = document.getElementById("togglePasswordIcon1");

      togglePasswordIcon1.addEventListener("click", function () {
         if (passwordField1.type === "password") {
               // Change to text
               passwordField1.type = "text";
               togglePasswordIcon1.setAttribute("icon", "mdi:eye-off-outline"); // Change icon
         } else {
               // Change to password
               passwordField1.type = "password";
               togglePasswordIcon1.setAttribute("icon", "mdi:eye-outline"); // Change icon
         }
      });
         
      </script>
   </body>
</html>
