<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Statistics extends CI_Controller {

	/**
	 * 
	 * Start 
	 * Create Date: 02 August, 2016
	 * This controller to manage site statistics in user side page.
	 * Created saravana kumar.
	 * @see http://ihyip.com/
	 * Last Updated: 02 August, 2016
	 * End
	 * 
	 */

	public function __construct() {
		parent::__construct();
		
		// admin login only
		if($this->session->userdata('admin_login')) {


			$this->load->model('statistics_model');
			
			// form validation library
			$this->load->library('form_validation');

		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$this->session->set_userdata('last_page', current_url());
				redirect('admin/login');
			}
		}
	}

	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$this->session->set_userdata($array);

		} else {
			redirect('admin/login');
		}
	}

	public function index() 
	{

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_statistics')
		);
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  base_url().'admin/statistics';

		$statistics_data = $this->statistics_model->GetStatistics('show_infobox');
		
		
		if($statistics_data) {
			foreach ($statistics_data as $row) {
				$this->data[$row->statistics_key] = $row->statistics_value;
			}
		} 
		

		if($this->input->post()) {
			
			foreach ($statistics_data as $row) {
				
				if($this->input->post($row->statistics_key)){

					if($row->statistics_key!='status'){
						
						$stats_data = array(
							"statistics_value"	=>	$this->input->post($row->statistics_key)
						);

						$this->db->where('statistics_name','show_infobox');
						$this->db->where('statistics_key',$row->statistics_key);
						
						$update_status = $this->db->update('statistics_controls', $stats_data);
						
					}
					
				} else {
					
					$stats_data = array(
						"statistics_value"	=>	'0'
					);

					$this->db->where('statistics_name','show_infobox');
					$this->db->where('statistics_key',$row->statistics_key);
					$update_status = $this->db->update('statistics_controls', $stats_data);
					
				}

				//$this->data[$row->statistics_key] = $row->statistics_value;
			}
			if($update_status){
				$this->session->set_flashdata('success_message', $this->lang->line('statistics_success_message'));
				redirect('admin/statistics');
			} else {
				$this->session->set_flashdata('error_message', $this->lang->line('statistics_error_message'));
				redirect('admin/statistics');
			}
			
			
		}
		$this->load->view('admin/settings/statistics',$this->data);

	}

	
}

