<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php $this->load->view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/tables/datatables/datatables.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/tables/datatables/extensions/responsive.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/forms/selects/select2.min.js"></script>

	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/app.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/pages/datatables_responsive.js"></script>
	<!-- /theme JS files -->
		<!-- select box theme JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/forms/selects/bootstrap_select.min.js"></script>

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/jgrowl.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/pages/components_popups.js"></script>

    <!-- select box JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/pages/form_bootstrap_select.js"></script>
	<!-- /select box JS files -->
    

</head>

<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php $this->load->view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php $this->load->view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo $this->lang->line('admin_log_history_details'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php $this->load->view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo $this->lang->line('admin_log_history_details'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
                               <li>
									<select id="users" name="users" class="bootstrap-select form-control" data-style="btn-primary">
										<option value="admin" <?php if($user_stat == 'admin') {echo "selected";} ?>><?php echo $this->lang->line('admin_name_lbl'); ?></option>
										<option value="users" <?php if($user_stat == 'users') {echo "selected";} ?>><?php echo $this->lang->line('menu_user'); ?></option>
										<option value="subadmin" <?php if($user_stat == 'subadmin') {echo "selected";} ?>><?php echo $this->lang->line('subadminhistory_log'); ?></option>
									</select>
								</li>
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>

					
					<table class="table datatable-responsive-row-control table-hover">
  						<col width="10%">
  						<col width="20%">
  						<col width="25%">
  						<col width="20%">
  						<col width="15%">
						<thead>
							<tr>
								<th></th>
								<th class="text-center"><?php echo $this->lang->line('exp_report_sno');?></th>
								<th class="text-center"><?php echo $this->lang->line('plac_smtp_username');?></th>
								<th class="text-center"><?php echo $this->lang->line('admin_ipadd_lbl');?></th>
								<th class="text-center"><?php echo $this->lang->line('ip_lastacc');?></th>
								<th class="text-center"><?php echo $this->lang->line('lbl_status');?></th>
							</tr>
						</thead>
						<tbody>
						<?php 
							if($log_data) {
								$this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt;
								$i=1;
								foreach ($log_data as $row) {
                                   if($row->user_type == 'admin' || $row->user_type == 'subadmin'){
									   	$user_condition = "id = '".$row->uusers_id."'";
									    $admin_status = $this->common_model->GetRow('admin',$user_condition);
									    $username = $admin_status->username;

									    if($admin_status->status == '1'){
									    	$status = 'Active';
									    	$class = 'label-success';

									    } else{
                                            $status = 'Inactive';
                                            $class = 'label-danger';
									    }

									   	
								   }
								   else{
									$user_condition = "uusersid = '".$row->uusers_id."'";
									$username1 = $this->common_model->GetRow('uusers',$user_condition);
									if($username1){
									$username = $username1->username;
                                          if($username1->status == '1'){
									    	$status = 'Active';
									    	$class = 'label-success';

									    } else{
                                            $status = 'Inactive';
                                            $class = 'label-danger';
									    }

									 }	


									}
							?>
							<tr>
								<td></td>
								<td class="text-center"><?php echo $i;?></td>
								<td class="text-center"><?php echo ucfirst($username);?></td>
								<td class="text-center"><?php echo $row->uusers_ip;?></td>
								
								<td class="text-center">

								<?php echo $row->lastaccess; ?>
								</td>
								<td class="text-center"><span class="label <?php echo $class; ?>"><?php echo $status; ?></span></td>
							</tr>
						<?php 

								$i++; }
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
				</div>
				<!-- /basic responsive configuration -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		
	(function($) {

	



	    $(document).ready(function() {

	    	$.jGrowl.defaults.closer = false;

				<?php if($this->session->flashdata('error_message')) { ?>
					$.jGrowl("<?php echo $this->session->flashdata('error_message');?>", {
			            header: '<?php echo $this->lang->line("error");?>',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($this->session->flashdata('success_message')) { ?>
	                $.jGrowl("<?php echo $this->session->flashdata('success_message');?>", {
			            header: '<?php echo $this->lang->line("success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

	            $('#icon-bck').on('click',function() {
					window.history.back();
				});

					$('#users').on('change', function() {
                 	var values = this.value;

                 	window.location.href = "<?php echo base_url();?>admin/loghistory/loglist/"+values;

                 });
		});

	})(jQuery);






	</script>

</body>
</html>
