<!DOCTYPE html>
<html lang="en">
<head>
    <!-- header -->
		<?php
		helper('form');

		$session = session();
		$validation = \Config\Services::validation();


		 echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>
	

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<!-- /theme JS files -->
	
	<!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url('assets/boots/js/bootstrap-switch.js');?>"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>

</head>

<body class="navbar-top-md-md">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.user_page_title'); ?></span></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><? echo lang('language_lang.user_page_title'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
                	</div>
                	
					<div class="panel-body">
						<form class="form-horizontal form-user" action="<?= site_url($action);?>" method="post" enctype="multipart/form-data">
							 <?php 
								if($validation->listErrors()) { 
									$form_err_data = str_replace('<p>', '', $validation->listErrors());
									$form_err_data = str_replace('</p>', '', $form_err_data);
									$form_err_data = str_replace('.', '', $form_err_data);
							?>
									
									<script type="text/javascript">
									
									(function( $ ) {
										$.jGrowl.defaults.closer = false;
								        var from_daa = '<?php $form_err_data;?>';
										$.jGrowl(from_daa, {
								            header: '<?php echo lang("language_lang.error");?>',
								            theme: 'bg-danger'
								        });
								    
									})(jQuery);


									</script>
							<?php
								}
							?>
							<div class="form-group ">   
				                <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.user_can_change_Email'); ?></label>
				                <div class="col-lg-6">
					                <div class="checkbox checkbox-switch">
										<label>
										   <input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_change_email" <?php if($user_change_email==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
									</div>
							    </div>
							</div>
							<div class="form-group" style="display:none;">
								<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.user_can_change_payment_account'); ?></label>
				                <div class="col-lg-6">
							       <div class="checkbox checkbox-switch">
	                                    <label>
									        <input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_change_payment" <?php if($user_change_payment==='on'){ echo 'checked="checked"'; }   ?>>
									    </label>
						           </div>
						        </div>
						    </div>
							<div class="form-group" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.User_can_make_deposit'); ?></label>
			                    <div class="col-lg-6">
                                    <div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_make_deposit" <?php if($user_make_deposit==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
									</div>
							    </div>
							</div>
							<div class="form-group " style="display:none;">
						    	<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.User_can_create_tickets'); ?></label>
			                    <div class="col-lg-6">
							        <div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_post_ticket" <?php if($user_post_ticket==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
									</div>
								</div>
							</div>
							<div class="form-group ">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.User_can_refer_friend'); ?></label>
			                    <div class="col-lg-6">
									<div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_refer_friend" <?php if($user_refer_friend==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
								    </div>
								</div>
							</div>
							<div class="form-group " style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.User_can_use_pro_tools'); ?></label>
			                    <div class="col-lg-6">
 									<div class="checkbox checkbox-switch">
								        <label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_use_promo_tools" <?php if($user_use_promo_tools==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
									</div>
								</div>
							</div>

							<div class="form-group" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.User_can_document'); ?></label>
			                    <div class="col-lg-6">
 									<div class="checkbox checkbox-switch">
								        <label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_use_document_upload" <?php if($user_use_document_upload==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
									</div>
								</div>
							</div>
							
							<div class="form-group" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.User_can_enable_two_factor_auth'); ?></label>
                                <div class="col-lg-6">
								    <div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_enable_twofactor_auth" <?php if($user_enable_twofactor_auth==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
									</div>
								</div>
							</div>

							<div class="form-group" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.admin_can_enable_two_factor_auth'); ?></label>
                                <div class="col-lg-6">
								    <div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="admin_enable_twofactor_auth" <?php if($admin_enable_twofactor_auth==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
									</div>
								</div>
							</div>

							<div class="form-group" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.User_token'); ?></label>
                                <div class="col-lg-6">
								    <div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_token" <?php if($user_token==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
									</div>
								</div>
							</div>

							<div class="form-group" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Use_confirmation_update'); ?></label>
                                <div class="col-lg-6">
								    <div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_confirmation_code" <?php if($user_confirmation_code==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
								    </div>
								</div>
							</div>

							<div class="form-group" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.User_notify_profile_change'); ?></label>
                                <div class="col-lg-6">
									<div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_notify_profilechange" <?php if($user_notify_profilechange==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
								    </div>
								</div>
							</div>
							

							<div class="form-group " style="display: none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.user_arbit'); ?></label>
                                <div class="col-lg-6">
									<div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_arbit" <?php if($user_arbit==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
								    </div>
								</div>
							</div>


							<div class="form-group" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.user_copy'); ?></label>
                                <div class="col-lg-6">
									<div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_copy" <?php if($user_copy==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
								    </div>
								</div>
							</div>


							<div class="form-group " style="display: none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.user_buyback'); ?></label>
                                <div class="col-lg-6">
									<div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" class="switch" data-on-text="<?php echo lang('language_lang.On'); ?>" data-off-text="<?php echo lang('language_lang.Off'); ?>" data-on-color="primary" data-off-color="default" name="user_buyback" <?php if($user_buyback==='on'){ echo 'checked="checked"'; }   ?>>
										</label>
								    </div>
								</div>
							</div>


							<div class="form-group  has-feedback <?php if($validation->getError('user_min_password_length')) echo "has-error";?>" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.Minimal_password_length'); ?>  <span class="text-danger">*</span></label>
						        <div class="col-lg-3">
							        <div style="width:65%;" class="input-group">
								        <input type="text" name="user_min_password_length" class="form-control"  placeholder="<?php echo lang('language_lang.User_password_length'); ?>" value="<?php echo set_value('user_min_password_length',isset($this->data['user_min_password_length']) ? $this->data['user_min_password_length'] : ''); ?>">
							        </div>
							        <?php echo $validation->getError('user_min_password_length', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
						        </div>
						    </div>

						<div class="form-group  has-feedback <?php if($validation->getError('user_min_balance')) echo "has-error";?>" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.user_min_balance'); ?>  <span class="text-danger">*</span></label>
						        <div class="col-lg-3">
							        <div style="width:65%;" class="input-group">
								        <input type="text" name="user_min_balance" class="form-control"  placeholder="<?php echo lang('language_lang.User_password_length'); ?>" value="<?php echo set_value('user_min_balance',isset($this->data['user_min_balance']) ? $this->data['user_min_balance'] : ''); ?>" onkeypress="return isNumber(event)"; >
							        </div>
							        <?php echo $validation->getError('user_min_balance', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
						        </div>
						    </div>

							<div class="form-group  has-feedback <?php if($validation->getError('user_block_chat')) echo "has-error";?>" style="display:none;">
							    <label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.user_block_chat'); ?>  <span class="text-danger">*</span></label>
						        <div class="col-lg-3">
							        <div style="width:65%;" class="input-group">
								        <input type="text" name="user_block_chat" class="form-control"  placeholder="<?php echo lang('language_lang.User_password_length'); ?>" value="<?php echo set_value('user_block_chat',isset($this->data['user_block_chat']) ? $this->data['user_block_chat'] : ''); ?>" onkeypress="return isNumber(event)"; >
							        </div>
							        <?php echo $validation->getError('user_block_chat', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
						        </div>
						    </div>

							<div class="text-right col-lg-5"> 
	                            <button type="submit" class="btn btn-primary"><?php echo lang('language_lang.button_update'); ?> <i class="icon-arrow-right14 position-right"></i></button>
						   </div>

						</form>
					</div>
				</div>
				<!-- /horizotal form -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

    </div>
	<!-- /page container -->

	<script type="text/javascript">
	jQuery.noConflict();
	(function( $ ) {
	$(function() {

		$(document).ready(function() {

			$.jGrowl.defaults.closer = false;

			<?php if($session->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($session->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>

		    $('.form-user').formValidation({
		    	framework: 'bootstrap',
		    	excluded: [':disabled'],
		        icon: {
		            validating: 'glyphicon glyphicon-refresh'
		        },
		        fields: {
		            user_min_password_length: {
		                message: '<?php echo lang("language_lang.minimum_password_lengthy");?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.minimum_password_len_empty"); ?>'
		                    },
		                    digits: {
		                        message: '<?php echo lang("language_lang.minimum_password_len_number"); ?>'

		                    }
		                }
		            },
		            user_min_balance: {
		                message: '<?php echo lang("language_lang.minimum_balance_length");?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.minimum_balance_length"); ?>'
		                    }
		                    
		                }
		            },

		            user_block_chat: {
		                message: '<?php echo lang("language_lang.minimum_block_length");?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo lang("language_lang.minimum_block_length"); ?>'
		                    },
		                    digits: {
		                        message: '<?php echo lang("language_lang.minimum_balance_len_number"); ?>'

		                    }
		                    
		                }
		            }
				 }
		    })
		});
	    
	    $('#icon-bck').on('click',function() {
			window.history.back();
		});
	    $(".switch").bootstrapSwitch();

	});
	})(jQuery);



function isNumber(evt)
{
  evt = (evt) ? evt : window.event;
  var charStr = String.fromCharCode(evt.which);
  if(charStr!='t' && charStr!='&' && charStr!='%' && charStr!='(')
  {
  	var charCode = (evt.which) ? evt.which : evt.keyCode; 
  	if (charCode > 31 && charCode!=37 && charCode!=38 && charCode!=39 && charCode!=40 && charCode!=46 && charCode!=116 && (charCode < 48 || charCode > 57 ||charCode==8  || charCode==45))
  	{
        return false;
  	}
  	else
  	{
  		return true;
  	}
  }
  else
  {
  	return false;
  }	
}

	
	</script>

</body>
</html>
