<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Main navbar -->
		<?php
        use App\Libraries\MyEncrypt;
        $session = session();
		 echo view('admin/common_header'); ?>
	<!-- /main navbar -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/datatables.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/extensions/responsive.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/select2.min.js');?>"></script>

	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/datatables_responsive.js');?>"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    
    <link href="<?php echo base_url('assets/css/icons/fontawesome/styles.min.css');?>" rel="stylesheet" type="text/css">

    	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/bootbox.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/sweet_alert.min.js');?>"></script>
    <script type="text/javascript" src="<?php echo base_url('assets/js/pages/components_modals.js');?>"></script>


</head>
<style>
.icons-list > li {
    display: inline-block;
    font-size: 26px;
    }
    .heading-elements .icons-list {
    margin-top: 5px;
}
</style>
<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.cms_page_title'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { ?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.cms_page_title'); ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
								<!-- <li><a href="<?php echo base_url();?>admin/cms/add" class="icon-plus-circle2"></a></li> -->
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>
					<table class="table datatable-responsive-row-control table-hover">
						<col width="25%">
  						<col width="15%">
  						<col width="25%">
  						<col width="20%">
  						<col width="15%">
						<thead>
							<tr>
								<th></th>
								<th class=""><?php echo lang('language_lang.cms_page_titlename');?></th>
								<th class=""><?php echo lang('language_lang.lab_language');?></th>
								<th class="text-center"><?php echo lang('language_lang.cms_page_content');?></th>
								<th class="text-center"><?php echo lang('language_lang.cms_page_status');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_action');?></th>
							</tr>
						</thead>
						<tbody>
						<?php 
							if($page_data) {
								
								// $this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt;
								foreach ($page_data as $row) {
									
									if($row->page_status=='1'){
										$label_status = 'label-success';
										$status = lang('language_lang.active');
									} else {
										$label_status = 'label-danger';
										$status = lang('language_lang.in_active');
									}

							?>
							<tr>
							    <td></td>
								<td class=""><?php echo ucfirst($row->page_title);?></td>
								<td class=""><?php echo ucfirst($row->language_name);?></td>
								<td class="text-center"><button type="button" class="btn btn-primary btn-sm" onClick="viewcontent('<?php echo $myencrypt->encode($row->page_url); ?>')" ><?php echo lang('language_lang.view_content');?> <i class="fa fa-search position-right"></i></button></td>
								<?php if($row->page_status=='1'){ ?>
								        <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" onclick="changeStatus('<?php echo $myencrypt->encode($row->page_url); ?>')"><?php echo $status;?></a></span></td>
								<?php } else {?>
 								        <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" onclick="changeActiveStatus('<?php echo $myencrypt->encode($row->page_url); ?>')"><?php echo $status;?></a></span></td>
                                <?php } ?>
								<td class="text-center">
									<ul class="icons-list">
										<li class="dropdown">
											<a href="#" class="dropdown-toggle" data-toggle="dropdown">
												<i class="icon-menu9"></i>
											</a>

											<ul class="dropdown-menu dropdown-menu-right">
												<?php if($row->page_url != 'home' || $row->page_url != 'about' || $row->page_url != 'different-services') {?>
													<li><a href="<?php echo base_url('admin/cms/edit/'.$myencrypt->encode($row->page_url));?>"><i class="fa fa-edit"></i> <?php echo lang('language_lang.edit');?></a></li>
													<li><a onclick="confirmdelete('<?php echo $myencrypt->encode($row->page_url);?>')" href="javascript:void(0)"><i class="fa fa-remove"></i> <?php echo lang('language_lang.delete');?></a></li>
												<?php } else {?>
	 												<li><a href="<?php echo base_url('admin/cms/edit/'.$myencrypt->encode($row->page_url));?>"><i class="fa fa-edit"></i> <?php echo lang('language_lang.edit');?></a></li>
													<li><a href="" ><i class="fa fa-remove"></i> <?php echo lang('language_lang.delete');?></a></li>
												<?php } ?>
											</ul>

										</li>
									</ul>
								</td>
							</tr>
						<?php 

								}
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
				</div>
				<!-- /basic responsive configuration -->

				<!-- Basic modal -->
				<?php //pr($page_data);?>
				<?php //foreach ($page_data as $row) { ?>
				<div id="modal_theme_primary" class="modal fade" >
					<div class="modal-dialog">
						<div class="modal-content">
							<div class="modal-header bg-primary">
								<button type="button" class="close" data-dismiss="modal">&times;</button>
								<h5 class="modal-title"><?php echo ucwords('page content');?></h5>
							</div>

							<div style=" max-height: 400px;overflow-y: scroll;" class="modal-body resp-body">
								
							</div>

							<div class="modal-footer">
								<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
							</div>
						</div>
					</div>
				</div>
				<? //} ?>
				<!-- /basic modal -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		
	(function($) {



	    $(document).ready(function() {

	    	$.jGrowl.defaults.closer = false;

				<?php if($session->getFlashData('error_message')) { ?>
					$.jGrowl("<?php echo lang('language_lang.cms_delete_error_message');?>", {
			            header: 'Error!',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($session->getFlashData('success_message')) { ?>
	                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
			            header: '<?php echo lang("language_lang.success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

	            $('#icon-bck').on('click',function() {
					window.history.back();
				});
	       //      $("#btn-viewcontent").on("click", function(){
	       //      	var id = $("#btn-viewcontent").val();
	       //      	$.post("<?php echo base_url();?>admin/cms/viewcontents/"+id,
				    // function(resp){
				    // 	$('#modal_theme_primary').modal();
				    //     $('.resp-body').html(resp);
				        
				    // });	
	       //      })
				
		});

	})(jQuery);

	function confirmdelete(value) {
		swal({
            title: "<?php echo lang('language_lang.lbl_delete_cms_page');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            cancelButtonColor: true,
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
            	window.location.href = "<?php echo base_url('admin/cms/delete/');?>"+'/'+value;
            }
        });
    }
	
	function changeStatus(valus) {
	
		swal({
            title: "<?php echo lang('language_lang.lbl_change_cms_status');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            cancelButtonColor: true,
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {

            	window.location.href = "<?php echo base_url('admin/cms/changeStatus/');?>"+'/'+valus;
         	}
		});
	}

	// Do you want to change status
	function changeActiveStatus(valus) {
		swal({
            title: "<?php echo lang('language_lang.lbl_change_cms_status');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            cancelButtonColor: true,
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
            	window.location.href = "<?php echo base_url('admin/cms/changeActiveStatus/');?>"+'/'+valus;
           	}
		});
		
	}
	
    function viewcontent(value) {
    	jQuery.post("<?php echo base_url('admin/cms/viewcontents/');?>"+'/'+value,
	    function(resp){
	    	jQuery('#modal_theme_primary').modal();
	        jQuery('.resp-body').html(resp);
	        
	    });	
    }
	
	</script>

</body>
</html>
