<?php 

error_reporting(E_ALL);
?>

<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Main navbar -->
		<?php
		$session = session();
         use App\Libraries\MyEncrypt;
		 echo view('admin/common_header'); ?>
	<!-- /main navbar -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/datatables.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/extensions/responsive.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/select2.min.js');?>"></script>

	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/datatables_responsive.js');?>"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    
    <link href="<?php echo base_url('assets/css/icons/fontawesome/styles.min.css');?>" rel="stylesheet" type="text/css">

    <!-- Theme JS files -->
	
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/bootstrap_select.min.js');?>"></script>
	<!-- select box JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/form_bootstrap_select.js');?>"></script>
	<!-- /select box JS files -->


	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/bootbox.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/sweet_alert.min.js');?>"></script>
	<!-- /theme JS files -->
</head>
<style>
.icons-list > li {
    display: inline-block;
    font-size: 26px;
    }
    .heading-elements .icons-list {
    margin-top: 5px;
}
</style>
<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.slider_page_title'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.slider_page_title'); ?></h5>
						<div class="heading-elements">
						    <ul class="icons-list">
								<li><a href="<?php echo base_url('admin/slider/add');?>" class="icon-plus-circle2"></a></li>
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>
					<table class="table datatable-responsive-row-control table-hover">
						<colgroup>
							<col width="15%">
							<col width="15%">
							<col width="50%">
							<col width="10%">
							<col width="10%">
						</colgroup>
						<thead>
							<tr>
								<th></th>
								<th class=""><?php echo lang('language_lang.lbl_slider_title');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_slider_image');?></th>
								<th class=""><?php echo lang('language_lang.lbl_slider_description');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_slider_status');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_action');?></th>
							</tr>
						</thead>
						<tbody>
						<?php
							if($slider_data) {
								$row_count = count($slider_data);
								// $this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt;
								foreach ($slider_data as $row) {
									if($row->status=='1'){
										$label_status = 'label-success';
										$status = lang('language_lang.active');
									} else {
										$label_status = 'label-danger';
										$status = lang('language_lang.in_active');
									}



							?>
							<tr>
							    <td></td>
								<td class=""><?php echo ucfirst($row->title);?></td>
							    <td class="text-center"><img style="width: 150px;" src="<?php echo base_url('content/slider/'.$row->image);?>" alt="<?php echo ucfirst($row->title);?>"/></td>
							    <td class=""><?php echo $row->description;?></td>
								<!-- <td class="text-center"><button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modal_theme_primary<?php echo $row->slider_id;?>"><?php echo lang('language_lang.view_content'); ?> <i class="fa fa-search position-right"></i></button></td> -->
								<?php if($row->status=='1'){ ?>
								         <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" onclick="changeStatus('<?php echo $myencrypt->encode($row->slider_id); ?>')" href="javascript:void(0)"><?php echo $status;?></a></span></td>
								<?php } else {?>
 								         <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" onclick="changeActiveStatus('<?php echo $myencrypt->encode($row->slider_id); ?>')" href="javascript:void(0)"><?php echo $status;?></a></span></td>
                                <?php } ?>
								<td class="text-center">
									<ul class="icons-list">
										<li class="dropdown">
											<a href="#" class="dropdown-toggle" data-toggle="dropdown">
												<i class="icon-menu9"></i>
											</a>

											<ul class="dropdown-menu dropdown-menu-right <?php if($row_count=='1' || $row_count=='2') { echo 'inline-drop'; }?>">
												<li><a href="<?php echo base_url('admin/slider/add/'.$myencrypt->encode($row->slider_id));?>"><i class="fa fa-edit"></i> <?php echo lang('language_lang.edit');?></a></li>
												<li><a onclick="confirmdelete('<?php echo $myencrypt->encode($row->slider_id);?>')" href="javascript:void(0)" ><i class="fa fa-remove"></i> <?php echo lang('language_lang.delete');?></a></li>
											</ul>
										</li>
									</ul>
								</td>
							</tr>
						<?php 

								}
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
				</div>
				<!-- /basic responsive configuration -->


			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		
	(function($) {

	    $(document).ready(function() {

	    	$.jGrowl.defaults.closer = false;

				<?php if($session->getFlashData('error_slider')) { ?>
					$.jGrowl("<?php echo $session->getFlashData('error_slider');?>", {
			            header: 'Error!',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($session->getFlashData('success_slider')) { ?>
	            	var succ_data = '<?php echo $session->getFlashData('success_slider');?>';
	                $.jGrowl(succ_data, {
			            header: '<?php echo lang("language_lang.success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

	            $('#icon-bck').on('click',function() {
					window.history.back();
				});

		});

	})(jQuery);
	
	function changeStatus(valus) {
         swal({
            title: "<?php echo lang('language_lang.confirm_status_change');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url('admin/slider/changeStatus/');?>"+'/'+valus;
            }
            else {
              return false;
            }
		
		});
	}
	function changeActiveStatus(valus) {
		swal({
            title: "<?php echo lang('language_lang.confirm_status_change');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url('admin/slider/changeActiveStatus/');?>"+'/'+valus;
            }
            else {
              return false;
            }
		
		});
	}
	function confirmdelete(value) {

		// alert(value);

		swal({
            title: "<?php echo lang('language_lang.confirm_delete_text');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url('admin/slider/delete/');?>"+'/'+value;
            }
            else {
              return false;
            }

		});
    }

	
	</script>

</body>
</html>
