<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Models\finance_model;
use App\Libraries\MyEncrypt;

class Admin extends BaseController {
	/**
	 * 
	 * Start 
	 * Create Date: 27 sep, 2016
	 * This controller to manage admin login.
	 * Created karthiga.
	 * @see http://ihyip.com/admin/sitesettings/
	 * Last Updated: 27 sep, 2016
	 * End
	 * 
	 */

	public function __construct() {
		// admin login only
		$session = \Config\Services::session();
		$this->common_model = model('CommonModel');
		if(!$session->get('admin_login')){
			return redirect()->to(site_url('admin/login'));
		}

		if(session()->get('admin_login')) {
			$this->finance_model = model('finance_model');
		    helper('site_helper');

			// form validation library
			// $this->load->library('form_validation');
			// $this->load->model('finance_model');
			// $this->load->helper('file');

			
			// custom encryption
			// library('MyEncrypt');
			// $myencrypt = new MyEncrypt;
			
		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				redirect('admin/login');
			}
		}

	}

	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			session()->set($array);

		} else {
			redirect('admin/login');
		}
	}

	
	public function index(){
		$this->db = db_connect();
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		if(!$session->get('admin_login')){
			return redirect()->to(site_url('admin/login'));
		}
		// redirect('admin/dashboard');
		
		$this->data['page_title'] = lang('language_lang.page_title');
		$this->data['page_info'] = lang('language_lang.page_info');

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);

		$this->data['module_name'] = 'dashboard';

		$admin_login=$session->get('userid');
		$get_admin=$this->db->query("select * from admin where id='".$admin_login."'")->getRow();
		$user_group = $get_admin->user_group;


		if($user_group=='0')
			$new_user_condition = "status = '0'";
		else if($user_group=='1')
			$new_user_condition = "status = '0' and new_entry='0'";
		else
			$new_user_condition = "status = '0' and new_entry='1'";

		$this->data['new_member_acc'] = $this->common_model->RecordCount('uusers', $new_user_condition);

		if($user_group=='1')
			$active_user_condition = "status = '1' and new_entry='0'";
		else if($user_group=='2')
			$active_user_condition = "status = '1' and new_entry='1'";
		else
			$active_user_condition = "status = '1'";
		$this->data['total_active_acc'] = $this->common_model->RecordCount('uusers', $active_user_condition);

		if($user_group=='0')
			$all_user_condition = "is_delete = '0'";
		else if($user_group=='1')
			$all_user_condition = "is_delete = '0' and new_entry='0'";
		else
			$all_user_condition = "is_delete = '0' and new_entry='1'";

		$this->data['total_accounts'] = $this->common_model->RecordCount('uusers',$all_user_condition);
		
		$languageid = (session()->get('langid')) ? session()->get('langid'): '1'; 

		$news_condition = "news_status = '1' AND language_id = '".$languageid."' ORDER BY `news_id` desc limit 0,1";
		$this->data['news'] = $this->common_model->GetResults('news_controls',$news_condition);
        
		$news_condition1 = "news_status = '1' AND language_id = '".$languageid."' ORDER BY `news_id` desc limit 1,1";

		$this->data['newslist'] = $this->common_model->GetResults('news_controls',$news_condition1);

		$new_ticket_condition = "ticket_status = 'new'";
		$new_ticketlist_condition = "ticket_status = 'new' ORDER BY 'ticket_id' desc limit 4";

		$this->data['new_ticket_list'] = $this->common_model->GetResults('tickets', $new_ticketlist_condition);


		$this->data['new_ticket_count'] = $this->common_model->RecordCount('tickets', $new_ticket_condition);

		$reopen_ticket_condition = "ticket_status = 'reopen' ORDER BY 'ticket_id' desc limit 4";
		$reopen_ticketcount_condition = "ticket_status = 'reopen'";

		$this->data['reopen_ticket_list'] = $this->common_model->GetResults('tickets', $reopen_ticket_condition);

		$close_ticket_condition = "ticket_status = 'close' ORDER BY 'ticket_id' desc limit 4";
		$this->data['close_ticket_list'] = $this->common_model->GetResults('tickets', $close_ticket_condition);
		$close_ticketcount_condition = "ticket_status = 'close'";
		$this->data['close_ticket_count'] = $this->common_model->RecordCount('tickets', $close_ticketcount_condition);


		$this->data['reopen_ticket_count'] = $this->common_model->RecordCount('tickets', $reopen_ticketcount_condition);
        $this->db = db_connect();
		$builder = $this->db->table('uusers_online');
	    $builder->select('*');
		$builder->where('uusers_id','1');
		$builder->where('user_type','admin');
		$builder->orderBy('uusers_id','desc');
		// $builder->limit('5');
		$query = $builder->get('5');
		$this->data['user_data'] = $query->getResult(); 

		$builder = $this->db->table('uusers_online');
		$builder->select('*');
		$builder->where('uusers_id','1');
		$builder->where('user_type','admin');
		$query = $builder->get();
		$this->data['usercount'] = $query->getNumRows();

		$builder = $this->db->table('tickets');
		$builder->select('*');
		$query = $builder->get();
		$this->data['tot_tickets'] = $query->getNumRows();

		$admin_data = $this->common_model->GetLimitedHis('uusers_online','uusers_id','10');

		date_default_timezone_set("EST");
		$wdate = date('Y-m-d',strtotime('monday this week'));
		$tuesdate = date('Y-m-d',strtotime('tuesday this week'));
		$weddate = date('Y-m-d',strtotime('wednesday this week'));
		$thudate = date('Y-m-d',strtotime('thursday this week'));
		$fridate = date('Y-m-d',strtotime('friday this week'));
		$satdate = date('Y-m-d',strtotime('saturday this week'));
		$sundate = date('Y-m-d',strtotime('sunday this week'));


		// $query = $this->db->query("SELECT count(uusers_id) as cou,date_format(lastaccess, '%Y-%m-%d %H') as lastaccess1,uusers_id,lastaccess FROM (`uusers_online`) INNER JOIN `uusers` ON `uusers_online`.`uusers_id` = `uusers`.`uusersid` WHERE `status` = '1'  GROUP BY `lastaccess1` ORDER BY `lastaccess` DESC");
		$mon_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`) WHERE DATE(createdate)='$wdate'");
		$this->data['mon_count'] = $mon_query->getRow();
		$tues_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`) WHERE DATE(createdate)='$tuesdate'");
		$this->data['tues_count'] = $tues_query->getRow();
		$wed_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`) WHERE DATE(createdate)='$weddate'");
		$this->data['wed_count'] = $wed_query->getRow();
		$thur_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`) WHERE DATE(createdate)='$thudate'");
		$this->data['thur_count'] = $thur_query->getRow();
		$fri_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`) WHERE DATE(createdate)='$fridate'");
		$this->data['fri_count'] = $fri_query->getRow();
		$sat_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`) WHERE DATE(createdate)='$satdate'");
		$this->data['sat_count'] = $sat_query->getRow();
		$sun_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`) WHERE DATE(createdate)='$sundate'");
		$this->data['sun_count'] = $sun_query->getRow();

		$actmon_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`) WHERE `status` = '1' AND DATE(createdate)='$wdate'");
		$this->data['act_mon_count'] = $actmon_query->getRow();
		$acttues_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`)  WHERE `status` = '1' AND DATE(createdate)='$tuesdate'");
		$this->data['act_tues_count'] = $acttues_query->getRow();
		$actwed_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`)  WHERE `status` = '1' AND DATE(createdate)='$weddate'");
		$this->data['act_wed_count'] = $actwed_query->getRow();
		$actthur_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`)  WHERE `status` = '1' AND DATE(createdate)='$thudate'");
		$this->data['act_thur_count'] = $actthur_query->getRow();
		$actfri_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`)  WHERE `status` = '1' AND DATE(createdate)='$fridate'");
		$this->data['act_fri_count'] = $actfri_query->getRow();
		$actsat_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`)  WHERE `status` = '1' AND DATE(createdate)='$satdate'");
		$this->data['act_sat_count'] = $actsat_query->getRow();
		$actsun_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`)  WHERE `status` = '1' AND DATE(createdate)='$sundate'");
		$this->data['act_sun_count'] = $actsun_query->getRow();


		$newmon_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`)  WHERE `status` = '0' AND DATE(createdate)='$wdate'");
		$this->data['new_mon_count'] = $newmon_query->getRow();

		$newtues_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`)  WHERE `status` = '0' AND DATE(createdate)='$tuesdate'");
		$this->data['new_tues_count'] = $newtues_query->getRow();
		$newwed_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`)  WHERE `status` = '0' AND DATE(createdate)='$weddate'");
		$this->data['new_wed_count'] = $newwed_query->getRow();
		$newthur_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`)  WHERE `status` = '0' AND DATE(createdate)='$thudate'");
		$this->data['new_thur_count'] = $newthur_query->getRow();
		$newfri_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`)  WHERE `status` = '0' AND DATE(createdate)='$fridate'");
		$this->data['new_fri_count'] = $newfri_query->getRow();
		$newsat_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`)  WHERE `status` = '0' AND DATE(createdate)='$satdate'");
		$this->data['new_sat_count'] = $newsat_query->getRow();
		$newsun_query = $this->db->query("SELECT count(uusersid) as cou FROM (`uusers`) WHERE `status` = '0' AND DATE(createdate)='$sundate'");
		$this->data['new_sun_count'] = $newsun_query->getRow();
		
		if($user_group=='1')
		    $penalty_condition = "type = 'penalty' and user_group='0'";
		else if($user_group=='2')
		    $penalty_condition = "type = 'penalty' and user_group='1'";
		else
		    $penalty_condition = "type = 'penalty'";
		$this->data['penalty_count'] = $this->common_model->RecordCount('history', $penalty_condition);
		
		if($user_group=='1')
		    $bonus_condition = "type = 'bonus' and user_group='0'";
		else if($user_group=='2')
		    $bonus_condition = "type = 'bonus' and user_group='1'";
		else
		    $bonus_condition = "type = 'bonus'";
	
		$this->data['bonus_count'] = $this->common_model->RecordCount('history', $bonus_condition);

		// $this->data['all_lasttransaction'] = $this->common_model->GetLimitedHis('history','historyid','0,7');
        $builder = $this->db->table('history');
        if($user_group=='1')
            $builder->where('user_group','0');
        else if($user_group=='2')
            $builder->where('user_group','1');
		$builder->orderBy('historyid','DESC');
		$trans = $builder->get(4, 1);
		$this->data['all_lasttransaction'] = $trans->getResult();
		// echo $this->db->last_query();
		// exit;

		$builder->orderBy('historyid','DESC');
		$translast = $builder->get(4, 5);
		$this->data['last_transaction'] = $translast->getResult();

		$builder->where('type','interest');
		$builder->orderBy('historyid','DESC');
		$intrest = $builder->get(5, 1);
		$this->data['all_lastintrest'] = $intrest->getResult();
        
        if($user_group=='1')
           $conz="type in('withdrawal','withdraw_request') and user_group='0'";
        else if($user_group=='2')
            $conz="type in('withdrawal','withdraw_request') and user_group='1'";
        else    
		    $conz="type in('withdrawal','withdraw_request')";
		$builder->where($conz);
		$builder->orderBy('historyid','DESC');
		$intrest = $builder->get(5);
		$this->data['last_payouts'] = $intrest->getResult();
		$query = $this->db->getLastQuery();

        if($user_group=='1')
            $tot_deposit_condition = "type IN ('deposit','reinvest') and user_group='0'";
        else if($user_group=='2')
            $tot_deposit_condition = "type IN ('deposit','reinvest') and user_group='1'";  
        else
		    $tot_deposit_condition = "type IN ('deposit','reinvest')";
		    
        $this->data['total_deposit_amnt'] = $this->common_model->sumofhistory($tot_deposit_condition);
        
         if($user_group=='1')
            $today_deposit_condition = "type IN ('deposit','reinvest') AND DATE(date) = '".date('Y-m-d')."' and user_group='0'";
        else if($user_group=='2')
           $today_deposit_condition = "type IN ('deposit','reinvest') AND DATE(date) = '".date('Y-m-d')."' and user_group='1'";
        else
		    $today_deposit_condition = "type IN ('deposit','reinvest') AND DATE(date) = '".date('Y-m-d')."'";

        $this->data['today_deposit_amnt'] = $this->common_model->sumofhistory($today_deposit_condition);

        if($user_group=='1')
            $tot_deposit_condition = "type IN ('withdrawal','reinvest') and user_group='0'";
        else if($user_group=='2')
            $tot_deposit_condition = "type IN ('withdrawal','reinvest') and user_group='1'";
        else
            $tot_deposit_condition = "type IN ('withdrawal','reinvest')";
            
        $this->data['total_withdraw_amnt'] = $this->common_model->sumofhistory($tot_deposit_condition);

        if($user_group=='1')
            $tot_deposit_condition = "type IN ('withdrawal','reinvest') AND DATE(date) = '".date('Y-m-d')."' and user_group='0'";
        else if($user_group=='2')
            $tot_deposit_condition = "type IN ('withdrawal','reinvest') AND DATE(date) = '".date('Y-m-d')."' and user_group='1'";
        else
            $today_deposit_condition = "type IN ('withdrawal','reinvest') AND DATE(date) = '".date('Y-m-d')."'";
        $this->data['today_withdraw_amnt'] = $this->common_model->sumofhistory($today_deposit_condition);

        $this->data['tot_amnt_percent'] = $this->data['total_deposit_amnt'] / 100;
        
           if($user_group=='1')
            $tot_deposit_condition = "type IN ('transfer_fee','withdraw_fee','penalty','commissions') and user_group='0'";
           else if($user_group=='2')
            $tot_earnings_condition = "type IN ('transfer_fee','withdraw_fee','penalty','commissions') and user_group='1'";
           else
            $tot_earnings_condition = "type IN ('transfer_fee','withdraw_fee','penalty','commissions')";
            
       // $this->data['total_earning_amnt'] = $this->common_model->sumofhistory($tot_earnings_condition);

        $this->data['tot_earn_percent'] = $this->data['total_earning_amnt'] / 100;

        if($user_group=='1')
            $tot_penalty_condition = "type IN ('penalty') AND DATE(date) = DATE(NOW()) and user_group='0'";
        else if($user_group=='2')
            $tot_penalty_condition = "type IN ('penalty') AND DATE(date) = DATE(NOW()) and user_group='1'";
        else
            $tot_penalty_condition = "type IN ('penalty') AND DATE(date) = DATE(NOW())";
        $this->data['total_penalty_amnt'] = $this->common_model->GetResults('history',$tot_penalty_condition);

        $this->data['tot_penalty_percent'] = $this->data['total_penalty_amnt'];
       
        
        $tot_at = "0";
        if(!empty($this->data['tot_penalty_percent']))
        {
        foreach ($this->data['tot_penalty_percent'] as $riow)
        {
        	$select_f=$this->db->query("select * from currency_upgrade where cid='".$riow->currency."'");
	        $f_data=$select_f->getResult();
    	    $values=$f_data[0]->datas;
	        $values=json_decode($values);
    	    $outputx = json_decode(json_encode($values), True);
    	    $tot_at+= $outputx['price_btc'] * $riow->amount; 
        }
    }

        $this->data['tot_penalty_percent'] = $tot_at;
        if($user_group=='1')
            $tot_bonus_condition = "type IN ('bonus')  AND DATE(date) = DATE(NOW()) and user_group='0'";
        else if($user_group=='2')
            $tot_bonus_condition = "type IN ('bonus')  AND DATE(date) = DATE(NOW()) and user_group='1'";
        else
            $tot_bonus_condition = "type IN ('bonus')  AND DATE(date) = DATE(NOW())";
        $this->data['total_bonus_amnt'] = $this->common_model->GetResults('history',$tot_bonus_condition);
        $this->data['tot_bonus_percent'] = $this->data['total_bonus_amnt'];
       


        $tot_at = "0";
        if(!empty($this->data['tot_bonus_percent'])){
        foreach ($this->data['tot_bonus_percent'] as $riow)
        {
        	$select_f=$this->db->query("select * from currency_upgrade where cid='".$riow->currency."'");
	        $f_data=$select_f->getResult();
    	    $values=$f_data[0]->datas;
	        $values=json_decode($values);
    	    $outputx = json_decode(json_encode($values), True);
    	    $tot_at+= $outputx['price_btc'] * $riow->amount; 
        }
        }	

        $this->data['tot_bonus_percent'] = $tot_at;

       if($user_group=='1')
       {
          $last_month_dep = "type IN ('deposit') AND date > DATE_SUB(DATE(NOW()), INTERVAL 1 MONTH) and user_group='0'";
          $last_weekly_dep = "type IN ('deposit') AND date > DATE_SUB(DATE(NOW()), INTERVAL 1 WEEK) and user_group='0'";
          $last_month_payout = "type IN ('withdrawal') AND date > DATE_SUB(DATE(NOW()), INTERVAL 1 MONTH) and user_group='0'";
          $last_weekly_payout = "type IN ('withdrawal') AND date > DATE_SUB(DATE(NOW()), INTERVAL 1 WEEK) and user_group='0'";
       }
       else if($user_group=='2')
       {
          $last_month_dep = "type IN ('deposit') AND date > DATE_SUB(DATE(NOW()), INTERVAL 1 MONTH) and user_group='1'";
          $last_weekly_dep = "type IN ('deposit') AND date > DATE_SUB(DATE(NOW()), INTERVAL 1 WEEK) and user_group='1'";
          $last_month_payout = "type IN ('withdrawal') AND date > DATE_SUB(DATE(NOW()), INTERVAL 1 MONTH) and user_group='1'";
          $last_weekly_payout = "type IN ('withdrawal') AND date > DATE_SUB(DATE(NOW()), INTERVAL 1 WEEK) and user_group='1'";
       }
       else
       {
          $last_month_dep = "type IN ('deposit') AND date > DATE_SUB(DATE(NOW()), INTERVAL 1 MONTH)";
          $last_weekly_dep = "type IN ('deposit') AND date > DATE_SUB(DATE(NOW()), INTERVAL 1 WEEK)";
          $last_month_payout = "type IN ('withdrawal') AND date > DATE_SUB(DATE(NOW()), INTERVAL 1 MONTH)";
          $last_weekly_payout = "type IN ('withdrawal') AND date > DATE_SUB(DATE(NOW()), INTERVAL 1 WEEK)";
        
       }
       
        $this->data['last_dep_rec'] = $this->common_model->sumofhistory($last_month_dep);
        $this->data['last_weeklydep_rec'] = $this->common_model->sumofhistory($last_weekly_dep);
        $this->data['last_withdraw_rec'] = $this->common_model->sumofhistory($last_month_payout);
        $this->data['last_weeklywithdraw_rec'] = $this->common_model->sumofhistory($last_weekly_payout);
		echo view('admin/dashboard',$this->data);
		// echo $this->db->last_query();
	}

	public function bulltes() {
        
		$current_date = date("Y-m-d");
	    $date = $current_date;
		$date = strtotime($date);
		$date = strtotime("-"."7"." day", $date);
		$firststartmon_week = date('Y-m-d', $date);
		$firststarttue_week = date('Y-m-d', strtotime($firststartmon_week .' +1 day'));
		$firststarttwed_week = date('Y-m-d', strtotime($firststarttue_week .' +1 day'));
		$firststartthur_week = date('Y-m-d', strtotime($firststarttwed_week .' +1 day'));
		$firststartfri_week = date('Y-m-d', strtotime($firststartthur_week .' +1 day'));
		$firststartsat_week = date('Y-m-d', strtotime($firststartfri_week .' +1 day'));
		$firststartsun_week = date('Y-m-d', strtotime($firststartsat_week .' +1 day'));

		$today_deposit_condition = "type IN ('deposit','reinvest') AND DATE(date) = '$firststartmon_week'";
		$todaytuesdate_deposit_condition = "type IN ('deposit','reinvest') AND DATE(date) = '$firststarttue_week'";
		$todayweddate_deposit_condition = "type IN ('deposit','reinvest') AND DATE(date)= '$firststarttwed_week'";
		$todaythudate_deposit_condition = "type IN ('deposit','reinvest') AND DATE(date)= '$firststartthur_week'";
		$todayfridate_deposit_condition = "type IN ('deposit','reinvest') AND DATE(date)= '$firststartfri_week'";
		$todaysatdate_deposit_condition = "type IN ('deposit','reinvest') AND DATE(date)= '$firststartsat_week'";
		$todaysundate_deposit_condition = "type IN ('deposit','reinvest') AND DATE(date)= '$firststartsun_week'";
    	$montoday_deposit_amnt = $this->common_model->sumofhistory($today_deposit_condition);
		$tuetoday_deposit_amnt = $this->common_model->sumofhistory($todaytuesdate_deposit_condition);
		$wedtoday_deposit_amnt = $this->common_model->sumofhistory($todayweddate_deposit_condition);
		$thurtoday_deposit_amnt = $this->common_model->sumofhistory($todaythudate_deposit_condition);
		$fritoday_deposit_amnt = $this->common_model->sumofhistory($todayfridate_deposit_condition);
		$sattoday_deposit_amnt = $this->common_model->sumofhistory($todaysatdate_deposit_condition);
		$suntoday_deposit_amnt = $this->common_model->sumofhistory($todaysundate_deposit_condition);

		$monthly_query = $this->db->query("SELECT sum(`amount`) as amnt,DATE(date) as deposit_date FROM `history`  WHERE type IN ('deposit','reinvest') AND MONTH(`date`) = MONTH(CURDATE() - INTERVAL 1 MONTH) GROUP BY `date`");
        $monthly_query_amnt = $monthly_query->getResult();

        $mon_amount = '0';
        $tue_amount = '0';
        $wed_amount = '0';
        $thu_amount = '0';
        $fri_amount = '0';
        $sat_amount = '0';
        $sun_amount = '0';
        if(!empty($monthly_query_amnt)) { 
        foreach ($monthly_query_amnt as $row) {

        	if(date('D',strtotime($row->deposit_date)) == "Mon"){

        		$mon_amount += $row->amnt;

            }
            if(date('D',strtotime($row->deposit_date)) == "Tue"){

        		$tue_amount += $row->amnt;

            }
            if(date('D',strtotime($row->deposit_date)) == "Wed"){

        		$wed_amount += $row->amnt;

            }
            if(date('D',strtotime($row->deposit_date)) == "Thu"){

        		$thu_amount += $row->amnt;

            }
            if(date('D',strtotime($row->deposit_date)) == "Fri"){

        		$fri_amount += $row->amnt;

            }
            if(date('D',strtotime($row->deposit_date)) == "Sat"){

        		$sat_amount += $row->amnt;

            }
            if(date('D',strtotime($row->deposit_date)) == "Sun"){

        		$sun_amount += $row->amnt;

            }
        
        }
    }

        $total_query = $this->db->query("SELECT sum(`amount`) as amnt,DATE(date) as deposit_date FROM `history`  WHERE type IN ('deposit','reinvest') GROUP BY `date`");
        $total_query_query_amnt = $total_query->getResult();


        $mon1_amount = '0';
        $tue1_amount = '0';
        $wed1_amount = '0';
        $thu1_amount = '0';
        $fri1_amount = '0';
        $sat1_amount = '0';
        $sun1_amount = '0';

        foreach ($total_query_query_amnt as $row) {

        	if(date('D',strtotime($row->deposit_date)) == "Mon"){

        		$mon1_amount += $row->amnt;

            }
            if(date('D',strtotime($row->deposit_date)) == "Tue"){

        		$tue1_amount += $row->amnt;

            }
            if(date('D',strtotime($row->deposit_date)) == "Wed"){

        		$wed1_amount += $row->amnt;

            }
            if(date('D',strtotime($row->deposit_date)) == "Thu"){

        		$thu1_amount += $row->amnt;

            }
            if(date('D',strtotime($row->deposit_date)) == "Fri"){

        		$fri1_amount += $row->amnt;

            }
            if(date('D',strtotime($row->deposit_date)) == "Sat"){

        		$sat1_amount += $row->amnt;

            }
            if(date('D',strtotime($row->deposit_date)) == "Sun"){

        		$sun1_amount += $row->amnt;

            }
        
        }
        
		$wdate1 = date('Y/m/d',strtotime($firststartmon_week));
		$tuesdate1 = date('Y/m/d',strtotime($firststarttue_week));
		$weddate1 = date('Y/m/d',strtotime($firststarttwed_week));
		$thudate1 = date('Y/m/d',strtotime($firststartthur_week));
		$fridate1 = date('Y/m/d',strtotime($firststartfri_week));
		$satdate1 = date('Y/m/d',strtotime($firststartsat_week));
		$sundate1 = date('Y/m/d',strtotime($firststartsun_week));

		echo 'type,date,Total Deposits,Monthly Deposits,Weekly Deposits'."\r\n".'val1'.','.$wdate1.','.round($mon1_amount).','.round($mon_amount).','.round($montoday_deposit_amnt)."\r\n"
		.'val1'.','.$tuesdate1.','.round($tue1_amount).','.round($tue_amount).','.round($tuetoday_deposit_amnt)."\r\n".
		'val1'.','.$weddate1.','.round($wed1_amount).','.round($wed_amount).','.round($wedtoday_deposit_amnt)."\r\n".
		'val1'.','.$thudate1.','.round($thu1_amount).','.round($thu_amount).','.round($thurtoday_deposit_amnt)."\r\n".
		'val1'.','.$fridate1.','.round($fri1_amount).','.round($fri_amount).','.round($fritoday_deposit_amnt)."\r\n".
		'val1'.','.$satdate1.','.round($sat1_amount).','.round($sat_amount).','.round($sattoday_deposit_amnt)."\r\n".
		'val1'.','.$sundate1.','.round($sun1_amount).','.round($sun_amount).','.round($suntoday_deposit_amnt)."\r\n";

	}

	public function sales_monthly(){
	    $this->common_model = model('CommonModel');
        $total_deposit_condition = "type IN ('interest') AND MONTH(`date`) = MONTH(CURDATE() - INTERVAL 1 MONTH)";
        $ttotal_dep_acc = $this->common_model->Depositcount('history', $total_deposit_condition);
        
        $data_json = "";
    if(!empty($total_dep_acc)) { 
        foreach ($ttotal_dep_acc as $row) {
			$data_json .= '{
				"date": "'.date('Y-m-d',strtotime($row->date)).'",
			    "value": '.$row->coun.'
			  },';
        }
    }
        
        echo '['.trim($data_json,',').']';

	}
	

}