<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Infoboxsettings extends CI_Controller {

	/**
	 * 
	 * Start 
	 * Create Date: 22 sep, 2016
	 * This controller to manage infobox setting page.
	 * Created karthiga.
	 * @see http://zhyip.com/admin/infoboxsettings/
	 * Last Updated: 22 sep, 2016
	 * End
	 * 
	 */

	public function __construct() {
		parent::__construct();

		// admin login only
		if($this->session->userdata('admin_login')) {

			// form validation library
			$this->load->library('form_validation');
			$this->isSubadmin();


		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$this->session->set_userdata('last_page', current_url());
				redirect('admin/login');
			}
		}
		
	}

	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$this->session->set_userdata($array);

		} else {
			redirect('admin/login');
		}
	}

	private function isSubadmin() {

		if($this->session->userdata('user_type') == 'subadmin') {
			$controller = $this->router->fetch_class();
			$pages = json_decode($this->session->userdata('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				redirect('admin');
			}
		}
	}


	public function index()
	{

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_home'),
			'href' => base_url().'admin'
		);
		
		$this->data['breadcrumbs'][] = array(
			'text' => $this->lang->line('text_settings')
		);
        $this->data['module_name'] = 'settings';
        
        // Function call for model
		$this->data['action'] =  base_url().'admin/infoboxsettings';

		$site_data = $this->common_model->GetSettingall('infobox');
		
		if($site_data) {
			
			foreach ($site_data as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}

		}

		if($this->input->post()) {

            foreach ($site_data as $row) {

				$key_value = $row->site_key;
				
				if($this->input->post($key_value)){

					$sitedata = array(
						"site_value"	=>	$this->input->post($key_value)
					);
					$this->db->where('settings_name','infobox');
					$this->db->where('site_key',$row->site_key);
					$update_status = $this->db->update('site_controls', $sitedata);


				} else {

					$sitedata = array(
						"site_value"	=>	'0'
					);
					$this->db->where('settings_name','infobox');
					$this->db->where('site_key',$row->site_key);
					$update_status = $this->db->update('site_controls', $sitedata);

				}

			}

            if($update_status) {
				$this->session->set_flashdata('success_message', $this->lang->line('infobox_success_message'));
				redirect('admin/infoboxsettings');
			} else {
				$this->session->set_flashdata('error_message', $this->lang->line('infobox_error_message'));
				redirect('admin/infoboxsettings');
			}
			
		}
		
		$this->load->view('admin/settings/infobox',$this->data);

	}
	
}

