<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;

class Rewardsettings extends BaseController {

	/**
	 * 
	 * Start 
	 * Create Date: 24 Jun, 2016
	 * This controller to manage referral setting page.
	 * Created karthiga.
	 * @see http://ihyip.com/admin/referralsettings/
	 * Last Updated: 28 Jun, 2016
	 * End
	 * 
	 */

	public function __construct() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');

		helper(['form','url','html']);
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		// admin login only
		if($session->get('admin_login')) {

			// form validation library
			// $this->load->library('form_validation');
			$this->isSubadmin();

		} else {
			$session->set('last_page', current_url());
			return redirect()->to('admin');
		}
		
	}

	private function isSubadmin() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		if($session->get('user_type') == 'subadmin') {
			$controller = $this->router->controllerName();
			$pages = json_decode($session->get('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}
		}
	}

	public function index()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);


		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		
        $this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_settings')
		);

		$this->data['module_name'] = 'settings';


		echo view('admin/settings/rewardsettings',$this->data);

	}



	public function add()
	{


		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}


		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.users_page_text')
		);


		$this->data['module_name'] = 'settings';
		$this->data['action'] =  'admin/rewardsettings/add';


		if($this->request->getpost())
		{
            

			$image=$_FILES['rank_image']['tmp_name'];
			if($image!='') {
				$validation->setRule('rank_image','Rank Image', 'trim|ext_in[rank_image,jpg,png,gif,jpeg]|is_image[rank_image]');
			}
           
          $rank_data=array(

				"rank_name"=>$this->request->getpost('rank_name'),
				"amount"=>$this->request->getpost('amount'),
				"direct_spon_count"=>$this->request->getpost('direct_spon_count'),
				"sponsor_elg_rank"=>$this->request->getpost('sponsor_elg_rank'),
				"sponsor_elg_count"=>$this->request->getpost('sponsor_elg_count'),
				"team_reward"=>$this->request->getpost('team_reward'),
				"gas_reward"=>$this->request->getpost('gas_reward'),
				"group_sales"=>$this->request->getpost('group_sales'),
				"status"	=>	($this->request->getPost('status')) ? '1' : '0',
		
			 );

			 if($image!='') {
				
				// $admin_profile_file = $this->upload->data();
				$path 				= 'assets/images/rank/';
				$file 			    = $this->request->getFile('rank_image');
				$upload_file 	    = $this->uploadFile($path, $file);

				$rank_img = array(
					"image"	=>	$upload_file
				);
				$rank_img = implode(',', $rank_img);
				$rank_data["image"] = $rank_img;
		
			}
      

			$this->db = db_connect();

			$query_status = $this->db->table('rewardsettings')->insert($rank_data);	

		
		     //$query_status=$this->builder;

			if($query_status) 
			    {
					$session->setFlashData('success_message', 'Rank Settings Added Successfully');
					return redirect()->to('admin/rewardsettings');
				} 
				else 
				{
					$session->setFlashData('error_message', 'Failed to Update Rank Setttings');
					return redirect()->to('admin/rewardsettings');
				}
		}



		echo view('admin/settings/rewardform', $this->data);

	}


	public function edit($id)
	{

		
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');

		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}


		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.users_page_text')
		);


		$this->data['module_name'] = 'settings';
		$this->data['action'] =  'admin/rewardsettings/edit/'.$id;

		$this->db = db_connect();

            if($id) {
				//$myencrypt = new MyEncrypt;
				//$id = $myencrypt->decode($id);
				$condition = "id = '".$id."'";
				$this->data['reward_info'] = $this->common_model->GetRow('rewardsettings',$condition);
			}
			
		

		if($this->request->getpost())
		{

            $id=$this->request->getpost('id');


			
			$file=$_FILES['rank_image']['tmp_name'];
			if($file!='') {
			$validation->setRule('rank_image', "News image", 'trim|ext_in[rank_image,jpg,png,gif,jpeg]|is_image[rank_image]');
			}


			
			if($file!='') {
					
				// $admin_profile_file = $this->upload->data();
				$path 				= 'assets/images/rank/';
				$file 			    = $this->request->getFile('rank_image');
				$upload_file 	    = $this->uploadFile($path, $file);
				$rank_img = array(
					"image"	=>	$upload_file
				);

			
				$query_status = $this->db->table('rewardsettings')->where('id',$id)->update($rank_img);
			}

			

			$rank_data=array(

				"rank_name"=>$this->request->getpost('rank_name'),
				"amount"=>$this->request->getpost('amount'),
				"direct_spon_count"=>$this->request->getpost('direct_spon_count'),
				"sponsor_elg_rank"=>$this->request->getpost('sponsor_elg_rank'),
				"sponsor_elg_count"=>$this->request->getpost('sponsor_elg_count'),
				"team_reward"=>$this->request->getpost('team_reward'),
				"gas_reward"=>$this->request->getpost('gas_reward'),
				"group_sales"=>$this->request->getpost('group_sales'),
				"status"	=>	($this->request->getPost('status')) ? '1' : '0',
		
			 );

	        $this->db = db_connect();
	    	$update_status = $this->db->table('rewardsettings')->where('id',$id)->update($rank_data);

	
				

		 if($update_status)
		   {

		$session->setFlashData('success_message', 'Rank Settings Updated Successfuly');
					return redirect()->to('admin/rewardsettings');
				} 
				
				else
			    {
					$session->setFlashData('error_message', 'Failed to Update Rank Settings');
					return redirect()->to('admin/rewardsettings');
				}
 
		 }
	 
		echo view('admin/settings/rewardform',$this->data);


	}


	
	public function uploadFile($path, $image) {


		if ($image->isValid() && ! $image->hasMoved()) {
			$newName = $image->getRandomName();
			$image->move($path, $newName);
			return $image->getName();
		}
		return "";
	}


	public function delete($id)

	 {
        $session = session();
		$myencrypt = new MyEncrypt;
		//$uusersid = $myencrypt->decode($id);
		$this->db = db_connect();


	  $delete_status = $this->db->table('rewardsettings')->where('id',$id)->delete();
 


	   if($delete_status) {
			$session->setFlashData('success_message', 'Rank Settings Deleted Successfully');
			return redirect()->to('admin/rewardsettings');
		} else {
			$session->setFlashData('error_message', 'Failed to Deleted Ranksettings');
			return redirect()->to('admin/rewardsettings');
		}
	}





}

