<?php

namespace App\Controllers\User;
use App\Views;
use App\Models\CommonModel;

class User extends BaseController
{
	public function __construct(){
		// $CommonModel = new CommonModel();
		$this->session = session();
		$CommonModel = model('CommonModel');
	}
   public function index() {
		$this->indexpage();
    }
	
	public function indexpage() {
        $CommonModel = model('CommonModel');
		//$this->db->query("SET GLOBAL sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''))");


		$languageid = ($this->session->get('user_langid')) ? $this->session->get('user_langid'): '1';

		$condition = "payment_key in('logo','status')";
		$payment_data_list = $CommonModel->GetPaymentsName($condition);
		$site_data = $CommonModel->GetSettingall('infobox');
		if($site_data) {
			
			foreach ($site_data as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}

		} else {
			$site_data_default = $CommonModel->defaultlangSettingall('infobox');
			foreach ($site_data_default as $row) {
				$this->data[$row->site_key] = $row->site_value;
			}
		}

		$site_lang_data = $CommonModel->GetSiteSettings('site');
		
		if($site_lang_data){	
			$site_data = array_merge($site_data, $site_lang_data);
		}

		foreach ($site_data as $row) {
			$this->data[$row->site_key] = $row->site_value;
		}


		$pay_array = array();
		$pay_array1['payment_name'] = '';
		foreach ($payment_data_list as $row) {
			
			if($row->payment_name!=$pay_array1['payment_name']){
				$pay_array1['payment_name'] = $row->payment_name;	
				$pay_array1['payment_logo'] = $row->payment_value;	
			} 
			else {
				$pay_array1['payment_status'] = $row->payment_value;
				$pay_array1['payment_id'] = $row->payment_id;
				$pay_array[]= $pay_array1;
			}
	
		}
        
        $this->data['payment_data_list'] = $pay_array;

        $condition = "banner_status = 'on'";
		$this->data['banner_list'] = $CommonModel->GetResults('promotionalbanner_control',$condition);

		$slider_condition = "status = '1' AND language_id = '".$languageid."'" ;
		// $this->data['sliders'] = $CommonModel->GetResults('slider_controls',$slider_condition);

		$faq_condition = "faq_status = '1' AND language_id = '".$languageid."'";
		$this->data['faqs'] = $CommonModel->GetLimitedRes('faq_controls',$faq_condition,'3');
		$news_condition = "news_status = '1' AND language_id = '".$languageid."' ORDER BY `news_id` desc";
		$this->data['news'] = $CommonModel->GetLimitedRes('news_controls',$news_condition,'3');
		
		
		// $this->load->model('packages_model');
		// $package_condition = "status = '1' AND is_delete = '0' AND closed = '0'";

		// $this->data['packages'] = $CommonModel->GetPackages($package_condition);
		
		$withdraw_condition = "history.type IN ('withdraw_request', 'withdrawal')";
		$this->data['withdraws'] = $CommonModel->Getdashresult($withdraw_condition,'6');
		
		if($this->data['show_top_investors'] == 'on') {
			$deposit_condition = "history.type IN ('deposit', 'reinvest')";
			$this->data['deposits'] = $CommonModel->Getdashresultsumby($deposit_condition,'6');
		}
		if($this->data['show_last_investors'] == 'on') {
			$deposit_condition = "history.type IN ('deposit', 'reinvest')";
			$this->data['deposits'] = $CommonModel->Getdashresult($deposit_condition,'6');	
		}

      
		$this->data['aboutus'] = $CommonModel->Getpageinfo('index-about',$languageid);
	

		$this->data['quantitative'] = $CommonModel->Getpageinfo('quantitative-trading-strategy',$languageid);
		$this->data['simple_easy'] = $CommonModel->Getpageinfo('simple-easy',$languageid);
        $this->data['artificial_intelligence'] = $CommonModel->Getpageinfo('artificial-intelligence',$languageid);
   

		$this->data['security'] = $CommonModel->Getpageinfo('home',$languageid);

		$this->data['secure'] = $CommonModel->Getpageinfo('security',$languageid);		
		$this->data['real_time_strategy'] = $CommonModel->Getpageinfo('real-time-strategy',$languageid);		

		$this->data['experience_team'] = $CommonModel->Getpageinfo('roadmap',$languageid);		

		$all_user_condition = "is_delete = '0'";
		$this->data['total_accounts'] = $CommonModel->RecordCount('uusers',$all_user_condition);
		

		$active_user_condition = "status = '1'";
		$this->data['total_active_acc'] = $CommonModel->RecordCount('uusers', $active_user_condition);
		

		$now = time(); 
     	$your_date = strtotime(site_info('site_start_date'));
     	$datediff = $now - $your_date;
     	$this->data['running_days'] = floor($datediff/(60*60*24));
     	$this->data['stat_started'] = floor($datediff/(60*60*24));
		
		$tot_deposit_condition = "type IN ('deposit', 'reinvest')";
		// $this->data['total_deposit'] = $CommonModel->sumofhistory($tot_deposit_condition);
		$this->data['total_deposit'] = $CommonModel->RecordCount('history',$tot_deposit_condition);

		echo view('user/index',$this->data);
	
	}

	 public function cms() {
       
       $this->session = \Config\Services::session();
       $this->common_model = model('CommonModel');

		// $pageID=$this->uri->getSegment('5');
		$pageID =  $this->request->uri->getSegment('2');

		if($pageID){

			$lang_id = ($this->session->get('user_langid')) ? $this->session->get('user_langid'): '1';
	
				
			$this->data['contents'] = $this->common_model->GetuserCMS($pageID,$lang_id);
			if($this->data['contents']){
				echo view('user/content',$this->data);	
			} else {
				return redirect()->to('my404');	
			}
			
		} else {
			return redirect()->to('my404');
		}
		
	}

}
