<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php $this->load->view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/app.js"></script>
	<!-- /theme JS files -->

	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/formValidation.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/bootstrap.js"></script>

	
	<!-- bootsrap switch checkbox JS files -->
    <script src="<?php echo base_url();?>/assets/boots/js/bootstrap-switch.js"></script>

    <!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/notifications/jgrowl.min.js"></script>
    <!-- Theme JS files -->

	<!-- ckeditor JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/ckeditor/ckeditor.js"></script>
	<script src="<?php echo base_url();?>assets/boots/js/jquery.js"></script>
	

</head>

<body class="navbar-top-md-md">
	<!-- <div class="pre_loader"></div> -->
	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php $this->load->view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php $this->load->view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo $this->lang->line('cms_page_title'); ?></span></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])) {?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?>
						<li><?php echo $breadcrumb['text']; ?></li>
					<?php } }?>
				</ul>
			</div>
			<?php $this->load->view('admin/'.$module_name.'_header'); ?>
			
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Horizontal form -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title">
						<?php 
						if(isset($page_data->page_id)) { 
                           echo $this->lang->line('cms_page_edit');
                        }
                        else{
                           echo $this->lang->line('cms_page_add');

                        }


                        ?>
						</h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
                	</div>
                	
					<div class="panel-body">
						<form class="form-horizontal cms" action="<?php echo $action;?>" method="post">
							<?php 
								if(validation_errors()) { 
									$form_err_data = str_replace('<p>', '', validation_errors());
									$form_err_data = str_replace('</p>', '', $form_err_data);
									$form_err_data = str_replace('.', '', $form_err_data);
							?>
									
									<script type="text/javascript">
									
									(function( $ ) {
										$.jGrowl.defaults.closer = false;
								        var from_daa = '<?php $form_err_data;?>';
										$.jGrowl(from_daa, {
								            header: '<?php echo $this->lang->line("Error");?>',
								            theme: 'bg-danger'
								        });
								    
									})(jQuery);


									</script>
							<?php
								}
							?>
							<input type="hidden" name="page_url" id="page_url" class="form-control" placeholder="<?php echo $this->lang->line('plac_page_title'); ?>" value="<?php echo set_value('page_title',isset($page_data->page_title) ? ucfirst($page_data->page_title) : ''); ?>">

							<div class="form-group  <?php if(form_error('page_title')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo $this->lang->line('cms_page_titlename'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-6">
									<div style="width:100%" class="input-group">
										<input type="text" name="page_title" id="name" class="form-control" placeholder="<?php echo $this->lang->line('plac_page_title'); ?>" value="<?php echo set_value('page_title',isset($page_data->page_title) ? ucfirst($page_data->page_title) : ''); ?>">
									</div>
									<?php echo form_error('page_title', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>

							<div class="form-group   <?php if(form_error('page_content')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo $this->lang->line('cms_page_content'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-11">
									<div style="width:100%" class="input-group">
							        <textarea class="ckeditor" name="page_content" id="editor-readonly" rows="4" cols="4" placeholder="<?php echo $this->lang->line('plac_page_content'); ?>"><?php echo set_value('page_content',isset($row->page_content) ? ucfirst($row->page_content) : ''); ?></textarea>

									</div>
									<?php echo form_error('page_content', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>
                            <!-- <div class="form-group  <?php if(form_error('language_id')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo $this->lang->line('lab_language'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-6">
									<div style="width:100%;" class="input-group">
										<select class="form-control" name="language_id">
											<?php 
												if(isset($page_data->language_id)) {
													$selected_lang = $page_data->language_id;
												} else {
													$selected_lang = '';
												}
												foreach ($languages as $row) { 
											?>
												<option <?php if($selected_lang==strtolower($row->language_id)) { echo 'selected';} ?> value='<?php echo strtolower($row->language_id);?>' ><?php echo ucfirst($row->language_name);?></option>	
											<?php	
												}
											?>
										</select>
									</div>
									<?php echo form_error('language_id', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
								</div>
							</div> -->

							<?php 
								if(isset($page_data->page_id)) { 
									$page_status = $page_data->page_status;
								} else {
									$page_status = '';
								}
							?>
							<!-- Switch single -->
							<div class="form-group <?php if(form_error('page_status')) echo "has-error";?>">
								<label class="control-label col-lg-1 text-semibold"><?php echo $this->lang->line('cms_page_status'); ?> </label>
								<div class="col-lg-6">
									<div class="checkbox checkbox-switch">
										<label>
											<input type="checkbox" <?php if(isset($page_status)=='on'){ echo 'checked="checked"'; }   ?> name="page_status" data-on-color="success" data-off-color="danger" data-on-text="<?php echo $this->lang->line('On');?>" data-off-text="<?php echo $this->lang->line('Off');?>" class="switchery">
										</label>
									</div>
									<?php echo form_error('page_status', '<label class="validation-error-label">', '</label>'); ?>
								</div>
							</div>
							<!-- /switch single -->

							<?php 
								if(isset($page_data->page_id)) { 
							?>
							<input type="hidden" name="page_id" value="<?php echo $page_data->page_id;?>"/>
							<?php } ?>

							<div class="text-right col-lg-9">
								<button type="submit" class="btn btn-primary"><?php if(isset($page_data->page_id)) {  echo $this->lang->line('button_update'); } else { echo $this->lang->line('button_save'); } ?> <i class="icon-arrow-right14 position-right"></i></button>
							</div>
						</form>
					</div>
				</div>
				<!-- /horizotal form -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->
		

		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		jQuery.noConflict();
		(function( $ ) {
		$(function() {

			$(document).ready(function() {

				$.jGrowl.defaults.closer = false;

				<?php if($this->session->flashdata('error_message')) { ?>
					$.jGrowl("<?php echo $this->session->flashdata('error_message');?>", {
			            header: '<?php echo $this->lang->line("error");?>',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($this->session->flashdata('success_message')) { ?>
	                $.jGrowl("<?php echo $this->session->flashdata('success_message');?>", {
			            header: '<?php echo $this->lang->line("success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

			    $('.cms').formValidation({
			    	framework: 'bootstrap',
			    	excluded: [':disabled'],
			        icon: {
			            // valid: 'glyphicon glyphicon-ok',
			            // invalid: 'glyphicon glyphicon-remove',
			            validating: 'glyphicon glyphicon-refresh'
			        },
			        fields: {
			            page_title: {
			                message: '<?php echo $this->lang->line("cms_title_valid");?>',
			                validators: {
			                    notEmpty: {
			                        message: '<?php echo $this->lang->line("cms_title_required");?>'
			                    },
			                    regexp: {
		                        regexp: /^[a-z\d\-\s]+$/i,
		                        message: '<?php echo $this->lang->line("cms_title_space");?>'
		                    }
			                }
			            },
			            page_content: {
			                message: '<?php echo $this->lang->line("cms_content_valid");?>',
			                validators: {
			                    notEmpty: {
			                        message: '<?php echo $this->lang->line("cms_content_required");?>'
			                    },
			                    stringLength: {
				                	min: 20,
				                	message: '<?php echo $this->lang->line("cms_content_exceeds");?>'
				                }
			                }
			                
			            }
			            
			        }
			    })
				.find('[name="page_content"]')
					.ckeditor()
		            .editor
	                .on('change', function() {
	                    $('.cms').formValidation('revalidateField', 'page_content');
	                });
				

			});
		    // $('[name="page_content"]').ckeditor();
		 	$('#icon-bck').on('click',function() {
				window.history.back();
			});
			
		    $(".switchery").bootstrapSwitch();
		    // $("#countries").msDropdown();

		});
		})(jQuery);
	
	</script>

</body>
</html>
