<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;
use App\Libraries\PHPMailer;
use App\Libraries\Commission;

class Bank extends BaseController {

	/**
	 * 
	 * Start 
	 * Create Date: 21 Jul, 2017
	 * This controller to manage user filiter in rank.
	 * Created saravana kumar.
	 * @see http://ihyip.com/admin/sitesettings/
	 * Last Updated: 23 Jun, 2016
	 * End
	 * 
	 */

	public function __construct() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$this->session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$this->session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		// admin login only
		if($this->session->get('admin_login')) {

			// form validation library
			// $this->load->library('form_validation');
			$this->isSubadmin();
			
		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$this->session->set('last_page', current_url());
				return redirect()->to('admin/login');
			}
		}

	}

	private function isSubadmin() {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->router = service('router');

		if($this->session->get('user_type') == 'subadmin') {
			$controller = $this->router->controllerName();
			$pages = json_decode($this->session->get('permission'));
		
			if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}
		}
	}

	private function isCookie($values) {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$this->session->set($array);

		} else {
			return redirect()->to('admin/login');
		}
	}

	public function index()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_rank')
		);

		$value= $_SERVER['QUERY_STRING'];
		$myencrypt = new MyEncrypt;
		$val = $myencrypt->decode($value);

		$this->data['module_name'] = 'settings';
		$this->data['format']=$val;
		
		$condition1="coid ='$val'";
		$this->data['coin_det'] = $this->common_model->GetResults('coin_info',$condition1);
		$this->session->set('add_bank',$val);
		$condition="payment_id = '".$val."'";
		$this->data['pay_address'] = $this->common_model->GetResults('bankwire',$condition);

		echo view('admin/settings/bank',$this->data);

	}
	public function add($id='') {
        $this->session = session();
        $this->form_validation = \Config\Services::validation();
		$format=$this->session->get('add_bank');

		$label=lang('language_lang.menu_bank_page');
		

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url('admin')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_settings'),
			'href' => base_url('admin/sitesettings')
		);
		$this->data['breadcrumbs'][] = array(
			'text' => $label,
			'href' => base_url('admin/bank')
		);
		
		$this->data['module_name'] = 'settings';
		$this->data['action'] =  'admin/bank/add';

		if($id) {
			$myencrypt = new MyEncrypt;
			$pid = $myencrypt->decode($id);
			$condition = "id = '".$pid."'";
			$this->data['addr_data'] = $this->common_model->GetRow('bankwire', $condition);
		}
		else
		{
			$this->data['addr_data']='';
		}

		if($this->request->getPost()) 
		{

			$pay_id=$this->session->get('add_bank');


			$this->form_validation->setRule('account_name',lang("language_lang.account_name"),'required');
			//$this->form_validation->setRule('address',lang("language_lang.menu_bank_aaddress"),'required');
			$this->form_validation->setRule('bank_name',lang("language_lang.menu_bank_name"),'required');
			$this->form_validation->setRule('bank_addr',lang("language_lang.menu_bank_address"),'required');
			$this->form_validation->setRule('iban',lang("language_lang.menu_bank_account"),'required');
			//$this->form_validation->setRule('swift_code',lang("language_lang.menu_bank_swift"),'required');
			if($this->form_validation->withRequest($this->request)->run() == TRUE)
            {

            	$pid=$this->request->getPost('hid');
            	
            	if($pid=='')
            	{
            		$bank_data=array(

            				"payment_id" 	=> $format,
            				"account_name"	=> $this->request->getPost("account_name"),
            				"address"		=> $this->request->getPost("address"),
            				"iban"			=> $this->request->getPost("iban"),
            				"bank_name"		=> $this->request->getPost("bank_name"),
            				"bank_addr"		=> $this->request->getPost("bank_addr"),
            				"swift_code"	=> $this->request->getPost("swift_code"),
            				"date"			=> date("Y-m-d H:i:s")
						);
					$query_status = $this->db->table('bankwire')->insert($bank_data);

					

				}
				else
				{
						$bank_data=array(
							"payment_id" 	=> $format,
            				"account_name"	=> $this->request->getPost("account_name"),
            				"address"		=> $this->request->getPost("address"),
            				"iban"			=> $this->request->getPost("iban"),
            				"bank_name"		=> $this->request->getPost("bank_name"),
            				"bank_addr"		=> $this->request->getPost("bank_addr"),
            				"swift_code"	=> $this->request->getPost("swift_code"),
            				
						);
					
					$query_status = $this->db->table('bankwire')->where("id = '".$pid."'")->update($bank_data);

				}
				$myencrypt = new MyEncrypt;
				$payment_name1=$myencrypt->encode($format);


				if($query_status) {
					$this->session->setFlashData('success_message', lang('language_lang.bank_success_message'));
					return redirect()->to('admin/bank?'.$payment_name1);
				} else {
					$this->session->setFlashData('error_message', lang('language_lang.bank_error_message'));
					return redirect()->to('admin/bank?'.$payment_name1);
				}


            	

            }

			
			/*if($query_status) {
					$this->session->setFlashData('success_message', lang('language_lang.address_success_message'));
					return redirect()->to('admin/addrset?'.$payment_name1);
				} else {
					$this->session->setFlashData('error_message', lang('language_lang.address_error_message'));
					return redirect()->to('admin/addrset?'.$payment_name1);
				}*/
		}
		
		echo view('admin/settings/add_bank',$this->data);
	}


	public function changeStatus() {
		$this->session = session();
		$this->db = db_connect();

		if($this->request->getPost('id')) {

			$myencrypt = new MyEncrypt;
			$uusersid = $myencrypt->decode($this->request->getPost('id'));
		
			$user_data = array(
				"status" => '0'
			);
		
			$update_status = $this->db->table('bankwire')->where('id',$uusersid)->update($user_data);

			if($update_status){
				$this->session->setFlashData('success_message', lang('language_lang.bank_success_message'));
				echo 1;
				// return redirect()->to('admin/users');
			} else {
				$this->session->setFlashData('error_message', lang('language_lang.bank_error_message'));
				// return redirect()->to('admin/users');
				echo 0;
			}
		}
	}

	public function changeinStatus() {
        $this->session = session();
		$this->db = db_connect();
		if($this->request->getPost('id')) {

			$myencrypt = new MyEncrypt;
			$uusersid = $myencrypt->decode($this->request->getPost('id'));
		
			$user_data = array(
				"status" => '1'
			);
			
			$update_status = $this->db->table('bankwire')->where('id',$uusersid)->update($user_data);

			if($update_status){
				$this->session->setFlashData('success_message', lang('language_lang.bank_success_message'));
				echo 1;
				// return redirect()->to('admin/users');
			} else {
				$this->session->setFlashData('error_message', lang('language_lang.bank_error_message'));
				// return redirect()->to('admin/users');
				echo 0;
			}
		}
	}


	public function delete($id) {
		$this->session = session();
		$this->db = db_connect();
		if($id) {
			$myencrypt = new MyEncrypt;

			$format=$this->session->get('add_bank');
			$payment_name1=$myencrypt->encode($format);

			
			$pid = $myencrypt->decode($id);
		
			$delete_status = $this->db->table('bankwire')->where('id',$pid)->delete();
			if($delete_status) {
					$this->session->setFlashData('success_message', lang('language_lang.bank_success_message'));
					return redirect()->to('admin/bank?'.$payment_name1);
				} else {
					$this->session->setFlashData('error_message', lang('language_lang.bank_error_message'));
					return redirect()->to('admin/bank?'.$payment_name1);
				}	
		} 
		else 
		{
			return redirect()->to('admin/bank?'.$payment_name1);
		}
		
	}
	

}

