<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Main navbar -->
		<?php
		use App\Libraries\MyEncrypt;
		$session = session();
		$validation = \Config\Services::validation();
		echo view('admin/common_header'); ?>
	<!-- /main navbar -->
	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/datatables.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/extensions/responsive.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/select2.min.js');?>"></script>

	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/datatables_responsive.js');?>"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    
    <link href="<?php echo base_url('assets/css/icons/fontawesome/styles.min.css');?>" rel="stylesheet" type="text/css">

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/bootbox.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/sweet_alert.min.js');?>"></script>
	<!-- /theme JS files -->
</head>

<body class="navbar-top-md-md pace-done">
<style>
.icons-list > li {
    display: inline-block;
    font-size: 26px;
    }
    .heading-elements .icons-list {
    margin-top: 5px;
}
</style>
	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->

		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->

	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.ip_title'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">
                  <div class="row"> 
                   <div class="col-lg-6">
				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.ip_title'); ?></h5>
						<div class="heading-elements">
						    <ul class="icons-list">
								<li><a class="icon-plus-circle2" data-toggle="modal" data-target="#modal_theme_primary"></a></li>
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>
					<table class="table datatable-responsive-block-ip table-hover">
					<colgroup>
						<col width="50%">
						<col width="50%">
						<col width="50%">
					</colgroup>
						<thead>
							<tr><th></th>
								<th class="text-center"><?php echo lang('language_lang.block_ip_address');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_action');?></th>
							</tr>
						</thead>
						<tbody>
						<?php
							if($ip_data) {
								$row_count = count($ip_data);
								// $this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt;
								foreach ($ip_data as $row) {

							?>
							<tr>
							    <td></td>
							    <td class="text-center"><?php echo ucfirst($row->ip_address);?></td>
								<td class="text-center">
									<ul class="icons-list">
										<li class="dropdown">
											<a href="#" class="dropdown-toggle" data-toggle="dropdown">
												<i class="icon-menu9"></i>
											</a>

											<ul class="dropdown-menu dropdown-menu-right <?php if($row_count=='1' || $row_count=='2') { echo 'inline-drop'; }?>">
												<li><a onclick="editFunc('<?php echo $myencrypt->encode($row->ip_id); ?>')" href="javascript:void(0)"><i class="fa fa-edit"></i> <?php echo lang('language_lang.edit');?></a></li>
												<li><a onclick="confirmdelete('<?php echo $myencrypt->encode($row->ip_id);?>')" href="javascript:void(0)" ><i class="fa fa-remove"></i> <?php echo lang('language_lang.delete');?></a></li>
											</ul>
										</li>
									</ul>
								</td>
							</tr>
						<?php 

								}
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
				</div>
				<!-- /basic responsive configuration -->
				<!-- Basic modal -->
           
				<div id="edit_modal_theme_primary" class="modal fade">
					<div class="modal-dialog">
						<div class="modal-content">
							<div class="modal-header bg-primary">
								<button type="button" class="close" data-dismiss="modal">&times;</button>
								<h5 class="modal-title">
								<?php 
									
			                           echo lang('language_lang.ip_edit_title');
			                         
		                        ?>
								</h5>
							</div>
                            
							<div style="height: 130px;" class="modal-body">
							 <form class="addip" method="post" enctype="multipart/form-data">
								<div class="form-group  <?php if($validation->getError('ip_address')) echo "has-error";?>">
								<label style="width:26%;" class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.block_ip_address'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-6">
									<div style="width:100%" class="input-group">
										<input type="text"  id="ip_address1" name="ip_address" class="form-control" placeholder="<?php echo lang('language_lang.plac_ipaddress'); ?>" value="">
									</div>
									<div style="display:none;color:#d84315;" class="error_msg"><?php echo lang('language_lang.ip_exixst'); ?></div>
									<?php echo $validation->getError('ip_address', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>
							
							<input class="ip_id" type="hidden" name="ip_id" value=""/>
							
							<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
								<button id="edit" class="btn btn-primary" type="button">Save</button>
							</form>
							</div>
						</div>
					</div>
				</div>
							

				<!-- /basic modal -->

				<div id="modal_theme_primary" class="modal fade" >
					<div class="modal-dialog">
						<div class="modal-content">
							<div class="modal-header bg-primary">
								<button type="button" class="close" data-dismiss="modal">&times;</button>
								<h5 class="modal-title">
								<?php 
									if(isset($ip_data->ip_id)) { 
			                           echo lang('language_lang.ip_edit_title');
			                        }
			                        else{
			                           echo lang('language_lang.ip_add_title');
			                        } 
		                        ?>
								</h5>
							</div>

							<div style="height: 130px;" class="modal-body">
							 <form class="addip" method="post" enctype="multipart/form-data">
								<div class="form-group  <?php if($validation->getError('ip_address')) echo "has-error";?>">
								<label class="control-label col-lg-3 text-semibold"><?php echo lang('language_lang.ip_address'); ?> <span class="text-danger">*</span></label>
								<div class="col-lg-6">
									<div style="width:100%" class="input-group">
										<input type="text" id="ip_address" name="ip_address" class="form-control" placeholder="<?php echo lang('language_lang.plac_ipaddress'); ?>" value="">
									</div>
                                    <div style="display:none;color:#d84315;" class="error_msg"><?php echo lang('language_lang.ip_exixst'); ?></div>
									<?php echo $validation->getError('ip_address', '<div class="form-control-feedback"></div><span class="help-block">', '</span>'); ?>
								</div>
							</div>
							<?php 
								if(isset($ip_data->ip_id)) { 
							?>
							<input type="hidden" name="ip_id" value="<?php echo $ip_data->ip_id;?>"/>
							<?php } ?>
							<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
								<button id="check" class="btn btn-primary" type="button">Save</button>
							</form>
							</div>
						</div>
					</div>
				</div>
                 </div>
                <div class="col-lg-6">
				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title">Coming soon</h5>
						<div class="heading-elements">
						    <ul class="icons-list">
								<li><a class="icon-plus-circle2"></a></li>
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>
				<div class="panel-body">
                     Data will update soon...
					</div>
				</div>
			</div>

                 </div>
			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		jQuery.noConflict();
		(function( $ ) {
		$(function() {

			$(document).ready(function() {

				<?php if($session->getFlashData('error_message')) { ?>
					$.jGrowl("<?php echo $session->getFlashData('error_message');?>", {
			            header: '<?php echo lang("language_lang.error");?>',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($session->getFlashData('success_message')) { ?>
	                $.jGrowl("<?php echo $session->getFlashData('success_message');?>", {
			            header: '<?php echo lang("language_lang.success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

	             $("#check").on('click', function(e) {
	            	if($('#ip_address').formValidation('revalidateField','ip_content_valid')){
	            		$.ajax({
		                  type: 'post',
		                  url : '<?=site_url($action); ?>',
		                  data : { ip_address : $('#ip_address').val()},
		                  success : function(msg)
		                  {
		                  
		                    if(msg==3) {
                            	$('.ip-exist').remove();
		                    	$('.input-group').after('<small style="display: none;" class="help-block ip-exist" data-fv-validator="notEmpty" data-fv-for="ip_address" data-fv-result="VALID"><?php echo lang("language_lang.ip_exixst"); ?></small>');
                            	$('.ip-exist').css('display','block');
                            	$('.error_msg').parent().parent().addClass('has-error');
		                    }
		                    else{
                               window.location.href = "<?php echo base_url('admin/ip');?>";
		                    }
		                  }
		                });
	            	}
	            });

	             $("#edit").on('click', function(e) {
	            	if($('#ip_address1').formValidation('revalidateField','ip_content_valid')){
	            		$.ajax({
		                  type: 'post',
		                  url : '<?=site_url($action1); ?>',
		                  data : { ip_id : $('.ip_id').val(), ip_address : $('#ip_address1').val()},
		                  success : function(msg)
		                  {
		                  	
		                    if(msg==3) {
		                    	$('.ip-exist').remove();
		                    	$('.input-group').after('<small style="display: none;" class="help-block ip-exist" data-fv-validator="notEmpty" data-fv-for="ip_address" data-fv-result="VALID"><?php echo lang("language_lang.ip_exixst"); ?></small>');
                            	$('.ip-exist').css('display','block');
                            	$('.error_msg').parent().parent().addClass('has-error');
		                    }
		                    else{
                               window.location.href = "<?php echo base_url('admin/ip');?>";
		                    }
		                  }
		                });
	            	}
	            });
	            $('#ip_address1').on("change", function(){
	            	$('#ip_address1').formValidation('revalidateField','ip_address');
	            })
			    $('.addip').formValidation({
			    	framework: 'bootstrap',
			    	excluded: [':disabled'],
			        icon: {
			            validating: 'glyphicon glyphicon-refresh'
			        },
			        fields: {
			            ip_address: {
			                message: '<?php echo lang("language_lang.ip_content_valid");?>',
			                validators: {
			                    notEmpty: {
			                        message: '<?php echo lang("language_lang.ip_content_required");?>'
			                    },
			                    regexp: {
		                        regexp: /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/,
		                        message: '<?php echo lang("language_lang.ip_content_valid");?>'
		                    }
			                }
			            },
			        }
			    })
				

			});
		    
		 	$('#icon-bck').on('click',function() {
				window.history.back();
			});

		});
		})(jQuery);
	
	function confirmdelete(value) {
		swal({
            title: "<?php echo lang('language_lang.delete_ip');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url('admin/ip/delete/');?>"+'/'+value;
            }
            else {
              return false;
            }

		});
    }

	function editFunc(valus) {
        var valus1 =  valus;
        jQuery.ajax({
	        url:'<?php echo base_url('admin/ip/edit/'); ?>'+'/'+valus1,
	        dataType : 'json',
	        success : function(resp)
	        {
	            if(resp){
	              jQuery('#edit_modal_theme_primary').modal();
	              jQuery('#ip_address1').val(resp['ip_address']);	
	              jQuery('.ip_id').val(resp['ip_id']);
	          }
	            
	        }
		});
	}
		
	</script>

</body>
</html>
