<!DOCTYPE html>
<html lang="en">
<head>
	<!-- header -->
		<?php
		use App\Libraries\MyEncrypt;
		$this->session = session();

		 echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/datatables.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/extensions/responsive.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/select2.min.js');?>"></script>

	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/datatables_responsive.js');?>"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/sweet_alert.min.js');?>"></script>

</head>
<style>
.icons-list > li {
    display: inline-block;
    font-size: 26px;
    }
    .heading-elements .icons-list {
    margin-top: 5px;
}
</style>
<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">
		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->
		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->
	</div>

	<?php
			$name=lang('language_lang.menu_bank_settings');

			?>
	<!-- /fixed navbars wrapper -->
	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left" id="icon-bck"></i> <span class="text-semibold"><?php echo $name; ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $name; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->
	<!-- Page container -->
	<div class="page-container">
		<!-- Page content -->
		<div class="page-content">
			<!-- Main content -->
			<div class="content-wrapper">


			
				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo $name; ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><label ><a href="<?php echo base_url('admin/bank/add');?>" class="icon-plus-circle2"> </a>  </label> </li>
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>

					<table class="table datatable-responsive-row-control table-hover">
						<col width="15%">
						<col width="20%">
						<col width="5%" style="display:none;">
  						<col width="20%">
  						<col width="20%">
  						<col width="25%">
  						<col width="20%">
  						
						<thead>
							<tr>
								<th></th>
								<th class="text-center"><?php echo lang('language_lang.menu_bank_name');?></th>
								<th style="display:none;"></th>
								<th class="text-center"><?php echo lang('language_lang.menu_bank_account');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_user_country');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_status');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_action');?></th>
							</tr>
						</thead>
						<tbody>
						<?php 
							if($pay_address) {
								
								// $this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt;
								foreach ($pay_address as $row) {
									
									if($row->status=='1'){
										$label_status = 'label-success';
										$status = lang('language_lang.active');
									}
									else if($row->status=='2'){
										$label_status = 'label-assign';
										$status = lang('language_lang.assign');
									}
									else if($row->status=='3'){
										$label_status = 'label-paid';
										$status = lang('language_lang.paid');
									}

									 else {
										$label_status = 'label-danger';
										$status = lang('language_lang.unavailable');
									}

									


									
							?>
							<tr>
							<td></td>
								<td class="text-center"><?php echo $row->bank_name;?></td>
								<td style="display:none;"></td>
								<td class="text-center"><?php echo $row->iban; ?></td>
								<td class="text-center"><?php echo $row->bank_addr;?></td>
								<?php
								if($row->status=='0')
								{?>
								    <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" data-popup="tooltip" title="<?php echo lang('language_lang.click_to_active');?>" onclick="changeinStatus('<?php echo $myencrypt->encode($row->id); ?>')"><?php echo $status;?></a></span></td>
								<?php
								}
								else if($row->status=='1')
								{?>
 								    <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" data-popup="tooltip" title="<?php echo lang('language_lang.click_to_deactive');?>" onclick="changeStatus('<?php echo $myencrypt->encode($row->id); ?>')"><?php echo $status;?></a></span></td>
                                <?php
                            	}
                            	?>
								<td class="text-center">
								<a href="<?php echo base_url('admin/bank/add/'.$myencrypt->encode($row->id));?>"><i class="fa fa-edit"></i> </a> |
								<a onclick="confirmdelete('<?php echo $myencrypt->encode($row->id);?>')" href="javascript:void(0)" ><i class="fa fa-remove"></i></a>
								
								
								</td>
							
							</tr>
						<?php 

								}
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
					
				</div>
				<!-- /basic responsive configuration -->

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
	(function($) {

	    $(document).ready(function() {
			$.jGrowl.defaults.closer = false;

			<?php if($this->session->getFlashData('error_message')) { ?>
				$.jGrowl("<?php echo $this->session->getFlashData('error_message');?>", {
		            header: '<?php echo lang("language_lang.error");?>',
		            theme: 'bg-danger'
		        });
            <?php } ?>
                    
            <?php if($this->session->getFlashData('success_message')) { ?>
                $.jGrowl("<?php echo $this->session->getFlashData('success_message');?>", {
		            header: '<?php echo lang("language_lang.success");?>',
		            theme: 'bg-success'
		        });
            <?php } ?>
            
            $('#icon-bck').on('click',function() {
				window.history.back();
			});
		});

	})(jQuery);
	function makeDefault(valus) {
		swal({
            title: "<?php echo lang('language_lang.lbl_default_language');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            cancelButtonColor: true,
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
				var valus1 =  valus;
				jQuery.ajax({
		            type: 'post',
		            url:'<?php echo base_url('admin/addrsettings/makedefaults');?>',
		            data: {'id':valus1},
		            success : function(resp)
		            {
		                if(resp==1)
		                    window.location.href = "<?php echo base_url('admin/addrsettings');?>";
		                else
		                    console.log('fail');
		            }
		        });
		    }
		});
	}

	function changeStatus(valus) {

		swal({
            title: "<?php echo lang('language_lang.confirm_status_text');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
	            var valus1 =  valus;
	            var value='<?php echo $_SERVER['QUERY_STRING'];?>';
	          	jQuery.ajax({
		            type: 'post',
		            url:'<?php echo base_url('admin/bank/changeStatus');?>',
		            data: {'id':valus1},
		            success : function(resp)
		            {
		                if(resp){
		                    window.location.href = "<?php echo base_url('admin/bank');?>?<?php echo $_SERVER['QUERY_STRING'];?>";
		                } 
		            }
		        });
		    }
        });
	}


	function changeinStatus(valus) {

		swal({
            title: "<?php echo lang('language_lang.confirm_status_text');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
	            var valus1 =  valus;
	            var value='<?php echo $_SERVER['QUERY_STRING'];?>';
	          	jQuery.ajax({
		            type: 'post',
		            url:'<?php echo base_url('admin/bank/changeinStatus');?>',
		            data: {'id':valus1},
		            success : function(resp)
		            {
		                if(resp){
		                    window.location.href = "<?php echo base_url('admin/bank');?>?<?php echo $_SERVER['QUERY_STRING'];?>";
		                } 
		            }
		        });
		    }
        });
	}

	function confirmdelete(value) {
		swal({
            title: "<?php echo lang('language_lang.delete_address');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            cancelButtonColor: true,
            showLoaderOnConfirm: true
        },
        function(inputValue){
            if (inputValue === false) {
            	return false;
            } else {
            	window.location.href = "<?php echo base_url('admin/bank/delete/');?>"+'/'+value;
            }
        });
    }
	</script>

</body>
</html>
