<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;
use App\Libraries\PHPMailer;
use App\Libraries\Commission;

class Botactivate extends BaseController {

	/**
	* 
	* Start 
	* Create Date: 15 July, 2016
	* This controller to manage all transactions.
	* Created saravanan.
	* @see http://zhyip.com/
	* Last Updated: 18 November, 2016
	* End
	* 
	*/

	public function __construct() {
        $this->session = session();
		// admin login only
		if($this->session->get('admin_login')) {

			// form validation library
			// $this->load->library('form_validation');
            $this->finance_model = model('finance_model');
            $this->packages_model = model('packages_model');

			// $this->load->model('finance_model');
			// $this->load->model('packages_model');

			helper('inflector');
			$this->isSubadmin();
			
			
		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$this->session->set('last_page', current_url());
				return redirect()->to('admin/login');
			}
		}

	}

	private function isSubadmin() {
		$this->router = service('router');
        $this->session = session();
        $this->form_validation = \Config\Services::validation();
		if($this->session->get('user_type') == 'subadmin') {
			$controller = $this->router->controllerName();
			$pages = json_decode($this->session->get('permission'));
		
			/*if(!in_array(ucfirst($controller), $pages)) {
				return redirect()->to('admin');
			}*/
		}
	}

	// 
	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$this->session->set($array);

		} else {
			return redirect()->to('admin/login');
		}
	}

     public function index()
     {
        $this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();
		$uri = service('uri');
		if(!$session->get('admin_login')) {
			return redirect()->to('admin/login');
		}
		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		$this->data['breadcrumbs'][] = array(
			'text' => 'Bot activate list'
		);
		
		$this->data['module_name'] = 'finance';
        $this->data['page_title'] = 'Bot Activate list';

		$admin_login=$this->session->get('userid');
		$get_admin=$this->db->query("select * from admin where id='".$admin_login."'")->getRow();
		$user_group = $get_admin->user_group;


		if($user_group=='0')
			$condition='';
		else if($user_group=='1')
			$condition="new_entry='0'";
		else if($user_group=='2')
			$condition="new_entry='1'";

	
        $this->data['users'] = $this->common_model->GetResults('uusers', $condition);
        $this->data['tradepair'] = $this->common_model->GetResults('tradepair_list');


		if($this->request->getPost())
		{
			$username=$this->request->getPost('username');
			$fromdate=$this->request->getPost('start_date');
			$todate=$this->request->getPost('end_date');
			$pair=$this->request->getPost('symbols');
			$status=$this->request->getPost('status');
			$user_type=$this->request->getPost('user_group');
			
			$from='';
			$to='';
         	$this->data['user']=$username;
			$this->data['fromdate']=$fromdate;
			$this->data['todate']=$todate;
			$this->data['pairs']=$pair;
			$this->data['status']=$status;
			$this->data['user_type']=$user_type;

			//print_r($this->request->getPost());
			
			$condi='';
			if($username!='')
			{
			    $get_user=$this->db->query("select * from uusers where username='".$username."'")->getRow();
			    $userid=$get_user->uusersid;
				$condi.=" and uusersid='".$userid."'";
			}
			if($pair!='')
			{
				$condi.=" and pair='".$pair."'";
			}
			if($status!='')
			{
				$condi.=" and trade_log='".$status."'";
			}
			else
			{
				if($fromdate!='' && $todate!='')
				{
					$from=date("Y-m-d 00:00:00", strtotime($fromdate));
					$to=date("Y-m-d 23:59:59", strtotime($todate));
				}
				else if($fromdate!='' && $todate=='')
				{
					$from=date("Y-m-d 00:00:00", strtotime($fromdate));
					$to=date("Y-m-d 23:59:59", strtotime($fromdate));
				}
				else if($fromdate=='' && $todate!='')
				{
					$from=date("Y-m-d 00:00:00", strtotime($fromdate));
					$to=date("Y-m-d 23:59:59", strtotime($todate));
				}
				

				if($from!='' && $to!='')
				{
					$from=strtotime($from);
					$to =strtotime($to);
					$condi.=" and created_time between $from and $to";
				}
			}

			
			
			$this->data['trades']=$this->db->query("select * from trade_process where trade_status!='2' and flag='0' $condi group by uusersid,pair order by id desc")->getResult();

		}
		else
		{
			$this->data['user']='';
			$this->data['fromdate']='';
			$this->data['todate']='';
			$this->data['pairs']='';
			$this->data['status']='';
			$this->data['user_type']='';

			$this->data['trades']=$this->db->query("select * from trade_process where trade_status!='2' and flag='0'  group by uusersid,pair order by id desc limit 10")->getResult();
		}
  
        // echo '<pre>';
        // print_r($this->data['tradepair']);
        // exit;

        echo view('admin/botactivate-list',$this->data);
     }

	 public function acitvate_trade()
	 {
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();

		$uusersid=$this->request->getPost('userid');
		$exchange=$this->request->getPost('exchange');
		$pair=$this->request->getPost('pair');

		$query_status = $this->db->query("UPDATE trade_process SET trade_status=1, updated_time='".time()."' WHERE uusersid='".$uusersid."' and pair='".$pair."' and exchange='".$exchange."' and trade_status = 0 order by id desc ");


		$session = \Config\Services::session();
		$session->setFlashData('success_message', 'Request Trade status activated successfully');
		return redirect()->to('admin/bot/activate-list');

	}

	public function pause_trade()
	{
		$this->db = db_connect();
		$myencrypt = new MyEncrypt(true);
		$this->common_model = model('CommonModel');
		$session = \Config\Services::session();
		$validation = \Config\Services::validation();

		$uusersid=$this->request->getPost('userid');
		$exchange=$this->request->getPost('exchange');
		$pair=$this->request->getPost('pair');

		$query_status = $this->db->query("UPDATE trade_process SET trade_status=0, updated_time='".time()."' WHERE uusersid='".$uusersid."' and pair='".$pair."' and exchange='".$exchange."' and trade_status = 1 order by id desc ");


		$session = \Config\Services::session();
		$session->setFlashData('success_message', 'Request Trade status paused successfully');
		return redirect()->to('admin/bot/activate-list');

	}

}