<!DOCTYPE html>
<html lang="en">
<head>
	<?php
      $this->session = session();
      helper('form');
      $validation =  \Config\Services::validation();

	?>
	<!-- header -->
		<?php echo view('admin/common_header'); ?>
	<!-- /header -->

	<!-- Bootsrap form validation JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/formValidation.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/bootstrap.js');?>"></script>

	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/pnotify.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/noty.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url();?>"></script>

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>assets/js/core/app.js"></script>
	<!-- /theme JS files -->

</head>

<body class="login-cover">

	<!-- Page container -->
	<div class="page-container login-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">


	            <!-- Password recovery form -->
				<div id="" class="panel panel-body login-form">

					<!-- Form -->
					<form class="reset-password" method="post" action="<?php echo base_url('admin/login/reset');?>">
						<div class="text-center">
							<div class="icon-object border-warning text-warning"><i class="icon-spinner11"></i></div>
							<h5 class="content-group"><?php echo "Password recovery";?> 
								<small class="display-block"><?php echo "We'll send you instructions in email";?></small>
							</h5>
						</div>

						<div class="form-group has-feedback">
							<input type="email" name="email" class="form-control" placeholder="Your email" value="<?php echo set_value('email');?>">
							<div class="form-control-feedback">
								<i class="icon-mail5 text-muted"></i>
							</div>
							<?php echo $validation->getError('email', '<div class="form-control-feedback"></div><span class="help-block" style="color:#EB5055;font-weight:bold;">', '</span>'); ?>
						</div>

						<button type="submit" class="btn bg-blue btn-block"><?php echo "Reset Password";?> <i class="icon-circle-right2 position-right"></i></button>
						<button type="button" class="btn btn-default btn-block" id="cancel"><?php echo "Cancel";?></button>
					</form>
					<!-- /form -->
						
				</div>
				<!-- /password recovery form -->


			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-white">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
	jQuery.noConflict();
	(function( $ ) {
	$(function() {

		$(document).ready(function() {

 $.jGrowl.defaults.closer = false;
			<?php if($this->session->getFlashData('reset_error_message')) { ?>

			$('#jgrowl-warning').on('click', function () {
		        $.jGrowl('<?php echo $this->session->getFlashData('reset_error_message');?>', {
		            header: 'Attention Here!',
		            theme: 'bg-warning'
		        });
		    });

		    <?php } ?>


			
			$('#cancel').on('click', function() {
				window.location.href="<?php echo base_url('admin/login');?>";
			});
			$('.reset-password').formValidation({
		    	framework: 'bootstrap',
		    	excluded: [':disabled'],
		        
		        fields: {
		            email: {
		                message: '<?php echo "The mail address is required and can\'t be empty";?>',
		                validators: {
		                    notEmpty: {
		                        message: '<?php echo "The mail address is required and can\'t be empty";?>'
		                    },
		                    emailAddress: {
		                        message: '<?php echo "The mail address is invalid"; ?>'
		                    }
		                }
		            }
		            
		        }
		    })
			
		});
	    
	   

	});
	})(jQuery);

	
	</script>

</body>
</html>
