<?php 
namespace App\Controllers\Admin;
use App\Views;
use App\Models\CommonModel;
use App\Libraries\MyEncrypt;

class Accountsettings extends BaseController {

	/**
	 * 
	 * Start 
	 * Create Date: 23 Aug, 2016
	 * This controller to manage account setting page.
	 * Created karthiga.
	 * @see http://zhyip.com/admin/accountsettings/
	 * Last Updated: 23 Aug, 2016
	 * End
	 * 
	 */

	public function __construct() {
		$this->common_model = model('CommonModel');
		helper('site_helper');
		$session = \Config\Services::session();
		if(!$session->get('admin_login')){
			return redirect()->to(site_url('admin/login'));
		}

		// admin login only
		if($session->get('admin_login')) {

			// form validation library
			 $this->load->library('form_validation');

		} else {
			if(isset($_COOKIE['remember_token'])) {

				$myencrypt = new MyEncrypt;
				$token_value = $myencrypt->decode($this->input->cookie('remember_token'));
				$this->isCookie($token_value);	

			} else {
				$session->set('last_page', current_url());
				return redirect()->to('admin/login');
			}
		}
		
	}

	
	private function isCookie($values) {

		$value = explode('|', $values);
		$result = $this->common_model->getPassword($value[0]);
		$hashed_password = $result->password;

		if(crypt(urlencode($value[1]), $hashed_password)) {

			$array = array(
				"logged_in" => TRUE,
				"userid" => $result->id,
				"admin_login" => TRUE
			);
			$this->session->set_userdata($array);

		} else {
			redirect('admin/login');
		}
	}



	public function index()
	{
		$this->db = db_connect();
		$session = \Config\Services::session();
		if(!$session->get('admin_login')){
			return redirect()->to(site_url('admin/login'));
		}
        $this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.text_home'),
			'href' => base_url().'admin'
		);
		
		$this->data['breadcrumbs'][] = array(
			'text' => lang('language_lang.admin_account_sett_title')
		);
		 $this->data['module_name'] = 'settings';
		$condition="id = '".$session->get('userid')."'";
        $this->data['admin'] = $this->common_model->GetRow('admin',$condition);

        $this->data['action'] = 'admin/accountsettings';
         
		if($this->request->getPost()) {
			
			$admin_data = array(
				"securitymail"	=>	$this->request->getPost('securitymail'),
				"mailverification"	=>	$this->request->getPost('mailverification'),
				"ipVerification" => $this->request->getPost('ipVerification')
			);
					
	$query_status = $this->db->table('admin')->where('id',$this->request->getPost('id'))->update($admin_data);
                
				if($query_status) {
					$session->setFlashData('success_message', lang('language_lang.admin_acc_settings_success'));
					return redirect()->to('admin/accountsettings');
				} else {
					$session->setFlashData('error_message', lang('language_lang.admin_acc_settings_error'));
					return redirect()->to('admin/accountsettings');
				}
			
			
		}
	echo view('admin/settings/accountsettings',$this->data);

	}
	
}

