<!DOCTYPE html>
<html lang="en">
<head>
	<?php $this->load->view('admin/common_header'); ?>

	<!-- Theme JS files -->
	
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/libraries/jquery.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/libraries/bootstrap.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/loaders/blockui.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/ui/nicescroll.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/ui/drilldown.js"></script>
	
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/forms/validation/validate.min.js"></script>
	

	<!-- /theme JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/app.js"></script>

	<!-- date picker JS files -->
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/libraries/jquery_ui/interactions.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/libraries/jquery_ui/widgets.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/libraries/jquery_ui/effects.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/extensions/mousewheel.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/core/libraries/jquery_ui/globalize/globalize.js"></script>
	
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/pages/jqueryui_forms.js"></script>
	
	<!-- file upload JS files -->	
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/uploaders/fileinput.min.js"></script>

	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/forms/styling/uniform.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/forms/styling/switchery.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/plugins/forms/styling/switch.min.js"></script>
	<script type="text/javascript" src="<?php echo base_url();?>assets/js/pages/form_checkboxes_radios.js"></script> 


</head>

<body>

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php $this->load->view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php $this->load->view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<?php $this->load->view('admin/pageheader'); ?>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Form validation -->
				<div class="panel panel-flat">
					<div class="panel-heading">
					
						<h5 class="panel-title"><?php echo $page_title; ?></h5>
						<div class="heading-elements">
							<ul class="icons-list">
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
	                	<!-- <hr> -->
	                	<!-- <legend></legend> -->
					</div>

					<div class="panel-body">
						<!-- <p class="content-group-lg"><?php echo $page_info; ?></p> -->
						<?php if($this->session->flashdata('error_message')) { ?> 
							<?php echo $this->session->flashdata('error_message');?>
		                <?php } ?>
                                
                        <?php if($this->session->flashdata('success_message')) { ?>
			                <?php echo $this->session->flashdata('success_message');?>
                        <?php } ?>

						<form class="form-horizontal form-validate-jquery" action="<?php echo $action;?>" method="post">
							<fieldset class="content-group">
								<!-- <legend class="text-bold">Basic inputs</legend> -->

								<div class="form-group has-feedback <?php if(form_error('name')) echo "has-error";?>">
									<label class="control-label col-lg-3 text-semibold"><?php echo $lbl_site_name; ?> <span class="text-danger">*</span></label>
									<div class="col-lg-6">
										<div class="input-group">
											<span class="input-group-addon"><i class="icon-droplets"></i></span>
											<input type="text" name="name" id="name" class="form-control" placeholder="<?php echo $lbl_site_name; ?>" value="<?php echo set_value('name',isset($this->data['site_name']) ? $this->data['site_name'] : ''); ?>">
										</div>
										<?php echo form_error('name', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
									</div>
								</div>

								<!-- URL validation -->
								<div class="form-group has-feedback <?php if(form_error('url')) echo "has-error";?>">
									<label class="control-label col-lg-3"><?php echo $lbl_site_url; ?> <span class="text-danger">*</span></label>
									<div class="col-lg-6">
										<input type="text" name="url" class="form-control"  placeholder="<?php echo $lbl_site_url; ?>" value="<?php echo set_value('url',isset($this->data['site_url']) ? $this->data['site_url'] : ''); ?>">
										<div class="form-control-feedback">
											<i class="icon-link"></i>
										</div>
										<?php echo form_error('url', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
									</div>
								</div>
								<!-- /url validation -->

								
								<!-- Styled file uploader -->
								<!-- <div class="form-group">
									<label class="control-label col-lg-3"><?php echo $lbl_site_logo; ?> <span class="text-danger">*</span></label>
									<div class="col-lg-6">
										<input type="file" name="logo" class="file-styled" value="<?php echo set_value('logo'); ?>">
										<span><img src="../uploads/site/<?php if(isset($this->data['site_logo'])) {echo $this->data['site_logo']; } ?>"/></span>
										<?php echo form_error('logo', '<label class="validation-error-label">', '</label>'); ?>
									</div>
								</div> -->
								<!-- /styled file uploader -->

								<div class="form-group <?php if(form_error('logo')) echo "has-error";?>">
									<label class="col-lg-3 control-label text-semibold"><?php echo $lbl_site_logo; ?> <span class="text-danger">*</span></label>
									<div class="col-lg-6">
										<input type="file" name="logo" class="file-input-extensions" value="<?php echo set_value('logo', isset($this->data['site_logo']) ? $this->data['site_logo'] : '' ); ?>">
										<span class="help-block">Allow only specific file extensions. In this example only <code>jpg</code>, <code>gif</code>, <code>png</code> and <code>jpeg</code> extensions are allowed.</span>
										<?php echo form_error('logo', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
									</div>
								</div>


								<!-- Date validation -->
								<div class="form-group has-feedback ">
									<label class="control-label col-lg-3"><?php echo $lbl_start_date; ?> <span class="text-danger">*</span></label>
									<div class="col-lg-6">
										<div class="form-control-feedback">
											<i class="icon-calendar"></i>
										</div>
										<input type="text" class="form-control datepicker" placeholder="<?php echo $lbl_start_date; ?>" name="start_date" value="<?php echo set_value('start_date',isset($this->data['site_start_date']) ? date('Y-m-d', strtotime($this->data['site_start_date'])) : ''); ?>">
			                        	<!-- <input type="text" class="form-control" data-mask="99/99/9999" placeholder="<?php echo $lbl_start_date; ?>" name="start_date" value="<?php echo set_value('start_date',isset($this->data['site_start_date']) ? $this->data['site_start_date'] : ''); ?>">
			                        	<span class="help-block">/99/9999</span>-->
			                        	
										<?php echo form_error('start_date', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
			                        </div>
								</div>

								<!-- /date validation -->

								<!-- Input with icons -->
								<div class="form-group <?php if(form_error('meta_title')) echo "has-error";?> has-feedback">
									<label class="control-label col-lg-3"><?php echo $lbl_meta_title; ?> <span class="text-danger">*</span></label>
									<div class="col-lg-6">
										<div class="form-control-feedback">
											<i class="icon-droplets"></i>
										</div>
										<input type="text" name="meta_title" class="form-control"  placeholder="<?php echo $lbl_meta_title; ?>" value="<?php echo set_value('meta_title',isset($this->data['meta_title']) ? $this->data['meta_title'] : ''); ?>">
										
										<?php echo form_error('meta_title', '<div class="form-control-feedback"><i class="icon-cancel-circle2"></i></div><span class="help-block">', '</span>'); ?>
									</div>
								</div>
								<!-- /input with icons -->

								<!-- Text Area -->
								<div class="form-group <?php if(form_error('meta_key')) echo "has-error";?>">
									<label class="control-label col-lg-3"><?php echo $lbl_meta_key; ?> <span class="text-danger">*</span></label>
									<div class="col-lg-6">
										<textarea rows="5" name="meta_key" cols="5" class="form-control" placeholder="<?php echo $lbl_meta_key; ?>"><?php echo set_value('meta_key',isset($this->data['meta_key']) ? $this->data['meta_key'] : ''); ?></textarea>
										<?php echo form_error('meta_key', '<span class="help-block">', '</span>'); ?>
									</div>
								</div>
								<!-- /Text Area -->

								<!-- Text Area -->
								<div class="form-group <?php if(form_error('meta_description')) echo "has-error";?>">
									<label class="control-label col-lg-3"><?php echo $lbl_meta_decription; ?> <span class="text-danger">*</span></label>
									<div class="col-lg-6">
										<textarea rows="5" name="meta_description" cols="5" class="form-control" placeholder="<?php echo $lbl_meta_decription; ?>"><?php echo set_value('meta_description',isset($this->data['meta_description']) ? $this->data['meta_description'] : ''); ?></textarea>
										<?php echo form_error('meta_description', '<span class="help-block">', '</span>'); ?>
									</div>
								</div>
								<!-- /Text Area -->

								<!-- Text Area -->
								<div class="form-group <?php if(form_error('analytical_code')) echo "has-error";?>">
									<label class="control-label col-lg-3"><?php echo $lbl_analytical_code; ?> <span class="text-danger">*</span></label>
									<div class="col-lg-6">
										<textarea rows="5" name="analytical_code" cols="5" class="form-control" placeholder="<?php echo $lbl_analytical_code; ?>"><?php echo set_value('analytical_code',isset($this->data['analytical_code']) ? $this->data['analytical_code'] : ''); ?></textarea>
										<?php echo form_error('analytical_code', '<span class="help-block">', '</span>'); ?>
									</div>
								</div>
								<!-- /Text Area -->

								
								<!-- Switch single -->
								<div class="form-group <?php if(form_error('status')) echo "has-error";?>">
									<label class="control-label col-lg-3"><?php echo $lbl_site_status; ?> <span class="text-danger">*</span></label>
									<div class="col-lg-6">
										<div class="checkbox checkbox-switch">
											<label>
												<input type="checkbox" <?php if($site_status==='on'){ echo 'checked="checked"'; }   ?> name="status" data-on-text="Yes" data-off-text="No" class="switch">
												
											</label>
										</div>
										<?php echo form_error('status', '<label class="validation-error-label">', '</label>'); ?>
									</div>
								</div>
								<!-- /switch single -->


								<!-- Text Area -->
								<div class="form-group <?php if(form_error('offline_msg')) echo "has-error";?>">
									<label class="control-label col-lg-3"><?php echo $lbl_offline_msg; ?> <span class="text-danger">*</span></label>
									<div class="col-lg-6">
										<textarea rows="5" name="offline_msg" cols="5" class="form-control" placeholder="<?php echo $lbl_offline_msg; ?>"><?php echo set_value('offline_msg',isset($this->data['site_offline_msg']) ? $this->data['site_offline_msg'] : ''); ?></textarea>
										<?php echo form_error('offline_msg', '<span class="help-block">', '</span>'); ?>
									</div>
								</div>
								<!-- /Text Area -->

							</fieldset>

							<div class="text-right col-lg-9">
								<button type="submit" class="btn btn-primary"><?php echo $btn_update; ?> <i class="icon-arrow-right14 position-right"></i></button>
							</div>
						</form>
					</div>
				</div>
				<!-- /form validation -->


			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
	$(function() {
	// Setup validation
    // ------------------------------

    $(document).ready(function() {
	    // Initialize
	    var validator = $(".form-validate-jquery").validate({
	        ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
	        errorClass: 'validation-error-label',
	        successClass: 'validation-valid-label',
	        highlight: function(element, errorClass) {
	            $(element).removeClass(errorClass);
	        },
	        unhighlight: function(element, errorClass) {
	            $(element).removeClass(errorClass);
	        },

	        // Different components require proper error label placement
	        errorPlacement: function(error, element) {

	            // Styled checkboxes, radios, bootstrap switch
	            if (element.parents('div').hasClass("checker") || element.parents('div').hasClass("choice") || element.parent().hasClass('bootstrap-switch-container') ) {
	                if(element.parents('label').hasClass('checkbox-inline') || element.parents('label').hasClass('radio-inline')) {
	                    error.appendTo( element.parent().parent().parent().parent() );
	                }
	                 else {
	                    error.appendTo( element.parent().parent().parent().parent().parent() );
	                }
	            }

	            // Unstyled checkboxes, radios
	            else if (element.parents('div').hasClass('checkbox') || element.parents('div').hasClass('radio')) {
	                error.appendTo( element.parent().parent().parent() );
	            }

	            // Input with icons and Select2
	            else if (element.parents('div').hasClass('has-feedback') || element.hasClass('select2-hidden-accessible')) {
	                error.appendTo( element.parent() );
	            }

	            // Inline checkboxes, radios
	            else if (element.parents('label').hasClass('checkbox-inline') || element.parents('label').hasClass('radio-inline')) {
	                error.appendTo( element.parent().parent() );
	            }

	            // Input group, styled file input
	            else if (element.parent().hasClass('uploader') || element.parents().hasClass('input-group')) {
	                error.appendTo( element.parent().parent() );
	            }

	            else {
	                error.insertAfter(element);
	            }
	        },
	        validClass: "validation-valid-label",
	        success: function(label) {
	            label.addClass("validation-valid-label").text("Success.")
	        },
	       //  rules: {
        //     password: {
        //         minlength: 5
        //     },
        //     repeat_password: {
        //         equalTo: "#password"
        //     },
        //     email: {
        //         email: true
        //     },
        //     repeat_email: {
        //         equalTo: "#email"
        //     },
        //     minimum_characters: {
        //         minlength: 10
        //     },
        //     maximum_characters: {
        //         maxlength: 10
        //     },
        //     minimum_number: {
        //         min: 10
        //     },
        //     maximum_number: {
        //         max: 10
        //     },
        //     number_range: {
        //         range: [10, 20]
        //     },
        //     url: {
        //         url: true
        //     },
        //     date: {
        //         date: true
        //     },
        //     date_iso: {
        //         dateISO: true
        //     },
        //     numbers: {
        //         number: true
        //     },
        //     digits: {
        //         digits: true
        //     },
        //     card: {
        //         creditcard: true
        //     },
        //     basic_checkbox: {
        //         minlength: 2
        //     },
        //     styled_checkbox: {
        //         minlength: 2
        //     },
        //     switchery_group: {
        //         minlength: 2
        //     },
        //     switch_group: {
        //         minlength: 2
        //     }
        // },
        // messages: {
        //     custom: {
        //         required: "This is a custom error message",
        //     },
        //     agree: "Please accept our policy"
        // }
		    rules: {
	            name: {
	                required: true,
	                minlength: 5
	            },
	            url: {
	                url: true,
	                required: true
	            },
	            offline_msg: {
	                required: true
	            },
	            start_date: {
	                date: true,
	                required: true
	            },
	            status: {
	                required: true
	            },
	            meta_title: {
	            	required: true,
	            	minlength: 5
	            },
	            meta_key: {
	            	required: true,
	            	minlength: 5
	            },
	            meta_description: {
	            	required: true,
	            	minlength: 5
	            },
	            analytical_code: {
	            	required: true
	            }
	            
	        },
	        messages: {
	            name: {
	                required: "site name field must be filled"
	            },
	            url: {
	                url: "Invalid site url",
	                required: "site url field must be filled"

	            },
	            offline_msg: {
	                required: "site offline message field must be filled"
	            },
	            start_date: {
	                date: "Invalid site start date",
	                required: "site start date field must be filled"
	            },
	            status: {
	                required: "site status must be selected"
	            },
	            meta_title: {
	            	required: "Meta title field is required",
	            	minlength: "Meta title is minimum 5 characters",
	            },
	            meta_key: {
	            	required: "meta keywords field is required",
	            	minlength: "meta keywords is minimum 5 characters",
	            },
	            meta_description: {
	            	required: "meta description field is required",
	            	minlength: "meta description is minimum 5 characters"
	            },
	            analytical_code: {
	            	required: "Analytical code field is required"
	            }
	        }
	    });
	});

	    // Reset form
	    $('#reset').on('click', function() {
	        validator.resetForm();
	    });

	});
	$(".file-input-extensions").fileinput({
        browseLabel: 'Browse',
        browseClass: 'btn btn-primary',
        uploadClass: 'btn btn-default',
        browseIcon: '<i class="icon-file-plus"></i>',
        uploadIcon: '<i class="icon-file-upload2"></i>',
        removeIcon: '<i class="icon-cross3"></i>',
        layoutTemplates: {
            icon: '<i class="icon-file-check"></i>'
        },
        maxFilesNum: 10,
        allowedFileExtensions: ["jpg", "gif", "png", "jpg"]
    });
	</script>


</body>
</html>
