<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Main navbar -->
		<?php
		use App\Libraries\MyEncrypt;

		$this->session = session();

		 echo view('admin/common_header'); ?>
	<!-- /main navbar -->

	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/datatables.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/tables/datatables/extensions/responsive.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/select2.min.js');?>"></script>

	<script type="text/javascript" src="<?php echo base_url('assets/js/core/app.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/datatables_responsive.js');?>"></script>
	<!-- /theme JS files -->

	<!-- notify JS files -->
    <script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/jgrowl.min.js');?>"></script>
    
    <link href="<?php echo base_url('assets/css/icons/fontawesome/styles.min.css');?>" rel="stylesheet" type="text/css">

    <!-- Theme JS files -->
	
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/forms/selects/bootstrap_select.min.js');?>"></script>
	<!-- select box JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/pages/form_bootstrap_select.js');?>"></script>
	<!-- /select box JS files -->


	<!-- Theme JS files -->
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/bootbox.min.js');?>"></script>
	<script type="text/javascript" src="<?php echo base_url('assets/js/plugins/notifications/sweet_alert.min.js');?>"></script>
	<!-- /theme JS files -->
	<style>
		.icons-list > li {
		    display: inline-block;
		    font-size: 26px;
		}
		.heading-elements .icons-list {
		    margin-top: 5px;
		}
	</style>
</head>

<body class="navbar-top-md-md pace-done">

	<!-- Fixed navbars wrapper -->
	<div class="navbar-fixed-top">

		<!-- Main navbar -->
		<?php echo view('admin/mainnav'); ?>
		<!-- /main navbar -->


		<!-- Second navbar -->
		<?php echo view('admin/secondnav'); ?>
		<!-- /second navbar -->

	</div>
	<!-- /fixed navbars wrapper -->


	<!-- Page header -->
	<div class="page-header">
		<div class="page-header-content">
			<div class="page-title">
				<h4><i id="icon-bck" class="icon-arrow-left52 position-left"></i> <span class="text-semibold"><?php echo lang('language_lang.subadmin_lbl'); ?></h4>

				<ul class="breadcrumb breadcrumb-caret position-right">
					<?php foreach ($breadcrumbs as $breadcrumb) { if(isset($breadcrumb['href'])){?>
					    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
					<?php } else { ?> <li><?php echo $breadcrumb['text']; ?></li><?php } } ?>
				</ul>
			</div>
			<?php echo view('admin/'.$module_name.'_header'); ?>
		</div>
	</div>
	<!-- /page header -->


	<!-- Page container -->
	<div class="page-container">

		<!-- Page content -->
		<div class="page-content">

			<!-- Main content -->
			<div class="content-wrapper">

				<!-- Basic responsive configuration -->
				<div class="panel panel-flat">
					<div class="panel-heading">
						<h5 class="panel-title"><?php echo lang('language_lang.subadmin_lbl'); ?></h5>
						<div class="heading-elements">
						    <ul class="icons-list">
								<li><a href="<?php echo base_url('admin/subadmin/add');?>" class="icon-plus-circle2"></a></li>
		                		<li><a data-action="collapse"></a></li>
		                		<li><a data-action="reload"></a></li>
		                		<li><a data-action="close"></a></li>
		                	</ul>
	                	</div>
					</div>
					<table class="table datatable-responsive-column-controlled table-hover">
					<colgroup>
						<col width="8%">
						<col width="20%">
						<col width="20%">
						<col width="20%">
						<col width="20%">
						<col width="12%">
					</colgroup>
						<thead>
							<tr><th></th><th><?php echo lang('language_lang.exp_report_sno');?></th>
								<th class="text-center"><?php echo lang('language_lang.plac_smtp_username');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_user_email');?></th>
								<th class="text-center"><?php echo lang('language_lang.subadmin_previlage');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_mail_status');?></th>
								<th class="text-center"><?php echo lang('language_lang.lbl_action');?></th>
							</tr>
						</thead>
						<tbody>
						<?php
							if($subadmin_data) {
								$i=1;
								$row_count = count($subadmin_data);
								// $this->load->library('MyEncrypt');
								$myencrypt = new MyEncrypt;

								foreach ($subadmin_data as $row) {
									

									if($row->status=='1'){
										$label_status = 'label-success';
										$status = lang('language_lang.active');
									} else {
										$label_status = 'label-danger';
										$status = lang('language_lang.in_active');
									}
							?>
							<tr><td></td>
							    <td><?php echo $i; ?></td>
								<td class="text-center"><?php echo ucfirst($row->username);?></td>
							    <td class="text-center"><?php echo $row->email;?></td>
								<td class="text-center"><button type="button" class="btn btn-info btn-sm" data-toggle="modal" data-target="#modal_theme_primary<?php echo $row->id;?>"><?php echo lang('language_lang.subadmin_view_previlage'); ?> <i class="fa fa-search position-right"></i></button></td>
								<?php if($row->status=='1'){ ?>
								         <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" onclick="changeStatus('<?php echo $myencrypt->encode($row->id); ?>')" href="javascript:void(0)"><?php echo $status;?></a></span></td>
								<?php } else {?>
 								         <td class="text-center"><span class="label <?php echo $label_status;?>"><a style="color:#fff;text-transform:none;font-size:13px;" onclick="changeActiveStatus('<?php echo $myencrypt->encode($row->id); ?>')" href="javascript:void(0)"><?php echo $status;?></a></span></td>
                                <?php } ?>
								<td class="text-center">
									<ul class="icons-list">
										<li class="dropdown">
											<a href="#" class="dropdown-toggle" data-toggle="dropdown">
												<i class="icon-menu9"></i>
											</a>

											<ul class="dropdown-menu dropdown-menu-right <?php if($row_count=='1' || $row_count=='2') { echo 'inline-drop'; }?>">
												<li><a href="<?php echo base_url('admin/subadmin/edit/'.$myencrypt->encode($row->id));?>"><i class="fa fa-edit"></i> <?php echo lang('language_lang.edit');?></a></li>
												<li><a onclick="confirmdelete('<?php echo $myencrypt->encode($row->id);?>')" href="javascript:void(0)" ><i class="fa fa-remove"></i> <?php echo lang('language_lang.delete');?></a></li>
											</ul>
										</li>
									</ul>
								</td>
							</tr>
						<?php 

								$i++; }
							}  else { 

						?>
							<?php } ?>
						</tbody>
					</table>
				</div>
				<!-- /basic responsive configuration -->

			<!-- Basic modal -->
            <?php 
            if($subadmin_data){
            	foreach ($subadmin_data as $row) { 
           	    	$per_data = json_decode($row->permission);
           	?>
					<div id="modal_theme_primary<?php echo $row->id;?>" class="modal fade" >
						<div class="modal-dialog">
							<div class="modal-content">
								<div class="modal-header bg-info">
									<button type="button" class="close" data-dismiss="modal">&times;</button>
									<h5 class="modal-title"><b><?php echo lang('language_lang.subadmin_previlage'); ?>:</b></h5>
								</div>

								<div style="height:300px;overflow-y:scroll;" class="modal-body">
									<div class="form-group">
										<div class="row">
											<?php 
												if($row->permission) { 
													foreach ($per_data as $key => $value) {
											?>

														<div style="margin-bottom:10px;" class="col-md-6">
															<label class="label border-left-info label-striped"><?php echo ucfirst($value);?></label>
													    </div>
											<?php 
													} 
												} 
											?>
						  				</div>
									</div>
								</div>

								<div class="modal-footer">
									<button type="button" class="btn btn-info" data-dismiss="modal">Close</button>
								</div>
							</div>
						</div>
					</div>
			<?
				} 
			}
			?>
			<!-- /basic modal -->
         

			</div>
			<!-- /main content -->

		</div>
		<!-- /page content -->


		<!-- Footer -->
		<div class="footer text-muted">
			<?php echo site_footer();?>
		</div>
		<!-- /footer -->

	</div>
	<!-- /page container -->

	<script type="text/javascript">
		
	(function($) {

	    $(document).ready(function() {

	    	$.jGrowl.defaults.closer = false;

				<?php if($this->session->getFlashData('error_message')) { ?>
					$.jGrowl("<?php echo $this->session->getFlashData('error_message');?>", {
			            header: 'Error!',
			            theme: 'bg-danger'
			        });
	            <?php } ?>
	                    
	            <?php if($this->session->getFlashData('success_message')) { ?>
	                $.jGrowl("<?php echo $this->session->getFlashData('success_message');?>", {
			            header: '<?php echo lang("language_lang.success");?>',
			            theme: 'bg-success'
			        });
	            <?php } ?>

	            $('#icon-bck').on('click',function() {
					window.history.back();
				});

				

		});

	})(jQuery);
	
	function changeStatus(valus) {
         swal({
            title: "<?php echo lang('language_lang.confirm_status_change');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url('admin/subadmin/changeStatus/');?>"+'/'+valus;
            }
            else {
              return false;
            }
		
		});
	}
	function changeActiveStatus(valus) {
		swal({
            title: "<?php echo lang('language_lang.confirm_status_change');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url('admin/subadmin/changeActiveStatus/');?>"+'/'+valus;
            }
            else {
              return false;
            }
		
		});
	}
	function confirmdelete(value) {
		swal({
            title: "<?php echo lang('language_lang.delete_subadmin');?>",
            showCancelButton: true,
            closeOnConfirm: false,
            confirmButtonColor: "#2196F3",
            showLoaderOnConfirm: true
        },
       function(inputValue) {
            if(inputValue === true){
             window.location.href = "<?php echo base_url('admin/subadmin/delete/');?>"+'/'+value;
            }
            else {
              return false;
            }

		});
    }

	
	</script>

</body>
</html>
